﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/forecast/ForecastService_EXPORTS.h>
#include <aws/forecast/model/DataSource.h>
#include <aws/forecast/model/Schema.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace ForecastService {
namespace Model {

/**
 * <p>Details about the import file that contains the time series for which you
 * want to create forecasts.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/TimeSeriesIdentifiers">AWS
 * API Reference</a></p>
 */
class TimeSeriesIdentifiers {
 public:
  AWS_FORECASTSERVICE_API TimeSeriesIdentifiers() = default;
  AWS_FORECASTSERVICE_API TimeSeriesIdentifiers(Aws::Utils::Json::JsonView jsonValue);
  AWS_FORECASTSERVICE_API TimeSeriesIdentifiers& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_FORECASTSERVICE_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{

  inline const DataSource& GetDataSource() const { return m_dataSource; }
  inline bool DataSourceHasBeenSet() const { return m_dataSourceHasBeenSet; }
  template <typename DataSourceT = DataSource>
  void SetDataSource(DataSourceT&& value) {
    m_dataSourceHasBeenSet = true;
    m_dataSource = std::forward<DataSourceT>(value);
  }
  template <typename DataSourceT = DataSource>
  TimeSeriesIdentifiers& WithDataSource(DataSourceT&& value) {
    SetDataSource(std::forward<DataSourceT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Schema& GetSchema() const { return m_schema; }
  inline bool SchemaHasBeenSet() const { return m_schemaHasBeenSet; }
  template <typename SchemaT = Schema>
  void SetSchema(SchemaT&& value) {
    m_schemaHasBeenSet = true;
    m_schema = std::forward<SchemaT>(value);
  }
  template <typename SchemaT = Schema>
  TimeSeriesIdentifiers& WithSchema(SchemaT&& value) {
    SetSchema(std::forward<SchemaT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The format of the data, either CSV or PARQUET.</p>
   */
  inline const Aws::String& GetFormat() const { return m_format; }
  inline bool FormatHasBeenSet() const { return m_formatHasBeenSet; }
  template <typename FormatT = Aws::String>
  void SetFormat(FormatT&& value) {
    m_formatHasBeenSet = true;
    m_format = std::forward<FormatT>(value);
  }
  template <typename FormatT = Aws::String>
  TimeSeriesIdentifiers& WithFormat(FormatT&& value) {
    SetFormat(std::forward<FormatT>(value));
    return *this;
  }
  ///@}
 private:
  DataSource m_dataSource;

  Schema m_schema;

  Aws::String m_format;
  bool m_dataSourceHasBeenSet = false;
  bool m_schemaHasBeenSet = false;
  bool m_formatHasBeenSet = false;
};

}  // namespace Model
}  // namespace ForecastService
}  // namespace Aws
