﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/workspaces-web/WorkSpacesWeb_EXPORTS.h>
#include <aws/workspaces-web/model/NetworkSettingsSummary.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace WorkSpacesWeb {
namespace Model {
class ListNetworkSettingsResult {
 public:
  AWS_WORKSPACESWEB_API ListNetworkSettingsResult() = default;
  AWS_WORKSPACESWEB_API ListNetworkSettingsResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_WORKSPACESWEB_API ListNetworkSettingsResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The network settings.</p>
   */
  inline const Aws::Vector<NetworkSettingsSummary>& GetNetworkSettings() const { return m_networkSettings; }
  template <typename NetworkSettingsT = Aws::Vector<NetworkSettingsSummary>>
  void SetNetworkSettings(NetworkSettingsT&& value) {
    m_networkSettingsHasBeenSet = true;
    m_networkSettings = std::forward<NetworkSettingsT>(value);
  }
  template <typename NetworkSettingsT = Aws::Vector<NetworkSettingsSummary>>
  ListNetworkSettingsResult& WithNetworkSettings(NetworkSettingsT&& value) {
    SetNetworkSettings(std::forward<NetworkSettingsT>(value));
    return *this;
  }
  template <typename NetworkSettingsT = NetworkSettingsSummary>
  ListNetworkSettingsResult& AddNetworkSettings(NetworkSettingsT&& value) {
    m_networkSettingsHasBeenSet = true;
    m_networkSettings.emplace_back(std::forward<NetworkSettingsT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The pagination token used to retrieve the next page of results for this
   * operation.</p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  ListNetworkSettingsResult& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  ListNetworkSettingsResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Vector<NetworkSettingsSummary> m_networkSettings;
  bool m_networkSettingsHasBeenSet = false;

  Aws::String m_nextToken;
  bool m_nextTokenHasBeenSet = false;

  Aws::String m_requestId;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace WorkSpacesWeb
}  // namespace Aws
