﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/pinpoint/Pinpoint_EXPORTS.h>
#include <aws/pinpoint/model/DimensionType.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace Pinpoint {
namespace Model {

/**
 * <p>Specifies the dimension type and values for a segment
 * dimension.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/SetDimension">AWS
 * API Reference</a></p>
 */
class SetDimension {
 public:
  AWS_PINPOINT_API SetDimension() = default;
  AWS_PINPOINT_API SetDimension(Aws::Utils::Json::JsonView jsonValue);
  AWS_PINPOINT_API SetDimension& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_PINPOINT_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The type of segment dimension to use. Valid values are: INCLUSIVE, endpoints
   * that match the criteria are included in the segment; and, EXCLUSIVE, endpoints
   * that match the criteria are excluded from the segment.</p>
   */
  inline DimensionType GetDimensionType() const { return m_dimensionType; }
  inline bool DimensionTypeHasBeenSet() const { return m_dimensionTypeHasBeenSet; }
  inline void SetDimensionType(DimensionType value) {
    m_dimensionTypeHasBeenSet = true;
    m_dimensionType = value;
  }
  inline SetDimension& WithDimensionType(DimensionType value) {
    SetDimensionType(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The criteria values to use for the segment dimension. Depending on the value
   * of the DimensionType property, endpoints are included or excluded from the
   * segment if their values match the criteria values.</p>
   */
  inline const Aws::Vector<Aws::String>& GetValues() const { return m_values; }
  inline bool ValuesHasBeenSet() const { return m_valuesHasBeenSet; }
  template <typename ValuesT = Aws::Vector<Aws::String>>
  void SetValues(ValuesT&& value) {
    m_valuesHasBeenSet = true;
    m_values = std::forward<ValuesT>(value);
  }
  template <typename ValuesT = Aws::Vector<Aws::String>>
  SetDimension& WithValues(ValuesT&& value) {
    SetValues(std::forward<ValuesT>(value));
    return *this;
  }
  template <typename ValuesT = Aws::String>
  SetDimension& AddValues(ValuesT&& value) {
    m_valuesHasBeenSet = true;
    m_values.emplace_back(std::forward<ValuesT>(value));
    return *this;
  }
  ///@}
 private:
  DimensionType m_dimensionType{DimensionType::NOT_SET};
  bool m_dimensionTypeHasBeenSet = false;

  Aws::Vector<Aws::String> m_values;
  bool m_valuesHasBeenSet = false;
};

}  // namespace Model
}  // namespace Pinpoint
}  // namespace Aws
