﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/mediaconvert/MediaConvert_EXPORTS.h>

namespace Aws {
namespace MediaConvert {
namespace Model {
enum class GifFramerateConversionAlgorithm { NOT_SET, DUPLICATE_DROP, INTERPOLATE };

namespace GifFramerateConversionAlgorithmMapper {
AWS_MEDIACONVERT_API GifFramerateConversionAlgorithm GetGifFramerateConversionAlgorithmForName(const Aws::String& name);

AWS_MEDIACONVERT_API Aws::String GetNameForGifFramerateConversionAlgorithm(GifFramerateConversionAlgorithm value);
}  // namespace GifFramerateConversionAlgorithmMapper
}  // namespace Model
}  // namespace MediaConvert
}  // namespace Aws
