﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/DateTime.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/iot/IoT_EXPORTS.h>
#include <aws/iot/model/ProvisioningHook.h>
#include <aws/iot/model/TemplateType.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace IoT {
namespace Model {
class DescribeProvisioningTemplateResult {
 public:
  AWS_IOT_API DescribeProvisioningTemplateResult() = default;
  AWS_IOT_API DescribeProvisioningTemplateResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_IOT_API DescribeProvisioningTemplateResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The ARN of the provisioning template.</p>
   */
  inline const Aws::String& GetTemplateArn() const { return m_templateArn; }
  template <typename TemplateArnT = Aws::String>
  void SetTemplateArn(TemplateArnT&& value) {
    m_templateArnHasBeenSet = true;
    m_templateArn = std::forward<TemplateArnT>(value);
  }
  template <typename TemplateArnT = Aws::String>
  DescribeProvisioningTemplateResult& WithTemplateArn(TemplateArnT&& value) {
    SetTemplateArn(std::forward<TemplateArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the provisioning template.</p>
   */
  inline const Aws::String& GetTemplateName() const { return m_templateName; }
  template <typename TemplateNameT = Aws::String>
  void SetTemplateName(TemplateNameT&& value) {
    m_templateNameHasBeenSet = true;
    m_templateName = std::forward<TemplateNameT>(value);
  }
  template <typename TemplateNameT = Aws::String>
  DescribeProvisioningTemplateResult& WithTemplateName(TemplateNameT&& value) {
    SetTemplateName(std::forward<TemplateNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The description of the provisioning template.</p>
   */
  inline const Aws::String& GetDescription() const { return m_description; }
  template <typename DescriptionT = Aws::String>
  void SetDescription(DescriptionT&& value) {
    m_descriptionHasBeenSet = true;
    m_description = std::forward<DescriptionT>(value);
  }
  template <typename DescriptionT = Aws::String>
  DescribeProvisioningTemplateResult& WithDescription(DescriptionT&& value) {
    SetDescription(std::forward<DescriptionT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The date when the provisioning template was created.</p>
   */
  inline const Aws::Utils::DateTime& GetCreationDate() const { return m_creationDate; }
  template <typename CreationDateT = Aws::Utils::DateTime>
  void SetCreationDate(CreationDateT&& value) {
    m_creationDateHasBeenSet = true;
    m_creationDate = std::forward<CreationDateT>(value);
  }
  template <typename CreationDateT = Aws::Utils::DateTime>
  DescribeProvisioningTemplateResult& WithCreationDate(CreationDateT&& value) {
    SetCreationDate(std::forward<CreationDateT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The date when the provisioning template was last modified.</p>
   */
  inline const Aws::Utils::DateTime& GetLastModifiedDate() const { return m_lastModifiedDate; }
  template <typename LastModifiedDateT = Aws::Utils::DateTime>
  void SetLastModifiedDate(LastModifiedDateT&& value) {
    m_lastModifiedDateHasBeenSet = true;
    m_lastModifiedDate = std::forward<LastModifiedDateT>(value);
  }
  template <typename LastModifiedDateT = Aws::Utils::DateTime>
  DescribeProvisioningTemplateResult& WithLastModifiedDate(LastModifiedDateT&& value) {
    SetLastModifiedDate(std::forward<LastModifiedDateT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The default fleet template version ID.</p>
   */
  inline int GetDefaultVersionId() const { return m_defaultVersionId; }
  inline void SetDefaultVersionId(int value) {
    m_defaultVersionIdHasBeenSet = true;
    m_defaultVersionId = value;
  }
  inline DescribeProvisioningTemplateResult& WithDefaultVersionId(int value) {
    SetDefaultVersionId(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The JSON formatted contents of the provisioning template.</p>
   */
  inline const Aws::String& GetTemplateBody() const { return m_templateBody; }
  template <typename TemplateBodyT = Aws::String>
  void SetTemplateBody(TemplateBodyT&& value) {
    m_templateBodyHasBeenSet = true;
    m_templateBody = std::forward<TemplateBodyT>(value);
  }
  template <typename TemplateBodyT = Aws::String>
  DescribeProvisioningTemplateResult& WithTemplateBody(TemplateBodyT&& value) {
    SetTemplateBody(std::forward<TemplateBodyT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>True if the provisioning template is enabled, otherwise false.</p>
   */
  inline bool GetEnabled() const { return m_enabled; }
  inline void SetEnabled(bool value) {
    m_enabledHasBeenSet = true;
    m_enabled = value;
  }
  inline DescribeProvisioningTemplateResult& WithEnabled(bool value) {
    SetEnabled(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The ARN of the role associated with the provisioning template. This IoT role
   * grants permission to provision a device.</p>
   */
  inline const Aws::String& GetProvisioningRoleArn() const { return m_provisioningRoleArn; }
  template <typename ProvisioningRoleArnT = Aws::String>
  void SetProvisioningRoleArn(ProvisioningRoleArnT&& value) {
    m_provisioningRoleArnHasBeenSet = true;
    m_provisioningRoleArn = std::forward<ProvisioningRoleArnT>(value);
  }
  template <typename ProvisioningRoleArnT = Aws::String>
  DescribeProvisioningTemplateResult& WithProvisioningRoleArn(ProvisioningRoleArnT&& value) {
    SetProvisioningRoleArn(std::forward<ProvisioningRoleArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Gets information about a pre-provisioned hook.</p>
   */
  inline const ProvisioningHook& GetPreProvisioningHook() const { return m_preProvisioningHook; }
  template <typename PreProvisioningHookT = ProvisioningHook>
  void SetPreProvisioningHook(PreProvisioningHookT&& value) {
    m_preProvisioningHookHasBeenSet = true;
    m_preProvisioningHook = std::forward<PreProvisioningHookT>(value);
  }
  template <typename PreProvisioningHookT = ProvisioningHook>
  DescribeProvisioningTemplateResult& WithPreProvisioningHook(PreProvisioningHookT&& value) {
    SetPreProvisioningHook(std::forward<PreProvisioningHookT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The type you define in a provisioning template. You can create a template
   * with only one type. You can't change the template type after its creation. The
   * default value is <code>FLEET_PROVISIONING</code>. For more information about
   * provisioning template, see: <a
   * href="https://docs.aws.amazon.com/iot/latest/developerguide/provision-template.html">Provisioning
   * template</a>. </p>
   */
  inline TemplateType GetType() const { return m_type; }
  inline void SetType(TemplateType value) {
    m_typeHasBeenSet = true;
    m_type = value;
  }
  inline DescribeProvisioningTemplateResult& WithType(TemplateType value) {
    SetType(value);
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  DescribeProvisioningTemplateResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_templateArn;
  bool m_templateArnHasBeenSet = false;

  Aws::String m_templateName;
  bool m_templateNameHasBeenSet = false;

  Aws::String m_description;
  bool m_descriptionHasBeenSet = false;

  Aws::Utils::DateTime m_creationDate{};
  bool m_creationDateHasBeenSet = false;

  Aws::Utils::DateTime m_lastModifiedDate{};
  bool m_lastModifiedDateHasBeenSet = false;

  int m_defaultVersionId{0};
  bool m_defaultVersionIdHasBeenSet = false;

  Aws::String m_templateBody;
  bool m_templateBodyHasBeenSet = false;

  bool m_enabled{false};
  bool m_enabledHasBeenSet = false;

  Aws::String m_provisioningRoleArn;
  bool m_provisioningRoleArnHasBeenSet = false;

  ProvisioningHook m_preProvisioningHook;
  bool m_preProvisioningHookHasBeenSet = false;

  TemplateType m_type{TemplateType::NOT_SET};
  bool m_typeHasBeenSet = false;

  Aws::String m_requestId;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace IoT
}  // namespace Aws
