﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/guardduty/GuardDuty_EXPORTS.h>
#include <aws/guardduty/model/Threat.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace GuardDuty {
namespace Model {

/**
 * <p>Information about the malware scan that generated a GuardDuty
 * finding.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/MalwareScanDetails">AWS
 * API Reference</a></p>
 */
class MalwareScanDetails {
 public:
  AWS_GUARDDUTY_API MalwareScanDetails() = default;
  AWS_GUARDDUTY_API MalwareScanDetails(Aws::Utils::Json::JsonView jsonValue);
  AWS_GUARDDUTY_API MalwareScanDetails& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_GUARDDUTY_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>Information about the detected threats associated with the generated
   * GuardDuty finding.</p>
   */
  inline const Aws::Vector<Threat>& GetThreats() const { return m_threats; }
  inline bool ThreatsHasBeenSet() const { return m_threatsHasBeenSet; }
  template <typename ThreatsT = Aws::Vector<Threat>>
  void SetThreats(ThreatsT&& value) {
    m_threatsHasBeenSet = true;
    m_threats = std::forward<ThreatsT>(value);
  }
  template <typename ThreatsT = Aws::Vector<Threat>>
  MalwareScanDetails& WithThreats(ThreatsT&& value) {
    SetThreats(std::forward<ThreatsT>(value));
    return *this;
  }
  template <typename ThreatsT = Threat>
  MalwareScanDetails& AddThreats(ThreatsT&& value) {
    m_threatsHasBeenSet = true;
    m_threats.emplace_back(std::forward<ThreatsT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Vector<Threat> m_threats;
  bool m_threatsHasBeenSet = false;
};

}  // namespace Model
}  // namespace GuardDuty
}  // namespace Aws
