﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/dms/DatabaseMigrationService_EXPORTS.h>
#include <aws/dms/model/DataProvider.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace DatabaseMigrationService {
namespace Model {
class DescribeDataProvidersResult {
 public:
  AWS_DATABASEMIGRATIONSERVICE_API DescribeDataProvidersResult() = default;
  AWS_DATABASEMIGRATIONSERVICE_API DescribeDataProvidersResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_DATABASEMIGRATIONSERVICE_API DescribeDataProvidersResult& operator=(
      const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>Specifies the unique pagination token that makes it possible to display the
   * next page of results. If this parameter is specified, the response includes only
   * records beyond the marker, up to the value specified by
   * <code>MaxRecords</code>.</p> <p>If <code>Marker</code> is returned by a previous
   * response, there are more results available. The value of <code>Marker</code> is
   * a unique pagination token for each page. To retrieve the next page, make the
   * call again using the returned token and keeping all other arguments
   * unchanged.</p>
   */
  inline const Aws::String& GetMarker() const { return m_marker; }
  template <typename MarkerT = Aws::String>
  void SetMarker(MarkerT&& value) {
    m_markerHasBeenSet = true;
    m_marker = std::forward<MarkerT>(value);
  }
  template <typename MarkerT = Aws::String>
  DescribeDataProvidersResult& WithMarker(MarkerT&& value) {
    SetMarker(std::forward<MarkerT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A description of data providers.</p>
   */
  inline const Aws::Vector<DataProvider>& GetDataProviders() const { return m_dataProviders; }
  template <typename DataProvidersT = Aws::Vector<DataProvider>>
  void SetDataProviders(DataProvidersT&& value) {
    m_dataProvidersHasBeenSet = true;
    m_dataProviders = std::forward<DataProvidersT>(value);
  }
  template <typename DataProvidersT = Aws::Vector<DataProvider>>
  DescribeDataProvidersResult& WithDataProviders(DataProvidersT&& value) {
    SetDataProviders(std::forward<DataProvidersT>(value));
    return *this;
  }
  template <typename DataProvidersT = DataProvider>
  DescribeDataProvidersResult& AddDataProviders(DataProvidersT&& value) {
    m_dataProvidersHasBeenSet = true;
    m_dataProviders.emplace_back(std::forward<DataProvidersT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  DescribeDataProvidersResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_marker;
  bool m_markerHasBeenSet = false;

  Aws::Vector<DataProvider> m_dataProviders;
  bool m_dataProvidersHasBeenSet = false;

  Aws::String m_requestId;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace DatabaseMigrationService
}  // namespace Aws
