/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.actors.mobs.npcs;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.Actor;
import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.npcs.NPC;
import com.shatteredpixel.shatteredpixeldungeon.effects.CheckedCell;
import com.shatteredpixel.shatteredpixeldungeon.mechanics.Ballistica;
import com.shatteredpixel.shatteredpixeldungeon.mechanics.ConeAOE;
import com.shatteredpixel.shatteredpixeldungeon.scenes.GameScene;
import com.shatteredpixel.shatteredpixeldungeon.sprites.CharSprite;
import com.shatteredpixel.shatteredpixeldungeon.sprites.WardSprite;
import com.watabou.utils.Bundle;

public class VaultSentry
extends NPC {
    public float scanWidth;
    public float scanLength;
    public int[][] scanDirs;
    public int scanDirIdx;
    private static final String SCAN_WIDTH = "scan_width";
    private static final String SCAN_LENGTH = "scan_length";
    private static final String SCAN_DIR_IDX = "scan_dir_idx";
    private static final String SCAN_DIRS = "scan_dirs_";
    private static final String SCAN_DIRS_LEN = "scan_dirs_len";

    public VaultSentry() {
        this.spriteClass = WardSprite.class;
        this.properties.add(Char.Property.IMMOVABLE);
    }

    @Override
    protected boolean act() {
        int[] scanDirsThisTurn = this.scanDirs[this.scanDirIdx];
        ++this.scanDirIdx;
        if (this.scanDirIdx >= this.scanDirs.length) {
            this.scanDirIdx = 0;
        }
        for (int scanDir : scanDirsThisTurn) {
            ConeAOE scan = new ConeAOE(new Ballistica(this.pos, scanDir, 4), this.scanLength, this.scanWidth, 5);
            for (int cell : scan.cells) {
                if (Actor.findChar(cell) == Dungeon.hero) {
                    Dungeon.hero.sprite.showStatus(0xFF0000, "!!!", new Object[0]);
                }
                if (!Dungeon.level.heroFOV[cell]) continue;
                GameScene.effect(new CheckedCell(cell, this.pos));
            }
        }
        this.throwItems();
        this.spend(1.0f);
        return true;
    }

    @Override
    public boolean isImmune(Class effect) {
        return true;
    }

    @Override
    public boolean isInvulnerable(Class effect) {
        return true;
    }

    @Override
    public boolean reset() {
        return true;
    }

    @Override
    public boolean interact(Char c) {
        return true;
    }

    @Override
    public void storeInBundle(Bundle bundle) {
        super.storeInBundle(bundle);
        bundle.put(SCAN_WIDTH, this.scanWidth);
        bundle.put(SCAN_LENGTH, this.scanLength);
        bundle.put(SCAN_DIR_IDX, this.scanDirIdx);
        bundle.put(SCAN_DIRS_LEN, this.scanDirs.length);
        for (int i = 0; i < this.scanDirs.length; ++i) {
            bundle.put(SCAN_DIRS + i, this.scanDirs[i]);
        }
    }

    @Override
    public void restoreFromBundle(Bundle bundle) {
        super.restoreFromBundle(bundle);
        this.scanWidth = bundle.getFloat(SCAN_WIDTH);
        this.scanLength = bundle.getFloat(SCAN_LENGTH);
        this.scanDirIdx = bundle.getInt(SCAN_DIR_IDX);
        this.scanDirs = new int[bundle.getInt(SCAN_DIRS_LEN)][];
        for (int i = 0; i < this.scanDirs.length; ++i) {
            this.scanDirs[i] = bundle.getIntArray(SCAN_DIRS + i);
        }
    }

    @Override
    public CharSprite sprite() {
        WardSprite sprite = (WardSprite)super.sprite();
        sprite.linkVisuals(this);
        return sprite;
    }
}

