/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project.time;

import java.time.DayOfWeek;
import java.time.format.TextStyle;
import java.util.Locale;
import net.sourceforge.plantuml.StringUtils;

public abstract class DayOfWeekUtils {
    public static String getRegexString() {
        StringBuilder sb = new StringBuilder();
        for (DayOfWeek day : DayOfWeek.values()) {
            if (sb.length() > 0) {
                sb.append("|");
            }
            sb.append(day.name().substring(0, 3) + "[a-z]*");
        }
        return sb.toString();
    }

    public static DayOfWeek fromString(String value) {
        value = StringUtils.goUpperCase(value).substring(0, 3);
        for (DayOfWeek day : DayOfWeek.values()) {
            if (!day.name().startsWith(value)) continue;
            return day;
        }
        throw new IllegalArgumentException();
    }

    public static String shortName(DayOfWeek dayOfWeek, Locale locale) {
        if (locale == Locale.ENGLISH) {
            return StringUtils.capitalize(dayOfWeek.name().substring(0, 2));
        }
        String s = StringUtils.capitalize(dayOfWeek.getDisplayName(TextStyle.SHORT_STANDALONE, locale));
        if (s.length() > 2) {
            return s.substring(0, 2);
        }
        return s;
    }
}

