/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.dangling_indices.list_dangling_indices;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class DanglingIndex
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, DanglingIndex> {
    @Nullable
    private final String creationDate;
    private final long creationDateMillis;
    @Nonnull
    private final String indexName;
    @Nonnull
    private final String indexUuid;
    @Nonnull
    private final List<String> nodeIds;
    public static final JsonpDeserializer<DanglingIndex> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DanglingIndex::setupDanglingIndexDeserializer);

    private DanglingIndex(Builder builder) {
        this.creationDate = builder.creationDate;
        this.creationDateMillis = ApiTypeHelper.requireNonNull(builder.creationDateMillis, this, "creationDateMillis");
        this.indexName = ApiTypeHelper.requireNonNull(builder.indexName, this, "indexName");
        this.indexUuid = ApiTypeHelper.requireNonNull(builder.indexUuid, this, "indexUuid");
        this.nodeIds = ApiTypeHelper.unmodifiableRequired(builder.nodeIds, (Object)this, "nodeIds");
    }

    public static DanglingIndex of(Function<Builder, ObjectBuilder<DanglingIndex>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String creationDate() {
        return this.creationDate;
    }

    public final long creationDateMillis() {
        return this.creationDateMillis;
    }

    @Nonnull
    public final String indexName() {
        return this.indexName;
    }

    @Nonnull
    public final String indexUuid() {
        return this.indexUuid;
    }

    @Nonnull
    public final List<String> nodeIds() {
        return this.nodeIds;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.creationDate != null) {
            generator.writeKey("creation_date");
            generator.write(this.creationDate);
        }
        generator.writeKey("creation_date_millis");
        generator.write(this.creationDateMillis);
        generator.writeKey("index_name");
        generator.write(this.indexName);
        generator.writeKey("index_uuid");
        generator.write(this.indexUuid);
        generator.writeKey("node_ids");
        generator.writeStartArray();
        for (String item0 : this.nodeIds) {
            generator.write(item0);
        }
        generator.writeEnd();
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupDanglingIndexDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::creationDate, JsonpDeserializer.stringDeserializer(), "creation_date");
        op.add(Builder::creationDateMillis, JsonpDeserializer.longDeserializer(), "creation_date_millis");
        op.add(Builder::indexName, JsonpDeserializer.stringDeserializer(), "index_name");
        op.add(Builder::indexUuid, JsonpDeserializer.stringDeserializer(), "index_uuid");
        op.add(Builder::nodeIds, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "node_ids");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.creationDate);
        result = 31 * result + Long.hashCode(this.creationDateMillis);
        result = 31 * result + this.indexName.hashCode();
        result = 31 * result + this.indexUuid.hashCode();
        result = 31 * result + this.nodeIds.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DanglingIndex other = (DanglingIndex)o;
        return Objects.equals(this.creationDate, other.creationDate) && this.creationDateMillis == other.creationDateMillis && this.indexName.equals(other.indexName) && this.indexUuid.equals(other.indexUuid) && this.nodeIds.equals(other.nodeIds);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, DanglingIndex> {
        @Nullable
        private String creationDate;
        private Long creationDateMillis;
        private String indexName;
        private String indexUuid;
        private List<String> nodeIds;

        public Builder() {
        }

        private Builder(DanglingIndex o) {
            this.creationDate = o.creationDate;
            this.creationDateMillis = o.creationDateMillis;
            this.indexName = o.indexName;
            this.indexUuid = o.indexUuid;
            this.nodeIds = Builder._listCopy(o.nodeIds);
        }

        private Builder(Builder o) {
            this.creationDate = o.creationDate;
            this.creationDateMillis = o.creationDateMillis;
            this.indexName = o.indexName;
            this.indexUuid = o.indexUuid;
            this.nodeIds = Builder._listCopy(o.nodeIds);
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder creationDate(@Nullable String value) {
            this.creationDate = value;
            return this;
        }

        @Nonnull
        public final Builder creationDateMillis(long value) {
            this.creationDateMillis = value;
            return this;
        }

        @Nonnull
        public final Builder indexName(String value) {
            this.indexName = value;
            return this;
        }

        @Nonnull
        public final Builder indexUuid(String value) {
            this.indexUuid = value;
            return this;
        }

        @Nonnull
        public final Builder nodeIds(List<String> list) {
            this.nodeIds = Builder._listAddAll(this.nodeIds, list);
            return this;
        }

        @Nonnull
        public final Builder nodeIds(String value, String ... values) {
            this.nodeIds = Builder._listAdd(this.nodeIds, value, values);
            return this;
        }

        @Override
        @Nonnull
        public DanglingIndex build() {
            this._checkSingleUse();
            return new DanglingIndex(this);
        }
    }
}

