/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.request;

import java.math.BigDecimal;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlBinaryOperator;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.util.Sarg;
import org.opensearch.search.aggregations.AggregationBuilders;
import org.opensearch.search.aggregations.bucket.range.RangeAggregationBuilder;
import shaded.com.google.common.collect.BoundType;
import shaded.com.google.common.collect.Range;
import shaded.com.google.common.collect.RangeSet;
import shaded.com.google.common.collect.TreeRangeSet;

public class CaseRangeAnalyzer {
    public static final String DEFAULT_ELSE_KEY = "null";
    private final RelDataType rowType;
    private final RangeSet<Double> takenRange;
    private final RangeAggregationBuilder builder;

    public CaseRangeAnalyzer(String name, RelDataType rowType) {
        this.rowType = rowType;
        this.takenRange = TreeRangeSet.create();
        this.builder = (RangeAggregationBuilder)AggregationBuilders.range((String)name).keyed(true);
    }

    public static CaseRangeAnalyzer create(String name, RelDataType rowType) {
        return new CaseRangeAnalyzer(name, rowType);
    }

    public Optional<RangeAggregationBuilder> analyze(RexCall caseCall) {
        String elseKey;
        if (!caseCall.getKind().equals((Object)SqlKind.CASE)) {
            return Optional.empty();
        }
        List operands = caseCall.getOperands();
        for (int i = 0; i < operands.size() - 1; i += 2) {
            RexNode condition = (RexNode)operands.get(i);
            RexNode expr = (RexNode)operands.get(i + 1);
            try {
                String key = CaseRangeAnalyzer.parseLiteralAsString(expr);
                this.analyzeCondition(condition, key);
                continue;
            }
            catch (UnsupportedOperationException e) {
                return Optional.empty();
            }
        }
        RexNode elseExpr = (RexNode)operands.getLast();
        if (RexLiteral.isNullLiteral((RexNode)elseExpr)) {
            elseKey = DEFAULT_ELSE_KEY;
        } else {
            try {
                elseKey = CaseRangeAnalyzer.parseLiteralAsString(elseExpr);
            }
            catch (UnsupportedOperationException e) {
                return Optional.empty();
            }
        }
        this.addRangeSet(elseKey, (RangeSet<Double>)this.takenRange.complement());
        return Optional.of(this.builder);
    }

    private void analyzeCondition(RexNode condition, String key) {
        RexCall call;
        SqlKind kind;
        if (!(condition instanceof RexCall)) {
            CaseRangeAnalyzer.throwUnsupported("condition must be a RexCall");
        }
        if ((kind = (call = (RexCall)condition).getKind()) == SqlKind.GREATER_THAN_OR_EQUAL || kind == SqlKind.LESS_THAN || kind == SqlKind.LESS_THAN_OR_EQUAL || kind == SqlKind.GREATER_THAN) {
            this.analyzeSimpleComparison(call, key);
        } else if (kind == SqlKind.SEARCH) {
            this.analyzeSearchCondition(call, key);
        } else if (kind == SqlKind.AND || kind == SqlKind.OR) {
            CaseRangeAnalyzer.throwUnsupported("Range queries must be performed on the same field");
        } else {
            CaseRangeAnalyzer.throwUnsupported("Can not analyze condition as a range query: " + String.valueOf(call));
        }
    }

    private void analyzeSimpleComparison(RexCall call, String key) {
        List operands = call.getOperands();
        if (operands.size() != 2 || !(call.getOperator() instanceof SqlBinaryOperator)) {
            CaseRangeAnalyzer.throwUnsupported();
        }
        RexNode left = (RexNode)operands.get(0);
        RexNode right = (RexNode)operands.get(1);
        SqlOperator operator = call.getOperator();
        RexInputRef inputRef = null;
        RexLiteral literal = null;
        if (left instanceof RexInputRef && right instanceof RexLiteral) {
            inputRef = (RexInputRef)left;
            literal = (RexLiteral)right;
        } else if (left instanceof RexLiteral && right instanceof RexInputRef) {
            inputRef = (RexInputRef)right;
            literal = (RexLiteral)left;
            operator = operator.reverse();
        } else {
            CaseRangeAnalyzer.throwUnsupported();
        }
        if (operator == null) {
            CaseRangeAnalyzer.throwUnsupported();
        }
        String fieldName = (String)this.rowType.getFieldNames().get(inputRef.getIndex());
        if (this.builder.field() == null) {
            this.builder.field(fieldName);
        } else if (!Objects.equals(this.builder.field(), fieldName)) {
            CaseRangeAnalyzer.throwUnsupported("comparison must be performed on the same field");
        }
        Double value = (Double)literal.getValueAs(Double.class);
        if (value == null) {
            CaseRangeAnalyzer.throwUnsupported("Cannot parse value for comparison");
        }
        switch (operator.getKind()) {
            case GREATER_THAN_OR_EQUAL: {
                this.addFrom(key, value);
                break;
            }
            case LESS_THAN: {
                this.addTo(key, value);
                break;
            }
            default: {
                throw new UnsupportedOperationException("ranges must be equivalents of field >= constant or field < constant");
            }
        }
    }

    private void analyzeSearchCondition(RexCall searchCall, String key) {
        RexNode field = (RexNode)searchCall.getOperands().getFirst();
        if (!(field instanceof RexInputRef)) {
            CaseRangeAnalyzer.throwUnsupported("Range query must be performed on a field");
        }
        String fieldName = this.getFieldName((RexInputRef)field);
        if (this.builder.field() == null) {
            this.builder.field(fieldName);
        } else if (!Objects.equals(this.builder.field(), fieldName)) {
            CaseRangeAnalyzer.throwUnsupported("Range query must be performed on the same field");
        }
        RexLiteral literal = (RexLiteral)searchCall.getOperands().getLast();
        Sarg sarg = Objects.requireNonNull((Sarg)literal.getValueAs(Sarg.class));
        Iterator iterator = sarg.rangeSet.asRanges().iterator();
        while (iterator.hasNext()) {
            double lower;
            Range r;
            Range range = r = (Range)iterator.next();
            CaseRangeAnalyzer.validateRange(range);
            if (!range.hasLowerBound() && range.hasUpperBound()) {
                double upper = ((BigDecimal)range.upperEndpoint()).doubleValue();
                this.addTo(key, upper);
                continue;
            }
            if (range.hasLowerBound() && !range.hasUpperBound()) {
                lower = ((BigDecimal)range.lowerEndpoint()).doubleValue();
                this.addFrom(key, lower);
                continue;
            }
            if (range.hasLowerBound()) {
                lower = ((BigDecimal)range.lowerEndpoint()).doubleValue();
                double upper = ((BigDecimal)range.upperEndpoint()).doubleValue();
                this.addBetween(key, lower, upper);
                continue;
            }
            this.addBetween(key, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        }
    }

    private void addFrom(String key, Double value) {
        Range from = Range.atLeast((Comparable)value);
        this.updateRange(key, (Range<Double>)from);
    }

    private void addTo(String key, Double value) {
        Range to = Range.lessThan((Comparable)value);
        this.updateRange(key, (Range<Double>)to);
    }

    private void addBetween(String key, Double from, Double to) {
        Range range = Range.closedOpen((Comparable)from, (Comparable)to);
        this.updateRange(key, (Range<Double>)range);
    }

    private void updateRange(String key, Range<Double> range) {
        RangeSet toAdd = this.takenRange.complement().subRangeSet(range);
        this.addRangeSet(key, (RangeSet<Double>)toAdd);
        this.takenRange.add(range);
    }

    private void addRangeSet(String key, RangeSet<Double> rangeSet) {
        rangeSet.asRanges().forEach(range -> this.addRange(key, (Range<Double>)range));
    }

    private void addRange(String key, Range<Double> range) {
        CaseRangeAnalyzer.validateRange(range);
        if (range.hasLowerBound() && range.hasUpperBound()) {
            this.builder.addRange(key, ((Double)range.lowerEndpoint()).doubleValue(), ((Double)range.upperEndpoint()).doubleValue());
        } else if (range.hasLowerBound()) {
            this.builder.addUnboundedFrom(key, ((Double)range.lowerEndpoint()).doubleValue());
        } else if (range.hasUpperBound()) {
            this.builder.addUnboundedTo(key, ((Double)range.upperEndpoint()).doubleValue());
        } else {
            this.builder.addRange(key, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        }
    }

    private String getFieldName(RexInputRef field) {
        return (String)this.rowType.getFieldNames().get(field.getIndex());
    }

    private static void validateRange(Range<?> range) {
        if (range.hasLowerBound() && range.lowerBoundType() != BoundType.CLOSED || range.hasUpperBound() && range.upperBoundType() != BoundType.OPEN) {
            CaseRangeAnalyzer.throwUnsupported("Range query only supports closed-open ranges");
        }
    }

    private static String parseLiteralAsString(RexNode node) {
        if (!(node instanceof RexLiteral)) {
            CaseRangeAnalyzer.throwUnsupported("Result expressions of range queries must be literals");
        }
        RexLiteral literal = (RexLiteral)node;
        try {
            return (String)literal.getValueAs(String.class);
        }
        catch (AssertionError assertionError) {
            throw new UnsupportedOperationException("Cannot parse result expression of type " + String.valueOf(literal.getType()));
        }
    }

    private static void throwUnsupported() {
        throw new UnsupportedOperationException("Cannot create range aggregator from case");
    }

    private static void throwUnsupported(String message) {
        throw new UnsupportedOperationException("Cannot create range aggregator: " + message);
    }
}

