/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queries.mlt;

import java.io.IOException;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.queries.mlt.MoreLikeThis;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;

public class MoreLikeThisQuery
extends Query {
    private String likeText;
    private String[] moreLikeFields;
    private Analyzer analyzer;
    private final String fieldName;
    private float percentTermsToMatch = 0.3f;
    private int minTermFrequency = 1;
    private int maxQueryTerms = 5;
    private Set<?> stopWords = null;
    private int minDocFreq = -1;

    public MoreLikeThisQuery(String likeText, String[] moreLikeFields, Analyzer analyzer, String fieldName) {
        this.likeText = Objects.requireNonNull(likeText);
        this.moreLikeFields = Objects.requireNonNull(moreLikeFields);
        this.analyzer = Objects.requireNonNull(analyzer);
        this.fieldName = Objects.requireNonNull(fieldName);
    }

    public Query rewrite(IndexSearcher indexSearcher) throws IOException {
        MoreLikeThis mlt = new MoreLikeThis(indexSearcher.getIndexReader());
        mlt.setFieldNames(this.moreLikeFields);
        mlt.setAnalyzer(this.analyzer);
        mlt.setMinTermFreq(this.minTermFrequency);
        if (this.minDocFreq >= 0) {
            mlt.setMinDocFreq(this.minDocFreq);
        }
        mlt.setMaxQueryTerms(this.maxQueryTerms);
        mlt.setStopWords(this.stopWords);
        BooleanQuery bq = (BooleanQuery)mlt.like(this.fieldName, new StringReader(this.likeText));
        BooleanQuery.Builder newBq = new BooleanQuery.Builder();
        for (BooleanClause clause : bq) {
            newBq.add(clause);
        }
        newBq.setMinimumNumberShouldMatch((int)((float)bq.clauses().size() * this.percentTermsToMatch));
        return newBq.build();
    }

    public String toString(String field) {
        return "like:" + this.likeText;
    }

    public float getPercentTermsToMatch() {
        return this.percentTermsToMatch;
    }

    public void setPercentTermsToMatch(float percentTermsToMatch) {
        this.percentTermsToMatch = percentTermsToMatch;
    }

    public Analyzer getAnalyzer() {
        return this.analyzer;
    }

    public void setAnalyzer(Analyzer analyzer) {
        this.analyzer = analyzer;
    }

    public String getLikeText() {
        return this.likeText;
    }

    public void setLikeText(String likeText) {
        this.likeText = likeText;
    }

    public int getMaxQueryTerms() {
        return this.maxQueryTerms;
    }

    public void setMaxQueryTerms(int maxQueryTerms) {
        this.maxQueryTerms = maxQueryTerms;
    }

    public int getMinTermFrequency() {
        return this.minTermFrequency;
    }

    public void setMinTermFrequency(int minTermFrequency) {
        this.minTermFrequency = minTermFrequency;
    }

    public String[] getMoreLikeFields() {
        return this.moreLikeFields;
    }

    public void setMoreLikeFields(String[] moreLikeFields) {
        this.moreLikeFields = moreLikeFields;
    }

    public Set<?> getStopWords() {
        return this.stopWords;
    }

    public void setStopWords(Set<?> stopWords) {
        this.stopWords = stopWords;
    }

    public int getMinDocFreq() {
        return this.minDocFreq;
    }

    public void setMinDocFreq(int minDocFreq) {
        this.minDocFreq = minDocFreq;
    }

    public int hashCode() {
        int prime = 31;
        int result = this.classHash();
        result = 31 * result + Objects.hash(this.analyzer, this.fieldName, this.likeText, this.stopWords);
        result = 31 * result + this.maxQueryTerms;
        result = 31 * result + this.minDocFreq;
        result = 31 * result + this.minTermFrequency;
        result = 31 * result + Arrays.hashCode(this.moreLikeFields);
        result = 31 * result + Float.floatToIntBits(this.percentTermsToMatch);
        return result;
    }

    public boolean equals(Object other) {
        return this.sameClassAs(other) && this.equalsTo((MoreLikeThisQuery)((Object)((Object)((Object)this)).getClass().cast(other)));
    }

    private boolean equalsTo(MoreLikeThisQuery other) {
        return this.maxQueryTerms == other.maxQueryTerms && this.minDocFreq == other.minDocFreq && this.minTermFrequency == other.minTermFrequency && Float.floatToIntBits(this.percentTermsToMatch) == Float.floatToIntBits(other.percentTermsToMatch) && this.analyzer.equals(other.analyzer) && this.fieldName.equals(other.fieldName) && this.likeText.equals(other.likeText) && Arrays.equals(this.moreLikeFields, other.moreLikeFields) && Objects.equals(this.stopWords, other.stopWords);
    }

    public void visit(QueryVisitor visitor) {
        visitor.visitLeaf((Query)this);
    }
}

