/*===------------- tsxldtrkintrin.h - tsxldtrk intrinsics ------------------===
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 *
 *===-----------------------------------------------------------------------===
 */

#if !defined(__EDG__) || !defined(__PGLLVM__)
#error "This version of <tsxldtrkintrin.h> does not work with this compiler."
#endif

#ifndef __IMMINTRIN_H
#error "Never use <tsxldtrkintrin.h> directly; include <immintrin.h> instead."
#endif

#ifndef __TSXLDTRKINTRIN_H
#define __TSXLDTRKINTRIN_H

/* Define the default attributes for the functions in this file */
#define _DEFAULT_FN_ATTRS \
  __attribute__((__always_inline__, __nodebug__, __target__("tsxldtrk")))

/// Marks the start of an TSX (RTM) suspend load address tracking region. If
///    this intrinsic is used inside a transactional region, subsequent loads
///    are not added to the read set of the transaction. If it's used inside a
///    suspend load address tracking region it will cause transaction abort.
///    If it's used outside of a transactional region it behaves like a NOP.
///
/// \headerfile <x86intrin.h>
///
/// This intrinsic corresponds to the \c XSUSLDTRK instruction.
///
static __inline__ void _DEFAULT_FN_ATTRS
_xsusldtrk (void)
{
    __builtin_ia32_xsusldtrk();
}

/// Marks the end of an TSX (RTM) suspend load address tracking region. If this
///    intrinsic is used inside a suspend load address tracking region it will
///    end the suspend region and all following load addresses will be added to
///    the transaction read set. If it's used inside an active transaction but
///    not in a suspend region it will cause transaction abort. If it's used
///    outside of a transactional region it behaves like a NOP.
///
/// \headerfile <x86intrin.h>
///
/// This intrinsic corresponds to the \c XRESLDTRK instruction.
///
static __inline__ void _DEFAULT_FN_ATTRS
_xresldtrk (void)
{
    __builtin_ia32_xresldtrk();
}

#undef _DEFAULT_FN_ATTRS

#endif /* __TSXLDTRKINTRIN_H */
