/*
 * Decompiled with CFR 0.152.
 */
package com.github.kokorin.jaffree.ffmpeg;

import com.github.kokorin.jaffree.StreamType;
import com.github.kokorin.jaffree.ffmpeg.Filter;
import java.util.ArrayList;
import java.util.List;

public class GenericFilter
implements Filter {
    private final List<String> inputLinks = new ArrayList<String>();
    private String name;
    private final List<String> arguments = new ArrayList<String>();
    private final List<String> outputLinks = new ArrayList<String>();

    public GenericFilter addInputLink(StreamType streamType) {
        this.inputLinks.add(streamType.code());
        return this;
    }

    public GenericFilter addInputLink(String linkOrStreamSpecifier) {
        this.inputLinks.add(linkOrStreamSpecifier);
        return this;
    }

    public GenericFilter setName(String name) {
        this.name = name;
        return this;
    }

    public GenericFilter addArgument(String key, String value) {
        this.arguments.add(key + "=" + GenericFilter.escape(value));
        return this;
    }

    public GenericFilter addArgumentEscaped(String key, String value) {
        this.arguments.add(key + "=" + value);
        return this;
    }

    public GenericFilter addArgument(String value) {
        this.arguments.add(GenericFilter.escape(value));
        return this;
    }

    public GenericFilter addArgumentEscaped(String value) {
        this.arguments.add(value);
        return this;
    }

    public GenericFilter addOutputLink(String link) {
        this.outputLinks.add(link);
        return this;
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        for (String inputLink : this.inputLinks) {
            result.append("[").append(inputLink).append("]");
        }
        result.append(this.name);
        boolean first = true;
        for (String argument : this.arguments) {
            if (first) {
                result.append("=");
                first = false;
            } else {
                result.append(":");
            }
            result.append(argument);
        }
        for (String outputLink : this.outputLinks) {
            result.append("[").append(outputLink).append("]");
        }
        return result.toString();
    }

    static String escape(String value) {
        if (value == null) {
            return null;
        }
        return value.replace("\\", "\\\\").replace(":", "\\\\:").replace(",", "\\,").replace("[", "\\[").replace("]", "\\]").replace(";", "\\;").replace("'", "\\\\\\'");
    }
}

