/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.predicate;

import jakarta.persistence.criteria.Expression;
import java.util.Objects;
import org.hibernate.query.criteria.JpaExpression;
import org.hibernate.query.internal.QueryHelper;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.SqmBindableType;
import org.hibernate.query.sqm.internal.TypecheckUtil;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.SqmRenderContext;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.query.sqm.tree.predicate.AbstractNegatableSqmPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmInPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmNegatablePredicate;
import org.hibernate.query.sqm.tree.select.SqmSubQuery;

public class SqmInSubQueryPredicate<T>
extends AbstractNegatableSqmPredicate
implements SqmInPredicate<T> {
    private final SqmExpression<T> testExpression;
    private final SqmSubQuery<T> subQueryExpression;

    public SqmInSubQueryPredicate(SqmExpression<T> testExpression, SqmSubQuery<T> subQueryExpression, NodeBuilder nodeBuilder) {
        this(testExpression, subQueryExpression, false, nodeBuilder);
    }

    public SqmInSubQueryPredicate(SqmExpression<T> testExpression, SqmSubQuery<T> subQueryExpression, boolean negated, NodeBuilder nodeBuilder) {
        super(negated, nodeBuilder);
        this.testExpression = testExpression;
        this.subQueryExpression = subQueryExpression;
        TypecheckUtil.assertComparable(testExpression, subQueryExpression, nodeBuilder);
        SqmBindableType expressibleType = QueryHelper.highestPrecedenceType2(testExpression.getExpressible(), subQueryExpression.getExpressible());
        testExpression.applyInferableType(expressibleType);
        subQueryExpression.applyInferableType(expressibleType);
    }

    @Override
    public SqmInSubQueryPredicate<T> copy(SqmCopyContext context) {
        SqmInSubQueryPredicate existing = context.getCopy(this);
        if (existing != null) {
            return existing;
        }
        SqmInSubQueryPredicate<T> predicate = context.registerCopy(this, new SqmInSubQueryPredicate<T>(this.testExpression.copy(context), this.subQueryExpression.copy(context), this.isNegated(), this.nodeBuilder()));
        this.copyTo(predicate, context);
        return predicate;
    }

    @Override
    public SqmExpression<T> getTestExpression() {
        return this.testExpression;
    }

    @Override
    public SqmExpression<T> getExpression() {
        return this.getTestExpression();
    }

    public SqmSubQuery<T> getSubQueryExpression() {
        return this.subQueryExpression;
    }

    @Override
    public <X> X accept(SemanticQueryWalker<X> walker) {
        return walker.visitInSubQueryPredicate(this);
    }

    @Override
    public SqmInPredicate<T> value(Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public SqmInPredicate<T> value(Expression value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public SqmInPredicate<T> value(JpaExpression<? extends T> value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void appendHqlString(StringBuilder hql, SqmRenderContext context) {
        this.testExpression.appendHqlString(hql, context);
        if (this.isNegated()) {
            hql.append(" not");
        }
        hql.append(" in ");
        this.subQueryExpression.appendHqlString(hql, context);
    }

    @Override
    protected SqmNegatablePredicate createNegatedNode() {
        return new SqmInSubQueryPredicate<T>(this.testExpression, this.subQueryExpression, !this.isNegated(), this.nodeBuilder());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object object) {
        if (!(object instanceof SqmInSubQueryPredicate)) return false;
        SqmInSubQueryPredicate that = (SqmInSubQueryPredicate)object;
        if (this.isNegated() != that.isNegated()) return false;
        if (!Objects.equals(this.testExpression, that.testExpression)) return false;
        if (!Objects.equals(this.subQueryExpression, that.subQueryExpression)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.testExpression, this.subQueryExpression, this.isNegated());
    }
}

