/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.connections.httpclient;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.keycloak.connections.httpclient.SafeInputStream;

class SafeHttpEntity
implements HttpEntity {
    private final HttpEntity delegate;
    private final long maxConsumedResponseSize;

    SafeHttpEntity(HttpEntity delegate, long maxConsumedResponseSize) {
        this.delegate = delegate;
        this.maxConsumedResponseSize = maxConsumedResponseSize;
    }

    public boolean isRepeatable() {
        return this.delegate.isRepeatable();
    }

    public boolean isChunked() {
        return this.delegate.isChunked();
    }

    public long getContentLength() {
        return this.delegate.getContentLength();
    }

    public Header getContentType() {
        return this.delegate.getContentType();
    }

    public Header getContentEncoding() {
        return this.delegate.getContentEncoding();
    }

    public InputStream getContent() throws IOException, UnsupportedOperationException {
        return new SafeInputStream(this.delegate.getContent(), this.maxConsumedResponseSize);
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        this.delegate.writeTo(outputStream);
    }

    public boolean isStreaming() {
        return this.delegate.isStreaming();
    }

    @Deprecated
    public void consumeContent() throws IOException {
        this.delegate.consumeContent();
    }
}

