/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.ast.internal;

import jakarta.persistence.Parameter;
import java.util.List;
import org.hibernate.FlushMode;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.CollectionKey;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.loader.ast.spi.CollectionLoader;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.query.QueryTypeMismatchException;
import org.hibernate.query.named.NamedQueryMemento;
import org.hibernate.query.spi.QueryImplementor;

public class CollectionLoaderNamedQuery
implements CollectionLoader {
    private final CollectionPersister persister;
    private final NamedQueryMemento<?> namedQueryMemento;

    public CollectionLoaderNamedQuery(CollectionPersister persister, NamedQueryMemento<?> namedQueryMemento) {
        this.persister = persister;
        this.namedQueryMemento = namedQueryMemento;
    }

    @Override
    public PluralAttributeMapping getLoadable() {
        return this.persister.getAttributeMapping();
    }

    @Override
    public PersistentCollection<?> load(Object key, SharedSessionContractImplementor session) {
        Object r;
        QueryImplementor<?> query = this.namedQueryMemento.toQuery(session);
        query.setParameter((Parameter)query.getParameters().iterator().next(), key);
        query.setHibernateFlushMode(FlushMode.MANUAL);
        List resultList = query.getResultList();
        if (!resultList.isEmpty() && (r = resultList.get(0)) instanceof PersistentCollection) {
            PersistentCollection persistentCollection = (PersistentCollection)r;
            return persistentCollection;
        }
        CollectionKey collectionKey = new CollectionKey(this.persister, key);
        PersistentCollection collection = session.getPersistenceContextInternal().getCollection(collectionKey);
        for (Object element : resultList) {
            if (element == null || this.persister.getElementType().getReturnedClass().isInstance(element)) continue;
            throw new QueryTypeMismatchException("Collection loader for '" + this.persister.getRole() + "' returned an instance of '" + element.getClass().getName() + "'");
        }
        collection.beforeInitialize(this.persister, resultList.size());
        collection.injectLoadedState(this.getLoadable(), resultList);
        collection.afterInitialize();
        session.getPersistenceContextInternal().getCollectionEntry(collection).postInitialize(collection, session);
        return collection;
    }
}

