/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data.attestation;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.webauthn4j.data.attestation.authenticator.AuthenticatorData;
import com.webauthn4j.data.attestation.statement.AttestationStatement;
import com.webauthn4j.data.extension.authenticator.RegistrationExtensionAuthenticatorOutput;
import com.webauthn4j.util.AssertUtil;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AttestationObject {
    @JsonProperty(value="authData")
    private final AuthenticatorData<RegistrationExtensionAuthenticatorOutput> authenticatorData;
    @JsonProperty(value="attStmt")
    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXTERNAL_PROPERTY, property="fmt")
    private final AttestationStatement attestationStatement;

    @JsonCreator
    public AttestationObject(@JsonProperty(value="authData") @NotNull AuthenticatorData<RegistrationExtensionAuthenticatorOutput> authenticatorData, @JsonProperty(value="attStmt") @NotNull AttestationStatement attestationStatement) {
        AssertUtil.notNull(authenticatorData, "authenticatorData must not be null");
        AssertUtil.notNull(attestationStatement, "attestationStatement must not be null");
        this.authenticatorData = authenticatorData;
        this.attestationStatement = attestationStatement;
    }

    @NotNull
    public AuthenticatorData<RegistrationExtensionAuthenticatorOutput> getAuthenticatorData() {
        return this.authenticatorData;
    }

    @JsonProperty(value="fmt")
    @NotNull
    public String getFormat() {
        return this.attestationStatement.getFormat();
    }

    @NotNull
    public AttestationStatement getAttestationStatement() {
        return this.attestationStatement;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AttestationObject that = (AttestationObject)o;
        return Objects.equals(this.authenticatorData, that.authenticatorData) && Objects.equals(this.attestationStatement, that.attestationStatement);
    }

    public int hashCode() {
        return Objects.hash(this.authenticatorData, this.attestationStatement);
    }

    public String toString() {
        return "AttestationObject(authenticatorData=" + String.valueOf(this.authenticatorData) + ", fmt=" + this.getFormat() + ", attestationStatement=" + String.valueOf(this.attestationStatement) + ")";
    }
}

