/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.utils;

import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.MediaType;

public class MediaTypeMatcher {
    public static boolean isHtmlRequest(HttpHeaders headers) {
        return MediaTypeMatcher.isAcceptMediaType(headers, MediaType.TEXT_HTML_TYPE);
    }

    public static boolean isJsonRequest(HttpHeaders headers) {
        return MediaTypeMatcher.isAcceptMediaType(headers, MediaType.APPLICATION_JSON_TYPE);
    }

    private static boolean isAcceptMediaType(HttpHeaders headers, MediaType textHtmlType) {
        for (MediaType m : headers.getAcceptableMediaTypes()) {
            if (m.isWildcardType() || !m.isCompatible(textHtmlType)) continue;
            return true;
        }
        return false;
    }
}

