/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals.graph;

import org.apache.kafka.streams.errors.TopologyException;
import org.apache.kafka.streams.kstream.internals.graph.GracePeriodGraphNode;
import org.apache.kafka.streams.kstream.internals.graph.GraphNode;

public final class GraphGraceSearchUtil {
    private GraphGraceSearchUtil() {
    }

    public static long findAndVerifyWindowGrace(GraphNode graphNode) {
        return GraphGraceSearchUtil.findAndVerifyWindowGrace(graphNode, "");
    }

    private static long findAndVerifyWindowGrace(GraphNode graphNode, String chain) {
        String newChain;
        if (graphNode == null) {
            throw new TopologyException("Window close time is only defined for windowed computations. Got [" + chain + "].");
        }
        if (graphNode instanceof GracePeriodGraphNode) {
            return ((GracePeriodGraphNode)graphNode).gracePeriod();
        }
        String string = newChain = chain.equals("") ? graphNode.nodeName() : graphNode.nodeName() + "->" + chain;
        if (graphNode.parentNodes().isEmpty()) {
            throw new TopologyException("Window close time is only defined for windowed computations. Got [" + newChain + "].");
        }
        long inheritedGrace = -1L;
        for (GraphNode parentNode : graphNode.parentNodes()) {
            long parentGrace = GraphGraceSearchUtil.findAndVerifyWindowGrace(parentNode, newChain);
            inheritedGrace = Math.max(inheritedGrace, parentGrace);
        }
        if (inheritedGrace == -1L) {
            throw new IllegalStateException();
        }
        return inheritedGrace;
    }
}

