/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.locking;

import java.util.function.Supplier;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.dsl.DependencyLockingHandler;
import org.gradle.api.artifacts.dsl.LockMode;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.internal.artifacts.dsl.dependencies.DependencyLockingProvider;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;

public class DefaultDependencyLockingHandler
implements DependencyLockingHandler {
    private final Supplier<ConfigurationContainer> configurationContainer;
    private final DependencyLockingProvider dependencyLockingProvider;
    private ConfigurationContainer configurations;

    public DefaultDependencyLockingHandler(Supplier<ConfigurationContainer> configurationContainer, DependencyLockingProvider dependencyLockingProvider) {
        this.configurationContainer = configurationContainer;
        this.dependencyLockingProvider = dependencyLockingProvider;
    }

    private ConfigurationContainer getConfigurations() {
        if (this.configurations == null) {
            this.configurations = this.configurationContainer.get();
        }
        return this.configurations;
    }

    public void lockAllConfigurations() {
        this.getConfigurations().configureEach(configuration -> configuration.getResolutionStrategy().activateDependencyLocking());
    }

    public void unlockAllConfigurations() {
        this.getConfigurations().configureEach(configuration -> configuration.getResolutionStrategy().deactivateDependencyLocking());
    }

    public Property<LockMode> getLockMode() {
        return this.dependencyLockingProvider.getLockMode();
    }

    public RegularFileProperty getLockFile() {
        return this.dependencyLockingProvider.getLockFile();
    }

    public ListProperty<String> getIgnoredDependencies() {
        return this.dependencyLockingProvider.getIgnoredDependencies();
    }
}

