/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.process.internal;

import com.google.common.collect.Maps;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import org.gradle.initialization.BuildCancellationToken;
import org.gradle.internal.file.PathToFileResolver;
import org.gradle.process.CommandLineArgumentProvider;
import org.gradle.process.ProcessForkOptions;
import org.gradle.process.internal.ClientExecHandleBuilder;
import org.gradle.process.internal.DefaultExecHandle;
import org.gradle.process.internal.ExecHandle;
import org.gradle.process.internal.ExecHandleListener;
import org.gradle.process.internal.ProcessArgumentsSpec;
import org.gradle.process.internal.ProcessStreamsSpec;
import org.gradle.process.internal.StreamsHandler;
import org.gradle.process.internal.streams.EmptyStdInStreamsHandler;
import org.gradle.process.internal.streams.ForwardStdinStreamsHandler;
import org.gradle.process.internal.streams.OutputStreamsForwarder;
import org.gradle.process.internal.streams.SafeStreams;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class DefaultClientExecHandleBuilder
implements ClientExecHandleBuilder,
ProcessArgumentsSpec.HasExecutable {
    private static final EmptyStdInStreamsHandler DEFAULT_STDIN = new EmptyStdInStreamsHandler();
    private final BuildCancellationToken buildCancellationToken;
    private final List<ExecHandleListener> listeners;
    private final ProcessStreamsSpec streamsSpec;
    private final ProcessArgumentsSpec argumentsSpec;
    private final PathToFileResolver fileResolver;
    private Map<String, Object> environment;
    private StreamsHandler inputHandler = DEFAULT_STDIN;
    private String displayName;
    private boolean redirectErrorStream;
    private StreamsHandler streamsHandler;
    private int timeoutMillis = Integer.MAX_VALUE;
    protected boolean daemon;
    private final Executor executor;
    private String executable;
    private File workingDir;

    public DefaultClientExecHandleBuilder(PathToFileResolver fileResolver, Executor executor, BuildCancellationToken buildCancellationToken) {
        this.buildCancellationToken = buildCancellationToken;
        this.executor = executor;
        this.listeners = new ArrayList<ExecHandleListener>();
        this.fileResolver = fileResolver;
        this.argumentsSpec = new ProcessArgumentsSpec(this);
        this.streamsSpec = new ProcessStreamsSpec();
        this.streamsSpec.setStandardOutput(SafeStreams.systemOut());
        this.streamsSpec.setErrorOutput(SafeStreams.systemErr());
        this.streamsSpec.setStandardInput(SafeStreams.emptyInput());
    }

    public ClientExecHandleBuilder commandLine(Iterable<?> args) {
        this.argumentsSpec.commandLine(args);
        return this;
    }

    public ClientExecHandleBuilder commandLine(Object ... args) {
        this.argumentsSpec.commandLine(args);
        return this;
    }

    public ClientExecHandleBuilder setStandardInput(InputStream inputStream) {
        this.streamsSpec.setStandardInput(inputStream);
        this.inputHandler = new ForwardStdinStreamsHandler(inputStream);
        return this;
    }

    public ClientExecHandleBuilder setStandardOutput(OutputStream outputStream) {
        this.streamsSpec.setStandardOutput(outputStream);
        return this;
    }

    public ClientExecHandleBuilder setErrorOutput(OutputStream outputStream) {
        this.streamsSpec.setErrorOutput(outputStream);
        return this;
    }

    public ClientExecHandleBuilder redirectErrorStream() {
        this.redirectErrorStream = true;
        return this;
    }

    public ClientExecHandleBuilder setDisplayName(@Nullable String displayName) {
        this.displayName = displayName;
        return this;
    }

    public ClientExecHandleBuilder setDaemon(boolean daemon) {
        this.daemon = daemon;
        return this;
    }

    public ClientExecHandleBuilder streamsHandler(StreamsHandler streamsHandler) {
        this.streamsHandler = streamsHandler;
        return this;
    }

    public ClientExecHandleBuilder setTimeout(int timeoutMillis) {
        this.timeoutMillis = timeoutMillis;
        return this;
    }

    public ClientExecHandleBuilder args(Object ... args) {
        this.argumentsSpec.args(args);
        return this;
    }

    public ClientExecHandleBuilder args(Iterable<?> args) {
        this.argumentsSpec.args(args);
        return this;
    }

    public List<String> getArgs() {
        return this.argumentsSpec.getArgs();
    }

    public ClientExecHandleBuilder setArgs(Iterable<?> args) {
        this.argumentsSpec.setArgs(args);
        return this;
    }

    @Override
    public String getExecutable() {
        return this.executable;
    }

    @Override
    public void setExecutable(Object executable) {
        this.setExecutable(Objects.toString(executable));
    }

    public ClientExecHandleBuilder setExecutable(String executable) {
        this.executable = executable;
        return this;
    }

    public ClientExecHandleBuilder listener(ExecHandleListener listener) {
        this.listeners.add(listener);
        return this;
    }

    public OutputStream getErrorOutput() {
        return this.streamsSpec.getErrorOutput();
    }

    public List<String> getCommandLine() {
        return this.argumentsSpec.getCommandLine();
    }

    public OutputStream getStandardOutput() {
        return this.streamsSpec.getStandardOutput();
    }

    public List<String> getAllArguments() {
        return this.argumentsSpec.getAllArguments();
    }

    public List<CommandLineArgumentProvider> getArgumentProviders() {
        return this.argumentsSpec.getArgumentProviders();
    }

    public Map<String, Object> getEnvironment() {
        if (this.environment == null) {
            this.setEnvironment(System.getenv());
        }
        return this.environment;
    }

    public ClientExecHandleBuilder environment(String key, Object value) {
        this.getEnvironment().put(key, value);
        return this;
    }

    public void setEnvironment(Map<String, ?> environmentVariables) {
        this.environment = Maps.newHashMap(environmentVariables);
    }

    public void environment(Map<String, ?> environmentVariables) {
        this.getEnvironment().putAll(environmentVariables);
    }

    public InputStream getStandardInput() {
        return this.streamsSpec.getStandardInput();
    }

    public @Nullable File getWorkingDir() {
        if (this.workingDir == null) {
            this.workingDir = this.fileResolver.resolve((Object)".");
        }
        return this.workingDir;
    }

    public ClientExecHandleBuilder setWorkingDir(@Nullable File dir) {
        this.workingDir = dir == null ? null : this.fileResolver.resolve((Object)dir);
        return this;
    }

    public ClientExecHandleBuilder setWorkingDir(@Nullable Object dir) {
        this.workingDir = dir == null ? null : this.fileResolver.resolve(dir);
        return this;
    }

    public void copyTo(ProcessForkOptions options) {
        options.setExecutable(this.executable);
        options.setWorkingDir(this.getWorkingDir());
        options.setEnvironment(this.getEnvironment());
    }

    private static Map<String, String> getEffectiveEnvironment(Map<String, Object> environment) {
        LinkedHashMap effectiveEnvironment = Maps.newLinkedHashMapWithExpectedSize((int)environment.size());
        for (Map.Entry<String, Object> entry : environment.entrySet()) {
            effectiveEnvironment.put(entry.getKey(), String.valueOf(entry.getValue()));
        }
        return effectiveEnvironment;
    }

    private static StreamsHandler getEffectiveStreamsHandler(@Nullable StreamsHandler streamsHandler, ProcessStreamsSpec streamsSpec, boolean redirectErrorStream) {
        if (streamsHandler != null) {
            return streamsHandler;
        }
        boolean shouldReadErrorStream = !redirectErrorStream;
        return new OutputStreamsForwarder(streamsSpec.getStandardOutput(), streamsSpec.getErrorOutput(), shouldReadErrorStream);
    }

    public ExecHandle build() {
        return this.buildWithEffectiveArguments(this.argumentsSpec.getAllArguments());
    }

    public ExecHandle buildWithEffectiveArguments(List<String> effectiveArguments) {
        String displayName = this.displayName == null ? String.format("command '%s'", this.executable) : this.displayName;
        Map<String, String> effectiveEnvironment = DefaultClientExecHandleBuilder.getEffectiveEnvironment(this.getEnvironment());
        StreamsHandler effectiveOutputHandler = DefaultClientExecHandleBuilder.getEffectiveStreamsHandler(this.streamsHandler, this.streamsSpec, this.redirectErrorStream);
        return new DefaultExecHandle(displayName, this.getWorkingDir(), this.executable, effectiveArguments, effectiveEnvironment, effectiveOutputHandler, this.inputHandler, this.listeners, this.redirectErrorStream, this.timeoutMillis, this.daemon, this.executor, this.buildCancellationToken);
    }
}

