/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolutionstrategy;

import groovy.lang.Closure;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.InvalidUserCodeException;
import org.gradle.api.artifacts.ComponentSelection;
import org.gradle.api.artifacts.ComponentSelectionRules;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.internal.artifacts.ComponentSelectionRulesInternal;
import org.gradle.api.internal.artifacts.ImmutableModuleIdentifierFactory;
import org.gradle.api.internal.artifacts.configurations.MutationValidator;
import org.gradle.api.internal.notations.ModuleIdentifierNotationConverter;
import org.gradle.api.specs.Spec;
import org.gradle.api.specs.Specs;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.deprecation.DeprecationMessageBuilder;
import org.gradle.internal.rules.DefaultRuleActionAdapter;
import org.gradle.internal.rules.DefaultRuleActionValidator;
import org.gradle.internal.rules.RuleAction;
import org.gradle.internal.rules.RuleActionAdapter;
import org.gradle.internal.rules.SpecRuleAction;
import org.gradle.internal.typeconversion.NotationConverter;
import org.gradle.internal.typeconversion.NotationParser;
import org.gradle.internal.typeconversion.NotationParserBuilder;
import org.gradle.internal.typeconversion.UnsupportedNotationException;

public class DefaultComponentSelectionRules
implements ComponentSelectionRulesInternal {
    private static final String INVALID_SPEC_ERROR = "Could not add a component selection rule for module '%s'.";
    private MutationValidator mutationValidator = MutationValidator.IGNORE;
    private Set<SpecRuleAction<? super ComponentSelection>> rules;
    private final RuleActionAdapter ruleActionAdapter;
    private final NotationParser<Object, ModuleIdentifier> moduleIdentifierNotationParser;

    public DefaultComponentSelectionRules(ImmutableModuleIdentifierFactory moduleIdentifierFactory) {
        this(moduleIdentifierFactory, DefaultComponentSelectionRules.createAdapter());
    }

    protected DefaultComponentSelectionRules(ImmutableModuleIdentifierFactory moduleIdentifierFactory, RuleActionAdapter ruleActionAdapter) {
        this.ruleActionAdapter = ruleActionAdapter;
        this.moduleIdentifierNotationParser = NotationParserBuilder.toType(ModuleIdentifier.class).fromCharSequence((NotationConverter)new ModuleIdentifierNotationConverter(moduleIdentifierFactory)).toComposite();
    }

    public void setMutationValidator(MutationValidator mutationValidator) {
        this.mutationValidator = mutationValidator;
    }

    private static RuleActionAdapter createAdapter() {
        DefaultRuleActionValidator ruleActionValidator = new DefaultRuleActionValidator();
        return new DefaultRuleActionAdapter(ruleActionValidator, "ComponentSelectionRules");
    }

    @Override
    public Collection<SpecRuleAction<? super ComponentSelection>> getRules() {
        return this.rules != null ? this.rules : Collections.emptySet();
    }

    public ComponentSelectionRules all(Action<? super ComponentSelection> selectionAction) {
        return this.addRule(this.createAllSpecRulesAction(this.ruleActionAdapter.createFromAction(selectionAction)));
    }

    public ComponentSelectionRules all(Closure<?> closure) {
        return this.addRule(this.createAllSpecRulesAction(this.ruleActionAdapter.createFromClosure(ComponentSelection.class, closure)));
    }

    @Deprecated
    public ComponentSelectionRules all(Object ruleSource) {
        ((DeprecationMessageBuilder.WithDocumentation)DeprecationLogger.deprecateMethod(ComponentSelectionRules.class, (String)"all(Object)").willBeRemovedInGradle10().withUpgradeGuideSection(9, "dependency_management_rules")).nagUser();
        return this.addRule(this.createAllSpecRulesAction(this.ruleActionAdapter.createFromRuleSource(ComponentSelection.class, ruleSource)));
    }

    public ComponentSelectionRules withModule(Object id, Action<? super ComponentSelection> selectionAction) {
        return this.addRule(this.createSpecRuleActionFromId(id, this.ruleActionAdapter.createFromAction(selectionAction)));
    }

    public ComponentSelectionRules withModule(Object id, Closure<?> closure) {
        return this.addRule(this.createSpecRuleActionFromId(id, this.ruleActionAdapter.createFromClosure(ComponentSelection.class, closure)));
    }

    @Deprecated
    public ComponentSelectionRules withModule(Object id, Object ruleSource) {
        ((DeprecationMessageBuilder.WithDocumentation)DeprecationLogger.deprecateMethod(ComponentSelectionRules.class, (String)"withModule(Object,Object)").willBeRemovedInGradle10().withUpgradeGuideSection(9, "dependency_management_rules")).nagUser();
        return this.addRule(this.createSpecRuleActionFromId(id, this.ruleActionAdapter.createFromRuleSource(ComponentSelection.class, ruleSource)));
    }

    @Override
    public ComponentSelectionRules addRule(SpecRuleAction<? super ComponentSelection> specRuleAction) {
        this.mutationValidator.validateMutation(MutationValidator.MutationType.STRATEGY);
        if (this.rules == null) {
            this.rules = new LinkedHashSet<SpecRuleAction<? super ComponentSelection>>();
        }
        this.rules.add(specRuleAction);
        return this;
    }

    @Override
    public ComponentSelectionRules addRule(RuleAction<? super ComponentSelection> specRuleAction) {
        return this.addRule(this.createAllSpecRulesAction(specRuleAction));
    }

    private SpecRuleAction<? super ComponentSelection> createSpecRuleActionFromId(Object id, RuleAction<? super ComponentSelection> ruleAction) {
        ModuleIdentifier moduleIdentifier;
        try {
            moduleIdentifier = (ModuleIdentifier)this.moduleIdentifierNotationParser.parseNotation(id);
        }
        catch (UnsupportedNotationException e) {
            throw new InvalidUserCodeException(String.format(INVALID_SPEC_ERROR, id == null ? "null" : id.toString()), (Throwable)e);
        }
        ComponentSelectionMatchingSpec spec = new ComponentSelectionMatchingSpec(moduleIdentifier);
        return new SpecRuleAction<ComponentSelection>(ruleAction, spec);
    }

    private SpecRuleAction<? super ComponentSelection> createAllSpecRulesAction(RuleAction<? super ComponentSelection> ruleAction) {
        return new SpecRuleAction<ComponentSelection>(ruleAction, Specs.satisfyAll());
    }

    static class ComponentSelectionMatchingSpec
    implements Spec<ComponentSelection> {
        final ModuleIdentifier target;

        private ComponentSelectionMatchingSpec(ModuleIdentifier target) {
            this.target = target;
        }

        public boolean isSatisfiedBy(ComponentSelection selection) {
            return selection.getCandidate().getGroup().equals(this.target.getGroup()) && selection.getCandidate().getModule().equals(this.target.getName());
        }
    }
}

