/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.DOMInvalidAccessException;
import io.sf.carte.doc.DOMNotSupportedException;
import io.sf.carte.doc.style.css.AlgebraicExpression;
import io.sf.carte.doc.style.css.BoxValues;
import io.sf.carte.doc.style.css.CSSCanvas;
import io.sf.carte.doc.style.css.CSSColor;
import io.sf.carte.doc.style.css.CSSColorMixFunction;
import io.sf.carte.doc.style.css.CSSComputedProperties;
import io.sf.carte.doc.style.css.CSSDeclarationRule;
import io.sf.carte.doc.style.css.CSSElement;
import io.sf.carte.doc.style.css.CSSExpression;
import io.sf.carte.doc.style.css.CSSExpressionValue;
import io.sf.carte.doc.style.css.CSSMathFunctionValue;
import io.sf.carte.doc.style.css.CSSNumberValue;
import io.sf.carte.doc.style.css.CSSOperandExpression;
import io.sf.carte.doc.style.css.CSSPrimitiveValue;
import io.sf.carte.doc.style.css.CSSPropertyDefinition;
import io.sf.carte.doc.style.css.CSSResourceLimitException;
import io.sf.carte.doc.style.css.CSSTypedValue;
import io.sf.carte.doc.style.css.CSSUnit;
import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.CSSValueSyntax;
import io.sf.carte.doc.style.css.StyleDatabase;
import io.sf.carte.doc.style.css.StyleDatabaseRequiredException;
import io.sf.carte.doc.style.css.StyleDeclarationErrorHandler;
import io.sf.carte.doc.style.css.StyleFormattingContext;
import io.sf.carte.doc.style.css.UnitStringToId;
import io.sf.carte.doc.style.css.Viewport;
import io.sf.carte.doc.style.css.nsac.CSSBudgetException;
import io.sf.carte.doc.style.css.nsac.CSSParseException;
import io.sf.carte.doc.style.css.nsac.Condition;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.nsac.Parser;
import io.sf.carte.doc.style.css.om.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.BaseDocumentCSSStyleSheet;
import io.sf.carte.doc.style.css.om.BoxModelHelper;
import io.sf.carte.doc.style.css.om.CounterRef;
import io.sf.carte.doc.style.css.om.PendingSubstitutionValue;
import io.sf.carte.doc.style.css.om.SimpleBoxModel;
import io.sf.carte.doc.style.css.parser.ParseHelper;
import io.sf.carte.doc.style.css.property.CSSPropertyValueException;
import io.sf.carte.doc.style.css.property.ColorIdentifiers;
import io.sf.carte.doc.style.css.property.ColorValue;
import io.sf.carte.doc.style.css.property.EnvVariableValue;
import io.sf.carte.doc.style.css.property.Evaluator;
import io.sf.carte.doc.style.css.property.ExpressionValue;
import io.sf.carte.doc.style.css.property.IdentifierValue;
import io.sf.carte.doc.style.css.property.InheritValue;
import io.sf.carte.doc.style.css.property.LexicalValue;
import io.sf.carte.doc.style.css.property.LinkedCSSValueList;
import io.sf.carte.doc.style.css.property.MathFunctionValue;
import io.sf.carte.doc.style.css.property.NumberValue;
import io.sf.carte.doc.style.css.property.PercentageEvaluator;
import io.sf.carte.doc.style.css.property.PrimitiveValue;
import io.sf.carte.doc.style.css.property.PropertyDatabase;
import io.sf.carte.doc.style.css.property.ProxyValue;
import io.sf.carte.doc.style.css.property.ShorthandDatabase;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.doc.style.css.property.TypedValue;
import io.sf.carte.doc.style.css.property.URIValue;
import io.sf.carte.doc.style.css.property.URIValueWrapper;
import io.sf.carte.doc.style.css.property.ValueFactory;
import io.sf.carte.doc.style.css.property.ValueList;
import io.sf.carte.doc.style.css.property.WrappedValue;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;

public abstract class ComputedCSSStyle
extends BaseCSSStyleDeclaration
implements CSSComputedProperties {
    private static final long serialVersionUID = 1L;
    static final float SCREEN_WIDTH = 1440.0f;
    static final float SCREEN_HEIGHT = 810.0f;
    static final float HANDHELD_WIDTH = 270.0f;
    static final float HANDHELD_HEIGHT = 480.0f;
    static final float PRINT_WIDTH = 595.0f;
    static final float PRINT_HEIGHT = 842.0f;
    private static Set<String> attrForbiddenProperties = new HashSet<String>(7);
    private final BaseDocumentCSSStyleSheet ownerSheet;
    private CSSElement node = null;
    private transient Set<String> attrTaintedProperties = null;

    protected ComputedCSSStyle(BaseDocumentCSSStyleSheet docSheet) {
        this.ownerSheet = docSheet;
    }

    protected ComputedCSSStyle(ComputedCSSStyle copiedObject) {
        super(copiedObject);
        this.ownerSheet = copiedObject.ownerSheet;
        this.setOwnerNode(copiedObject.getOwnerNode());
    }

    protected void setOwnerNode(CSSElement node) {
        this.node = node;
    }

    @Override
    public CSSElement getOwnerNode() {
        return this.node;
    }

    protected BaseDocumentCSSStyleSheet getOwnerSheet() {
        return this.ownerSheet;
    }

    @Override
    public StyleDeclarationErrorHandler getStyleDeclarationErrorHandler() {
        if (this.node != null && this.node.getNodeType() == 1) {
            return this.node.getOwnerDocument().getErrorHandler().getInlineStyleErrorHandler(this.node);
        }
        return null;
    }

    @Override
    String getUnknownPropertyPriority(String propertyName) {
        return this.checkShorthandPriority(propertyName);
    }

    @Override
    public String getPropertyValue(String propertyName) {
        StyleValue value = this.getCSSValue(propertyName = this.getCanonicalPropertyName(propertyName));
        if (value != null) {
            CSSValue.Type ptype;
            CSSValue.CssType type = value.getCssValueType();
            if (type == CSSValue.CssType.TYPED && ((ptype = value.getPrimitiveType()) == CSSValue.Type.STRING || ptype == CSSValue.Type.IDENT)) {
                return ((CSSTypedValue)((Object)value)).getStringValue();
            }
            return value.getCssText();
        }
        if (ShorthandDatabase.getInstance().isShorthand(propertyName)) {
            return this.serializeShorthand(propertyName);
        }
        return "";
    }

    private static boolean isCustomPropertyName(String propertyName) {
        return propertyName.startsWith("--");
    }

    @Override
    protected void setPropertyCSSValue(String propertyName, StyleValue value, String hrefcontext) {
        if ("background-image".equals(propertyName) || "border-image-source".equals(propertyName)) {
            if (value.getCssValueType() == CSSValue.CssType.LIST) {
                if (hrefcontext != null) {
                    value = ((ValueList)value).wrap(hrefcontext, this.getOwnerNode().getOwnerDocument().getBaseURI());
                }
            } else if (value.getPrimitiveType() == CSSValue.Type.URI && hrefcontext != null) {
                value = new URIValueWrapper((URIValue)value, hrefcontext, this.getOwnerNode().getOwnerDocument().getBaseURI());
            }
        }
        super.setPropertyCSSValue(propertyName, value, hrefcontext);
    }

    private LexicalValue getCustomPropertyValue(String property, boolean inherited, CounterRef counter, Set<String> customPtySet) {
        LexicalValue value = (LexicalValue)super.getCSSValue(property);
        ComputedCSSStyle ancStyle = this;
        if (inherited) {
            while (value == null) {
                if ((ancStyle = ancStyle.getParentComputedStyle()) == null) {
                    value = null;
                    break;
                }
                if (!ancStyle.isPropertySet(property)) continue;
                value = (LexicalValue)ancStyle.getDeclaredCSSValue(property);
            }
        }
        return value;
    }

    public StyleValue getCascadedValue(String property) throws StyleDatabaseRequiredException {
        StyleValue value = super.getCSSValue(property);
        if (value != null) {
            CSSValue.CssType category = value.getCssValueType();
            if (category == CSSValue.CssType.PROXY) {
                value = this.replaceProxyValues(property, value);
            } else if (value.getCssValueType() == CSSValue.CssType.SHORTHAND) {
                return null;
            }
            if (value != null) {
                if (value.getPrimitiveType() == CSSValue.Type.UNSET) {
                    value = null;
                } else {
                    try {
                        value = this.absoluteValue(property, value, false);
                    }
                    catch (DOMException e) {
                        this.computedStyleError(property, value.getCssText(), null, e);
                        value = null;
                    }
                }
            }
        }
        if (value == null) {
            boolean inherited;
            CSSPropertyDefinition definition = null;
            boolean bl = inherited = PropertyDatabase.getInstance().isInherited(property) || ComputedCSSStyle.isCustomPropertyName(property) && ((definition = this.getOwnerSheet().getPropertyDefinition(property)) == null || definition.inherits());
            value = inherited ? InheritValue.getValue() : (definition != null ? (StyleValue)((Object)definition.getInitialValue()) : this.defaultPropertyValue(property));
        }
        return value;
    }

    @Override
    public StyleValue getCSSValue(String property) throws StyleDatabaseRequiredException {
        StyleValue comp;
        boolean inherited = PropertyDatabase.getInstance().isInherited(property);
        if (!inherited && ComputedCSSStyle.isCustomPropertyName(property)) {
            LexicalUnit initial;
            LexicalValue lexval;
            CSSPropertyDefinition definition = this.getOwnerSheet().getPropertyDefinition(property);
            inherited = definition == null || definition.inherits();
            try {
                lexval = this.getCustomPropertyValue(property, inherited, new CounterRef(), new HashSet<String>(1));
            }
            catch (DOMException e) {
                this.computedStyleError(property, null, null, e);
                return null;
            }
            if (lexval == null && definition != null && (initial = definition.getInitialValue()) != null) {
                lexval = new LexicalValue();
                lexval.setLexicalUnit(initial);
            }
            comp = lexval;
        } else {
            comp = this.getCSSValue(property, inherited);
        }
        return comp;
    }

    StyleValue getCSSValue(String property, boolean inherited) throws StyleDatabaseRequiredException {
        StyleValue value = this.getDeclaredCSSValue(property);
        if (value != null) {
            CSSValue.CssType category = value.getCssValueType();
            if (category == CSSValue.CssType.PROXY || category == CSSValue.CssType.LIST) {
                value = this.replaceProxyValues(property, value);
            } else if (category == CSSValue.CssType.SHORTHAND) {
                return null;
            }
            if (value != null) {
                if (value.getPrimitiveType() == CSSValue.Type.UNSET) {
                    value = null;
                } else if (value.getPrimitiveType() == CSSValue.Type.LEXICAL) {
                    this.computedStyleError(property, value.getCssText(), "Unable to replace LEXICAL value.");
                    value = null;
                }
            }
        }
        if ((value = ComputedCSSStyle.inheritValue(this, property, value, inherited)) != null && value.getPrimitiveType() == CSSValue.Type.INHERIT) {
            value = null;
        }
        value = this.computeValue(property, value, inherited);
        return value;
    }

    private StyleValue replaceProxyValues(String property, StyleValue value) {
        block4: {
            CSSValue.CssType type;
            block5: {
                type = value.getCssValueType();
                if (type != CSSValue.CssType.LIST) break block5;
                ValueList list = (ValueList)value;
                int lstlen = list.getLength();
                for (int i = 0; i < lstlen; ++i) {
                    StyleValue item = list.item(i);
                    item = this.replaceProxyValues(property, item);
                    while (item != null && item.getCssValueType() == CSSValue.CssType.PROXY) {
                        item = this.replaceProxyValue(property, item);
                    }
                    if (item == null) {
                        value = null;
                        break block4;
                    }
                    list.set(i, item);
                }
                break block4;
            }
            if (type != CSSValue.CssType.PROXY) break block4;
            while ((value = this.replaceProxyValue(property, value)) != null && value.getCssValueType() == CSSValue.CssType.PROXY && value.getPrimitiveType() != CSSValue.Type.LEXICAL) {
            }
        }
        return value;
    }

    private TypedValue primitiveToTypedValue(String propertyName, PrimitiveValue value) {
        TypedValue typed;
        if (value.getCssValueType() == CSSValue.CssType.TYPED) {
            typed = (TypedValue)value;
        } else {
            StyleValue proxy = value;
            while ((proxy = this.replaceProxyValue(propertyName, proxy)) != null && proxy.getCssValueType() == CSSValue.CssType.PROXY && proxy.getPrimitiveType() != CSSValue.Type.LEXICAL) {
            }
            if (proxy == null || proxy.getCssValueType() != CSSValue.CssType.TYPED) {
                this.computedStyleError(propertyName, value.getCssText(), "Could not evaluate proxy value");
                return null;
            }
            typed = (TypedValue)proxy;
        }
        return typed;
    }

    StyleValue replaceProxyValue(String propertyName, CSSValue pri) {
        StyleValue value;
        CSSValue.Type pritype = pri.getPrimitiveType();
        if (pritype == CSSValue.Type.LEXICAL) {
            try {
                value = this.evaluateLexicalValue(propertyName, (LexicalValue)pri);
            }
            catch (CSSResourceLimitException e) {
                this.computedStyleError(propertyName, pri.getCssText(), null, e);
                return null;
            }
            if (value != null && value.getPrimitiveType() == CSSValue.Type.LEXICAL) {
                if (!ComputedCSSStyle.isCustomPropertyName(propertyName)) {
                    this.computedStyleError(propertyName, value.getCssText(), "Invalid value for non-custom property.");
                    return null;
                }
                return value;
            }
        } else if (pritype == CSSValue.Type.ENV) {
            value = this.computeEnv(propertyName, (EnvVariableValue)pri);
        } else if (pritype == CSSValue.Type.INTERNAL) {
            PendingSubstitutionValue pending = (PendingSubstitutionValue)pri;
            value = this.getSubstitutedValue(propertyName, pending.getShorthandName(), pending.getLexicalUnit().clone(), this.isPropertyImportant(propertyName));
        } else {
            return null;
        }
        return value;
    }

    private static StyleValue inheritValue(ComputedCSSStyle ancStyle, String propertyName, StyleValue value, boolean inherited) {
        while ((value == null ? inherited : value.getPrimitiveType() == CSSValue.Type.INHERIT) && (ancStyle = ancStyle.getParentComputedStyle()) != null) {
            if (!ancStyle.isPropertySet(propertyName) || (value = ancStyle.getCSSValue(propertyName)) == null || value.getPrimitiveType() != CSSValue.Type.UNSET) continue;
            value = null;
        }
        return value;
    }

    private StyleValue getSubstitutedValue(String longhand, String shorthandName, LexicalUnit lunit, boolean propertyImportant) {
        try {
            lunit = this.replaceLexicalProxy(longhand, lunit, new CounterRef(), new HashSet<String>(1));
            if (lunit != null && this.setShorthandLonghands(shorthandName, lunit, propertyImportant, null, this.attrTaintedProperties != null && this.attrTaintedProperties.contains(longhand))) {
                return this.getCSSValue(longhand);
            }
        }
        catch (DOMException e) {
            this.computedStyleError(longhand, lunit.toString(), "Problem substituting lexical value in shorthand.", e);
        }
        return null;
    }

    private StyleValue computeValue(String property, StyleValue value, boolean inherited) {
        if (value == null || value.getPrimitiveType() == CSSValue.Type.INITIAL || !inherited && value.getPrimitiveType() == CSSValue.Type.UNSET) {
            value = this.defaultPropertyValue(property);
        }
        if (value != null) {
            if (value.isSystemDefault()) {
                return value;
            }
            if (property.equals("font-size")) {
                value = this.absoluteFontSizeValue(value, false);
            } else {
                try {
                    value = this.absoluteValue(property, value, false);
                }
                catch (DOMException e) {
                    this.computedStyleError(property, value.getCssText(), null, e);
                    value = null;
                }
                if (value == null) {
                    if (inherited) {
                        ComputedCSSStyle ancStyle = this;
                        do {
                            if ((value = ComputedCSSStyle.inheritValue(ancStyle, property, value, true)) == null || (value = ancStyle.replaceProxyValues(property, value)) == null) continue;
                            value = ancStyle.computeValue(property, value, inherited);
                        } while (value == null && (ancStyle = ancStyle.getParentComputedStyle()) != null);
                    }
                    if (value == null || value.getPrimitiveType() == CSSValue.Type.INHERIT) {
                        value = this.defaultPropertyValue(property);
                    }
                }
                if ("display".equals(property)) {
                    value = this.applyDisplayConstrains(value);
                } else if (property.endsWith("-width")) {
                    value = this.applyBorderWidthConstrains(property, value);
                } else if ("background-repeat".equals(property)) {
                    value = this.computeBackgroundRepeat(value);
                } else if (property.endsWith("color") && value.getCssValueType() == CSSValue.CssType.TYPED) {
                    value = this.colorValue(property, (TypedValue)value);
                }
            }
        }
        return value;
    }

    private StyleValue absoluteValue(String property, StyleValue value, boolean useParentStyle) {
        CSSValue.CssType type = value.getCssValueType();
        if (type == CSSValue.CssType.LIST) {
            ValueList list = (ValueList)value;
            int lstlen = list.getLength();
            for (int i = 0; i < lstlen; ++i) {
                list.set(i, this.absoluteValue(property, list.item(i), useParentStyle));
            }
        } else if (type == CSSValue.CssType.TYPED) {
            value = this.absoluteTypedValue(property, (TypedValue)value, useParentStyle);
        }
        return value;
    }

    TypedValue absoluteTypedValue(String propertyName, TypedValue typed, boolean useParentStyle) {
        if (this.isRelativeUnit(typed)) {
            try {
                typed = this.absoluteNumberValue((CSSNumberValue)((Object)typed), useParentStyle);
            }
            catch (IllegalStateException | DOMException e) {
                this.computedStyleError(propertyName, typed.getCssText(), "Could not absolutize property value.", e);
            }
        } else {
            CSSValue.Type type = typed.getPrimitiveType();
            if (type == CSSValue.Type.EXPRESSION) {
                typed = typed.clone();
                ExpressionValue exprval = (ExpressionValue)typed;
                MyEvaluator ev = new MyEvaluator(propertyName);
                try {
                    typed = (TypedValue)((Object)ev.evaluateExpression(exprval));
                }
                catch (DOMNotSupportedException e) {
                    this.computedStyleWarning(propertyName, typed, "Could not evaluate expression value.", (Throwable)e);
                    this.absoluteExpressionValue(propertyName, exprval.getExpression(), useParentStyle);
                }
            } else if (type == CSSValue.Type.MATH_FUNCTION) {
                MathFunctionValue function = (MathFunctionValue)typed;
                MyEvaluator ev = new MyEvaluator(propertyName);
                try {
                    typed = (TypedValue)((Object)ev.evaluateFunction(function));
                }
                catch (DOMNotSupportedException e) {
                    this.computedStyleWarning(propertyName, typed, "Could not evaluate function value.", (Throwable)e);
                    function = (MathFunctionValue)typed.clone();
                    LinkedCSSValueList args = function.getArguments();
                    int sz = args.size();
                    for (int i = 0; i < sz; ++i) {
                        args.set(i, this.absoluteValue(propertyName, (StyleValue)args.get(i), useParentStyle));
                    }
                }
            } else if (type == CSSValue.Type.COLOR) {
                typed = this.computeColor(propertyName, (ColorValue)typed);
            } else if (type == CSSValue.Type.COLOR_MIX) {
                typed = this.computeColorMix(propertyName, typed, useParentStyle);
            } else if (typed.getComponentCount() != 0) {
                typed = this.absolutizeComponents(propertyName, typed, useParentStyle);
            }
        }
        return typed;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private NumberValue absoluteNumberValue(CSSNumberValue value, boolean useParentStyle) {
        short unit = value.getUnitType();
        float fv = value.getFloatValue(unit);
        if (unit == 20) {
            ComputedCSSStyle parentStyle;
            fv = useParentStyle ? ((parentStyle = this.getParentComputedStyle()) != null ? (fv *= parentStyle.getComputedFontSize()) : (fv *= this.getInitialFontSize())) : (fv *= this.getComputedFontSize());
            return ComputedCSSStyle.asNumericValuePt(fv);
        } else if (unit == 21) {
            float fontSize;
            ComputedCSSStyle style;
            if (useParentStyle) {
                style = this.getParentComputedStyle();
                if (style != null) {
                    fontSize = style.getComputedFontSize();
                } else {
                    style = this;
                    fontSize = this.getInitialFontSize();
                }
            } else {
                style = this;
                fontSize = this.getComputedFontSize();
            }
            fv = this.getStyleDatabase() != null ? (fv *= this.getStyleDatabase().getExSizeInPt(style.getUsedFontFamily(), fontSize)) : (fv *= fontSize * 0.5f);
            return ComputedCSSStyle.asNumericValuePt(fv);
        } else if (unit == 26) {
            CSSElement root = this.getOwnerNode().getOwnerDocument().getDocumentElement();
            fv = root != this.getOwnerNode() ? (fv *= root.getComputedStyle(null).getComputedFontSize()) : (!useParentStyle ? (fv *= this.getComputedFontSize()) : (fv *= this.getInitialFontSize()));
            return ComputedCSSStyle.asNumericValuePt(fv);
        } else if (unit == 28) {
            float fontSize;
            CSSElement root = this.getOwnerNode().getOwnerDocument().getDocumentElement();
            CSSComputedProperties style = this;
            if (root != this.getOwnerNode()) {
                style = root.getComputedStyle(null);
                fontSize = style.getComputedFontSize();
            } else {
                fontSize = !useParentStyle ? this.getComputedFontSize() : this.getInitialFontSize();
            }
            fv = this.getStyleDatabase() != null ? (fv *= this.getStyleDatabase().getExSizeInPt(style.getUsedFontFamily(), fontSize)) : (fv *= fontSize * 0.5f);
            return ComputedCSSStyle.asNumericValuePt(fv);
        } else if (unit == 25) {
            ComputedCSSStyle parentStyle;
            fv = useParentStyle ? ((parentStyle = this.getParentComputedStyle()) != null ? (fv *= parentStyle.getComputedLineHeight()) : (fv *= this.getInitialFontSize() * 1.2f)) : (fv *= this.getComputedLineHeight());
            return ComputedCSSStyle.asNumericValuePt(fv);
        } else if (unit == 27) {
            CSSElement root = this.getOwnerNode().getOwnerDocument().getDocumentElement();
            fv = root != this.getOwnerNode() ? (fv *= root.getComputedStyle(null).getComputedLineHeight()) : (!useParentStyle ? (fv *= this.getComputedLineHeight()) : (fv *= this.getInitialFontSize() * 1.2f));
            return ComputedCSSStyle.asNumericValuePt(fv);
        } else {
            CSSCanvas canvas = this.getOwnerNode().getOwnerDocument().getCanvas();
            if (unit == 22) {
                ComputedCSSStyle style;
                if (canvas == null) throw new IllegalStateException("cap unit requires canvas");
                if (useParentStyle) {
                    style = this.getParentComputedStyle();
                    if (style == null) {
                        throw new DOMNotSupportedException("Cannot use parent style at root element.");
                    }
                } else {
                    style = this;
                }
                fv *= canvas.getCapHeight(style);
                return ComputedCSSStyle.asNumericValuePt(fv);
            } else if (unit == 23) {
                ComputedCSSStyle style;
                if (useParentStyle) {
                    style = this.getParentComputedStyle();
                    if (style == null) {
                        return ComputedCSSStyle.asNumericValuePt(fv *= this.getInitialFontSize() * 0.25f);
                    }
                } else {
                    style = this;
                }
                fv = canvas != null ? (fv *= (float)canvas.stringWidth("0", style)) : (fv *= style.getComputedFontSize() * 0.25f);
                return ComputedCSSStyle.asNumericValuePt(fv);
            } else if (unit == 29) {
                CSSComputedProperties style;
                CSSElement root = this.getOwnerNode().getOwnerDocument().getDocumentElement();
                if (root != this.getOwnerNode()) {
                    style = root.getComputedStyle(null);
                } else {
                    if (useParentStyle) return ComputedCSSStyle.asNumericValuePt(fv *= this.getInitialFontSize() * 0.25f);
                    style = this;
                }
                fv = canvas != null ? (fv *= (float)canvas.stringWidth("0", style)) : (fv *= style.getComputedFontSize() * 0.25f);
                return ComputedCSSStyle.asNumericValuePt(fv);
            } else if (unit == 24) {
                ComputedCSSStyle style;
                if (useParentStyle) {
                    style = this.getParentComputedStyle();
                    if (style == null) {
                        return ComputedCSSStyle.asNumericValuePt(fv *= this.getInitialFontSize());
                    }
                } else {
                    style = this;
                }
                fv = canvas != null ? (fv *= (float)canvas.stringWidth("\u6c34", style)) : (fv *= this.getComputedFontSize());
                return ComputedCSSStyle.asNumericValuePt(fv);
            } else if (unit == 30) {
                CSSComputedProperties style;
                CSSElement root = this.getOwnerNode().getOwnerDocument().getDocumentElement();
                if (root != this.getOwnerNode()) {
                    style = root.getComputedStyle(null);
                } else {
                    if (useParentStyle) return ComputedCSSStyle.asNumericValuePt(fv *= this.getInitialFontSize());
                    style = this;
                }
                fv = canvas != null ? (fv *= (float)canvas.stringWidth("\u6c34", style)) : (fv *= style.getComputedFontSize());
                return ComputedCSSStyle.asNumericValuePt(fv);
            } else if (unit == 45) {
                fv *= this.getInitialContainingBlockWidthPt(canvas, true) * 0.01f;
                return ComputedCSSStyle.asNumericValuePt(fv);
            } else if (unit == 41) {
                fv *= this.getInitialContainingBlockHeightPt(canvas, true) * 0.01f;
                return ComputedCSSStyle.asNumericValuePt(fv);
            } else if (unit == 42) {
                String writingMode = this.getCSSValue("writing-mode").getCssText();
                fv = "horizontal-tb".equalsIgnoreCase(writingMode) ? (fv *= this.getInitialContainingBlockWidthPt(canvas, true)) : (fv *= this.getInitialContainingBlockHeightPt(canvas, true));
                fv *= 0.01f;
                return ComputedCSSStyle.asNumericValuePt(fv);
            } else if (unit == 40) {
                String writingMode = this.getCSSValue("writing-mode").getCssText();
                fv = "horizontal-tb".equalsIgnoreCase(writingMode) ? (fv *= this.getInitialContainingBlockHeightPt(canvas, true)) : (fv *= this.getInitialContainingBlockWidthPt(canvas, true));
                fv *= 0.01f;
                return ComputedCSSStyle.asNumericValuePt(fv);
            } else if (unit == 44) {
                float size = Math.min(this.getInitialContainingBlockWidthPt(canvas, true), this.getInitialContainingBlockHeightPt(canvas, true));
                fv *= size * 0.01f;
                return ComputedCSSStyle.asNumericValuePt(fv);
            } else if (unit == 43) {
                float size = Math.max(this.getInitialContainingBlockWidthPt(canvas, true), this.getInitialContainingBlockHeightPt(canvas, true));
                fv *= size * 0.01f;
                return ComputedCSSStyle.asNumericValuePt(fv);
            } else {
                fv = NumberValue.floatValueConversion(fv, unit, (short)6);
            }
        }
        return ComputedCSSStyle.asNumericValuePt(fv);
    }

    private float getInitialContainingBlockWidthPt(CSSCanvas canvas, boolean force) throws StyleDatabaseRequiredException {
        String medium;
        Viewport viewport;
        if (canvas != null && (viewport = canvas.getViewport()) != null) {
            float fv = viewport.getViewportWidth();
            return NumberValue.floatValueConversion(fv, this.getStyleDatabase().getNaturalUnit(), (short)6);
        }
        StyleDatabase sdb = this.getStyleDatabase();
        if (sdb != null) {
            float fv = sdb.getDeviceWidth();
            return NumberValue.floatValueConversion(fv, sdb.getNaturalUnit(), (short)6);
        }
        if (force && (medium = this.getOwnerNode().getOwnerDocument().getTargetMedium()) != null) {
            if ("print".equals(medium)) {
                return 595.0f;
            }
            if ("screen".equals(medium)) {
                return 1440.0f;
            }
            if ("handheld".equals(medium)) {
                return 270.0f;
            }
        }
        throw new StyleDatabaseRequiredException("Unit conversion failed.");
    }

    private float getInitialContainingBlockHeightPt(CSSCanvas canvas, boolean force) throws StyleDatabaseRequiredException {
        String medium;
        Viewport viewport;
        if (canvas != null && (viewport = canvas.getViewport()) != null) {
            float fv = viewport.getViewportHeight();
            return NumberValue.floatValueConversion(fv, this.getStyleDatabase().getNaturalUnit(), (short)6);
        }
        StyleDatabase sdb = this.getStyleDatabase();
        if (sdb != null) {
            float fv = sdb.getDeviceHeight();
            return NumberValue.floatValueConversion(fv, sdb.getNaturalUnit(), (short)6);
        }
        if (force && (medium = this.getOwnerNode().getOwnerDocument().getTargetMedium()) != null) {
            if ("print".equals(medium)) {
                return 842.0f;
            }
            if ("screen".equals(medium)) {
                return 810.0f;
            }
            if ("handheld".equals(medium)) {
                return 480.0f;
            }
        }
        throw new StyleDatabaseRequiredException("Unit conversion failed.");
    }

    private TypedValue computeColor(String propertyName, ColorValue color) {
        ColorValue color2 = null;
        int len = color.getColor().getLength();
        for (int i = 0; i < len; ++i) {
            PrimitiveValue comp = color.getComponent(i);
            if (comp != null) {
                TypedValue typed = this.primitiveToTypedValue(propertyName, comp);
                if (comp != typed) {
                    if (typed == null) {
                        return null;
                    }
                    if (color2 == null) {
                        color2 = color.clone();
                    }
                    ((TypedValue)color2).setComponent(i, typed);
                }
                if (typed.getPrimitiveType() == CSSValue.Type.EXPRESSION) {
                    if (color2 == null) {
                        color2 = color.clone();
                    }
                    PercentageEvaluator ev = new PercentageEvaluator();
                    try {
                        typed = (TypedValue)((Object)((Evaluator)ev).evaluateExpression((ExpressionValue)typed));
                    }
                    catch (DOMException e) {
                        this.computedStyleError(propertyName, color.getCssText(), "Could not evaluate expression value in color.", e);
                        return null;
                    }
                    ((TypedValue)color2).setComponent(i, typed);
                    continue;
                }
                if (typed.getPrimitiveType() != CSSValue.Type.MATH_FUNCTION) continue;
                if (color2 == null) {
                    color2 = color.clone();
                }
                PercentageEvaluator eval = new PercentageEvaluator();
                try {
                    typed = (TypedValue)((Object)eval.evaluateFunction((CSSMathFunctionValue)((Object)typed)));
                }
                catch (DOMException e) {
                    this.computedStyleError(propertyName, color.getCssText(), "Could not evaluate math function in color.", e);
                    return null;
                }
                ((TypedValue)color2).setComponent(i, typed);
                continue;
            }
            comp = NumberValue.createCSSNumberValue((short)0, 0.0f);
            if (color2 == null) {
                color2 = color.clone();
            }
            ((TypedValue)color2).setComponent(i, comp);
        }
        return color2 == null ? color : color2;
    }

    private TypedValue computeColorMix(String propertyName, TypedValue typed, boolean useParentStyle) {
        PrimitiveValue interpMethod;
        PrimitiveValue primi;
        TypedValue typed2 = null;
        if ((typed = this.absolutizeComponents(propertyName, typed, useParentStyle)) == null) {
            return null;
        }
        CSSColorMixFunction colorMix = (CSSColorMixFunction)((Object)typed);
        PrimitiveValue colorVal1 = (PrimitiveValue)colorMix.getColorValue1();
        PrimitiveValue colorVal2 = (PrimitiveValue)colorMix.getColorValue2();
        TypedValue color1 = this.primitiveToTypedValue(propertyName, colorVal1);
        TypedValue color2 = this.primitiveToTypedValue(propertyName, colorVal2);
        if (color1 == null || color2 == null) {
            return null;
        }
        color1 = this.absolutizeComponents(propertyName, color1, useParentStyle);
        color2 = this.absolutizeComponents(propertyName, color2, useParentStyle);
        if (color1 != colorVal1) {
            typed2 = typed.clone();
            typed2.setComponent(0, color1);
        }
        if (color2 != colorVal2) {
            if (typed2 == null) {
                typed2 = typed.clone();
            }
            typed2.setComponent(2, color2);
        }
        if ((primi = (PrimitiveValue)colorMix.getPercentage1()) != null) {
            TypedValue pcnt1 = this.primitiveToTypedValue(propertyName, primi);
            if ((pcnt1 = this.absolutizeComponents(propertyName, pcnt1, useParentStyle)) == null) {
                return null;
            }
            if (pcnt1 != primi) {
                if (typed2 == null) {
                    typed2 = typed.clone();
                }
                typed2.setComponent(1, pcnt1);
            }
        }
        if ((primi = (PrimitiveValue)colorMix.getPercentage2()) != null) {
            TypedValue pcnt2 = this.primitiveToTypedValue(propertyName, primi);
            if (pcnt2 == null) {
                return null;
            }
            if ((pcnt2 = this.absolutizeComponents(propertyName, pcnt2, useParentStyle)) != primi) {
                if (typed2 == null) {
                    typed2 = typed.clone();
                }
                typed2.setComponent(3, pcnt2);
            }
        }
        if ((interpMethod = (PrimitiveValue)typed.getComponent(4)) != null) {
            TypedValue ident;
            if (typed2 == null) {
                typed2 = typed.clone();
            }
            if ((ident = this.primitiveToTypedValue(propertyName, interpMethod)) == null || ident.getPrimitiveType() != CSSValue.Type.IDENT) {
                return null;
            }
            typed2.setComponent(4, ident);
        }
        colorMix = (CSSColorMixFunction)((Object)(typed2 == null ? typed : typed2));
        CSSColor color = colorMix.getColor();
        typed = color != null ? (TypedValue)((Object)color.packInValue()) : null;
        return typed;
    }

    private TypedValue absolutizeComponents(String propertyName, TypedValue typed, boolean useParentStyle) {
        TypedValue typed2 = null;
        int len = typed.getComponentCount();
        for (int i = 0; i < len; ++i) {
            StyleValue comp = typed.getComponent(i);
            if (comp == null) continue;
            StyleValue value = this.replaceProxyValues(propertyName, comp);
            if (value == null) {
                return null;
            }
            if ((value = this.absoluteValue(propertyName, value, useParentStyle)) != comp) {
                if (value == null) {
                    return null;
                }
                if (typed2 == null) {
                    typed2 = typed.clone();
                }
                typed2.setComponent(i, value);
            }
            if (value.getPrimitiveType() == CSSValue.Type.EXPRESSION) {
                if (typed2 == null) {
                    typed2 = typed.clone();
                }
                ExpressionValue exprval = (ExpressionValue)value;
                MyEvaluator ev = new MyEvaluator(propertyName);
                try {
                    comp = (TypedValue)((Object)ev.evaluateExpression(exprval));
                    typed2.setComponent(i, comp);
                }
                catch (RuntimeException e) {
                    this.computedStyleWarning(propertyName, exprval, "Could not evaluate expression value.", (Throwable)e);
                    exprval = exprval.clone();
                    try {
                        this.absoluteExpressionValue(propertyName, exprval.getExpression(), useParentStyle);
                        typed2.setComponent(i, exprval);
                    }
                    catch (RuntimeException runtimeException) {}
                }
                continue;
            }
            if (value.getPrimitiveType() != CSSValue.Type.MATH_FUNCTION) continue;
            if (typed2 == null) {
                typed2 = typed.clone();
            }
            MathFunctionValue mathFunction = (MathFunctionValue)value;
            PercentageEvaluator eval = new PercentageEvaluator();
            try {
                comp = (StyleValue)((Object)eval.evaluateFunction(mathFunction));
                typed2.setComponent(i, comp);
                continue;
            }
            catch (RuntimeException e) {
                this.computedStyleWarning(propertyName, mathFunction, "Could not evaluate math function.", (Throwable)e);
                mathFunction = mathFunction.clone();
                LinkedCSSValueList args = mathFunction.getArguments();
                int sz = args.size();
                int j = 0;
                while (i < sz) {
                    try {
                        args.set(j, this.absoluteValue(propertyName, (StyleValue)args.get(j), useParentStyle));
                    }
                    catch (RuntimeException e1) {
                        // empty catch block
                    }
                    ++i;
                }
                try {
                    typed2.setComponent(i, mathFunction);
                    continue;
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
        }
        return typed2 == null ? typed : typed2;
    }

    private void absoluteExpressionValue(String propertyName, CSSExpression expr, boolean useParentStyle) throws DOMException {
        switch (expr.getPartType()) {
            case SUM: 
            case PRODUCT: {
                AlgebraicExpression ae = (AlgebraicExpression)expr;
                int len = ae.getLength();
                for (int i = 0; i < len; ++i) {
                    CSSExpression op = ae.item(i);
                    this.absoluteExpressionValue(propertyName, op, useParentStyle);
                }
                break;
            }
            case OPERAND: {
                CSSOperandExpression operand = (CSSOperandExpression)expr;
                StyleValue value = (StyleValue)((Object)operand.getOperand());
                if (value.getCssValueType() == CSSValue.CssType.PROXY) {
                    value = this.replaceProxyValue(propertyName, value);
                }
                if (value.getCssValueType() != CSSValue.CssType.TYPED) {
                    throw new DOMInvalidAccessException("Unexpected value in expression: " + value.getCssText());
                }
                TypedValue primi = this.absoluteTypedValue(propertyName, (TypedValue)value, useParentStyle);
                operand.setOperand(primi);
            }
        }
    }

    private StyleValue enforceExpectIntegerFromProxy(String property, ProxyValue proxy, StyleValue resolved) {
        if (proxy.isExpectingInteger()) {
            if (resolved.isPrimitiveValue()) {
                try {
                    ((CSSPrimitiveValue)((Object)resolved)).setExpectInteger();
                }
                catch (DOMException e) {
                    this.computedStyleError(property, resolved.getCssText(), null, e);
                    resolved = null;
                }
            } else if (resolved.getCssValueType() == CSSValue.CssType.LIST) {
                this.computedStyleError(property, resolved.getCssText(), "Expected an integer, found a LIST.");
                resolved = null;
            }
        }
        return resolved;
    }

    private StyleValue evaluateLexicalValue(String property, LexicalValue lexval) throws CSSResourceLimitException {
        LexicalUnit replUnit;
        HashSet<String> customPropertySet = new HashSet<String>(1);
        LexicalUnit lunit = lexval.getLexicalUnit().clone();
        try {
            replUnit = this.replaceLexicalProxy(property, lunit, new CounterRef(), customPropertySet);
        }
        catch (CSSResourceLimitException e) {
            throw e;
        }
        catch (DOMException e) {
            this.computedStyleError(property, lunit.toString(), "Problem evaluating lexical value.", e);
            return null;
        }
        StyleValue result = null;
        if (replUnit != null) {
            try {
                result = this.getValueFactory().createCSSValue(replUnit, this);
            }
            catch (DOMException e) {
                this.computedStyleError(property, replUnit.toString(), "Invalid replaced value.", e);
                return null;
            }
        }
        result = this.enforceExpectIntegerFromProxy(property, lexval, result);
        return result;
    }

    private LexicalUnit replaceLexicalProxy(String property, LexicalUnit lexval, CounterRef counter, Set<String> customPtySet) throws DOMException {
        int REPLACE_COUNT_LIMIT = 131072;
        LexicalUnit lu = lexval;
        block4: do {
            if (lu.getLexicalUnitType() == LexicalUnit.LexicalType.VAR) {
                boolean isLexval;
                LexicalUnit param = lu.getParameters();
                String customPtyName = param.getStringValue();
                if ((param = param.getNextLexicalUnit()) != null) {
                    param = param.getNextLexicalUnit();
                }
                if (!counter.increment()) {
                    throw new CSSResourceLimitException("Resource limit hit while replacing custom property: " + customPtyName);
                }
                LexicalUnit newlu = this.getCustomPropertyValueOrFallback(property, customPtyName, param, counter, customPtySet);
                boolean bl = isLexval = lu == lexval;
                if (newlu == null) {
                    lu = lu.remove();
                    if (!isLexval) continue;
                    lexval = lu;
                    continue;
                }
                if (newlu.getLexicalUnitType() != LexicalUnit.LexicalType.EMPTY) {
                    try {
                        counter.replaceCounter += lu.countReplaceBy(newlu);
                    }
                    catch (CSSBudgetException e) {
                        throw new CSSResourceLimitException("Resource limit hit while replacing custom property " + customPtyName, e);
                    }
                    if (counter.replaceCounter >= 131072) {
                        throw new CSSResourceLimitException("Resource limit hit while replacing custom property: " + property);
                    }
                    lu = newlu;
                    if (!isLexval) continue;
                    lexval = newlu;
                    continue;
                }
                LexicalUnit nextlu = lu.remove();
                lu = nextlu != null ? nextlu : newlu;
                if (!isLexval) continue;
                lexval = lu;
                continue;
            }
            if (lu.getLexicalUnitType() == LexicalUnit.LexicalType.ATTR) {
                boolean isLexval = lu == lexval;
                HashSet<String> ptySet = new HashSet<String>(customPtySet.size() + 1);
                ptySet.addAll(customPtySet);
                LexicalUnit newlu = this.replacementAttrUnit(property, lu, counter, customPtySet, ptySet);
                if (newlu != null) {
                    newlu = this.replaceLexicalProxy(property, newlu, counter, ptySet);
                }
                if (newlu == null) {
                    lu = lu.remove();
                    if (!isLexval) continue;
                    lexval = lu;
                    continue;
                }
                if (attrForbiddenProperties.contains(property)) {
                    this.computedStyleWarning(property, lu.getCssText(), property + " value is attr()-tainted.", null);
                    return null;
                }
                if (this.attrTaintedProperties == null) {
                    this.attrTaintedProperties = new HashSet<String>();
                }
                this.attrTaintedProperties.add(property);
                while (newlu.getLexicalUnitType() == LexicalUnit.LexicalType.EMPTY) {
                    LexicalUnit nextlu = newlu.remove();
                    if (nextlu == null) {
                        if ((lu = lu.remove()) == null) {
                            lu = newlu;
                        }
                        if (!isLexval) continue block4;
                        lexval = lu;
                        continue block4;
                    }
                    newlu = nextlu;
                }
                try {
                    counter.replaceCounter += lu.countReplaceBy(newlu);
                }
                catch (CSSBudgetException e) {
                    throw new CSSResourceLimitException("Resource limit hit while replacing attr() property " + property, e);
                }
                if (counter.replaceCounter >= 131072) {
                    throw new CSSResourceLimitException("Resource limit hit while replacing attr() property " + property);
                }
                lu = newlu;
                if (!isLexval) continue;
                lexval = newlu;
                continue;
            }
            LexicalUnit param = lu.getParameters();
            if (param != null || (param = lu.getSubValues()) != null) {
                this.replaceLexicalProxy(property, param, counter, customPtySet);
            }
            lu = lu.getNextLexicalUnit();
        } while (lu != null);
        return lexval;
    }

    private LexicalUnit getCustomPropertyValueOrFallback(String property, String customProperty, LexicalUnit fallbackLU, CounterRef counter, Set<String> checkPtySet) throws DOMException {
        LexicalUnit lu;
        boolean inherited;
        CSSPropertyDefinition definition = this.getOwnerSheet().getPropertyDefinition(customProperty);
        boolean bl = inherited = definition == null || definition.inherits();
        if (checkPtySet.contains(customProperty)) {
            this.computedStyleError(property, null, "Circularity evaluating custom property " + customProperty + ": " + checkPtySet.toString());
            if (definition == null || (lu = definition.getInitialValue()) == null) {
                return null;
            }
        } else {
            LexicalValue custom = this.getCustomPropertyValue(customProperty, inherited, counter, checkPtySet);
            if (custom != null) {
                LexicalUnit lu2 = custom.getLexicalUnit();
                lu2 = lu2.clone();
                HashSet<String> ptySet = new HashSet<String>(checkPtySet.size() + 1);
                ptySet.add(customProperty);
                lu2 = this.replaceLexicalProxy(property, lu2, counter, ptySet);
                if (definition != null && (lu2 == null || lu2.matches(definition.getSyntax()) == CSSValueSyntax.Match.FALSE) && (lu2 = definition.getInitialValue()) != null) {
                    lu2 = this.replaceLexicalProxy(property, lu2.clone(), counter, ptySet);
                }
                return lu2;
            }
            if (definition != null ? (lu = definition.getInitialValue()) == null && (lu = fallbackLU) == null : (lu = fallbackLU) == null) {
                return null;
            }
        }
        HashSet<String> ptySet = new HashSet<String>(checkPtySet.size() + 1);
        ptySet.add(customProperty);
        return this.replaceLexicalProxy(property, lu.clone(), counter, ptySet);
    }

    private LexicalUnit replacementAttrUnit(String propertyName, LexicalUnit attr, CounterRef counter, Set<String> checkSet, Set<String> putSet) throws DOMException {
        CSSElement owner;
        Attr attrNode;
        LexicalUnit lu = attr.getParameters();
        if (lu.getLexicalUnitType() != LexicalUnit.LexicalType.IDENT) {
            this.computedStyleError(propertyName, attr.getCssText(), "Unexpected attribute name: " + lu.getCssText());
            return null;
        }
        String attrname = lu.getStringValue();
        if (checkSet.contains(attrname)) {
            throw new DOMInvalidAccessException("Circularity evaluating attr() '" + attrname + "': " + checkSet.toString());
        }
        putSet.add(attrname);
        CSSValueSyntax syn = null;
        short unitConv = -1;
        lu = lu.getNextLexicalUnit();
        if (lu != null) {
            if (lu.getLexicalUnitType() != LexicalUnit.LexicalType.OPERATOR_COMMA) {
                switch (lu.getLexicalUnitType()) {
                    case IDENT: {
                        String attrtype = lu.getStringValue().toLowerCase(Locale.ROOT);
                        if ("raw-string".equals(attrtype) || (unitConv = (short)UnitStringToId.unitFromString(attrtype)) != 1) break;
                        this.computedStyleError(propertyName, attr.getCssText(), "Unexpected attribute type: " + attrtype);
                        return null;
                    }
                    case OPERATOR_MOD: {
                        unitConv = 2;
                        break;
                    }
                    case TYPE_FUNCTION: {
                        LexicalUnit param = lu.getParameters();
                        if (param.getLexicalUnitType() == LexicalUnit.LexicalType.SYNTAX) {
                            syn = param.getSyntax();
                            unitConv = 0;
                            break;
                        }
                    }
                    default: {
                        this.computedStyleError(propertyName, attr.getCssText(), "Unexpected attribute type: " + lu.getCssText());
                        return lu == null ? null : lu.clone();
                    }
                }
                if ((lu = lu.getNextLexicalUnit()) != null) {
                    if (lu.getLexicalUnitType() != LexicalUnit.LexicalType.OPERATOR_COMMA) {
                        this.computedStyleError(propertyName, attr.getCssText(), "Expected comma, found: " + lu.getCssText());
                        return null;
                    }
                    lu = lu.getNextLexicalUnit();
                }
            } else if ((lu = lu.getNextLexicalUnit()) == null) {
                this.computedStyleError(propertyName, attr.getCssText(), "Unexpected end after comma.");
                return null;
            }
        }
        String attrvalue = (attrNode = (owner = this.getOwnerNode()).getAttributeNode(attrname)) != null ? attrNode.getValue() : "";
        Parser parser = this.getStyleSheetFactory().createSACParser();
        if (unitConv == -1) {
            LexicalUnit substValue;
            block41: {
                if (attrNode != null || lu == null) {
                    String s = ParseHelper.quote(attrvalue, '\"');
                    try {
                        substValue = parser.parsePropertyValue(new StringReader(s));
                    }
                    catch (IOException e) {
                        substValue = null;
                    }
                    catch (CSSParseException e) {
                        this.computedStyleError(propertyName, attr.getCssText(), "Unexpected error parsing: " + s.substring(0, Math.min(s.length(), 255)), e);
                        if (lu != null) {
                            substValue = lu.clone();
                            break block41;
                        }
                        try {
                            substValue = parser.parsePropertyValue(new StringReader("\"\""));
                        }
                        catch (CSSParseException | IOException e1) {
                            substValue = null;
                        }
                    }
                } else {
                    substValue = lu.clone();
                }
            }
            return substValue;
        }
        if (!(attrvalue = attrvalue.trim()).isEmpty()) {
            LexicalUnit substValue;
            try {
                substValue = parser.parsePropertyValue(new StringReader(attrvalue));
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
            catch (CSSParseException e) {
                this.computedStyleError(propertyName, attr.getCssText(), "Error parsing attribute '" + attrname + "', value: " + attrvalue, e);
                return lu == null ? null : lu.clone();
            }
            substValue = this.replaceLexicalProxy(propertyName, substValue, counter, putSet);
            if (substValue != null) {
                if (syn != null) {
                    if (substValue.matches(syn) == CSSValueSyntax.Match.TRUE) {
                        return substValue;
                    }
                    String message = "Attribute " + attrname + " with value '" + substValue + "' does not match type '" + syn.toString() + "'.";
                    if (lu == null) {
                        throw new DOMException(17, message);
                    }
                    this.computedStyleError(propertyName, attr.getCssText(), message);
                } else {
                    float f;
                    LexicalUnit.LexicalType luType = substValue.getLexicalUnitType();
                    if (luType == LexicalUnit.LexicalType.INTEGER) {
                        f = substValue.getIntegerValue();
                    } else if (luType == LexicalUnit.LexicalType.REAL) {
                        f = substValue.getFloatValue();
                    } else {
                        String message = "Attribute unit is not a <number>, instead is: " + CSSUnit.dimensionUnitString(substValue.getCssUnit());
                        if (lu != null) {
                            this.computedStyleError(propertyName, attr.getCssText(), message);
                            return lu.clone();
                        }
                        throw new DOMException(17, message);
                    }
                    switch (unitConv) {
                        case 0: {
                            break;
                        }
                        case 2: {
                            substValue = ParseHelper.createPercentageLexicalUnit(f);
                            break;
                        }
                        default: {
                            substValue = ParseHelper.createDimensionLexicalUnit(unitConv, f);
                        }
                    }
                    return substValue;
                }
            }
        }
        return lu == null ? null : lu.clone();
    }

    private StyleValue computeEnv(String propertyName, EnvVariableValue env) {
        StyleValue envValue;
        if (this.getStyleDatabase() != null && (envValue = (StyleValue)this.getStyleDatabase().getEnvValue(env.getName())) != null) {
            return envValue;
        }
        StyleValue fallback = null;
        LexicalUnit lu = env.getFallback();
        if (lu == null) {
            this.computedStyleError(propertyName, env.getCssText(), "Unable to evaluate env() value for: " + env.getName());
        } else {
            ValueFactory factory = new ValueFactory();
            try {
                fallback = factory.createCSSValue(lu, this);
            }
            catch (DOMException e) {
                this.computedStyleError(propertyName, lu.toString(), "Unable to evaluate env() fallback: " + env.getCssText());
            }
        }
        return fallback;
    }

    private TypedValue getFontSizeValue() {
        StyleValue value = super.getCSSValue("font-size");
        if (value != null && value.getPrimitiveType() == CSSValue.Type.UNSET) {
            value = null;
        }
        if ((value = ComputedCSSStyle.inheritValue(this, "font-size", value, true)) != null && value.getPrimitiveType() == CSSValue.Type.INHERIT) {
            value = null;
        }
        if (value == null || value.getPrimitiveType() == CSSValue.Type.INITIAL) {
            return new IdentifierValue("medium");
        }
        return this.absoluteFontSizeValue(value, false);
    }

    private TypedValue absoluteFontSizeValue(StyleValue value, boolean force) {
        TypedValue primi;
        CSSValue.CssType type = value.getCssValueType();
        if (type == CSSValue.CssType.TYPED && (primi = this.absoluteFontSizeTyped((TypedValue)value, force)) != null) {
            return primi;
        }
        if (value.getPrimitiveType() != CSSValue.Type.INITIAL && value.getPrimitiveType() != CSSValue.Type.INTERNAL) {
            StyleValue inheritedValue;
            primi = null;
            ComputedCSSStyle ancStyle = this;
            while (((inheritedValue = ComputedCSSStyle.inheritValue(ancStyle, "font-size", primi, true)) == null || (primi = this.absoluteFontSizeValue(inheritedValue, force)) == null) && (ancStyle = ancStyle.getParentComputedStyle()) != null) {
            }
            if (primi != null) {
                return primi;
            }
            this.reportFontSizeError(value, "Could not compute font-size from " + value.getCssText());
        }
        if (force) {
            float sz = this.getInitialFontSize();
            return ComputedCSSStyle.asNumericValuePt(sz);
        }
        return new IdentifierValue("medium");
    }

    private TypedValue absoluteFontSizeTyped(TypedValue cssSize, boolean force) {
        switch (cssSize.getPrimitiveType()) {
            case IDENT: {
                String sizeIdentifier = cssSize.getStringValue();
                String familyName = this.getUsedFontFamily();
                if ("larger".equalsIgnoreCase(sizeIdentifier)) {
                    cssSize = this.getLargerFontSize(familyName);
                } else if ("smaller".equalsIgnoreCase(sizeIdentifier)) {
                    cssSize = this.getSmallerFontSize(familyName);
                }
                return cssSize;
            }
            case EXPRESSION: {
                cssSize = cssSize.clone();
                CSSExpressionValue exprval = (CSSExpressionValue)((Object)cssSize);
                this.absoluteExpressionValue("font-size", exprval.getExpression(), true);
                FontEvaluator ev = new FontEvaluator();
                try {
                    cssSize = (TypedValue)((Object)ev.evaluateExpression(exprval));
                }
                catch (DOMException e) {
                    this.computedStyleError("font-size", exprval.getCssText(), "Could not evaluate expression value.", e);
                    break;
                }
                return cssSize;
            }
            case MATH_FUNCTION: {
                MathFunctionValue function = (MathFunctionValue)cssSize;
                function = function.clone();
                LinkedCSSValueList args = function.getArguments();
                int siz = args.size();
                for (int i = 0; i < siz; ++i) {
                    args.set(i, this.absoluteFontSizeValue((StyleValue)args.get(i), true));
                }
                FontEvaluator ev = new FontEvaluator();
                try {
                    cssSize = (TypedValue)((Object)ev.evaluateFunction(function));
                }
                catch (DOMException e) {
                    this.computedStyleError("font-size", function.getCssText(), "Could not evaluate function value.", e);
                    break;
                }
                return cssSize;
            }
            case NUMERIC: {
                return this.absoluteFontSizeNumeric(cssSize, force);
            }
            default: {
                String cssText = cssSize.getCssText();
                this.computedStyleError("font-size", cssText, "Unable to convert to absolute length.");
            }
        }
        float sz = this.getInitialFontSize();
        sz = (float)Math.round(sz * 100.0f) * 0.01f;
        NumberValue number = new NumberValue();
        number.setFloatValuePt(sz);
        number.setSubproperty(cssSize.isSubproperty());
        number.setAbsolutizedUnit();
        return number;
    }

    private TypedValue absoluteFontSizeNumeric(TypedValue cssSize, boolean force) {
        float sz;
        switch (cssSize.getUnitType()) {
            case 20: {
                float factor = cssSize.getFloatValue();
                return this.getRelativeFontSize(cssSize, factor, force);
            }
            case 21: {
                float factor = cssSize.getFloatValue();
                ComputedCSSStyle parentStyle = this.getParentComputedStyle();
                if (parentStyle == null) {
                    sz = this.getInitialFontSize() * 0.5f * factor;
                    break;
                }
                if (this.getStyleDatabase() != null) {
                    sz = this.getStyleDatabase().getExSizeInPt(parentStyle.getUsedFontFamily(), parentStyle.getComputedFontSize()) * factor;
                    break;
                }
                if (force) {
                    factor = 0.5f * factor;
                    return this.getRelativeFontSize(cssSize, factor, force);
                }
                return cssSize;
            }
            case 26: {
                float factor = cssSize.getFloatValue();
                CSSElement root = this.getOwnerNode().getOwnerDocument().getDocumentElement();
                if (root != this.getOwnerNode()) {
                    sz = root.getComputedStyle(null).getComputedFontSize();
                } else if (force) {
                    this.reportFontSizeWarning(cssSize, "Inaccurate use of 'rem'.");
                    sz = this.getInitialFontSize();
                } else {
                    return cssSize;
                }
                sz *= factor;
                break;
            }
            case 28: {
                float factor = cssSize.getFloatValue();
                CSSElement root = this.getOwnerNode().getOwnerDocument().getDocumentElement();
                if (root != this.getOwnerNode()) {
                    sz = root.getComputedStyle(null).getComputedFontSize() * 0.5f;
                } else if (force) {
                    this.reportFontSizeWarning(cssSize, "Inaccurate use of 'rex'.");
                    sz = this.getInitialFontSize() * 0.5f;
                } else {
                    return cssSize;
                }
                sz *= factor;
                break;
            }
            case 25: {
                float factor = cssSize.getFloatValue();
                ComputedCSSStyle parentStyle = this.getParentComputedStyle();
                if (parentStyle != null) {
                    sz = parentStyle.getComputedLineHeight();
                } else if (force) {
                    sz = this.getInitialFontSize() * 1.2f;
                } else {
                    return cssSize;
                }
                sz *= factor;
                break;
            }
            case 27: {
                float factor = cssSize.getFloatValue();
                CSSElement root = this.getOwnerNode().getOwnerDocument().getDocumentElement();
                if (root != this.getOwnerNode()) {
                    sz = root.getComputedStyle(null).getComputedLineHeight();
                } else if (force) {
                    sz = this.getInitialFontSize() * 1.2f;
                } else {
                    return cssSize;
                }
                sz *= factor;
                break;
            }
            case 22: {
                float factor = cssSize.getFloatValue();
                CSSCanvas canvas = this.getOwnerNode().getOwnerDocument().getCanvas();
                if (canvas != null) {
                    ComputedCSSStyle parentStyle = this.getParentComputedStyle();
                    if (parentStyle != null) {
                        sz = canvas.getCapHeight(parentStyle) * factor;
                        break;
                    }
                    sz = this.getInitialFontSize() * factor;
                    this.reportFontSizeWarning(cssSize, "Inaccurate use of 'cap'.");
                    break;
                }
                if (force) {
                    sz = this.getInitialFontSize() * factor;
                    this.reportFontSizeWarning(cssSize, "Inaccurate conversion from 'cap'.");
                    break;
                }
                return cssSize;
            }
            case 23: {
                float factor = cssSize.getFloatValue();
                CSSCanvas canvas = this.getOwnerNode().getOwnerDocument().getCanvas();
                if (canvas != null) {
                    ComputedCSSStyle parentStyle = this.getParentComputedStyle();
                    if (parentStyle != null) {
                        sz = (float)canvas.stringWidth("0", parentStyle) * factor;
                        break;
                    }
                    sz = this.getInitialFontSize() * 0.25f * factor;
                    this.reportFontSizeWarning(cssSize, "Inaccurate use of 'ch'.");
                    break;
                }
                if (force) {
                    sz = this.getParentElementFontSize() * 0.25f * factor;
                    this.reportFontSizeWarning(cssSize, "Inaccurate conversion from 'ch'.");
                    break;
                }
                return cssSize;
            }
            case 29: {
                float factor = cssSize.getFloatValue();
                Document doc = this.getOwnerNode().getOwnerDocument();
                CSSCanvas canvas = doc.getCanvas();
                CSSElement root = doc.getDocumentElement();
                if (canvas != null) {
                    if (root != this.getOwnerNode()) {
                        sz = (float)canvas.stringWidth("0", root.getComputedStyle(null)) * factor;
                        break;
                    }
                    sz = this.getInitialFontSize() * 0.25f * factor;
                    this.reportFontSizeWarning(cssSize, "Inaccurate use of 'rch'.");
                    break;
                }
                if (!force) {
                    return cssSize;
                }
                sz = root != this.getOwnerNode() ? root.getComputedStyle(null).getComputedFontSize() * 0.25f : this.getInitialFontSize() * 0.25f;
                this.reportFontSizeWarning(cssSize, "Inaccurate conversion from 'rch'.");
                sz *= factor;
                break;
            }
            case 24: {
                float factor = cssSize.getFloatValue();
                CSSCanvas canvas = this.getOwnerNode().getOwnerDocument().getCanvas();
                if (canvas != null) {
                    ComputedCSSStyle parentStyle = this.getParentComputedStyle();
                    if (parentStyle != null) {
                        sz = (float)canvas.stringWidth("\u6c34", parentStyle) * factor;
                        break;
                    }
                    sz = this.getInitialFontSize() * factor;
                    this.reportFontSizeWarning(cssSize, "Inaccurate use of 'ic'.");
                    break;
                }
                if (force) {
                    sz = this.getParentElementFontSize() * factor;
                    this.reportFontSizeWarning(cssSize, "Inaccurate conversion from 'ic'.");
                    break;
                }
                return cssSize;
            }
            case 30: {
                float factor = cssSize.getFloatValue();
                Document doc = this.getOwnerNode().getOwnerDocument();
                CSSCanvas canvas = doc.getCanvas();
                CSSElement root = doc.getDocumentElement();
                if (canvas != null) {
                    if (root != this.getOwnerNode()) {
                        sz = (float)canvas.stringWidth("\u6c34", root.getComputedStyle(null)) * factor;
                        break;
                    }
                    sz = this.getInitialFontSize() * factor;
                    this.reportFontSizeWarning(cssSize, "Inaccurate use of 'ric'.");
                    break;
                }
                if (!force) {
                    return cssSize;
                }
                sz = root != this.getOwnerNode() ? root.getComputedStyle(null).getComputedFontSize() : this.getInitialFontSize();
                this.reportFontSizeWarning(cssSize, "Inaccurate conversion from 'ric'.");
                sz *= factor;
                break;
            }
            case 2: {
                float pcnt = cssSize.getFloatValue();
                return this.getRelativeFontSize(cssSize, pcnt / 100.0f, true);
            }
            case 45: {
                float factor = cssSize.getFloatValue();
                CSSCanvas canvas = this.getOwnerNode().getOwnerDocument().getCanvas();
                try {
                    sz = this.getInitialContainingBlockWidthPt(canvas, force) * factor / 100.0f;
                    break;
                }
                catch (StyleDatabaseRequiredException e) {
                    if (force) {
                        throw e;
                    }
                    return cssSize;
                }
            }
            case 41: {
                float factor = cssSize.getFloatValue();
                CSSCanvas canvas = this.getOwnerNode().getOwnerDocument().getCanvas();
                try {
                    sz = this.getInitialContainingBlockHeightPt(canvas, force) * factor / 100.0f;
                    break;
                }
                catch (StyleDatabaseRequiredException e) {
                    if (force) {
                        throw e;
                    }
                    return cssSize;
                }
            }
            case 42: {
                float factor = cssSize.getFloatValue();
                String writingMode = this.getCSSValue("writing-mode").getCssText();
                CSSCanvas canvas = this.getOwnerNode().getOwnerDocument().getCanvas();
                try {
                    sz = "horizontal-tb".equalsIgnoreCase(writingMode) ? this.getInitialContainingBlockWidthPt(canvas, force) : this.getInitialContainingBlockHeightPt(canvas, force);
                }
                catch (StyleDatabaseRequiredException e) {
                    if (force) {
                        throw e;
                    }
                    return cssSize;
                }
                sz *= factor / 100.0f;
                break;
            }
            case 40: {
                float factor = cssSize.getFloatValue();
                String writingMode = this.getCSSValue("writing-mode").getCssText();
                CSSCanvas canvas = this.getOwnerNode().getOwnerDocument().getCanvas();
                try {
                    sz = "horizontal-tb".equalsIgnoreCase(writingMode) ? this.getInitialContainingBlockHeightPt(canvas, force) : this.getInitialContainingBlockWidthPt(canvas, force);
                }
                catch (StyleDatabaseRequiredException e) {
                    if (force) {
                        throw e;
                    }
                    return cssSize;
                }
                sz *= factor / 100.0f;
                break;
            }
            case 44: {
                float factor = cssSize.getFloatValue();
                CSSCanvas canvas = this.getOwnerNode().getOwnerDocument().getCanvas();
                try {
                    sz = Math.min(this.getInitialContainingBlockWidthPt(canvas, force), this.getInitialContainingBlockHeightPt(canvas, force));
                }
                catch (StyleDatabaseRequiredException e) {
                    if (force) {
                        throw e;
                    }
                    return cssSize;
                }
                sz *= factor / 100.0f;
                break;
            }
            case 43: {
                float factor = cssSize.getFloatValue();
                CSSCanvas canvas = this.getOwnerNode().getOwnerDocument().getCanvas();
                try {
                    sz = Math.max(this.getInitialContainingBlockWidthPt(canvas, force), this.getInitialContainingBlockHeightPt(canvas, force));
                }
                catch (StyleDatabaseRequiredException e) {
                    if (force) {
                        throw e;
                    }
                    return cssSize;
                }
                sz *= factor / 100.0f;
                break;
            }
            default: {
                try {
                    cssSize.getFloatValue((short)6);
                }
                catch (DOMException e) {
                    String cssText = cssSize.getCssText();
                    this.computedStyleError("font-size", cssText, "Error converting to points.", e);
                    sz = this.getInitialFontSize();
                    break;
                }
                return cssSize;
            }
        }
        sz = (float)Math.round(sz * 100.0f) / 100.0f;
        NumberValue number = new NumberValue();
        number.setFloatValuePt(sz);
        number.setSubproperty(cssSize.isSubproperty());
        number.setAbsolutizedUnit();
        return number;
    }

    private TypedValue getRelativeFontSize(TypedValue cssSize, float factor, boolean force) {
        TypedValue value;
        ComputedCSSStyle parentCss = this.getParentComputedStyle();
        if (parentCss != null) {
            if (force) {
                float sz = parentCss.getComputedFontSize() * factor;
                sz = (float)Math.round(sz * 100.0f) * 0.01f;
                value = ComputedCSSStyle.asNumericValuePt(sz);
            } else {
                value = parentCss.getFontSizeValue();
                if (value.getPrimitiveType() == CSSValue.Type.IDENT) {
                    value = cssSize;
                } else {
                    try {
                        float sz = value.getFloatValue((short)6) * factor;
                        sz = (float)Math.round(sz * 100.0f) * 0.01f;
                        value = ComputedCSSStyle.asNumericValuePt(sz);
                    }
                    catch (DOMException e) {
                        value = cssSize;
                    }
                }
            }
        } else {
            float sz = this.getInitialFontSize() * factor;
            value = ComputedCSSStyle.asNumericValuePt(sz);
        }
        return value;
    }

    @Override
    public float getComputedFontSize() {
        float sz;
        StyleValue value = super.getCSSValue("font-size");
        if (value != null) {
            CSSValue.CssType category;
            if (value.getPrimitiveType() == CSSValue.Type.INTERNAL) {
                PendingSubstitutionValue pending = (PendingSubstitutionValue)value;
                value = this.getSubstitutedValue("font-size", "font", pending.getLexicalUnit().clone(), this.isPropertyImportant("font-size"));
            } else if (value.getPrimitiveType() == CSSValue.Type.UNSET) {
                value = null;
            }
            if (value != null && (category = value.getCssValueType()) == CSSValue.CssType.PROXY) {
                try {
                    value = this.replaceProxyValues("font-size", value);
                }
                catch (DOMException e) {
                    this.computedStyleError("font-size", value.getCssText(), "Unable to replace PROXY value.", e);
                    value = null;
                }
                if (value != null && value.getPrimitiveType() == CSSValue.Type.LEXICAL) {
                    this.computedStyleError("font-size", value.getCssText(), "Unable to replace LEXICAL value.");
                    value = null;
                }
            }
        }
        if ((value = ComputedCSSStyle.inheritValue(this, "font-size", value, true)) != null && value.getPrimitiveType() == CSSValue.Type.INHERIT) {
            value = null;
        }
        if (value == null || value.getPrimitiveType() == CSSValue.Type.INITIAL) {
            return this.getInitialFontSize();
        }
        TypedValue cssSize = this.absoluteFontSizeValue(value, true);
        switch (cssSize.getPrimitiveType()) {
            case IDENT: {
                String sizeIdentifier = cssSize.getStringValue().toLowerCase(Locale.ROOT);
                try {
                    String familyName = this.getUsedFontFamily();
                    sz = this.getFontSizeFromIdentifier(familyName, sizeIdentifier);
                }
                catch (DOMException e) {
                    this.computedStyleError("font-size", sizeIdentifier, "Unknown identifier", e);
                    sz = this.getInitialFontSize();
                }
                break;
            }
            default: {
                try {
                    sz = cssSize.getFloatValue((short)6);
                    break;
                }
                catch (DOMException e) {
                    String cssText = cssSize.getCssText();
                    this.computedStyleError("font-size", cssText, null, e);
                    sz = this.getInitialFontSize();
                }
            }
        }
        return sz;
    }

    private float getFontSizeFromIdentifier(String familyName, String sizeIdentifier) {
        if (this.getStyleDatabase() != null) {
            return this.getStyleDatabase().getFontSizeFromIdentifier(familyName, sizeIdentifier);
        }
        float sz = sizeIdentifier.equals("medium") ? 12.0f : (sizeIdentifier.equals("x-small") ? 9.0f : (sizeIdentifier.equals("small") ? 10.0f : (sizeIdentifier.equals("xx-small") ? 8.0f : (sizeIdentifier.equals("large") ? 14.0f : (sizeIdentifier.equals("x-large") ? 18.0f : (sizeIdentifier.equals("xx-large") ? 24.0f : 12.0f))))));
        return sz;
    }

    private TypedValue getLargerFontSize(String familyName) {
        CSSTypedValue csssize;
        ComputedCSSStyle parentCss = this.getParentComputedStyle();
        if (parentCss != null && (csssize = (CSSTypedValue)((Object)parentCss.getCSSValue("font-size"))) != null) {
            String larger;
            switch (csssize.getPrimitiveType()) {
                case IDENT: {
                    String baseFontSize = csssize.getStringValue();
                    if (baseFontSize.equals("xx-small")) {
                        larger = "x-small";
                        break;
                    }
                    if (baseFontSize.equals("x-small")) {
                        larger = "small";
                        break;
                    }
                    if (baseFontSize.equals("small")) {
                        larger = "medium";
                        break;
                    }
                    if (baseFontSize.equals("medium")) {
                        larger = "large";
                        break;
                    }
                    if (baseFontSize.equals("large")) {
                        larger = "x-large";
                        break;
                    }
                    if (baseFontSize.equals("x-large")) {
                        larger = "xx-large";
                        break;
                    }
                    if (baseFontSize.equals("xx-large")) {
                        return ComputedCSSStyle.asNumericValuePt(2.0f * this.getFontSizeFromIdentifier(familyName, "xx-large") - this.getFontSizeFromIdentifier(familyName, "x-large"));
                    }
                    this.computedStyleError("font-size", baseFontSize, "Unknown identifier");
                    return ComputedCSSStyle.asNumericValuePt(this.getFontSizeFromIdentifier(familyName, "medium") * 1.2f);
                }
                default: {
                    return ComputedCSSStyle.asNumericValuePt(parentCss.getComputedFontSize() * 1.2f);
                }
            }
            return new IdentifierValue(larger);
        }
        return ComputedCSSStyle.asNumericValuePt(this.getFontSizeFromIdentifier(familyName, "medium") * 1.2f);
    }

    private TypedValue getSmallerFontSize(String familyName) {
        CSSTypedValue csssize;
        ComputedCSSStyle parentCss = this.getParentComputedStyle();
        if (parentCss != null && (csssize = (CSSTypedValue)((Object)parentCss.getCSSValue("font-size"))) != null) {
            String smaller;
            switch (csssize.getPrimitiveType()) {
                case IDENT: {
                    String baseFontSize = csssize.getStringValue();
                    if (baseFontSize.equals("xx-small")) {
                        float sz = 2.0f * this.getFontSizeFromIdentifier(familyName, "xx-small") - this.getFontSizeFromIdentifier(familyName, "x-small");
                        if (sz < 7.0f) {
                            sz = this.getFontSizeFromIdentifier(familyName, "xx-small");
                        }
                        return ComputedCSSStyle.asNumericValuePt(sz);
                    }
                    if (baseFontSize.equals("x-small")) {
                        smaller = "xx-small";
                        break;
                    }
                    if (baseFontSize.equals("small")) {
                        smaller = "x-small";
                        break;
                    }
                    if (baseFontSize.equals("medium")) {
                        smaller = "small";
                        break;
                    }
                    if (baseFontSize.equals("large")) {
                        smaller = "medium";
                        break;
                    }
                    if (baseFontSize.equals("x-large")) {
                        smaller = "large";
                        break;
                    }
                    if (baseFontSize.equals("xx-large")) {
                        smaller = "x-large";
                        break;
                    }
                    this.computedStyleError("font-size", baseFontSize, "Unknown identifier");
                    return ComputedCSSStyle.asNumericValuePt(this.getFontSizeFromIdentifier(familyName, "medium") * 0.82f);
                }
                default: {
                    return ComputedCSSStyle.asNumericValuePt(parentCss.getComputedFontSize() * 0.82f);
                }
            }
            return new IdentifierValue(smaller);
        }
        return ComputedCSSStyle.asNumericValuePt(this.getFontSizeFromIdentifier(familyName, "medium") * 0.82f);
    }

    private void reportFontSizeError(CSSValue cssSize, String message) {
        String cssText = cssSize.getCssText();
        this.computedStyleError("font-size", cssText, message);
    }

    private void reportFontSizeWarning(PrimitiveValue cssSize, String message) {
        this.computedStyleWarning("font-size", cssSize, message);
    }

    private float getParentElementFontSize() {
        ComputedCSSStyle parentCss = this.getParentComputedStyle();
        float sz = parentCss != null ? parentCss.getComputedFontSize() : this.getInitialFontSize();
        return sz;
    }

    private boolean isRelativeUnit(CSSTypedValue pri) {
        return pri.getPrimitiveType() == CSSValue.Type.NUMERIC && CSSUnit.isRelativeLengthUnitType(pri.getUnitType());
    }

    private TypedValue colorValue(String propertyName, TypedValue primi) {
        if (primi.getPrimitiveType() == CSSValue.Type.IDENT) {
            String s = primi.getStringValue().toLowerCase(Locale.ROOT);
            if ("currentcolor".equals(s)) {
                if (!"color".equals(propertyName)) {
                    primi = this.getCSSColor();
                }
            } else {
                String spec = "transparent".equals(s) ? "#0000" : ColorIdentifiers.getInstance().getColor(s);
                if (spec != null) {
                    try {
                        primi = (TypedValue)this.getValueFactory().parseProperty(spec);
                    }
                    catch (DOMException dOMException) {
                        // empty catch block
                    }
                }
            }
        }
        return primi;
    }

    private static NumberValue asNumericValuePt(float f) {
        NumberValue number = new NumberValue();
        number.setFloatValuePt(f);
        number.setAbsolutizedUnit();
        return number;
    }

    private float getInitialFontSize() {
        String familyName = this.getUsedFontFamily();
        return this.getFontSizeFromIdentifier(familyName, "medium");
    }

    @Override
    public float getComputedLineHeight() {
        return this.getComputedLineHeight(1.16f);
    }

    public float getComputedLineHeight(float defval) {
        float height;
        StyleValue value = this.getCSSValue("line-height");
        if (value == null || value.getCssValueType() != CSSValue.CssType.TYPED) {
            return defval * this.getComputedFontSize();
        }
        CSSTypedValue cssval = (CSSTypedValue)((Object)value);
        CSSValue.Type declType = cssval.getPrimitiveType();
        if (declType == CSSValue.Type.NUMERIC) {
            short unit = cssval.getUnitType();
            if (unit == 2) {
                height = this.getComputedFontSize() * cssval.getFloatValue() / 100.0f;
            } else {
                height = cssval.getFloatValue(unit);
                if (unit != 6) {
                    height = NumberValue.floatValueConversion(height, unit, (short)6);
                }
            }
        } else if (declType == CSSValue.Type.IDENT) {
            if (!"normal".equalsIgnoreCase(cssval.getStringValue())) {
                this.computedStyleError("line-height", cssval.getStringValue(), "Wrong value: expected 'normal'");
            }
            height = defval * this.getComputedFontSize();
        } else {
            this.computedStyleError("line-height", cssval.getStringValue(), "Wrong value: expected number or identifier");
            height = defval * this.getComputedFontSize();
        }
        return height;
    }

    private StyleValue applyDisplayConstrains(StyleValue value) {
        StyleValue computedValue = value;
        if (value.getCssValueType() != CSSValue.CssType.TYPED) {
            return value;
        }
        String strVal = ((CSSTypedValue)((Object)value)).getStringValue();
        if (!"none".equalsIgnoreCase(strVal)) {
            String position = this.getTypedValueOrInitial("position").getStringValue();
            if ("absolute".equalsIgnoreCase(position) || "fixed".equalsIgnoreCase(position)) {
                computedValue = this.computeConstrainedDisplay(value);
            } else {
                CSSElement node;
                String floatProp = this.getTypedValueOrInitial("float").getStringValue();
                if (!"none".equalsIgnoreCase(floatProp) || (node = this.getOwnerNode()).getParentNode() == node.getOwnerDocument()) {
                    computedValue = this.computeConstrainedDisplay(value);
                }
            }
        }
        return computedValue;
    }

    private TypedValue getTypedValueOrInitial(String propertyName) {
        StyleValue value = this.getCSSValue(propertyName);
        TypedValue typed = value.getCssValueType() != CSSValue.CssType.TYPED ? (TypedValue)this.defaultPropertyValue(propertyName) : (TypedValue)value;
        return typed;
    }

    private TypedValue getTypedValueOrInherit(String propertyName) {
        ComputedCSSStyle ancStyle = this;
        StyleValue value = this.getCSSValue(propertyName);
        if (value.getCssValueType() != CSSValue.CssType.TYPED) {
            while ((value = ComputedCSSStyle.inheritValue(ancStyle, propertyName, value, true)) == null || value.getCssValueType() != CSSValue.CssType.TYPED) {
                value = null;
                if ((ancStyle = ancStyle.getParentComputedStyle()) != null) continue;
            }
            if (value == null) {
                value = this.defaultPropertyValue(propertyName);
            }
        }
        return (TypedValue)value;
    }

    private StyleValue computeConstrainedDisplay(StyleValue value) {
        String display = ((CSSTypedValue)((Object)value)).getStringValue().toLowerCase(Locale.ROOT);
        if ("inline-table".equals(display)) {
            return new IdentifierValue("table");
        }
        if ("inline".equals(display) || "run-in".equals(display) || "table-row-group".equals(display) || "table-column".equals(display) || "table-column-group".equals(display) || "table-header-group".equals(display) || "table-footer-group".equals(display) || "table-row".equals(display) || "table-cell".equals(display) || "table-caption".equals(display) || "inline-block".equals(display)) {
            return new IdentifierValue("block");
        }
        return value;
    }

    private StyleValue applyBorderWidthConstrains(String property, StyleValue value) {
        String style = null;
        if (property.equals("border-top-width")) {
            style = this.getCSSValue("border-top-style").getCssText();
        } else if (property.equals("border-right-width")) {
            style = this.getCSSValue("border-top-style").getCssText();
        } else if (property.equals("border-bottom-width")) {
            style = this.getCSSValue("border-top-style").getCssText();
        } else if (property.equals("border-left-width")) {
            style = this.getCSSValue("border-top-style").getCssText();
        }
        if (style != null && (style.equals("none") || style.equals("hidden"))) {
            value = this.getValueFactory().parseProperty("0");
        }
        return value;
    }

    private StyleValue computeBackgroundRepeat(StyleValue value) {
        if (value.getCssValueType() == CSSValue.CssType.LIST) {
            ValueList list = (ValueList)value;
            if (list.isCommaSeparated()) {
                for (int i = 0; i < list.getLength(); ++i) {
                    StyleValue item = list.item(i);
                    if (item.getCssValueType() == CSSValue.CssType.LIST) continue;
                    list.set(i, this.computeBackgroundRepeatPrimitive(item));
                }
            }
        } else {
            value = this.computeBackgroundRepeatPrimitive(value);
        }
        return value;
    }

    private StyleValue computeBackgroundRepeatPrimitive(StyleValue value) {
        ValueList list = ValueList.createWSValueList();
        String s = value.getCssText();
        if (s.equals("repeat-y")) {
            list.add(new IdentifierValue("no-repeat"));
            list.add(new IdentifierValue("repeat"));
        } else if (s.equals("repeat-x")) {
            list.add(new IdentifierValue("repeat"));
            list.add(new IdentifierValue("no-repeat"));
        } else if (s.equals("repeat")) {
            list.add(new IdentifierValue("repeat"));
            list.add(new IdentifierValue("repeat"));
        } else if (s.equals("no-repeat")) {
            list.add(new IdentifierValue("no-repeat"));
            list.add(new IdentifierValue("no-repeat"));
        } else if (s.equals("space")) {
            list.add(new IdentifierValue("space"));
            list.add(new IdentifierValue("space"));
        } else if (s.equals("round")) {
            list.add(new IdentifierValue("round"));
            list.add(new IdentifierValue("round"));
        } else {
            return value;
        }
        return list;
    }

    @Override
    protected TypedValue getCurrentColor() {
        return this.getCSSColor();
    }

    @Override
    public TypedValue getCSSColor() {
        return this.getTypedValueOrInherit("color");
    }

    @Override
    public TypedValue getCSSBackgroundColor() {
        return this.getTypedValueOrInitial("background-color");
    }

    @Override
    public String[] getBackgroundImages() {
        CSSDeclarationRule pRule;
        StyleValue cssVal = this.getCSSValue("background-image");
        if (cssVal == null) {
            return null;
        }
        String baseHref = cssVal instanceof WrappedValue ? ((WrappedValue)((Object)cssVal)).getParentSheetHref() : ((pRule = this.getParentRule()) != null ? pRule.getParentStyleSheet().getHref() : null);
        if (cssVal.getCssValueType() == CSSValue.CssType.TYPED) {
            return new String[]{this.getHref((CSSTypedValue)((Object)cssVal), baseHref)};
        }
        ValueList list = (ValueList)cssVal;
        int len = list.getLength();
        String[] sa = new String[len];
        for (int i = 0; i < len; ++i) {
            sa[i] = this.getHref((CSSTypedValue)((Object)list.item(i)), baseHref);
        }
        return sa;
    }

    protected String getHref(CSSTypedValue cssVal, String baseHref) {
        URI uri;
        String href = cssVal.getStringValue();
        try {
            uri = new URI(href);
        }
        catch (Exception e) {
            this.getStyleDeclarationErrorHandler().malformedURIValue(baseHref);
            return null;
        }
        if (!uri.isAbsolute()) {
            URI baseUri = null;
            if (baseHref == null) {
                baseUri = this.documentURI();
            } else {
                try {
                    String ownerUri;
                    baseUri = new URI(baseHref);
                    if (!baseUri.isAbsolute() && (ownerUri = this.getOwnerNode().getBaseURI()) != null) {
                        URI ownerBase = new URI(ownerUri);
                        baseUri = ownerBase.resolve(baseUri);
                    }
                }
                catch (Exception e) {
                    this.getStyleDeclarationErrorHandler().malformedURIValue(baseHref);
                    baseUri = this.documentURI();
                }
            }
            if (baseUri != null) {
                uri = baseUri.resolve(uri);
            }
        }
        return uri.toASCIIString();
    }

    private URI documentURI() {
        URI uri = null;
        String documentURI = this.getOwnerNode().getBaseURI();
        if (documentURI != null) {
            try {
                uri = new URI(documentURI);
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return uri;
    }

    @Override
    public String getUsedFontFamily() {
        StyleDatabase sdb = this.getStyleDatabase();
        if (sdb != null) {
            return sdb.getUsedFontFamily(this);
        }
        StyleValue fontFamily = this.getCSSValue("font-family");
        if (fontFamily != null) {
            if (fontFamily.getCssValueType() == CSSValue.CssType.LIST) {
                ValueList list = (ValueList)fontFamily;
                fontFamily = list.item(0);
            }
            if (fontFamily.getPrimitiveType() != CSSValue.Type.UNKNOWN && fontFamily.getCssValueType() == CSSValue.CssType.TYPED) {
                CSSTypedValue primi = (CSSTypedValue)((Object)fontFamily);
                try {
                    return primi.getStringValue();
                }
                catch (DOMException e) {
                    this.computedStyleError("font-family", primi.getCssText(), "Bad font-family.");
                }
            }
        }
        return "Serif";
    }

    private void computedStyleError(String propertyName, String propertyValue, String message) {
        this.computedStyleError(propertyName, propertyValue, message, null);
    }

    private void computedStyleError(String propertyName, String propertyValue, String message, Throwable cause) {
        CSSPropertyValueException ex = cause == null ? new CSSPropertyValueException(message) : (message == null ? new CSSPropertyValueException(cause) : new CSSPropertyValueException(message, cause));
        ex.setValueText(propertyValue);
        this.getOwnerNode().getOwnerDocument().getErrorHandler().computedStyleError(this.getOwnerNode(), propertyName, ex);
    }

    private void computedStyleWarning(String propertyName, CSSPrimitiveValue value, String message) {
        this.computedStyleWarning(propertyName, value, message, null);
    }

    private void computedStyleWarning(String propertyName, CSSPrimitiveValue value, String message, Throwable cause) {
        this.computedStyleWarning(propertyName, value.getCssText(), message, cause);
    }

    private void computedStyleWarning(String propertyName, String propertyValue, String message, Throwable cause) {
        CSSPropertyValueException ex = cause == null ? new CSSPropertyValueException(message) : (message == null ? new CSSPropertyValueException(cause) : new CSSPropertyValueException(message, cause));
        ex.setValueText(propertyValue);
        this.getOwnerNode().getOwnerDocument().getErrorHandler().computedStyleWarning(this.getOwnerNode(), propertyName, ex);
    }

    @Override
    public BoxValues getBoxValues(short unitType) throws DOMException, StyleDatabaseRequiredException {
        return new MyDefaultBoxModel().getComputedBox(unitType);
    }

    @Override
    public String getCssText() {
        return this.getComputedPlainCssText();
    }

    @Override
    public void writeCssText(SimpleWriter wri, StyleFormattingContext context) throws IOException {
        this.writeComputedCssText(wri, context);
    }

    @Override
    public String getMinifiedCssText() {
        return this.getOptimizedCssText();
    }

    public ComputedCSSStyle getRevertStyle(Condition pseudoElt) {
        ComputedCSSStyle style = this.ownerSheet.createComputedCSSStyle();
        CSSElement elt = this.getOwnerNode();
        style.setOwnerNode(elt);
        return this.ownerSheet.computeRevertedStyle(style, elt.getSelectorMatcher(), pseudoElt, (BaseCSSStyleDeclaration)elt.getStyle(), Short.MAX_VALUE);
    }

    @Override
    public abstract ComputedCSSStyle getParentComputedStyle();

    public String getText() {
        return BoxModelHelper.contractSpaces(this.getOwnerNode().getTextContent()).trim();
    }

    @Override
    public abstract ComputedCSSStyle clone();

    static {
        attrForbiddenProperties.add("background-image");
        attrForbiddenProperties.add("cue-after");
        attrForbiddenProperties.add("cue-before");
        attrForbiddenProperties.add("cursor");
        attrForbiddenProperties.add("list-style-image");
        attrForbiddenProperties.add("play-during");
    }

    private class MyEvaluator
    extends Evaluator {
        final String propertyName;

        MyEvaluator(String propertyName) {
            this.propertyName = propertyName;
        }

        @Override
        protected CSSNumberValue absoluteTypedValue(CSSTypedValue partialValue) {
            TypedValue typed = ComputedCSSStyle.this.absoluteTypedValue(this.propertyName, (TypedValue)partialValue, false);
            return super.absoluteTypedValue(typed);
        }

        @Override
        protected StyleValue absoluteProxyValue(CSSPrimitiveValue partialValue) {
            return ComputedCSSStyle.this.replaceProxyValue(this.propertyName, partialValue);
        }
    }

    private class FontEvaluator
    extends MyEvaluator {
        FontEvaluator() {
            super("font-size");
        }

        @Override
        protected CSSNumberValue absoluteTypedValue(CSSTypedValue partialValue) {
            TypedValue typed = ComputedCSSStyle.this.absoluteTypedValue(this.propertyName, (TypedValue)partialValue, true);
            return super.absoluteTypedValue(typed);
        }

        @Override
        protected StyleValue absoluteProxyValue(CSSPrimitiveValue partialValue) {
            return ComputedCSSStyle.this.replaceProxyValue(this.propertyName, partialValue);
        }

        @Override
        protected float percentage(CSSNumberValue value, short resultType) throws DOMException {
            float pcnt = value.getFloatValue((short)2);
            return ComputedCSSStyle.this.getParentElementFontSize() * pcnt / 100.0f;
        }
    }

    private class MyDefaultBoxModel
    extends SimpleBoxModel {
        MyDefaultBoxModel() {
        }

        @Override
        protected ComputedCSSStyle getComputedStyle() {
            return ComputedCSSStyle.this;
        }

        @Override
        protected CSSComputedProperties getRevertStyle(Condition pseudoElt) {
            return ComputedCSSStyle.this.getRevertStyle(pseudoElt);
        }
    }
}

