/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.bridge;

import io.sf.carte.echosvg.anim.dom.AbstractSVGAnimatedLength;
import io.sf.carte.echosvg.anim.dom.AnimatedLiveAttributeValue;
import io.sf.carte.echosvg.anim.dom.SVGOMLineElement;
import io.sf.carte.echosvg.bridge.Bridge;
import io.sf.carte.echosvg.bridge.BridgeContext;
import io.sf.carte.echosvg.bridge.BridgeException;
import io.sf.carte.echosvg.bridge.PaintServer;
import io.sf.carte.echosvg.bridge.SVGDecoratedShapeElementBridge;
import io.sf.carte.echosvg.dom.svg.LiveAttributeException;
import io.sf.carte.echosvg.gvt.ShapeNode;
import io.sf.carte.echosvg.gvt.ShapePainter;
import java.awt.Shape;
import java.awt.geom.Line2D;
import org.w3c.dom.Element;

public class SVGLineElementBridge
extends SVGDecoratedShapeElementBridge {
    @Override
    public String getLocalName() {
        return "line";
    }

    @Override
    public Bridge getInstance() {
        return new SVGLineElementBridge();
    }

    @Override
    protected ShapePainter createFillStrokePainter(BridgeContext ctx, Element e, ShapeNode shapeNode) {
        return PaintServer.convertStrokePainter(e, shapeNode, ctx);
    }

    @Override
    protected void buildShape(BridgeContext ctx, Element e, ShapeNode shapeNode) throws BridgeException {
        SVGOMLineElement le = (SVGOMLineElement)e;
        AbstractSVGAnimatedLength _x1 = (AbstractSVGAnimatedLength)le.getX1();
        float x1 = this.safeAnimatedLength(_x1, 0.0f);
        AbstractSVGAnimatedLength _y1 = (AbstractSVGAnimatedLength)le.getY1();
        float y1 = this.safeAnimatedLength(_y1, 0.0f);
        AbstractSVGAnimatedLength _x2 = (AbstractSVGAnimatedLength)le.getX2();
        float x2 = this.safeAnimatedLength(_x2, 0.0f);
        AbstractSVGAnimatedLength _y2 = (AbstractSVGAnimatedLength)le.getY2();
        float y2 = this.safeAnimatedLength(_y2, 0.0f);
        try {
            shapeNode.setShape((Shape)new Line2D.Float(x1, y1, x2, y2));
        }
        catch (LiveAttributeException ex) {
            throw new BridgeException(ctx, ex);
        }
    }

    @Override
    public void handleAnimatedAttributeChanged(AnimatedLiveAttributeValue alav) {
        String ln;
        if (alav.getNamespaceURI() == null && ((ln = alav.getLocalName()).equals("x1") || ln.equals("y1") || ln.equals("x2") || ln.equals("y2"))) {
            this.buildShape(this.ctx, this.e, (ShapeNode)this.node);
            this.handleGeometryChanged();
            return;
        }
        super.handleAnimatedAttributeChanged(alav);
    }
}

