/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.semantics.model.select;

import java.util.LinkedList;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryComplexName;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryRecognitionContext;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySemanticUtils;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolClass;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryResultColumn;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryRowsDataContext;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryNodeModelVisitor;
import org.jkiss.dbeaver.model.sql.semantics.model.expressions.SQLQueryValueTupleReferenceExpression;
import org.jkiss.dbeaver.model.sql.semantics.model.select.SQLQueryRowsProjectionModel;
import org.jkiss.dbeaver.model.sql.semantics.model.select.SQLQueryRowsSourceModel;
import org.jkiss.dbeaver.model.sql.semantics.model.select.SQLQuerySelectionResultSublistSpec;
import org.jkiss.dbeaver.model.stm.STMTreeNode;

public class SQLQuerySelectionResultTupleSpec
extends SQLQuerySelectionResultSublistSpec {
    @NotNull
    private final SQLQueryValueTupleReferenceExpression tupleReference;

    public SQLQuerySelectionResultTupleSpec(@NotNull STMTreeNode syntaxNode, @NotNull SQLQueryValueTupleReferenceExpression tupleReference) {
        super(syntaxNode);
        this.tupleReference = tupleReference;
        this.registerSubnode(tupleReference);
    }

    @Override
    @Nullable
    public SQLQuerySymbolClass getAssociatedSymbolClass() {
        return SQLQuerySemanticUtils.getIdentifierSymbolClass(this.tupleReference.getTableName());
    }

    @NotNull
    public SQLQueryComplexName getTableName() {
        return this.tupleReference.getTableName();
    }

    @Nullable
    public SQLQueryRowsSourceModel getTupleSource() {
        return this.tupleReference.getTupleSource();
    }

    @Override
    protected void collectColumns(@NotNull SQLQueryRowsDataContext knownValues, @NotNull SQLQueryRowsProjectionModel rowsSourceModel, @NotNull SQLQueryRecognitionContext statistics, @NotNull LinkedList<SQLQueryResultColumn> resultColumns) {
        this.tupleReference.resolveRowSources(knownValues.getRowsSources(), statistics);
        this.tupleReference.resolveValueRelations(knownValues, statistics);
        SQLQueryRowsSourceModel tupleSource = this.tupleReference.getTupleSource();
        if (tupleSource != null) {
            this.collectForeignColumns(tupleSource.getRowsDataContext().getColumnsList(), rowsSourceModel, resultColumns);
        }
    }

    @Override
    protected <R, T> R applyImpl(@NotNull SQLQueryNodeModelVisitor<T, R> visitor, @NotNull T node) {
        return visitor.visitSelectTupleSpec(this, node);
    }
}

