#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2017-2025 Google
# GNU General Public License v3.0+ (see COPYING or https://www.gnu.org/licenses/gpl-3.0.txt)
# ----------------------------------------------------------------------------
#
#     ***     AUTO GENERATED CODE    ***    Type: MMv1     ***
#
# ----------------------------------------------------------------------------
#
#     This file is automatically generated by Magic Modules and manual
#     changes will be clobbered when the file is regenerated.
#
# ----------------------------------------------------------------------------
#

from __future__ import absolute_import, division, print_function

__metaclass__ = type

################################################################################
# Documentation
################################################################################

ANSIBLE_METADATA = {
    "metadata_version": "1.1",
    "status": ["preview"],
    "supported_by": "community",
}

DOCUMENTATION = r"""
---
author:
  - Google Inc. (@googlecloudplatform)
description:
  - A repository associated to a parent connection.
extends_documentation_fragment:
  - google.cloud.gcp
module: gcp_cloudbuildv2_repository
notes:
  - 'API Reference: U(https://cloud.google.com/build/docs/api/reference/rest)'
  - 'Official Documentation Guide: U(https://cloud.google.com/build/docs)'
options:
  annotations:
    description:
      - Allows clients to store small amounts of arbitrary data.
    type: dict
  location:
    description:
      - The location for the resource.
    type: str
  name:
    description:
      - Name of the repository.
    required: true
    type: str
  parent_connection:
    description:
      - The connection for the resource.
      - This field is a reference to a connection resource in GCP.
      - 'It can be specified in two ways: First, you can place a dictionary with key ''name'' matching your resource.'
      - 'Alternatively, you can add `register: name-of-resource` to a connection task and then set this field to `{{ name-of-resource }}`.'
    required: true
    type: dict
  remote_uri:
    description:
      - Git Clone HTTPS URI.
    required: true
    type: str
  state:
    choices:
      - present
      - absent
    default: present
    description:
      - Whether the resource should exist in GCP.
    type: str
requirements:
  - python >= 3.8
  - requests >= 2.18.4
  - google-auth >= 2.25.1
short_description: Creates a GCP Cloudbuildv2.Repository resource
"""

EXAMPLES = r"""
# repository_ghe_doc

################################################################################

# repository_github_doc
"""

RETURN = r"""
changed:
  description: Whether the resource was changed.
  returned: always
  type: bool
createTime:
  description:
    - Output only.
    - Server assigned timestamp for when the connection was created.
  returned: success
  type: str
etag:
  description:
    - >-
      This checksum is computed by the server based on the value of other fields, and may be sent on update and delete requests to ensure the

      client has an up-to-date value before proceeding.
  returned: success
  type: str
state:
  description: The current state of the resource.
  returned: always
  type: str
updateTime:
  description:
    - Output only.
    - Server assigned timestamp for when the connection was updated.
  returned: success
  type: str
"""

################################################################################
# Imports
################################################################################

from ansible_collections.google.cloud.plugins.module_utils import gcp_utils as gcp
import copy

# BEGIN Custom imports
# END Custom imports


def build_link(module, uri):
    params = module.params.copy()
    params["parent_connection"] = gcp.replace_resource_dict(module.params["parent_connection"], "name")

    return "https://cloudbuild.googleapis.com/v2/" + uri.format(**params)


class Cloudbuildv2(gcp.Resource):
    def _request(self):
        return {
            "annotations": self.request.get("annotations"),
            "name": self.request.get("name"),
            "remoteUri": self.request.get("remote_uri"),
        }

    def _response(self):
        return {
            "annotations": self.response.get("annotations"),
            "createTime": self.response.get("createTime"),
            "etag": self.response.get("etag"),
            "name": self.response.get("name"),
            "remoteUri": self.response.get("remoteUri"),
            "updateTime": self.response.get("updateTime"),
        }


################################################################################
# Main
################################################################################


def encode(obj):
    """
    The encoder is a function which take the `obj` map after it has been
    assembled in either "Create" or "Update" and mutate it before it is sent to
    the server
    """

    if obj is None:
        return None
    r = copy.deepcopy(obj)
    # --------- BEGIN custom encoder code ---------
    # no encoder needed
    # --------- END custom encoder code ---------

    return r


def decode(obj):
    """
    The decoder is a function which takes the `obj` map after the read succeeds
    and mutates it before it is returned to the module caller
    """

    if obj is None:
        return None
    r = copy.deepcopy(obj)
    # --------- BEGIN custom decoder code ---------
    # the name returned from the API is FQDN, but the name
    # we send is just the "base name", convert it back to
    # what we need but maintain the parent connection ref
    parts = obj["name"].split("/")
    r["parentConnection"] = "/".join(parts[:-2])
    r["name"] = parts[-1]
    # --------- END custom decoder code ---------

    return r


def main():
    """Main function"""

    module = gcp.Module(
        argument_spec=dict(
            name=dict(
                type="str",
                required=True,
            ),
            state=dict(
                type="str",
                default="present",
                choices=["present", "absent"],
            ),
            annotations=dict(
                type="dict",
            ),
            location=dict(
                type="str",
            ),
            parent_connection=dict(
                type="dict",
                required=True,
            ),
            remote_uri=dict(
                type="str",
                required=True,
            ),
        )
    )

    if not module.params["scopes"]:
        module.params["scopes"] = ["https://www.googleapis.com/auth/cloud-platform"]

    state = module.params["state"]
    changed = False

    op_configs = gcp.ResourceOpConfigs(
        {
            "create": gcp.ResourceOpConfig(
                **{
                    "uri": "{parent_connection}/repositories?repositoryId={name}",
                    "async_uri": "{op_id}",
                    "verb": "POST",
                    "timeout_minutes": 20,
                }
            ),
            "delete": gcp.ResourceOpConfig(
                **{
                    "uri": "{parent_connection}/repositories/{name}",
                    "async_uri": "{op_id}",
                    "verb": "DELETE",
                    "timeout_minutes": 20,
                }
            ),
            "read": gcp.ResourceOpConfig(
                **{
                    "uri": "{parent_connection}/repositories/{name}",
                    "async_uri": "",
                    "verb": "GET",
                    "timeout_minutes": 0,
                }
            ),
            "update": gcp.ResourceOpConfig(
                **{
                    "uri": "{parent_connection}/repositories/{name}",
                    "async_uri": "{op_id}",
                    "verb": "PUT",
                    "timeout_minutes": 20,
                }
            ),
        }
    )

    params = gcp.remove_nones_from_dict(module.params)
    resource = Cloudbuildv2(params, module=module, product="Cloudbuildv2", kind="cloudbuildv2#repository")
    existing_obj = decode(resource.get(build_link(module, op_configs.read.uri), allow_not_found=True))

    if existing_obj is None:
        if state == "present":
            is_async = op_configs.create.async_uri != ""
            create_link = build_link(module, op_configs.create.uri)
            create_retries = op_configs.create.timeout
            create_func = getattr(resource, op_configs.create.verb)
            async_create_func = getattr(resource, op_configs.create.verb + "_async")
            async_create_link = build_link(module, "") + op_configs.create.async_uri
            # --------- BEGIN custom pre-create code ---------
            # --------- END custom pre-create code ---------
            gcp.debug(
                module,
                msg="Creating resource",
                create_link=create_link,
                async_create_link=async_create_link,
                is_async=is_async,
            )
            try:
                if is_async:
                    new_obj = async_create_func(create_link, async_link=async_create_link, retries=create_retries)
                else:
                    new_obj = create_func(create_link)
                changed = True
            except Exception as e:
                module.fail_json(msg=str(e))
        else:
            pass  # nothing to do
    else:
        if state == "absent":
            is_async = op_configs.delete.async_uri != ""
            delete_link = build_link(module, op_configs.delete.uri)
            delete_retries = op_configs.delete.timeout
            delete_func = getattr(resource, op_configs.delete.verb)
            async_delete_func = getattr(resource, op_configs.delete.verb + "_async")
            async_delete_link = build_link(module, "") + op_configs.delete.async_uri
            # --------- BEGIN custom pre-delete code ---------
            # --------- END custom pre-delete code ---------
            gcp.debug(
                module,
                msg="Destroying resource",
                delete_link=delete_link,
                async_delete_link=async_delete_link,
                is_async=is_async,
            )
            try:
                if is_async:
                    new_obj = async_delete_func(delete_link, async_link=async_delete_link, retries=delete_retries)
                else:
                    new_obj = delete_func(delete_link)
                changed = True
            except Exception as e:
                module.fail_json(msg=str(e))
        else:
            gcp.debug(module, existing=existing_obj, request=resource.to_request())
            if resource.diff(existing_obj):
                is_async = op_configs.update.async_uri != ""
                update_link = build_link(module, op_configs.update.uri)
                update_retries = op_configs.update.timeout
                update_func = getattr(resource, op_configs.update.verb)
                async_update_func = getattr(resource, op_configs.update.verb + "_async")
                async_update_link = build_link(module, "") + op_configs.update.async_uri
                # --------- BEGIN custom pre-update code ---------
                # --------- END custom pre-update code ---------
                gcp.debug(
                    module,
                    msg="Updating resource",
                    update_link=update_link,
                    async_update_link=async_update_link,
                    is_async=is_async,
                )
                try:
                    if is_async:
                        new_obj = async_update_func(update_link, async_link=async_update_link, retries=update_retries)
                    else:
                        new_obj = update_func(update_link)
                except Exception as e:
                    module.fail_json(msg=str(e))
                changed = True

    new_obj = decode(resource.get(build_link(module, op_configs.read.uri), allow_not_found=True))
    new_obj = resource.from_response(new_obj or {})

    new_obj.update({"changed": changed})
    module.exit_json(**new_obj)


if __name__ == "__main__":
    main()
