//
// Copyright 2023 Pixar
//
// Licensed under the terms set forth in the LICENSE.txt file available at
// https://openusd.org/license.
//
////////////////////////////////////////////////////////////////////////

/* ************************************************************************** */
/* **                                                                      ** */
/* ** This file is generated by a script.                                  ** */
/* **                                                                      ** */
/* ** Do not edit it directly (unless it is within a CUSTOM CODE section)! ** */
/* ** Edit hdSchemaDefs.py instead to make changes.                        ** */
/* **                                                                      ** */
/* ************************************************************************** */

#ifndef PXR_IMAGING_HD_MATERIAL_INTERFACE_SCHEMA_H
#define PXR_IMAGING_HD_MATERIAL_INTERFACE_SCHEMA_H

/// \file

#include "pxr/imaging/hd/api.h"
#include "pxr/imaging/hd/schemaTypeDefs.h"

#include "pxr/imaging/hd/schema.h"

// --(BEGIN CUSTOM CODE: Includes)--

#include <unordered_map>

// --(END CUSTOM CODE: Includes)--

PXR_NAMESPACE_OPEN_SCOPE

// --(BEGIN CUSTOM CODE: Declares)--

using TfTokenMap = std::unordered_map<TfToken, TfToken, TfToken::HashFunctor>;
using NestedTfTokenMap = 
    std::unordered_map<TfToken, TfTokenMap, TfToken::HashFunctor>;

// --(END CUSTOM CODE: Declares)--

#define HD_MATERIAL_INTERFACE_SCHEMA_TOKENS \
    (parameters) \
    (parameterOrder) \

TF_DECLARE_PUBLIC_TOKENS(HdMaterialInterfaceSchemaTokens, HD_API,
    HD_MATERIAL_INTERFACE_SCHEMA_TOKENS);

//-----------------------------------------------------------------------------


/// \class HdMaterialInterfaceSchema
///
/// The MaterialInterface schema describes a material's interface parameters,
/// also known as public UI parameters.
///
class HdMaterialInterfaceSchema : public HdSchema
{
public:
    /// \name Schema retrieval
    /// @{

    HdMaterialInterfaceSchema(HdContainerDataSourceHandle container)
      : HdSchema(container) {}

    /// @}

// --(BEGIN CUSTOM CODE: Schema Methods)--

    /// Builds and returns a map of reversed interface mappings.  If no  
    /// interface mappings were found, returns an empty map.
    /// 
    /// Interface mappings are mapped like this:
    /// publicUIName -> [(nodePath, inputName),...]
    /// 
    /// The returned map of reversed interface mappings is mapped like this:
    /// nodePath -> (inputName -> publicUIName)
    HD_API 
    NestedTfTokenMap GetReverseInterfaceMappings() const;

// --(END CUSTOM CODE: Schema Methods)--

    /// \name Member accessor
    /// @{

    /// A container for all the material's interface parameters.
    HD_API
    HdMaterialInterfaceParameterContainerSchema GetParameters() const;

    /// Provides the intended order of the interface parameters for UI
    /// purposes. Any member of 'parameters' that is not found in this list
    /// can come after all listed members. The order of display groups is
    /// implicitly encoded. As this list is traversed, display groups are
    /// ordered by first encounter.
    HD_API
    HdTokenArrayDataSourceHandle GetParameterOrder() const; 

    /// @} 

    /// \name Schema construction
    /// @{

    /// \deprecated Use Builder instead.
    ///
    /// Builds a container data source which includes the provided child data
    /// sources. Parameters with nullptr values are excluded. This is a
    /// low-level interface. For cases in which it's desired to define
    /// the container with a sparse set of child fields, the Builder class
    /// is often more convenient and readable.
    HD_API
    static HdContainerDataSourceHandle
    BuildRetained(
        const HdContainerDataSourceHandle &parameters,
        const HdTokenArrayDataSourceHandle &parameterOrder
    );

    /// \class HdMaterialInterfaceSchema::Builder
    /// 
    /// Utility class for setting sparse sets of child data source fields to be
    /// filled as arguments into BuildRetained. Because all setter methods
    /// return a reference to the instance, this can be used in the "builder
    /// pattern" form.
    class Builder
    {
    public:
        HD_API
        Builder &SetParameters(
            const HdContainerDataSourceHandle &parameters);
        HD_API
        Builder &SetParameterOrder(
            const HdTokenArrayDataSourceHandle &parameterOrder);

        /// Returns a container data source containing the members set thus far.
        HD_API
        HdContainerDataSourceHandle Build();

    private:
        HdContainerDataSourceHandle _parameters;
        HdTokenArrayDataSourceHandle _parameterOrder;

    };

    /// @}
};

PXR_NAMESPACE_CLOSE_SCOPE

#endif