/*
 * Decompiled with CFR 0.152.
 */
package hughai.basictypes;

import com.springrts.ai.oo.AIFloat3;
import com.springrts.ai.oo.CallbackAIException;
import com.springrts.ai.oo.clb.Unit;
import com.springrts.ai.oo.clb.UnitDef;
import hughai.basictypes.Float3;

public class OOPCommands {

    public static class StopCommand
    extends OOPCommand {
        public StopCommand(Unit unit) {
            this.UnitToReceiveOrder = unit;
        }

        @Override
        public void execute() throws CallbackAIException {
            this.UnitToReceiveOrder.stop((short)0, Integer.MAX_VALUE);
        }
    }

    public static class SelfDestructCommand
    extends OOPCommand {
        public SelfDestructCommand(Unit unit) {
            this.UnitToReceiveOrder = unit;
        }

        @Override
        public void execute() throws CallbackAIException {
            this.UnitToReceiveOrder.selfDestruct((short)0, Integer.MAX_VALUE);
        }
    }

    public static class ReclaimCommand
    extends OOPCommand {
        public Float3 pos;
        public double radius;

        public ReclaimCommand(Unit unit, Float3 float3, double d) {
            this.UnitToReceiveOrder = unit;
            this.pos = float3;
            this.radius = d;
        }

        @Override
        public void execute() throws CallbackAIException {
            this.UnitToReceiveOrder.reclaimInArea(this.pos.toAIFloat3(), (float)this.radius, (short)0, Integer.MAX_VALUE);
        }
    }

    public static class GuardCommand
    extends OOPCommand {
        public Unit unittobeguarded;

        public GuardCommand(Unit unit, Unit unit2) {
            this.UnitToReceiveOrder = unit;
            this.unittobeguarded = unit2;
        }

        @Override
        public void execute() throws CallbackAIException {
            this.UnitToReceiveOrder.guard(this.unittobeguarded, (short)0, Integer.MAX_VALUE);
        }
    }

    public static class MoveToCommand
    extends OOPCommand {
        public Float3 targetpos;

        public MoveToCommand(Unit unit, Float3 float3) {
            this.UnitToReceiveOrder = unit;
            this.targetpos = float3;
        }

        @Override
        public void execute() throws CallbackAIException {
            this.UnitToReceiveOrder.moveTo(this.targetpos.toAIFloat3(), (short)0, Integer.MAX_VALUE);
        }

        @Override
        public String toString() {
            UnitDef unitDef = this.UnitToReceiveOrder.getDef();
            if (unitDef != null) {
                return "MoveToCommand " + this.UnitToReceiveOrder.getUnitId() + " " + this.UnitToReceiveOrder.getDef().getHumanName() + " moving to " + this.targetpos.toString();
            }
            return "MoveToCommand.  Unittoreceiveorder doesn't exist. id " + this.UnitToReceiveOrder.getUnitId();
        }
    }

    public static class AttackCommand
    extends OOPCommand {
        public Target target;

        public AttackCommand(Unit unit, Target target) {
            this.UnitToReceiveOrder = unit;
            this.target = target;
        }

        @Override
        public void execute() throws CallbackAIException {
            if (this.target.getClass() == UnitTarget.class) {
                this.UnitToReceiveOrder.attack(((UnitTarget)this.target).target, (short)0, Integer.MAX_VALUE);
            } else if (this.target.getClass() == PositionTarget.class) {
                this.UnitToReceiveOrder.attackArea(((PositionTarget)this.target).targetpos.toAIFloat3(), 100.0f, (short)0, Integer.MAX_VALUE);
            }
            throw new RuntimeException("Invalid target");
        }

        @Override
        public String toString() {
            return "AttackCommand " + this.UnitToReceiveOrder + " attacking " + this.target.toString();
        }
    }

    public static class BuildCommand
    extends OOPCommand {
        public UnitDef unitdeftobuild;
        public Float3 pos = null;
        public String unitdefhumanname = "";

        public BuildCommand(Unit unit, UnitDef unitDef, String string) {
            this.UnitToReceiveOrder = unit;
            this.unitdeftobuild = unitDef;
            this.unitdefhumanname = string;
        }

        public BuildCommand(Unit unit, UnitDef unitDef, Float3 float3, String string) {
            this.UnitToReceiveOrder = unit;
            this.unitdeftobuild = unitDef;
            this.pos = float3;
            this.unitdefhumanname = string;
        }

        @Override
        public void execute() throws CallbackAIException {
            if (this.pos == null) {
                this.UnitToReceiveOrder.build(this.unitdeftobuild, new AIFloat3(), 0, (short)0, Integer.MAX_VALUE);
            } else {
                this.UnitToReceiveOrder.build(this.unitdeftobuild, this.pos.toAIFloat3(), 0, (short)0, Integer.MAX_VALUE);
            }
        }

        @Override
        public String toString() {
            if (this.pos != null) {
                return "BuildCommand " + this.UnitToReceiveOrder.getDef().getHumanName() + " " + this.UnitToReceiveOrder.getUnitId() + " building " + this.unitdefhumanname + " at " + this.pos.toString();
            }
            return "BuildCommand " + this.UnitToReceiveOrder.getDef().getHumanName() + " " + this.UnitToReceiveOrder.getUnitId() + " building " + this.unitdefhumanname;
        }
    }

    public static class OOPCommand {
        public Unit UnitToReceiveOrder;

        public OOPCommand() {
        }

        public OOPCommand(Unit unit) {
            this.UnitToReceiveOrder = unit;
        }

        public void execute() throws CallbackAIException {
        }

        public String toString() {
            return this.getClass().getSimpleName() + " unit " + this.UnitToReceiveOrder.getUnitId() + " " + this.UnitToReceiveOrder.getDef().getHumanName();
        }
    }

    public static class UnitTarget
    extends Target {
        public Unit target;

        public UnitTarget(Unit unit) {
            this.target = unit;
        }
    }

    public static class PositionTarget
    extends Target {
        public Float3 targetpos;

        public PositionTarget(Float3 float3) {
            this.targetpos = float3;
        }

        public String toString() {
            return "PositionTarget: " + this.targetpos.toString();
        }
    }

    public static class Target {
        public double[] ToDoubleArray() {
            return null;
        }
    }
}

