#
# Copyright (c), 2016-2020, SISSA (International School for Advanced Studies).
# All rights reserved.
# This file is distributed under the terms of the MIT License.
# See the file 'LICENSE' in the root directory of the present
# distribution, or http://opensource.org/licenses/MIT.
#
# @author Davide Brunato <brunato@sissa.it>
#
from xml.etree.ElementTree import ParseError


class XMLSchemaException(Exception):
    """The base exception that let you catch all the errors generated by the library."""


class XMLSchemaOSError(XMLSchemaException, OSError):
    pass


class XMLSchemaAttributeError(XMLSchemaException, AttributeError):
    pass


class XMLSchemaTypeError(XMLSchemaException, TypeError):
    pass


class XMLSchemaValueError(XMLSchemaException, ValueError):
    pass


class XMLSchemaKeyError(XMLSchemaException, KeyError):
    pass


class XMLSchemaRuntimeError(XMLSchemaException, RuntimeError):
    pass


class XMLSchemaNamespaceError(XMLSchemaException, RuntimeError):
    """Raised when a wrong runtime condition is found with a namespace."""


class XMLSchemaWarning(Warning):
    """Base warning class for the XMLSchema package."""


class XMLResourceError(XMLSchemaException):
    """
    A generic error on an XML resource that catches all the errors generated
    by an XML resource/loader instance on accessing XML data.
    """


class XMLResourceParseError(XMLResourceError, ParseError):
    """Raised when an error is found parsing an XML resource."""


class XMLResourceExceeded(XMLResourceError):
    """Raised when the parsing of an XML resource exceeds a safety limit."""


class XMLResourceBlocked(XMLResourceError):
    """Raised when an XML resource access is blocked by security settings."""


class XMLResourceForbidden(XMLResourceError):
    """Raised when the parsing of an XML resource is forbidden for safety reasons."""


class XMLResourceOSError(XMLResourceError, OSError):
    """
    Raised when an XMLResource calls a system function that returns a system-related error,
    including I/O operations.
    """
