from chardet.enums import CharacterCategory, SequenceLikelihood
from chardet.sbcharsetprober import SingleByteCharSetModel

MALTESE_LANG_MODEL = {
    31: {  # 'A'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        43: SequenceLikelihood.LIKELY,  # 'B'
        46: SequenceLikelihood.LIKELY,  # 'C'
        36: SequenceLikelihood.LIKELY,  # 'D'
        32: SequenceLikelihood.LIKELY,  # 'E'
        40: SequenceLikelihood.LIKELY,  # 'F'
        44: SequenceLikelihood.LIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        29: SequenceLikelihood.LIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        33: SequenceLikelihood.LIKELY,  # 'K'
        37: SequenceLikelihood.LIKELY,  # 'L'
        30: SequenceLikelihood.LIKELY,  # 'M'
        45: SequenceLikelihood.LIKELY,  # 'N'
        48: SequenceLikelihood.UNLIKELY,  # 'O'
        35: SequenceLikelihood.LIKELY,  # 'P'
        53: SequenceLikelihood.UNLIKELY,  # 'Q'
        42: SequenceLikelihood.LIKELY,  # 'R'
        34: SequenceLikelihood.LIKELY,  # 'S'
        38: SequenceLikelihood.LIKELY,  # 'T'
        39: SequenceLikelihood.UNLIKELY,  # 'U'
        52: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        60: SequenceLikelihood.UNLIKELY,  # 'Y'
        59: SequenceLikelihood.LIKELY,  # 'Z'
        2: SequenceLikelihood.UNLIKELY,  # 'a'
        17: SequenceLikelihood.LIKELY,  # 'b'
        41: SequenceLikelihood.LIKELY,  # 'c'
        14: SequenceLikelihood.LIKELY,  # 'd'
        5: SequenceLikelihood.UNLIKELY,  # 'e'
        19: SequenceLikelihood.LIKELY,  # 'f'
        18: SequenceLikelihood.LIKELY,  # 'g'
        23: SequenceLikelihood.UNLIKELY,  # 'h'
        1: SequenceLikelihood.LIKELY,  # 'i'
        11: SequenceLikelihood.UNLIKELY,  # 'j'
        13: SequenceLikelihood.LIKELY,  # 'k'
        4: SequenceLikelihood.POSITIVE,  # 'l'
        12: SequenceLikelihood.LIKELY,  # 'm'
        6: SequenceLikelihood.POSITIVE,  # 'n'
        9: SequenceLikelihood.UNLIKELY,  # 'o'
        16: SequenceLikelihood.POSITIVE,  # 'p'
        26: SequenceLikelihood.LIKELY,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        10: SequenceLikelihood.LIKELY,  # 's'
        3: SequenceLikelihood.LIKELY,  # 't'
        8: SequenceLikelihood.LIKELY,  # 'u'
        27: SequenceLikelihood.LIKELY,  # 'v'
        21: SequenceLikelihood.POSITIVE,  # 'w'
        25: SequenceLikelihood.UNLIKELY,  # 'x'
        51: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.LIKELY,  # 'z'
        57: SequenceLikelihood.UNLIKELY,  # 'Ċ'
        28: SequenceLikelihood.UNLIKELY,  # 'ċ'
        49: SequenceLikelihood.UNLIKELY,  # 'Ġ'
        22: SequenceLikelihood.LIKELY,  # 'ġ'
        55: SequenceLikelihood.UNLIKELY,  # 'Ħ'
        15: SequenceLikelihood.POSITIVE,  # 'ħ'
        58: SequenceLikelihood.UNLIKELY,  # 'Ż'
        24: SequenceLikelihood.UNLIKELY,  # 'ż'
    },
    43: {  # 'B'
        31: SequenceLikelihood.LIKELY,  # 'A'
        43: SequenceLikelihood.LIKELY,  # 'B'
        46: SequenceLikelihood.UNLIKELY,  # 'C'
        36: SequenceLikelihood.UNLIKELY,  # 'D'
        32: SequenceLikelihood.LIKELY,  # 'E'
        40: SequenceLikelihood.UNLIKELY,  # 'F'
        44: SequenceLikelihood.UNLIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        29: SequenceLikelihood.LIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        33: SequenceLikelihood.UNLIKELY,  # 'K'
        37: SequenceLikelihood.UNLIKELY,  # 'L'
        30: SequenceLikelihood.UNLIKELY,  # 'M'
        45: SequenceLikelihood.UNLIKELY,  # 'N'
        48: SequenceLikelihood.UNLIKELY,  # 'O'
        35: SequenceLikelihood.UNLIKELY,  # 'P'
        53: SequenceLikelihood.UNLIKELY,  # 'Q'
        42: SequenceLikelihood.UNLIKELY,  # 'R'
        34: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        39: SequenceLikelihood.UNLIKELY,  # 'U'
        52: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        60: SequenceLikelihood.UNLIKELY,  # 'Y'
        59: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        17: SequenceLikelihood.UNLIKELY,  # 'b'
        41: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.POSITIVE,  # 'e'
        19: SequenceLikelihood.UNLIKELY,  # 'f'
        18: SequenceLikelihood.UNLIKELY,  # 'g'
        23: SequenceLikelihood.UNLIKELY,  # 'h'
        1: SequenceLikelihood.POSITIVE,  # 'i'
        11: SequenceLikelihood.UNLIKELY,  # 'j'
        13: SequenceLikelihood.UNLIKELY,  # 'k'
        4: SequenceLikelihood.LIKELY,  # 'l'
        12: SequenceLikelihood.UNLIKELY,  # 'm'
        6: SequenceLikelihood.LIKELY,  # 'n'
        9: SequenceLikelihood.POSITIVE,  # 'o'
        16: SequenceLikelihood.UNLIKELY,  # 'p'
        26: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.LIKELY,  # 'r'
        10: SequenceLikelihood.UNLIKELY,  # 's'
        3: SequenceLikelihood.UNLIKELY,  # 't'
        8: SequenceLikelihood.LIKELY,  # 'u'
        27: SequenceLikelihood.UNLIKELY,  # 'v'
        21: SequenceLikelihood.UNLIKELY,  # 'w'
        25: SequenceLikelihood.UNLIKELY,  # 'x'
        51: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        57: SequenceLikelihood.LIKELY,  # 'Ċ'
        28: SequenceLikelihood.UNLIKELY,  # 'ċ'
        49: SequenceLikelihood.UNLIKELY,  # 'Ġ'
        22: SequenceLikelihood.UNLIKELY,  # 'ġ'
        55: SequenceLikelihood.UNLIKELY,  # 'Ħ'
        15: SequenceLikelihood.LIKELY,  # 'ħ'
        58: SequenceLikelihood.UNLIKELY,  # 'Ż'
        24: SequenceLikelihood.UNLIKELY,  # 'ż'
    },
    46: {  # 'C'
        31: SequenceLikelihood.LIKELY,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        46: SequenceLikelihood.LIKELY,  # 'C'
        36: SequenceLikelihood.LIKELY,  # 'D'
        32: SequenceLikelihood.LIKELY,  # 'E'
        40: SequenceLikelihood.UNLIKELY,  # 'F'
        44: SequenceLikelihood.UNLIKELY,  # 'G'
        50: SequenceLikelihood.LIKELY,  # 'H'
        29: SequenceLikelihood.LIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        33: SequenceLikelihood.UNLIKELY,  # 'K'
        37: SequenceLikelihood.UNLIKELY,  # 'L'
        30: SequenceLikelihood.UNLIKELY,  # 'M'
        45: SequenceLikelihood.UNLIKELY,  # 'N'
        48: SequenceLikelihood.LIKELY,  # 'O'
        35: SequenceLikelihood.LIKELY,  # 'P'
        53: SequenceLikelihood.UNLIKELY,  # 'Q'
        42: SequenceLikelihood.LIKELY,  # 'R'
        34: SequenceLikelihood.LIKELY,  # 'S'
        38: SequenceLikelihood.LIKELY,  # 'T'
        39: SequenceLikelihood.UNLIKELY,  # 'U'
        52: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        60: SequenceLikelihood.UNLIKELY,  # 'Y'
        59: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        17: SequenceLikelihood.UNLIKELY,  # 'b'
        41: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.LIKELY,  # 'e'
        19: SequenceLikelihood.UNLIKELY,  # 'f'
        18: SequenceLikelihood.UNLIKELY,  # 'g'
        23: SequenceLikelihood.LIKELY,  # 'h'
        1: SequenceLikelihood.LIKELY,  # 'i'
        11: SequenceLikelihood.UNLIKELY,  # 'j'
        13: SequenceLikelihood.UNLIKELY,  # 'k'
        4: SequenceLikelihood.LIKELY,  # 'l'
        12: SequenceLikelihood.UNLIKELY,  # 'm'
        6: SequenceLikelihood.UNLIKELY,  # 'n'
        9: SequenceLikelihood.POSITIVE,  # 'o'
        16: SequenceLikelihood.UNLIKELY,  # 'p'
        26: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.LIKELY,  # 'r'
        10: SequenceLikelihood.UNLIKELY,  # 's'
        3: SequenceLikelihood.UNLIKELY,  # 't'
        8: SequenceLikelihood.LIKELY,  # 'u'
        27: SequenceLikelihood.UNLIKELY,  # 'v'
        21: SequenceLikelihood.UNLIKELY,  # 'w'
        25: SequenceLikelihood.UNLIKELY,  # 'x'
        51: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        57: SequenceLikelihood.NEGATIVE,  # 'Ċ'
        28: SequenceLikelihood.UNLIKELY,  # 'ċ'
        49: SequenceLikelihood.NEGATIVE,  # 'Ġ'
        22: SequenceLikelihood.NEGATIVE,  # 'ġ'
        55: SequenceLikelihood.NEGATIVE,  # 'Ħ'
        15: SequenceLikelihood.UNLIKELY,  # 'ħ'
        58: SequenceLikelihood.NEGATIVE,  # 'Ż'
        24: SequenceLikelihood.NEGATIVE,  # 'ż'
    },
    36: {  # 'D'
        31: SequenceLikelihood.LIKELY,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        46: SequenceLikelihood.LIKELY,  # 'C'
        36: SequenceLikelihood.UNLIKELY,  # 'D'
        32: SequenceLikelihood.LIKELY,  # 'E'
        40: SequenceLikelihood.UNLIKELY,  # 'F'
        44: SequenceLikelihood.LIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        29: SequenceLikelihood.LIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        33: SequenceLikelihood.UNLIKELY,  # 'K'
        37: SequenceLikelihood.UNLIKELY,  # 'L'
        30: SequenceLikelihood.UNLIKELY,  # 'M'
        45: SequenceLikelihood.UNLIKELY,  # 'N'
        48: SequenceLikelihood.UNLIKELY,  # 'O'
        35: SequenceLikelihood.LIKELY,  # 'P'
        53: SequenceLikelihood.UNLIKELY,  # 'Q'
        42: SequenceLikelihood.LIKELY,  # 'R'
        34: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        39: SequenceLikelihood.UNLIKELY,  # 'U'
        52: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        60: SequenceLikelihood.UNLIKELY,  # 'Y'
        59: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        17: SequenceLikelihood.UNLIKELY,  # 'b'
        41: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.POSITIVE,  # 'e'
        19: SequenceLikelihood.UNLIKELY,  # 'f'
        18: SequenceLikelihood.UNLIKELY,  # 'g'
        23: SequenceLikelihood.UNLIKELY,  # 'h'
        1: SequenceLikelihood.POSITIVE,  # 'i'
        11: SequenceLikelihood.LIKELY,  # 'j'
        13: SequenceLikelihood.UNLIKELY,  # 'k'
        4: SequenceLikelihood.UNLIKELY,  # 'l'
        12: SequenceLikelihood.UNLIKELY,  # 'm'
        6: SequenceLikelihood.UNLIKELY,  # 'n'
        9: SequenceLikelihood.LIKELY,  # 'o'
        16: SequenceLikelihood.UNLIKELY,  # 'p'
        26: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.LIKELY,  # 'r'
        10: SequenceLikelihood.UNLIKELY,  # 's'
        3: SequenceLikelihood.UNLIKELY,  # 't'
        8: SequenceLikelihood.LIKELY,  # 'u'
        27: SequenceLikelihood.UNLIKELY,  # 'v'
        21: SequenceLikelihood.LIKELY,  # 'w'
        25: SequenceLikelihood.UNLIKELY,  # 'x'
        51: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        57: SequenceLikelihood.UNLIKELY,  # 'Ċ'
        28: SequenceLikelihood.UNLIKELY,  # 'ċ'
        49: SequenceLikelihood.UNLIKELY,  # 'Ġ'
        22: SequenceLikelihood.UNLIKELY,  # 'ġ'
        55: SequenceLikelihood.UNLIKELY,  # 'Ħ'
        15: SequenceLikelihood.UNLIKELY,  # 'ħ'
        58: SequenceLikelihood.UNLIKELY,  # 'Ż'
        24: SequenceLikelihood.NEGATIVE,  # 'ż'
    },
    32: {  # 'E'
        31: SequenceLikelihood.LIKELY,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        46: SequenceLikelihood.LIKELY,  # 'C'
        36: SequenceLikelihood.LIKELY,  # 'D'
        32: SequenceLikelihood.LIKELY,  # 'E'
        40: SequenceLikelihood.LIKELY,  # 'F'
        44: SequenceLikelihood.LIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        29: SequenceLikelihood.LIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        33: SequenceLikelihood.UNLIKELY,  # 'K'
        37: SequenceLikelihood.LIKELY,  # 'L'
        30: SequenceLikelihood.LIKELY,  # 'M'
        45: SequenceLikelihood.LIKELY,  # 'N'
        48: SequenceLikelihood.LIKELY,  # 'O'
        35: SequenceLikelihood.LIKELY,  # 'P'
        53: SequenceLikelihood.UNLIKELY,  # 'Q'
        42: SequenceLikelihood.LIKELY,  # 'R'
        34: SequenceLikelihood.LIKELY,  # 'S'
        38: SequenceLikelihood.LIKELY,  # 'T'
        39: SequenceLikelihood.POSITIVE,  # 'U'
        52: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.LIKELY,  # 'W'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        60: SequenceLikelihood.UNLIKELY,  # 'Y'
        59: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.UNLIKELY,  # 'a'
        17: SequenceLikelihood.UNLIKELY,  # 'b'
        41: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.LIKELY,  # 'd'
        5: SequenceLikelihood.UNLIKELY,  # 'e'
        19: SequenceLikelihood.LIKELY,  # 'f'
        18: SequenceLikelihood.UNLIKELY,  # 'g'
        23: SequenceLikelihood.UNLIKELY,  # 'h'
        1: SequenceLikelihood.UNLIKELY,  # 'i'
        11: SequenceLikelihood.LIKELY,  # 'j'
        13: SequenceLikelihood.LIKELY,  # 'k'
        4: SequenceLikelihood.LIKELY,  # 'l'
        12: SequenceLikelihood.LIKELY,  # 'm'
        6: SequenceLikelihood.LIKELY,  # 'n'
        9: SequenceLikelihood.UNLIKELY,  # 'o'
        16: SequenceLikelihood.UNLIKELY,  # 'p'
        26: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.LIKELY,  # 'r'
        10: SequenceLikelihood.LIKELY,  # 's'
        3: SequenceLikelihood.UNLIKELY,  # 't'
        8: SequenceLikelihood.LIKELY,  # 'u'
        27: SequenceLikelihood.LIKELY,  # 'v'
        21: SequenceLikelihood.POSITIVE,  # 'w'
        25: SequenceLikelihood.LIKELY,  # 'x'
        51: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        57: SequenceLikelihood.UNLIKELY,  # 'Ċ'
        28: SequenceLikelihood.UNLIKELY,  # 'ċ'
        49: SequenceLikelihood.UNLIKELY,  # 'Ġ'
        22: SequenceLikelihood.LIKELY,  # 'ġ'
        55: SequenceLikelihood.UNLIKELY,  # 'Ħ'
        15: SequenceLikelihood.UNLIKELY,  # 'ħ'
        58: SequenceLikelihood.UNLIKELY,  # 'Ż'
        24: SequenceLikelihood.LIKELY,  # 'ż'
    },
    40: {  # 'F'
        31: SequenceLikelihood.LIKELY,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        46: SequenceLikelihood.LIKELY,  # 'C'
        36: SequenceLikelihood.UNLIKELY,  # 'D'
        32: SequenceLikelihood.LIKELY,  # 'E'
        40: SequenceLikelihood.UNLIKELY,  # 'F'
        44: SequenceLikelihood.UNLIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        29: SequenceLikelihood.LIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        33: SequenceLikelihood.UNLIKELY,  # 'K'
        37: SequenceLikelihood.UNLIKELY,  # 'L'
        30: SequenceLikelihood.UNLIKELY,  # 'M'
        45: SequenceLikelihood.UNLIKELY,  # 'N'
        48: SequenceLikelihood.UNLIKELY,  # 'O'
        35: SequenceLikelihood.UNLIKELY,  # 'P'
        53: SequenceLikelihood.UNLIKELY,  # 'Q'
        42: SequenceLikelihood.LIKELY,  # 'R'
        34: SequenceLikelihood.LIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        39: SequenceLikelihood.LIKELY,  # 'U'
        52: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        60: SequenceLikelihood.UNLIKELY,  # 'Y'
        59: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        17: SequenceLikelihood.UNLIKELY,  # 'b'
        41: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.LIKELY,  # 'e'
        19: SequenceLikelihood.UNLIKELY,  # 'f'
        18: SequenceLikelihood.UNLIKELY,  # 'g'
        23: SequenceLikelihood.UNLIKELY,  # 'h'
        1: SequenceLikelihood.POSITIVE,  # 'i'
        11: SequenceLikelihood.UNLIKELY,  # 'j'
        13: SequenceLikelihood.UNLIKELY,  # 'k'
        4: SequenceLikelihood.POSITIVE,  # 'l'
        12: SequenceLikelihood.UNLIKELY,  # 'm'
        6: SequenceLikelihood.UNLIKELY,  # 'n'
        9: SequenceLikelihood.POSITIVE,  # 'o'
        16: SequenceLikelihood.UNLIKELY,  # 'p'
        26: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        10: SequenceLikelihood.UNLIKELY,  # 's'
        3: SequenceLikelihood.LIKELY,  # 't'
        8: SequenceLikelihood.LIKELY,  # 'u'
        27: SequenceLikelihood.UNLIKELY,  # 'v'
        21: SequenceLikelihood.UNLIKELY,  # 'w'
        25: SequenceLikelihood.UNLIKELY,  # 'x'
        51: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        57: SequenceLikelihood.UNLIKELY,  # 'Ċ'
        28: SequenceLikelihood.NEGATIVE,  # 'ċ'
        49: SequenceLikelihood.UNLIKELY,  # 'Ġ'
        22: SequenceLikelihood.UNLIKELY,  # 'ġ'
        55: SequenceLikelihood.UNLIKELY,  # 'Ħ'
        15: SequenceLikelihood.UNLIKELY,  # 'ħ'
        58: SequenceLikelihood.UNLIKELY,  # 'Ż'
        24: SequenceLikelihood.UNLIKELY,  # 'ż'
    },
    44: {  # 'G'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        43: SequenceLikelihood.LIKELY,  # 'B'
        46: SequenceLikelihood.UNLIKELY,  # 'C'
        36: SequenceLikelihood.UNLIKELY,  # 'D'
        32: SequenceLikelihood.UNLIKELY,  # 'E'
        40: SequenceLikelihood.UNLIKELY,  # 'F'
        44: SequenceLikelihood.UNLIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        29: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        33: SequenceLikelihood.UNLIKELY,  # 'K'
        37: SequenceLikelihood.UNLIKELY,  # 'L'
        30: SequenceLikelihood.UNLIKELY,  # 'M'
        45: SequenceLikelihood.UNLIKELY,  # 'N'
        48: SequenceLikelihood.LIKELY,  # 'O'
        35: SequenceLikelihood.UNLIKELY,  # 'P'
        53: SequenceLikelihood.UNLIKELY,  # 'Q'
        42: SequenceLikelihood.UNLIKELY,  # 'R'
        34: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        39: SequenceLikelihood.UNLIKELY,  # 'U'
        52: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        60: SequenceLikelihood.UNLIKELY,  # 'Y'
        59: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.LIKELY,  # 'a'
        17: SequenceLikelihood.UNLIKELY,  # 'b'
        41: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.LIKELY,  # 'e'
        19: SequenceLikelihood.UNLIKELY,  # 'f'
        18: SequenceLikelihood.UNLIKELY,  # 'g'
        23: SequenceLikelihood.UNLIKELY,  # 'h'
        1: SequenceLikelihood.LIKELY,  # 'i'
        11: SequenceLikelihood.UNLIKELY,  # 'j'
        13: SequenceLikelihood.UNLIKELY,  # 'k'
        4: SequenceLikelihood.LIKELY,  # 'l'
        12: SequenceLikelihood.UNLIKELY,  # 'm'
        6: SequenceLikelihood.UNLIKELY,  # 'n'
        9: SequenceLikelihood.LIKELY,  # 'o'
        16: SequenceLikelihood.UNLIKELY,  # 'p'
        26: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        10: SequenceLikelihood.UNLIKELY,  # 's'
        3: SequenceLikelihood.UNLIKELY,  # 't'
        8: SequenceLikelihood.LIKELY,  # 'u'
        27: SequenceLikelihood.POSITIVE,  # 'v'
        21: SequenceLikelihood.LIKELY,  # 'w'
        25: SequenceLikelihood.UNLIKELY,  # 'x'
        51: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        57: SequenceLikelihood.NEGATIVE,  # 'Ċ'
        28: SequenceLikelihood.NEGATIVE,  # 'ċ'
        49: SequenceLikelihood.NEGATIVE,  # 'Ġ'
        22: SequenceLikelihood.UNLIKELY,  # 'ġ'
        55: SequenceLikelihood.LIKELY,  # 'Ħ'
        15: SequenceLikelihood.POSITIVE,  # 'ħ'
        58: SequenceLikelihood.UNLIKELY,  # 'Ż'
        24: SequenceLikelihood.UNLIKELY,  # 'ż'
    },
    50: {  # 'H'
        31: SequenceLikelihood.LIKELY,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        46: SequenceLikelihood.UNLIKELY,  # 'C'
        36: SequenceLikelihood.UNLIKELY,  # 'D'
        32: SequenceLikelihood.UNLIKELY,  # 'E'
        40: SequenceLikelihood.UNLIKELY,  # 'F'
        44: SequenceLikelihood.UNLIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        29: SequenceLikelihood.LIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        33: SequenceLikelihood.UNLIKELY,  # 'K'
        37: SequenceLikelihood.UNLIKELY,  # 'L'
        30: SequenceLikelihood.UNLIKELY,  # 'M'
        45: SequenceLikelihood.UNLIKELY,  # 'N'
        48: SequenceLikelihood.UNLIKELY,  # 'O'
        35: SequenceLikelihood.UNLIKELY,  # 'P'
        53: SequenceLikelihood.UNLIKELY,  # 'Q'
        42: SequenceLikelihood.UNLIKELY,  # 'R'
        34: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        39: SequenceLikelihood.UNLIKELY,  # 'U'
        52: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        60: SequenceLikelihood.UNLIKELY,  # 'Y'
        59: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.LIKELY,  # 'a'
        17: SequenceLikelihood.UNLIKELY,  # 'b'
        41: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.POSITIVE,  # 'e'
        19: SequenceLikelihood.UNLIKELY,  # 'f'
        18: SequenceLikelihood.UNLIKELY,  # 'g'
        23: SequenceLikelihood.UNLIKELY,  # 'h'
        1: SequenceLikelihood.LIKELY,  # 'i'
        11: SequenceLikelihood.UNLIKELY,  # 'j'
        13: SequenceLikelihood.UNLIKELY,  # 'k'
        4: SequenceLikelihood.UNLIKELY,  # 'l'
        12: SequenceLikelihood.UNLIKELY,  # 'm'
        6: SequenceLikelihood.UNLIKELY,  # 'n'
        9: SequenceLikelihood.LIKELY,  # 'o'
        16: SequenceLikelihood.UNLIKELY,  # 'p'
        26: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        10: SequenceLikelihood.UNLIKELY,  # 's'
        3: SequenceLikelihood.UNLIKELY,  # 't'
        8: SequenceLikelihood.POSITIVE,  # 'u'
        27: SequenceLikelihood.UNLIKELY,  # 'v'
        21: SequenceLikelihood.UNLIKELY,  # 'w'
        25: SequenceLikelihood.UNLIKELY,  # 'x'
        51: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        57: SequenceLikelihood.NEGATIVE,  # 'Ċ'
        28: SequenceLikelihood.NEGATIVE,  # 'ċ'
        49: SequenceLikelihood.NEGATIVE,  # 'Ġ'
        22: SequenceLikelihood.NEGATIVE,  # 'ġ'
        55: SequenceLikelihood.NEGATIVE,  # 'Ħ'
        15: SequenceLikelihood.NEGATIVE,  # 'ħ'
        58: SequenceLikelihood.NEGATIVE,  # 'Ż'
        24: SequenceLikelihood.UNLIKELY,  # 'ż'
    },
    29: {  # 'I'
        31: SequenceLikelihood.LIKELY,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        46: SequenceLikelihood.LIKELY,  # 'C'
        36: SequenceLikelihood.LIKELY,  # 'D'
        32: SequenceLikelihood.LIKELY,  # 'E'
        40: SequenceLikelihood.LIKELY,  # 'F'
        44: SequenceLikelihood.UNLIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        29: SequenceLikelihood.LIKELY,  # 'I'
        47: SequenceLikelihood.LIKELY,  # 'J'
        33: SequenceLikelihood.LIKELY,  # 'K'
        37: SequenceLikelihood.LIKELY,  # 'L'
        30: SequenceLikelihood.LIKELY,  # 'M'
        45: SequenceLikelihood.LIKELY,  # 'N'
        48: SequenceLikelihood.LIKELY,  # 'O'
        35: SequenceLikelihood.LIKELY,  # 'P'
        53: SequenceLikelihood.UNLIKELY,  # 'Q'
        42: SequenceLikelihood.LIKELY,  # 'R'
        34: SequenceLikelihood.LIKELY,  # 'S'
        38: SequenceLikelihood.LIKELY,  # 'T'
        39: SequenceLikelihood.UNLIKELY,  # 'U'
        52: SequenceLikelihood.LIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        60: SequenceLikelihood.UNLIKELY,  # 'Y'
        59: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.UNLIKELY,  # 'a'
        17: SequenceLikelihood.LIKELY,  # 'b'
        41: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.POSITIVE,  # 'd'
        5: SequenceLikelihood.UNLIKELY,  # 'e'
        19: SequenceLikelihood.LIKELY,  # 'f'
        18: SequenceLikelihood.UNLIKELY,  # 'g'
        23: SequenceLikelihood.UNLIKELY,  # 'h'
        1: SequenceLikelihood.UNLIKELY,  # 'i'
        11: SequenceLikelihood.UNLIKELY,  # 'j'
        13: SequenceLikelihood.LIKELY,  # 'k'
        4: SequenceLikelihood.POSITIVE,  # 'l'
        12: SequenceLikelihood.POSITIVE,  # 'm'
        6: SequenceLikelihood.POSITIVE,  # 'n'
        9: SequenceLikelihood.UNLIKELY,  # 'o'
        16: SequenceLikelihood.LIKELY,  # 'p'
        26: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        10: SequenceLikelihood.POSITIVE,  # 's'
        3: SequenceLikelihood.POSITIVE,  # 't'
        8: SequenceLikelihood.UNLIKELY,  # 'u'
        27: SequenceLikelihood.LIKELY,  # 'v'
        21: SequenceLikelihood.UNLIKELY,  # 'w'
        25: SequenceLikelihood.LIKELY,  # 'x'
        51: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        57: SequenceLikelihood.UNLIKELY,  # 'Ċ'
        28: SequenceLikelihood.LIKELY,  # 'ċ'
        49: SequenceLikelihood.UNLIKELY,  # 'Ġ'
        22: SequenceLikelihood.UNLIKELY,  # 'ġ'
        55: SequenceLikelihood.UNLIKELY,  # 'Ħ'
        15: SequenceLikelihood.LIKELY,  # 'ħ'
        58: SequenceLikelihood.UNLIKELY,  # 'Ż'
        24: SequenceLikelihood.POSITIVE,  # 'ż'
    },
    47: {  # 'J'
        31: SequenceLikelihood.LIKELY,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        46: SequenceLikelihood.UNLIKELY,  # 'C'
        36: SequenceLikelihood.UNLIKELY,  # 'D'
        32: SequenceLikelihood.UNLIKELY,  # 'E'
        40: SequenceLikelihood.UNLIKELY,  # 'F'
        44: SequenceLikelihood.UNLIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        29: SequenceLikelihood.LIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        33: SequenceLikelihood.UNLIKELY,  # 'K'
        37: SequenceLikelihood.UNLIKELY,  # 'L'
        30: SequenceLikelihood.UNLIKELY,  # 'M'
        45: SequenceLikelihood.UNLIKELY,  # 'N'
        48: SequenceLikelihood.LIKELY,  # 'O'
        35: SequenceLikelihood.UNLIKELY,  # 'P'
        53: SequenceLikelihood.UNLIKELY,  # 'Q'
        42: SequenceLikelihood.UNLIKELY,  # 'R'
        34: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        39: SequenceLikelihood.UNLIKELY,  # 'U'
        52: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        60: SequenceLikelihood.UNLIKELY,  # 'Y'
        59: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        17: SequenceLikelihood.UNLIKELY,  # 'b'
        41: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.POSITIVE,  # 'e'
        19: SequenceLikelihood.UNLIKELY,  # 'f'
        18: SequenceLikelihood.UNLIKELY,  # 'g'
        23: SequenceLikelihood.UNLIKELY,  # 'h'
        1: SequenceLikelihood.POSITIVE,  # 'i'
        11: SequenceLikelihood.UNLIKELY,  # 'j'
        13: SequenceLikelihood.UNLIKELY,  # 'k'
        4: SequenceLikelihood.UNLIKELY,  # 'l'
        12: SequenceLikelihood.LIKELY,  # 'm'
        6: SequenceLikelihood.UNLIKELY,  # 'n'
        9: SequenceLikelihood.LIKELY,  # 'o'
        16: SequenceLikelihood.UNLIKELY,  # 'p'
        26: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        10: SequenceLikelihood.UNLIKELY,  # 's'
        3: SequenceLikelihood.UNLIKELY,  # 't'
        8: SequenceLikelihood.LIKELY,  # 'u'
        27: SequenceLikelihood.UNLIKELY,  # 'v'
        21: SequenceLikelihood.UNLIKELY,  # 'w'
        25: SequenceLikelihood.UNLIKELY,  # 'x'
        51: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        57: SequenceLikelihood.UNLIKELY,  # 'Ċ'
        28: SequenceLikelihood.UNLIKELY,  # 'ċ'
        49: SequenceLikelihood.UNLIKELY,  # 'Ġ'
        22: SequenceLikelihood.UNLIKELY,  # 'ġ'
        55: SequenceLikelihood.UNLIKELY,  # 'Ħ'
        15: SequenceLikelihood.UNLIKELY,  # 'ħ'
        58: SequenceLikelihood.UNLIKELY,  # 'Ż'
        24: SequenceLikelihood.UNLIKELY,  # 'ż'
    },
    33: {  # 'K'
        31: SequenceLikelihood.LIKELY,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        46: SequenceLikelihood.UNLIKELY,  # 'C'
        36: SequenceLikelihood.UNLIKELY,  # 'D'
        32: SequenceLikelihood.POSITIVE,  # 'E'
        40: SequenceLikelihood.UNLIKELY,  # 'F'
        44: SequenceLikelihood.UNLIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        29: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        33: SequenceLikelihood.UNLIKELY,  # 'K'
        37: SequenceLikelihood.UNLIKELY,  # 'L'
        30: SequenceLikelihood.UNLIKELY,  # 'M'
        45: SequenceLikelihood.UNLIKELY,  # 'N'
        48: SequenceLikelihood.LIKELY,  # 'O'
        35: SequenceLikelihood.UNLIKELY,  # 'P'
        53: SequenceLikelihood.UNLIKELY,  # 'Q'
        42: SequenceLikelihood.UNLIKELY,  # 'R'
        34: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        39: SequenceLikelihood.LIKELY,  # 'U'
        52: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        60: SequenceLikelihood.UNLIKELY,  # 'Y'
        59: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        17: SequenceLikelihood.LIKELY,  # 'b'
        41: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.LIKELY,  # 'e'
        19: SequenceLikelihood.UNLIKELY,  # 'f'
        18: SequenceLikelihood.UNLIKELY,  # 'g'
        23: SequenceLikelihood.UNLIKELY,  # 'h'
        1: SequenceLikelihood.POSITIVE,  # 'i'
        11: SequenceLikelihood.UNLIKELY,  # 'j'
        13: SequenceLikelihood.UNLIKELY,  # 'k'
        4: SequenceLikelihood.LIKELY,  # 'l'
        12: SequenceLikelihood.UNLIKELY,  # 'm'
        6: SequenceLikelihood.LIKELY,  # 'n'
        9: SequenceLikelihood.POSITIVE,  # 'o'
        16: SequenceLikelihood.UNLIKELY,  # 'p'
        26: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.LIKELY,  # 'r'
        10: SequenceLikelihood.UNLIKELY,  # 's'
        3: SequenceLikelihood.UNLIKELY,  # 't'
        8: SequenceLikelihood.POSITIVE,  # 'u'
        27: SequenceLikelihood.UNLIKELY,  # 'v'
        21: SequenceLikelihood.LIKELY,  # 'w'
        25: SequenceLikelihood.UNLIKELY,  # 'x'
        51: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        57: SequenceLikelihood.UNLIKELY,  # 'Ċ'
        28: SequenceLikelihood.UNLIKELY,  # 'ċ'
        49: SequenceLikelihood.UNLIKELY,  # 'Ġ'
        22: SequenceLikelihood.NEGATIVE,  # 'ġ'
        55: SequenceLikelihood.UNLIKELY,  # 'Ħ'
        15: SequenceLikelihood.NEGATIVE,  # 'ħ'
        58: SequenceLikelihood.UNLIKELY,  # 'Ż'
        24: SequenceLikelihood.UNLIKELY,  # 'ż'
    },
    37: {  # 'L'
        31: SequenceLikelihood.LIKELY,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        46: SequenceLikelihood.UNLIKELY,  # 'C'
        36: SequenceLikelihood.UNLIKELY,  # 'D'
        32: SequenceLikelihood.LIKELY,  # 'E'
        40: SequenceLikelihood.UNLIKELY,  # 'F'
        44: SequenceLikelihood.UNLIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        29: SequenceLikelihood.LIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        33: SequenceLikelihood.UNLIKELY,  # 'K'
        37: SequenceLikelihood.LIKELY,  # 'L'
        30: SequenceLikelihood.UNLIKELY,  # 'M'
        45: SequenceLikelihood.UNLIKELY,  # 'N'
        48: SequenceLikelihood.UNLIKELY,  # 'O'
        35: SequenceLikelihood.UNLIKELY,  # 'P'
        53: SequenceLikelihood.UNLIKELY,  # 'Q'
        42: SequenceLikelihood.UNLIKELY,  # 'R'
        34: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.LIKELY,  # 'T'
        39: SequenceLikelihood.LIKELY,  # 'U'
        52: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        60: SequenceLikelihood.UNLIKELY,  # 'Y'
        59: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        17: SequenceLikelihood.UNLIKELY,  # 'b'
        41: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.LIKELY,  # 'e'
        19: SequenceLikelihood.UNLIKELY,  # 'f'
        18: SequenceLikelihood.UNLIKELY,  # 'g'
        23: SequenceLikelihood.UNLIKELY,  # 'h'
        1: SequenceLikelihood.POSITIVE,  # 'i'
        11: SequenceLikelihood.UNLIKELY,  # 'j'
        13: SequenceLikelihood.UNLIKELY,  # 'k'
        4: SequenceLikelihood.UNLIKELY,  # 'l'
        12: SequenceLikelihood.UNLIKELY,  # 'm'
        6: SequenceLikelihood.UNLIKELY,  # 'n'
        9: SequenceLikelihood.LIKELY,  # 'o'
        16: SequenceLikelihood.UNLIKELY,  # 'p'
        26: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        10: SequenceLikelihood.UNLIKELY,  # 's'
        3: SequenceLikelihood.UNLIKELY,  # 't'
        8: SequenceLikelihood.LIKELY,  # 'u'
        27: SequenceLikelihood.LIKELY,  # 'v'
        21: SequenceLikelihood.UNLIKELY,  # 'w'
        25: SequenceLikelihood.UNLIKELY,  # 'x'
        51: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        57: SequenceLikelihood.UNLIKELY,  # 'Ċ'
        28: SequenceLikelihood.UNLIKELY,  # 'ċ'
        49: SequenceLikelihood.UNLIKELY,  # 'Ġ'
        22: SequenceLikelihood.NEGATIVE,  # 'ġ'
        55: SequenceLikelihood.UNLIKELY,  # 'Ħ'
        15: SequenceLikelihood.UNLIKELY,  # 'ħ'
        58: SequenceLikelihood.NEGATIVE,  # 'Ż'
        24: SequenceLikelihood.NEGATIVE,  # 'ż'
    },
    30: {  # 'M'
        31: SequenceLikelihood.LIKELY,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        46: SequenceLikelihood.LIKELY,  # 'C'
        36: SequenceLikelihood.UNLIKELY,  # 'D'
        32: SequenceLikelihood.LIKELY,  # 'E'
        40: SequenceLikelihood.LIKELY,  # 'F'
        44: SequenceLikelihood.UNLIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        29: SequenceLikelihood.LIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        33: SequenceLikelihood.UNLIKELY,  # 'K'
        37: SequenceLikelihood.UNLIKELY,  # 'L'
        30: SequenceLikelihood.LIKELY,  # 'M'
        45: SequenceLikelihood.UNLIKELY,  # 'N'
        48: SequenceLikelihood.LIKELY,  # 'O'
        35: SequenceLikelihood.LIKELY,  # 'P'
        53: SequenceLikelihood.UNLIKELY,  # 'Q'
        42: SequenceLikelihood.UNLIKELY,  # 'R'
        34: SequenceLikelihood.LIKELY,  # 'S'
        38: SequenceLikelihood.LIKELY,  # 'T'
        39: SequenceLikelihood.LIKELY,  # 'U'
        52: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        60: SequenceLikelihood.UNLIKELY,  # 'Y'
        59: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        17: SequenceLikelihood.UNLIKELY,  # 'b'
        41: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.POSITIVE,  # 'e'
        19: SequenceLikelihood.UNLIKELY,  # 'f'
        18: SequenceLikelihood.UNLIKELY,  # 'g'
        23: SequenceLikelihood.LIKELY,  # 'h'
        1: SequenceLikelihood.POSITIVE,  # 'i'
        11: SequenceLikelihood.UNLIKELY,  # 'j'
        13: SequenceLikelihood.UNLIKELY,  # 'k'
        4: SequenceLikelihood.UNLIKELY,  # 'l'
        12: SequenceLikelihood.UNLIKELY,  # 'm'
        6: SequenceLikelihood.UNLIKELY,  # 'n'
        9: SequenceLikelihood.POSITIVE,  # 'o'
        16: SequenceLikelihood.UNLIKELY,  # 'p'
        26: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        10: SequenceLikelihood.UNLIKELY,  # 's'
        3: SequenceLikelihood.UNLIKELY,  # 't'
        8: SequenceLikelihood.LIKELY,  # 'u'
        27: SequenceLikelihood.UNLIKELY,  # 'v'
        21: SequenceLikelihood.UNLIKELY,  # 'w'
        25: SequenceLikelihood.UNLIKELY,  # 'x'
        51: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        57: SequenceLikelihood.UNLIKELY,  # 'Ċ'
        28: SequenceLikelihood.UNLIKELY,  # 'ċ'
        49: SequenceLikelihood.UNLIKELY,  # 'Ġ'
        22: SequenceLikelihood.UNLIKELY,  # 'ġ'
        55: SequenceLikelihood.UNLIKELY,  # 'Ħ'
        15: SequenceLikelihood.UNLIKELY,  # 'ħ'
        58: SequenceLikelihood.UNLIKELY,  # 'Ż'
        24: SequenceLikelihood.UNLIKELY,  # 'ż'
    },
    45: {  # 'N'
        31: SequenceLikelihood.LIKELY,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        46: SequenceLikelihood.LIKELY,  # 'C'
        36: SequenceLikelihood.LIKELY,  # 'D'
        32: SequenceLikelihood.LIKELY,  # 'E'
        40: SequenceLikelihood.UNLIKELY,  # 'F'
        44: SequenceLikelihood.LIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        29: SequenceLikelihood.LIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        33: SequenceLikelihood.UNLIKELY,  # 'K'
        37: SequenceLikelihood.UNLIKELY,  # 'L'
        30: SequenceLikelihood.UNLIKELY,  # 'M'
        45: SequenceLikelihood.UNLIKELY,  # 'N'
        48: SequenceLikelihood.LIKELY,  # 'O'
        35: SequenceLikelihood.UNLIKELY,  # 'P'
        53: SequenceLikelihood.UNLIKELY,  # 'Q'
        42: SequenceLikelihood.UNLIKELY,  # 'R'
        34: SequenceLikelihood.LIKELY,  # 'S'
        38: SequenceLikelihood.LIKELY,  # 'T'
        39: SequenceLikelihood.LIKELY,  # 'U'
        52: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        60: SequenceLikelihood.UNLIKELY,  # 'Y'
        59: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        17: SequenceLikelihood.UNLIKELY,  # 'b'
        41: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.POSITIVE,  # 'e'
        19: SequenceLikelihood.UNLIKELY,  # 'f'
        18: SequenceLikelihood.UNLIKELY,  # 'g'
        23: SequenceLikelihood.LIKELY,  # 'h'
        1: SequenceLikelihood.POSITIVE,  # 'i'
        11: SequenceLikelihood.UNLIKELY,  # 'j'
        13: SequenceLikelihood.UNLIKELY,  # 'k'
        4: SequenceLikelihood.UNLIKELY,  # 'l'
        12: SequenceLikelihood.UNLIKELY,  # 'm'
        6: SequenceLikelihood.UNLIKELY,  # 'n'
        9: SequenceLikelihood.POSITIVE,  # 'o'
        16: SequenceLikelihood.UNLIKELY,  # 'p'
        26: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        10: SequenceLikelihood.UNLIKELY,  # 's'
        3: SequenceLikelihood.UNLIKELY,  # 't'
        8: SequenceLikelihood.LIKELY,  # 'u'
        27: SequenceLikelihood.UNLIKELY,  # 'v'
        21: SequenceLikelihood.UNLIKELY,  # 'w'
        25: SequenceLikelihood.UNLIKELY,  # 'x'
        51: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        57: SequenceLikelihood.UNLIKELY,  # 'Ċ'
        28: SequenceLikelihood.UNLIKELY,  # 'ċ'
        49: SequenceLikelihood.UNLIKELY,  # 'Ġ'
        22: SequenceLikelihood.UNLIKELY,  # 'ġ'
        55: SequenceLikelihood.UNLIKELY,  # 'Ħ'
        15: SequenceLikelihood.UNLIKELY,  # 'ħ'
        58: SequenceLikelihood.UNLIKELY,  # 'Ż'
        24: SequenceLikelihood.UNLIKELY,  # 'ż'
    },
    48: {  # 'O'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        46: SequenceLikelihood.UNLIKELY,  # 'C'
        36: SequenceLikelihood.LIKELY,  # 'D'
        32: SequenceLikelihood.UNLIKELY,  # 'E'
        40: SequenceLikelihood.UNLIKELY,  # 'F'
        44: SequenceLikelihood.UNLIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        29: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        33: SequenceLikelihood.UNLIKELY,  # 'K'
        37: SequenceLikelihood.LIKELY,  # 'L'
        30: SequenceLikelihood.LIKELY,  # 'M'
        45: SequenceLikelihood.LIKELY,  # 'N'
        48: SequenceLikelihood.UNLIKELY,  # 'O'
        35: SequenceLikelihood.LIKELY,  # 'P'
        53: SequenceLikelihood.UNLIKELY,  # 'Q'
        42: SequenceLikelihood.LIKELY,  # 'R'
        34: SequenceLikelihood.LIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        39: SequenceLikelihood.UNLIKELY,  # 'U'
        52: SequenceLikelihood.LIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        60: SequenceLikelihood.UNLIKELY,  # 'Y'
        59: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.UNLIKELY,  # 'a'
        17: SequenceLikelihood.UNLIKELY,  # 'b'
        41: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.UNLIKELY,  # 'e'
        19: SequenceLikelihood.UNLIKELY,  # 'f'
        18: SequenceLikelihood.UNLIKELY,  # 'g'
        23: SequenceLikelihood.UNLIKELY,  # 'h'
        1: SequenceLikelihood.UNLIKELY,  # 'i'
        11: SequenceLikelihood.UNLIKELY,  # 'j'
        13: SequenceLikelihood.UNLIKELY,  # 'k'
        4: SequenceLikelihood.LIKELY,  # 'l'
        12: SequenceLikelihood.LIKELY,  # 'm'
        6: SequenceLikelihood.LIKELY,  # 'n'
        9: SequenceLikelihood.UNLIKELY,  # 'o'
        16: SequenceLikelihood.LIKELY,  # 'p'
        26: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.LIKELY,  # 'r'
        10: SequenceLikelihood.LIKELY,  # 's'
        3: SequenceLikelihood.LIKELY,  # 't'
        8: SequenceLikelihood.UNLIKELY,  # 'u'
        27: SequenceLikelihood.UNLIKELY,  # 'v'
        21: SequenceLikelihood.UNLIKELY,  # 'w'
        25: SequenceLikelihood.UNLIKELY,  # 'x'
        51: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        57: SequenceLikelihood.UNLIKELY,  # 'Ċ'
        28: SequenceLikelihood.UNLIKELY,  # 'ċ'
        49: SequenceLikelihood.UNLIKELY,  # 'Ġ'
        22: SequenceLikelihood.UNLIKELY,  # 'ġ'
        55: SequenceLikelihood.UNLIKELY,  # 'Ħ'
        15: SequenceLikelihood.LIKELY,  # 'ħ'
        58: SequenceLikelihood.UNLIKELY,  # 'Ż'
        24: SequenceLikelihood.UNLIKELY,  # 'ż'
    },
    35: {  # 'P'
        31: SequenceLikelihood.LIKELY,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        46: SequenceLikelihood.LIKELY,  # 'C'
        36: SequenceLikelihood.LIKELY,  # 'D'
        32: SequenceLikelihood.LIKELY,  # 'E'
        40: SequenceLikelihood.UNLIKELY,  # 'F'
        44: SequenceLikelihood.UNLIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        29: SequenceLikelihood.LIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        33: SequenceLikelihood.UNLIKELY,  # 'K'
        37: SequenceLikelihood.LIKELY,  # 'L'
        30: SequenceLikelihood.LIKELY,  # 'M'
        45: SequenceLikelihood.LIKELY,  # 'N'
        48: SequenceLikelihood.LIKELY,  # 'O'
        35: SequenceLikelihood.LIKELY,  # 'P'
        53: SequenceLikelihood.UNLIKELY,  # 'Q'
        42: SequenceLikelihood.LIKELY,  # 'R'
        34: SequenceLikelihood.LIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        39: SequenceLikelihood.UNLIKELY,  # 'U'
        52: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        60: SequenceLikelihood.UNLIKELY,  # 'Y'
        59: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        17: SequenceLikelihood.UNLIKELY,  # 'b'
        41: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.POSITIVE,  # 'e'
        19: SequenceLikelihood.UNLIKELY,  # 'f'
        18: SequenceLikelihood.UNLIKELY,  # 'g'
        23: SequenceLikelihood.LIKELY,  # 'h'
        1: SequenceLikelihood.LIKELY,  # 'i'
        11: SequenceLikelihood.LIKELY,  # 'j'
        13: SequenceLikelihood.UNLIKELY,  # 'k'
        4: SequenceLikelihood.LIKELY,  # 'l'
        12: SequenceLikelihood.UNLIKELY,  # 'm'
        6: SequenceLikelihood.UNLIKELY,  # 'n'
        9: SequenceLikelihood.POSITIVE,  # 'o'
        16: SequenceLikelihood.UNLIKELY,  # 'p'
        26: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        10: SequenceLikelihood.LIKELY,  # 's'
        3: SequenceLikelihood.UNLIKELY,  # 't'
        8: SequenceLikelihood.LIKELY,  # 'u'
        27: SequenceLikelihood.UNLIKELY,  # 'v'
        21: SequenceLikelihood.UNLIKELY,  # 'w'
        25: SequenceLikelihood.UNLIKELY,  # 'x'
        51: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        57: SequenceLikelihood.UNLIKELY,  # 'Ċ'
        28: SequenceLikelihood.NEGATIVE,  # 'ċ'
        49: SequenceLikelihood.UNLIKELY,  # 'Ġ'
        22: SequenceLikelihood.NEGATIVE,  # 'ġ'
        55: SequenceLikelihood.UNLIKELY,  # 'Ħ'
        15: SequenceLikelihood.NEGATIVE,  # 'ħ'
        58: SequenceLikelihood.UNLIKELY,  # 'Ż'
        24: SequenceLikelihood.UNLIKELY,  # 'ż'
    },
    53: {  # 'Q'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        46: SequenceLikelihood.UNLIKELY,  # 'C'
        36: SequenceLikelihood.UNLIKELY,  # 'D'
        32: SequenceLikelihood.UNLIKELY,  # 'E'
        40: SequenceLikelihood.UNLIKELY,  # 'F'
        44: SequenceLikelihood.UNLIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        29: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        33: SequenceLikelihood.UNLIKELY,  # 'K'
        37: SequenceLikelihood.UNLIKELY,  # 'L'
        30: SequenceLikelihood.UNLIKELY,  # 'M'
        45: SequenceLikelihood.UNLIKELY,  # 'N'
        48: SequenceLikelihood.UNLIKELY,  # 'O'
        35: SequenceLikelihood.UNLIKELY,  # 'P'
        53: SequenceLikelihood.UNLIKELY,  # 'Q'
        42: SequenceLikelihood.UNLIKELY,  # 'R'
        34: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        39: SequenceLikelihood.UNLIKELY,  # 'U'
        52: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        60: SequenceLikelihood.UNLIKELY,  # 'Y'
        59: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        17: SequenceLikelihood.UNLIKELY,  # 'b'
        41: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.LIKELY,  # 'e'
        19: SequenceLikelihood.UNLIKELY,  # 'f'
        18: SequenceLikelihood.UNLIKELY,  # 'g'
        23: SequenceLikelihood.UNLIKELY,  # 'h'
        1: SequenceLikelihood.UNLIKELY,  # 'i'
        11: SequenceLikelihood.UNLIKELY,  # 'j'
        13: SequenceLikelihood.NEGATIVE,  # 'k'
        4: SequenceLikelihood.UNLIKELY,  # 'l'
        12: SequenceLikelihood.UNLIKELY,  # 'm'
        6: SequenceLikelihood.UNLIKELY,  # 'n'
        9: SequenceLikelihood.POSITIVE,  # 'o'
        16: SequenceLikelihood.UNLIKELY,  # 'p'
        26: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.LIKELY,  # 'r'
        10: SequenceLikelihood.UNLIKELY,  # 's'
        3: SequenceLikelihood.UNLIKELY,  # 't'
        8: SequenceLikelihood.LIKELY,  # 'u'
        27: SequenceLikelihood.UNLIKELY,  # 'v'
        21: SequenceLikelihood.UNLIKELY,  # 'w'
        25: SequenceLikelihood.UNLIKELY,  # 'x'
        51: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        57: SequenceLikelihood.UNLIKELY,  # 'Ċ'
        28: SequenceLikelihood.UNLIKELY,  # 'ċ'
        49: SequenceLikelihood.UNLIKELY,  # 'Ġ'
        22: SequenceLikelihood.NEGATIVE,  # 'ġ'
        55: SequenceLikelihood.UNLIKELY,  # 'Ħ'
        15: SequenceLikelihood.NEGATIVE,  # 'ħ'
        58: SequenceLikelihood.NEGATIVE,  # 'Ż'
        24: SequenceLikelihood.UNLIKELY,  # 'ż'
    },
    42: {  # 'R'
        31: SequenceLikelihood.LIKELY,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        46: SequenceLikelihood.UNLIKELY,  # 'C'
        36: SequenceLikelihood.UNLIKELY,  # 'D'
        32: SequenceLikelihood.LIKELY,  # 'E'
        40: SequenceLikelihood.UNLIKELY,  # 'F'
        44: SequenceLikelihood.UNLIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        29: SequenceLikelihood.LIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        33: SequenceLikelihood.UNLIKELY,  # 'K'
        37: SequenceLikelihood.UNLIKELY,  # 'L'
        30: SequenceLikelihood.LIKELY,  # 'M'
        45: SequenceLikelihood.UNLIKELY,  # 'N'
        48: SequenceLikelihood.LIKELY,  # 'O'
        35: SequenceLikelihood.LIKELY,  # 'P'
        53: SequenceLikelihood.UNLIKELY,  # 'Q'
        42: SequenceLikelihood.UNLIKELY,  # 'R'
        34: SequenceLikelihood.LIKELY,  # 'S'
        38: SequenceLikelihood.LIKELY,  # 'T'
        39: SequenceLikelihood.LIKELY,  # 'U'
        52: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        60: SequenceLikelihood.UNLIKELY,  # 'Y'
        59: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        17: SequenceLikelihood.UNLIKELY,  # 'b'
        41: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.POSITIVE,  # 'e'
        19: SequenceLikelihood.UNLIKELY,  # 'f'
        18: SequenceLikelihood.UNLIKELY,  # 'g'
        23: SequenceLikelihood.UNLIKELY,  # 'h'
        1: SequenceLikelihood.POSITIVE,  # 'i'
        11: SequenceLikelihood.UNLIKELY,  # 'j'
        13: SequenceLikelihood.UNLIKELY,  # 'k'
        4: SequenceLikelihood.UNLIKELY,  # 'l'
        12: SequenceLikelihood.UNLIKELY,  # 'm'
        6: SequenceLikelihood.UNLIKELY,  # 'n'
        9: SequenceLikelihood.LIKELY,  # 'o'
        16: SequenceLikelihood.UNLIKELY,  # 'p'
        26: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        10: SequenceLikelihood.UNLIKELY,  # 's'
        3: SequenceLikelihood.UNLIKELY,  # 't'
        8: SequenceLikelihood.LIKELY,  # 'u'
        27: SequenceLikelihood.UNLIKELY,  # 'v'
        21: SequenceLikelihood.UNLIKELY,  # 'w'
        25: SequenceLikelihood.UNLIKELY,  # 'x'
        51: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        57: SequenceLikelihood.UNLIKELY,  # 'Ċ'
        28: SequenceLikelihood.UNLIKELY,  # 'ċ'
        49: SequenceLikelihood.UNLIKELY,  # 'Ġ'
        22: SequenceLikelihood.UNLIKELY,  # 'ġ'
        55: SequenceLikelihood.UNLIKELY,  # 'Ħ'
        15: SequenceLikelihood.UNLIKELY,  # 'ħ'
        58: SequenceLikelihood.UNLIKELY,  # 'Ż'
        24: SequenceLikelihood.NEGATIVE,  # 'ż'
    },
    34: {  # 'S'
        31: SequenceLikelihood.LIKELY,  # 'A'
        43: SequenceLikelihood.LIKELY,  # 'B'
        46: SequenceLikelihood.LIKELY,  # 'C'
        36: SequenceLikelihood.LIKELY,  # 'D'
        32: SequenceLikelihood.LIKELY,  # 'E'
        40: SequenceLikelihood.UNLIKELY,  # 'F'
        44: SequenceLikelihood.UNLIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        29: SequenceLikelihood.LIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        33: SequenceLikelihood.LIKELY,  # 'K'
        37: SequenceLikelihood.UNLIKELY,  # 'L'
        30: SequenceLikelihood.LIKELY,  # 'M'
        45: SequenceLikelihood.UNLIKELY,  # 'N'
        48: SequenceLikelihood.LIKELY,  # 'O'
        35: SequenceLikelihood.LIKELY,  # 'P'
        53: SequenceLikelihood.UNLIKELY,  # 'Q'
        42: SequenceLikelihood.UNLIKELY,  # 'R'
        34: SequenceLikelihood.LIKELY,  # 'S'
        38: SequenceLikelihood.LIKELY,  # 'T'
        39: SequenceLikelihood.LIKELY,  # 'U'
        52: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        60: SequenceLikelihood.UNLIKELY,  # 'Y'
        59: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        17: SequenceLikelihood.UNLIKELY,  # 'b'
        41: SequenceLikelihood.LIKELY,  # 'c'
        14: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.POSITIVE,  # 'e'
        19: SequenceLikelihood.UNLIKELY,  # 'f'
        18: SequenceLikelihood.UNLIKELY,  # 'g'
        23: SequenceLikelihood.LIKELY,  # 'h'
        1: SequenceLikelihood.POSITIVE,  # 'i'
        11: SequenceLikelihood.UNLIKELY,  # 'j'
        13: SequenceLikelihood.LIKELY,  # 'k'
        4: SequenceLikelihood.LIKELY,  # 'l'
        12: SequenceLikelihood.UNLIKELY,  # 'm'
        6: SequenceLikelihood.UNLIKELY,  # 'n'
        9: SequenceLikelihood.POSITIVE,  # 'o'
        16: SequenceLikelihood.LIKELY,  # 'p'
        26: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        10: SequenceLikelihood.UNLIKELY,  # 's'
        3: SequenceLikelihood.POSITIVE,  # 't'
        8: SequenceLikelihood.POSITIVE,  # 'u'
        27: SequenceLikelihood.UNLIKELY,  # 'v'
        21: SequenceLikelihood.UNLIKELY,  # 'w'
        25: SequenceLikelihood.UNLIKELY,  # 'x'
        51: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        57: SequenceLikelihood.UNLIKELY,  # 'Ċ'
        28: SequenceLikelihood.UNLIKELY,  # 'ċ'
        49: SequenceLikelihood.UNLIKELY,  # 'Ġ'
        22: SequenceLikelihood.NEGATIVE,  # 'ġ'
        55: SequenceLikelihood.UNLIKELY,  # 'Ħ'
        15: SequenceLikelihood.LIKELY,  # 'ħ'
        58: SequenceLikelihood.NEGATIVE,  # 'Ż'
        24: SequenceLikelihood.NEGATIVE,  # 'ż'
    },
    38: {  # 'T'
        31: SequenceLikelihood.POSITIVE,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        46: SequenceLikelihood.UNLIKELY,  # 'C'
        36: SequenceLikelihood.UNLIKELY,  # 'D'
        32: SequenceLikelihood.LIKELY,  # 'E'
        40: SequenceLikelihood.LIKELY,  # 'F'
        44: SequenceLikelihood.UNLIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        29: SequenceLikelihood.LIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        33: SequenceLikelihood.UNLIKELY,  # 'K'
        37: SequenceLikelihood.UNLIKELY,  # 'L'
        30: SequenceLikelihood.UNLIKELY,  # 'M'
        45: SequenceLikelihood.UNLIKELY,  # 'N'
        48: SequenceLikelihood.LIKELY,  # 'O'
        35: SequenceLikelihood.UNLIKELY,  # 'P'
        53: SequenceLikelihood.UNLIKELY,  # 'Q'
        42: SequenceLikelihood.LIKELY,  # 'R'
        34: SequenceLikelihood.LIKELY,  # 'S'
        38: SequenceLikelihood.LIKELY,  # 'T'
        39: SequenceLikelihood.LIKELY,  # 'U'
        52: SequenceLikelihood.LIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        60: SequenceLikelihood.UNLIKELY,  # 'Y'
        59: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        17: SequenceLikelihood.UNLIKELY,  # 'b'
        41: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.POSITIVE,  # 'e'
        19: SequenceLikelihood.LIKELY,  # 'f'
        18: SequenceLikelihood.UNLIKELY,  # 'g'
        23: SequenceLikelihood.LIKELY,  # 'h'
        1: SequenceLikelihood.POSITIVE,  # 'i'
        11: SequenceLikelihood.UNLIKELY,  # 'j'
        13: SequenceLikelihood.LIKELY,  # 'k'
        4: SequenceLikelihood.LIKELY,  # 'l'
        12: SequenceLikelihood.LIKELY,  # 'm'
        6: SequenceLikelihood.LIKELY,  # 'n'
        9: SequenceLikelihood.LIKELY,  # 'o'
        16: SequenceLikelihood.UNLIKELY,  # 'p'
        26: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        10: SequenceLikelihood.UNLIKELY,  # 's'
        3: SequenceLikelihood.UNLIKELY,  # 't'
        8: SequenceLikelihood.LIKELY,  # 'u'
        27: SequenceLikelihood.UNLIKELY,  # 'v'
        21: SequenceLikelihood.LIKELY,  # 'w'
        25: SequenceLikelihood.UNLIKELY,  # 'x'
        51: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        57: SequenceLikelihood.UNLIKELY,  # 'Ċ'
        28: SequenceLikelihood.NEGATIVE,  # 'ċ'
        49: SequenceLikelihood.UNLIKELY,  # 'Ġ'
        22: SequenceLikelihood.UNLIKELY,  # 'ġ'
        55: SequenceLikelihood.UNLIKELY,  # 'Ħ'
        15: SequenceLikelihood.UNLIKELY,  # 'ħ'
        58: SequenceLikelihood.NEGATIVE,  # 'Ż'
        24: SequenceLikelihood.UNLIKELY,  # 'ż'
    },
    39: {  # 'U'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        46: SequenceLikelihood.UNLIKELY,  # 'C'
        36: SequenceLikelihood.UNLIKELY,  # 'D'
        32: SequenceLikelihood.POSITIVE,  # 'E'
        40: SequenceLikelihood.UNLIKELY,  # 'F'
        44: SequenceLikelihood.UNLIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        29: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        33: SequenceLikelihood.UNLIKELY,  # 'K'
        37: SequenceLikelihood.UNLIKELY,  # 'L'
        30: SequenceLikelihood.LIKELY,  # 'M'
        45: SequenceLikelihood.LIKELY,  # 'N'
        48: SequenceLikelihood.UNLIKELY,  # 'O'
        35: SequenceLikelihood.UNLIKELY,  # 'P'
        53: SequenceLikelihood.UNLIKELY,  # 'Q'
        42: SequenceLikelihood.LIKELY,  # 'R'
        34: SequenceLikelihood.LIKELY,  # 'S'
        38: SequenceLikelihood.LIKELY,  # 'T'
        39: SequenceLikelihood.UNLIKELY,  # 'U'
        52: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        60: SequenceLikelihood.UNLIKELY,  # 'Y'
        59: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.UNLIKELY,  # 'a'
        17: SequenceLikelihood.UNLIKELY,  # 'b'
        41: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.UNLIKELY,  # 'e'
        19: SequenceLikelihood.LIKELY,  # 'f'
        18: SequenceLikelihood.UNLIKELY,  # 'g'
        23: SequenceLikelihood.UNLIKELY,  # 'h'
        1: SequenceLikelihood.UNLIKELY,  # 'i'
        11: SequenceLikelihood.UNLIKELY,  # 'j'
        13: SequenceLikelihood.LIKELY,  # 'k'
        4: SequenceLikelihood.UNLIKELY,  # 'l'
        12: SequenceLikelihood.UNLIKELY,  # 'm'
        6: SequenceLikelihood.POSITIVE,  # 'n'
        9: SequenceLikelihood.UNLIKELY,  # 'o'
        16: SequenceLikelihood.UNLIKELY,  # 'p'
        26: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        10: SequenceLikelihood.UNLIKELY,  # 's'
        3: SequenceLikelihood.UNLIKELY,  # 't'
        8: SequenceLikelihood.UNLIKELY,  # 'u'
        27: SequenceLikelihood.UNLIKELY,  # 'v'
        21: SequenceLikelihood.UNLIKELY,  # 'w'
        25: SequenceLikelihood.UNLIKELY,  # 'x'
        51: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        57: SequenceLikelihood.UNLIKELY,  # 'Ċ'
        28: SequenceLikelihood.UNLIKELY,  # 'ċ'
        49: SequenceLikelihood.UNLIKELY,  # 'Ġ'
        22: SequenceLikelihood.UNLIKELY,  # 'ġ'
        55: SequenceLikelihood.UNLIKELY,  # 'Ħ'
        15: SequenceLikelihood.UNLIKELY,  # 'ħ'
        58: SequenceLikelihood.UNLIKELY,  # 'Ż'
        24: SequenceLikelihood.LIKELY,  # 'ż'
    },
    52: {  # 'V'
        31: SequenceLikelihood.LIKELY,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        46: SequenceLikelihood.UNLIKELY,  # 'C'
        36: SequenceLikelihood.UNLIKELY,  # 'D'
        32: SequenceLikelihood.LIKELY,  # 'E'
        40: SequenceLikelihood.UNLIKELY,  # 'F'
        44: SequenceLikelihood.UNLIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        29: SequenceLikelihood.LIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        33: SequenceLikelihood.UNLIKELY,  # 'K'
        37: SequenceLikelihood.UNLIKELY,  # 'L'
        30: SequenceLikelihood.LIKELY,  # 'M'
        45: SequenceLikelihood.UNLIKELY,  # 'N'
        48: SequenceLikelihood.UNLIKELY,  # 'O'
        35: SequenceLikelihood.UNLIKELY,  # 'P'
        53: SequenceLikelihood.UNLIKELY,  # 'Q'
        42: SequenceLikelihood.UNLIKELY,  # 'R'
        34: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        39: SequenceLikelihood.UNLIKELY,  # 'U'
        52: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        60: SequenceLikelihood.UNLIKELY,  # 'Y'
        59: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.LIKELY,  # 'a'
        17: SequenceLikelihood.UNLIKELY,  # 'b'
        41: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.LIKELY,  # 'e'
        19: SequenceLikelihood.UNLIKELY,  # 'f'
        18: SequenceLikelihood.UNLIKELY,  # 'g'
        23: SequenceLikelihood.UNLIKELY,  # 'h'
        1: SequenceLikelihood.LIKELY,  # 'i'
        11: SequenceLikelihood.LIKELY,  # 'j'
        13: SequenceLikelihood.UNLIKELY,  # 'k'
        4: SequenceLikelihood.UNLIKELY,  # 'l'
        12: SequenceLikelihood.UNLIKELY,  # 'm'
        6: SequenceLikelihood.UNLIKELY,  # 'n'
        9: SequenceLikelihood.LIKELY,  # 'o'
        16: SequenceLikelihood.UNLIKELY,  # 'p'
        26: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        10: SequenceLikelihood.UNLIKELY,  # 's'
        3: SequenceLikelihood.UNLIKELY,  # 't'
        8: SequenceLikelihood.UNLIKELY,  # 'u'
        27: SequenceLikelihood.UNLIKELY,  # 'v'
        21: SequenceLikelihood.UNLIKELY,  # 'w'
        25: SequenceLikelihood.UNLIKELY,  # 'x'
        51: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        57: SequenceLikelihood.NEGATIVE,  # 'Ċ'
        28: SequenceLikelihood.NEGATIVE,  # 'ċ'
        49: SequenceLikelihood.UNLIKELY,  # 'Ġ'
        22: SequenceLikelihood.UNLIKELY,  # 'ġ'
        55: SequenceLikelihood.UNLIKELY,  # 'Ħ'
        15: SequenceLikelihood.NEGATIVE,  # 'ħ'
        58: SequenceLikelihood.UNLIKELY,  # 'Ż'
        24: SequenceLikelihood.NEGATIVE,  # 'ż'
    },
    54: {  # 'W'
        31: SequenceLikelihood.LIKELY,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        46: SequenceLikelihood.UNLIKELY,  # 'C'
        36: SequenceLikelihood.UNLIKELY,  # 'D'
        32: SequenceLikelihood.UNLIKELY,  # 'E'
        40: SequenceLikelihood.UNLIKELY,  # 'F'
        44: SequenceLikelihood.UNLIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        29: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        33: SequenceLikelihood.UNLIKELY,  # 'K'
        37: SequenceLikelihood.UNLIKELY,  # 'L'
        30: SequenceLikelihood.UNLIKELY,  # 'M'
        45: SequenceLikelihood.UNLIKELY,  # 'N'
        48: SequenceLikelihood.UNLIKELY,  # 'O'
        35: SequenceLikelihood.UNLIKELY,  # 'P'
        53: SequenceLikelihood.UNLIKELY,  # 'Q'
        42: SequenceLikelihood.UNLIKELY,  # 'R'
        34: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        39: SequenceLikelihood.UNLIKELY,  # 'U'
        52: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        60: SequenceLikelihood.UNLIKELY,  # 'Y'
        59: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        17: SequenceLikelihood.UNLIKELY,  # 'b'
        41: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.LIKELY,  # 'e'
        19: SequenceLikelihood.UNLIKELY,  # 'f'
        18: SequenceLikelihood.UNLIKELY,  # 'g'
        23: SequenceLikelihood.LIKELY,  # 'h'
        1: SequenceLikelihood.LIKELY,  # 'i'
        11: SequenceLikelihood.UNLIKELY,  # 'j'
        13: SequenceLikelihood.UNLIKELY,  # 'k'
        4: SequenceLikelihood.UNLIKELY,  # 'l'
        12: SequenceLikelihood.UNLIKELY,  # 'm'
        6: SequenceLikelihood.UNLIKELY,  # 'n'
        9: SequenceLikelihood.LIKELY,  # 'o'
        16: SequenceLikelihood.UNLIKELY,  # 'p'
        26: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        10: SequenceLikelihood.UNLIKELY,  # 's'
        3: SequenceLikelihood.UNLIKELY,  # 't'
        8: SequenceLikelihood.UNLIKELY,  # 'u'
        27: SequenceLikelihood.UNLIKELY,  # 'v'
        21: SequenceLikelihood.UNLIKELY,  # 'w'
        25: SequenceLikelihood.UNLIKELY,  # 'x'
        51: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        57: SequenceLikelihood.UNLIKELY,  # 'Ċ'
        28: SequenceLikelihood.NEGATIVE,  # 'ċ'
        49: SequenceLikelihood.UNLIKELY,  # 'Ġ'
        22: SequenceLikelihood.UNLIKELY,  # 'ġ'
        55: SequenceLikelihood.UNLIKELY,  # 'Ħ'
        15: SequenceLikelihood.UNLIKELY,  # 'ħ'
        58: SequenceLikelihood.UNLIKELY,  # 'Ż'
        24: SequenceLikelihood.NEGATIVE,  # 'ż'
    },
    56: {  # 'X'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        46: SequenceLikelihood.UNLIKELY,  # 'C'
        36: SequenceLikelihood.UNLIKELY,  # 'D'
        32: SequenceLikelihood.UNLIKELY,  # 'E'
        40: SequenceLikelihood.UNLIKELY,  # 'F'
        44: SequenceLikelihood.UNLIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        29: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        33: SequenceLikelihood.UNLIKELY,  # 'K'
        37: SequenceLikelihood.UNLIKELY,  # 'L'
        30: SequenceLikelihood.UNLIKELY,  # 'M'
        45: SequenceLikelihood.UNLIKELY,  # 'N'
        48: SequenceLikelihood.UNLIKELY,  # 'O'
        35: SequenceLikelihood.UNLIKELY,  # 'P'
        53: SequenceLikelihood.UNLIKELY,  # 'Q'
        42: SequenceLikelihood.UNLIKELY,  # 'R'
        34: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        39: SequenceLikelihood.UNLIKELY,  # 'U'
        52: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        60: SequenceLikelihood.UNLIKELY,  # 'Y'
        59: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.LIKELY,  # 'a'
        17: SequenceLikelihood.UNLIKELY,  # 'b'
        41: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.LIKELY,  # 'e'
        19: SequenceLikelihood.UNLIKELY,  # 'f'
        18: SequenceLikelihood.UNLIKELY,  # 'g'
        23: SequenceLikelihood.UNLIKELY,  # 'h'
        1: SequenceLikelihood.LIKELY,  # 'i'
        11: SequenceLikelihood.UNLIKELY,  # 'j'
        13: SequenceLikelihood.UNLIKELY,  # 'k'
        4: SequenceLikelihood.UNLIKELY,  # 'l'
        12: SequenceLikelihood.UNLIKELY,  # 'm'
        6: SequenceLikelihood.UNLIKELY,  # 'n'
        9: SequenceLikelihood.LIKELY,  # 'o'
        16: SequenceLikelihood.UNLIKELY,  # 'p'
        26: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        10: SequenceLikelihood.UNLIKELY,  # 's'
        3: SequenceLikelihood.UNLIKELY,  # 't'
        8: SequenceLikelihood.UNLIKELY,  # 'u'
        27: SequenceLikelihood.UNLIKELY,  # 'v'
        21: SequenceLikelihood.UNLIKELY,  # 'w'
        25: SequenceLikelihood.UNLIKELY,  # 'x'
        51: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        57: SequenceLikelihood.NEGATIVE,  # 'Ċ'
        28: SequenceLikelihood.NEGATIVE,  # 'ċ'
        49: SequenceLikelihood.NEGATIVE,  # 'Ġ'
        22: SequenceLikelihood.NEGATIVE,  # 'ġ'
        55: SequenceLikelihood.UNLIKELY,  # 'Ħ'
        15: SequenceLikelihood.UNLIKELY,  # 'ħ'
        58: SequenceLikelihood.NEGATIVE,  # 'Ż'
        24: SequenceLikelihood.NEGATIVE,  # 'ż'
    },
    60: {  # 'Y'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        46: SequenceLikelihood.UNLIKELY,  # 'C'
        36: SequenceLikelihood.UNLIKELY,  # 'D'
        32: SequenceLikelihood.UNLIKELY,  # 'E'
        40: SequenceLikelihood.UNLIKELY,  # 'F'
        44: SequenceLikelihood.UNLIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        29: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        33: SequenceLikelihood.UNLIKELY,  # 'K'
        37: SequenceLikelihood.UNLIKELY,  # 'L'
        30: SequenceLikelihood.UNLIKELY,  # 'M'
        45: SequenceLikelihood.UNLIKELY,  # 'N'
        48: SequenceLikelihood.UNLIKELY,  # 'O'
        35: SequenceLikelihood.UNLIKELY,  # 'P'
        53: SequenceLikelihood.UNLIKELY,  # 'Q'
        42: SequenceLikelihood.UNLIKELY,  # 'R'
        34: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        39: SequenceLikelihood.UNLIKELY,  # 'U'
        52: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        60: SequenceLikelihood.UNLIKELY,  # 'Y'
        59: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.UNLIKELY,  # 'a'
        17: SequenceLikelihood.UNLIKELY,  # 'b'
        41: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.UNLIKELY,  # 'e'
        19: SequenceLikelihood.UNLIKELY,  # 'f'
        18: SequenceLikelihood.UNLIKELY,  # 'g'
        23: SequenceLikelihood.UNLIKELY,  # 'h'
        1: SequenceLikelihood.UNLIKELY,  # 'i'
        11: SequenceLikelihood.UNLIKELY,  # 'j'
        13: SequenceLikelihood.UNLIKELY,  # 'k'
        4: SequenceLikelihood.UNLIKELY,  # 'l'
        12: SequenceLikelihood.UNLIKELY,  # 'm'
        6: SequenceLikelihood.UNLIKELY,  # 'n'
        9: SequenceLikelihood.LIKELY,  # 'o'
        16: SequenceLikelihood.UNLIKELY,  # 'p'
        26: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        10: SequenceLikelihood.UNLIKELY,  # 's'
        3: SequenceLikelihood.UNLIKELY,  # 't'
        8: SequenceLikelihood.UNLIKELY,  # 'u'
        27: SequenceLikelihood.UNLIKELY,  # 'v'
        21: SequenceLikelihood.UNLIKELY,  # 'w'
        25: SequenceLikelihood.UNLIKELY,  # 'x'
        51: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        57: SequenceLikelihood.NEGATIVE,  # 'Ċ'
        28: SequenceLikelihood.NEGATIVE,  # 'ċ'
        49: SequenceLikelihood.NEGATIVE,  # 'Ġ'
        22: SequenceLikelihood.NEGATIVE,  # 'ġ'
        55: SequenceLikelihood.NEGATIVE,  # 'Ħ'
        15: SequenceLikelihood.NEGATIVE,  # 'ħ'
        58: SequenceLikelihood.NEGATIVE,  # 'Ż'
        24: SequenceLikelihood.NEGATIVE,  # 'ż'
    },
    59: {  # 'Z'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        46: SequenceLikelihood.UNLIKELY,  # 'C'
        36: SequenceLikelihood.UNLIKELY,  # 'D'
        32: SequenceLikelihood.UNLIKELY,  # 'E'
        40: SequenceLikelihood.UNLIKELY,  # 'F'
        44: SequenceLikelihood.UNLIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        29: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.LIKELY,  # 'J'
        33: SequenceLikelihood.UNLIKELY,  # 'K'
        37: SequenceLikelihood.UNLIKELY,  # 'L'
        30: SequenceLikelihood.UNLIKELY,  # 'M'
        45: SequenceLikelihood.UNLIKELY,  # 'N'
        48: SequenceLikelihood.UNLIKELY,  # 'O'
        35: SequenceLikelihood.UNLIKELY,  # 'P'
        53: SequenceLikelihood.UNLIKELY,  # 'Q'
        42: SequenceLikelihood.UNLIKELY,  # 'R'
        34: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        39: SequenceLikelihood.UNLIKELY,  # 'U'
        52: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        60: SequenceLikelihood.UNLIKELY,  # 'Y'
        59: SequenceLikelihood.LIKELY,  # 'Z'
        2: SequenceLikelihood.LIKELY,  # 'a'
        17: SequenceLikelihood.UNLIKELY,  # 'b'
        41: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.UNLIKELY,  # 'e'
        19: SequenceLikelihood.UNLIKELY,  # 'f'
        18: SequenceLikelihood.UNLIKELY,  # 'g'
        23: SequenceLikelihood.UNLIKELY,  # 'h'
        1: SequenceLikelihood.UNLIKELY,  # 'i'
        11: SequenceLikelihood.UNLIKELY,  # 'j'
        13: SequenceLikelihood.UNLIKELY,  # 'k'
        4: SequenceLikelihood.UNLIKELY,  # 'l'
        12: SequenceLikelihood.UNLIKELY,  # 'm'
        6: SequenceLikelihood.UNLIKELY,  # 'n'
        9: SequenceLikelihood.UNLIKELY,  # 'o'
        16: SequenceLikelihood.UNLIKELY,  # 'p'
        26: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        10: SequenceLikelihood.UNLIKELY,  # 's'
        3: SequenceLikelihood.UNLIKELY,  # 't'
        8: SequenceLikelihood.UNLIKELY,  # 'u'
        27: SequenceLikelihood.UNLIKELY,  # 'v'
        21: SequenceLikelihood.UNLIKELY,  # 'w'
        25: SequenceLikelihood.UNLIKELY,  # 'x'
        51: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        57: SequenceLikelihood.NEGATIVE,  # 'Ċ'
        28: SequenceLikelihood.NEGATIVE,  # 'ċ'
        49: SequenceLikelihood.NEGATIVE,  # 'Ġ'
        22: SequenceLikelihood.NEGATIVE,  # 'ġ'
        55: SequenceLikelihood.NEGATIVE,  # 'Ħ'
        15: SequenceLikelihood.UNLIKELY,  # 'ħ'
        58: SequenceLikelihood.NEGATIVE,  # 'Ż'
        24: SequenceLikelihood.NEGATIVE,  # 'ż'
    },
    2: {  # 'a'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        46: SequenceLikelihood.UNLIKELY,  # 'C'
        36: SequenceLikelihood.UNLIKELY,  # 'D'
        32: SequenceLikelihood.UNLIKELY,  # 'E'
        40: SequenceLikelihood.UNLIKELY,  # 'F'
        44: SequenceLikelihood.UNLIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        29: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        33: SequenceLikelihood.UNLIKELY,  # 'K'
        37: SequenceLikelihood.UNLIKELY,  # 'L'
        30: SequenceLikelihood.UNLIKELY,  # 'M'
        45: SequenceLikelihood.UNLIKELY,  # 'N'
        48: SequenceLikelihood.UNLIKELY,  # 'O'
        35: SequenceLikelihood.UNLIKELY,  # 'P'
        53: SequenceLikelihood.UNLIKELY,  # 'Q'
        42: SequenceLikelihood.UNLIKELY,  # 'R'
        34: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        39: SequenceLikelihood.UNLIKELY,  # 'U'
        52: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        60: SequenceLikelihood.UNLIKELY,  # 'Y'
        59: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.LIKELY,  # 'a'
        17: SequenceLikelihood.POSITIVE,  # 'b'
        41: SequenceLikelihood.POSITIVE,  # 'c'
        14: SequenceLikelihood.POSITIVE,  # 'd'
        5: SequenceLikelihood.LIKELY,  # 'e'
        19: SequenceLikelihood.POSITIVE,  # 'f'
        18: SequenceLikelihood.POSITIVE,  # 'g'
        23: SequenceLikelihood.POSITIVE,  # 'h'
        1: SequenceLikelihood.POSITIVE,  # 'i'
        11: SequenceLikelihood.POSITIVE,  # 'j'
        13: SequenceLikelihood.POSITIVE,  # 'k'
        4: SequenceLikelihood.POSITIVE,  # 'l'
        12: SequenceLikelihood.POSITIVE,  # 'm'
        6: SequenceLikelihood.POSITIVE,  # 'n'
        9: SequenceLikelihood.LIKELY,  # 'o'
        16: SequenceLikelihood.POSITIVE,  # 'p'
        26: SequenceLikelihood.POSITIVE,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        10: SequenceLikelihood.POSITIVE,  # 's'
        3: SequenceLikelihood.POSITIVE,  # 't'
        8: SequenceLikelihood.LIKELY,  # 'u'
        27: SequenceLikelihood.POSITIVE,  # 'v'
        21: SequenceLikelihood.POSITIVE,  # 'w'
        25: SequenceLikelihood.POSITIVE,  # 'x'
        51: SequenceLikelihood.LIKELY,  # 'y'
        20: SequenceLikelihood.POSITIVE,  # 'z'
        57: SequenceLikelihood.UNLIKELY,  # 'Ċ'
        28: SequenceLikelihood.POSITIVE,  # 'ċ'
        49: SequenceLikelihood.UNLIKELY,  # 'Ġ'
        22: SequenceLikelihood.POSITIVE,  # 'ġ'
        55: SequenceLikelihood.UNLIKELY,  # 'Ħ'
        15: SequenceLikelihood.POSITIVE,  # 'ħ'
        58: SequenceLikelihood.UNLIKELY,  # 'Ż'
        24: SequenceLikelihood.POSITIVE,  # 'ż'
    },
    17: {  # 'b'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        46: SequenceLikelihood.UNLIKELY,  # 'C'
        36: SequenceLikelihood.UNLIKELY,  # 'D'
        32: SequenceLikelihood.UNLIKELY,  # 'E'
        40: SequenceLikelihood.UNLIKELY,  # 'F'
        44: SequenceLikelihood.UNLIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        29: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        33: SequenceLikelihood.UNLIKELY,  # 'K'
        37: SequenceLikelihood.UNLIKELY,  # 'L'
        30: SequenceLikelihood.UNLIKELY,  # 'M'
        45: SequenceLikelihood.UNLIKELY,  # 'N'
        48: SequenceLikelihood.UNLIKELY,  # 'O'
        35: SequenceLikelihood.UNLIKELY,  # 'P'
        53: SequenceLikelihood.UNLIKELY,  # 'Q'
        42: SequenceLikelihood.UNLIKELY,  # 'R'
        34: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        39: SequenceLikelihood.UNLIKELY,  # 'U'
        52: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        60: SequenceLikelihood.UNLIKELY,  # 'Y'
        59: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        17: SequenceLikelihood.POSITIVE,  # 'b'
        41: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.POSITIVE,  # 'd'
        5: SequenceLikelihood.POSITIVE,  # 'e'
        19: SequenceLikelihood.UNLIKELY,  # 'f'
        18: SequenceLikelihood.LIKELY,  # 'g'
        23: SequenceLikelihood.LIKELY,  # 'h'
        1: SequenceLikelihood.POSITIVE,  # 'i'
        11: SequenceLikelihood.POSITIVE,  # 'j'
        13: SequenceLikelihood.LIKELY,  # 'k'
        4: SequenceLikelihood.POSITIVE,  # 'l'
        12: SequenceLikelihood.UNLIKELY,  # 'm'
        6: SequenceLikelihood.POSITIVE,  # 'n'
        9: SequenceLikelihood.POSITIVE,  # 'o'
        16: SequenceLikelihood.LIKELY,  # 'p'
        26: SequenceLikelihood.POSITIVE,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        10: SequenceLikelihood.POSITIVE,  # 's'
        3: SequenceLikelihood.POSITIVE,  # 't'
        8: SequenceLikelihood.POSITIVE,  # 'u'
        27: SequenceLikelihood.UNLIKELY,  # 'v'
        21: SequenceLikelihood.LIKELY,  # 'w'
        25: SequenceLikelihood.LIKELY,  # 'x'
        51: SequenceLikelihood.LIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        57: SequenceLikelihood.NEGATIVE,  # 'Ċ'
        28: SequenceLikelihood.UNLIKELY,  # 'ċ'
        49: SequenceLikelihood.UNLIKELY,  # 'Ġ'
        22: SequenceLikelihood.UNLIKELY,  # 'ġ'
        55: SequenceLikelihood.UNLIKELY,  # 'Ħ'
        15: SequenceLikelihood.POSITIVE,  # 'ħ'
        58: SequenceLikelihood.UNLIKELY,  # 'Ż'
        24: SequenceLikelihood.POSITIVE,  # 'ż'
    },
    41: {  # 'c'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        46: SequenceLikelihood.UNLIKELY,  # 'C'
        36: SequenceLikelihood.UNLIKELY,  # 'D'
        32: SequenceLikelihood.UNLIKELY,  # 'E'
        40: SequenceLikelihood.UNLIKELY,  # 'F'
        44: SequenceLikelihood.UNLIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        29: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        33: SequenceLikelihood.UNLIKELY,  # 'K'
        37: SequenceLikelihood.UNLIKELY,  # 'L'
        30: SequenceLikelihood.UNLIKELY,  # 'M'
        45: SequenceLikelihood.UNLIKELY,  # 'N'
        48: SequenceLikelihood.UNLIKELY,  # 'O'
        35: SequenceLikelihood.UNLIKELY,  # 'P'
        53: SequenceLikelihood.UNLIKELY,  # 'Q'
        42: SequenceLikelihood.UNLIKELY,  # 'R'
        34: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        39: SequenceLikelihood.UNLIKELY,  # 'U'
        52: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        60: SequenceLikelihood.UNLIKELY,  # 'Y'
        59: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        17: SequenceLikelihood.UNLIKELY,  # 'b'
        41: SequenceLikelihood.LIKELY,  # 'c'
        14: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.POSITIVE,  # 'e'
        19: SequenceLikelihood.UNLIKELY,  # 'f'
        18: SequenceLikelihood.UNLIKELY,  # 'g'
        23: SequenceLikelihood.POSITIVE,  # 'h'
        1: SequenceLikelihood.POSITIVE,  # 'i'
        11: SequenceLikelihood.UNLIKELY,  # 'j'
        13: SequenceLikelihood.LIKELY,  # 'k'
        4: SequenceLikelihood.LIKELY,  # 'l'
        12: SequenceLikelihood.UNLIKELY,  # 'm'
        6: SequenceLikelihood.UNLIKELY,  # 'n'
        9: SequenceLikelihood.POSITIVE,  # 'o'
        16: SequenceLikelihood.UNLIKELY,  # 'p'
        26: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.LIKELY,  # 'r'
        10: SequenceLikelihood.LIKELY,  # 's'
        3: SequenceLikelihood.LIKELY,  # 't'
        8: SequenceLikelihood.LIKELY,  # 'u'
        27: SequenceLikelihood.UNLIKELY,  # 'v'
        21: SequenceLikelihood.UNLIKELY,  # 'w'
        25: SequenceLikelihood.UNLIKELY,  # 'x'
        51: SequenceLikelihood.LIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        57: SequenceLikelihood.NEGATIVE,  # 'Ċ'
        28: SequenceLikelihood.UNLIKELY,  # 'ċ'
        49: SequenceLikelihood.UNLIKELY,  # 'Ġ'
        22: SequenceLikelihood.NEGATIVE,  # 'ġ'
        55: SequenceLikelihood.UNLIKELY,  # 'Ħ'
        15: SequenceLikelihood.UNLIKELY,  # 'ħ'
        58: SequenceLikelihood.NEGATIVE,  # 'Ż'
        24: SequenceLikelihood.NEGATIVE,  # 'ż'
    },
    14: {  # 'd'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        46: SequenceLikelihood.UNLIKELY,  # 'C'
        36: SequenceLikelihood.UNLIKELY,  # 'D'
        32: SequenceLikelihood.UNLIKELY,  # 'E'
        40: SequenceLikelihood.UNLIKELY,  # 'F'
        44: SequenceLikelihood.UNLIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        29: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        33: SequenceLikelihood.UNLIKELY,  # 'K'
        37: SequenceLikelihood.UNLIKELY,  # 'L'
        30: SequenceLikelihood.UNLIKELY,  # 'M'
        45: SequenceLikelihood.UNLIKELY,  # 'N'
        48: SequenceLikelihood.UNLIKELY,  # 'O'
        35: SequenceLikelihood.UNLIKELY,  # 'P'
        53: SequenceLikelihood.UNLIKELY,  # 'Q'
        42: SequenceLikelihood.UNLIKELY,  # 'R'
        34: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        39: SequenceLikelihood.UNLIKELY,  # 'U'
        52: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        60: SequenceLikelihood.UNLIKELY,  # 'Y'
        59: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        17: SequenceLikelihood.LIKELY,  # 'b'
        41: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.POSITIVE,  # 'd'
        5: SequenceLikelihood.POSITIVE,  # 'e'
        19: SequenceLikelihood.LIKELY,  # 'f'
        18: SequenceLikelihood.LIKELY,  # 'g'
        23: SequenceLikelihood.POSITIVE,  # 'h'
        1: SequenceLikelihood.POSITIVE,  # 'i'
        11: SequenceLikelihood.POSITIVE,  # 'j'
        13: SequenceLikelihood.LIKELY,  # 'k'
        4: SequenceLikelihood.POSITIVE,  # 'l'
        12: SequenceLikelihood.POSITIVE,  # 'm'
        6: SequenceLikelihood.POSITIVE,  # 'n'
        9: SequenceLikelihood.POSITIVE,  # 'o'
        16: SequenceLikelihood.UNLIKELY,  # 'p'
        26: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        10: SequenceLikelihood.POSITIVE,  # 's'
        3: SequenceLikelihood.LIKELY,  # 't'
        8: SequenceLikelihood.POSITIVE,  # 'u'
        27: SequenceLikelihood.UNLIKELY,  # 'v'
        21: SequenceLikelihood.POSITIVE,  # 'w'
        25: SequenceLikelihood.LIKELY,  # 'x'
        51: SequenceLikelihood.LIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        57: SequenceLikelihood.NEGATIVE,  # 'Ċ'
        28: SequenceLikelihood.UNLIKELY,  # 'ċ'
        49: SequenceLikelihood.UNLIKELY,  # 'Ġ'
        22: SequenceLikelihood.UNLIKELY,  # 'ġ'
        55: SequenceLikelihood.UNLIKELY,  # 'Ħ'
        15: SequenceLikelihood.POSITIVE,  # 'ħ'
        58: SequenceLikelihood.NEGATIVE,  # 'Ż'
        24: SequenceLikelihood.UNLIKELY,  # 'ż'
    },
    5: {  # 'e'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        46: SequenceLikelihood.UNLIKELY,  # 'C'
        36: SequenceLikelihood.UNLIKELY,  # 'D'
        32: SequenceLikelihood.UNLIKELY,  # 'E'
        40: SequenceLikelihood.UNLIKELY,  # 'F'
        44: SequenceLikelihood.UNLIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        29: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        33: SequenceLikelihood.UNLIKELY,  # 'K'
        37: SequenceLikelihood.UNLIKELY,  # 'L'
        30: SequenceLikelihood.UNLIKELY,  # 'M'
        45: SequenceLikelihood.UNLIKELY,  # 'N'
        48: SequenceLikelihood.UNLIKELY,  # 'O'
        35: SequenceLikelihood.UNLIKELY,  # 'P'
        53: SequenceLikelihood.UNLIKELY,  # 'Q'
        42: SequenceLikelihood.UNLIKELY,  # 'R'
        34: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        39: SequenceLikelihood.UNLIKELY,  # 'U'
        52: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        60: SequenceLikelihood.UNLIKELY,  # 'Y'
        59: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        17: SequenceLikelihood.POSITIVE,  # 'b'
        41: SequenceLikelihood.POSITIVE,  # 'c'
        14: SequenceLikelihood.POSITIVE,  # 'd'
        5: SequenceLikelihood.LIKELY,  # 'e'
        19: SequenceLikelihood.POSITIVE,  # 'f'
        18: SequenceLikelihood.POSITIVE,  # 'g'
        23: SequenceLikelihood.POSITIVE,  # 'h'
        1: SequenceLikelihood.LIKELY,  # 'i'
        11: SequenceLikelihood.POSITIVE,  # 'j'
        13: SequenceLikelihood.POSITIVE,  # 'k'
        4: SequenceLikelihood.POSITIVE,  # 'l'
        12: SequenceLikelihood.POSITIVE,  # 'm'
        6: SequenceLikelihood.POSITIVE,  # 'n'
        9: SequenceLikelihood.POSITIVE,  # 'o'
        16: SequenceLikelihood.POSITIVE,  # 'p'
        26: SequenceLikelihood.POSITIVE,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        10: SequenceLikelihood.POSITIVE,  # 's'
        3: SequenceLikelihood.POSITIVE,  # 't'
        8: SequenceLikelihood.LIKELY,  # 'u'
        27: SequenceLikelihood.POSITIVE,  # 'v'
        21: SequenceLikelihood.POSITIVE,  # 'w'
        25: SequenceLikelihood.POSITIVE,  # 'x'
        51: SequenceLikelihood.LIKELY,  # 'y'
        20: SequenceLikelihood.POSITIVE,  # 'z'
        57: SequenceLikelihood.UNLIKELY,  # 'Ċ'
        28: SequenceLikelihood.POSITIVE,  # 'ċ'
        49: SequenceLikelihood.UNLIKELY,  # 'Ġ'
        22: SequenceLikelihood.POSITIVE,  # 'ġ'
        55: SequenceLikelihood.UNLIKELY,  # 'Ħ'
        15: SequenceLikelihood.POSITIVE,  # 'ħ'
        58: SequenceLikelihood.UNLIKELY,  # 'Ż'
        24: SequenceLikelihood.POSITIVE,  # 'ż'
    },
    19: {  # 'f'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        46: SequenceLikelihood.UNLIKELY,  # 'C'
        36: SequenceLikelihood.UNLIKELY,  # 'D'
        32: SequenceLikelihood.UNLIKELY,  # 'E'
        40: SequenceLikelihood.UNLIKELY,  # 'F'
        44: SequenceLikelihood.UNLIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        29: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        33: SequenceLikelihood.UNLIKELY,  # 'K'
        37: SequenceLikelihood.UNLIKELY,  # 'L'
        30: SequenceLikelihood.UNLIKELY,  # 'M'
        45: SequenceLikelihood.UNLIKELY,  # 'N'
        48: SequenceLikelihood.UNLIKELY,  # 'O'
        35: SequenceLikelihood.UNLIKELY,  # 'P'
        53: SequenceLikelihood.UNLIKELY,  # 'Q'
        42: SequenceLikelihood.UNLIKELY,  # 'R'
        34: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        39: SequenceLikelihood.UNLIKELY,  # 'U'
        52: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        60: SequenceLikelihood.UNLIKELY,  # 'Y'
        59: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        17: SequenceLikelihood.UNLIKELY,  # 'b'
        41: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.LIKELY,  # 'd'
        5: SequenceLikelihood.POSITIVE,  # 'e'
        19: SequenceLikelihood.POSITIVE,  # 'f'
        18: SequenceLikelihood.LIKELY,  # 'g'
        23: SequenceLikelihood.LIKELY,  # 'h'
        1: SequenceLikelihood.POSITIVE,  # 'i'
        11: SequenceLikelihood.LIKELY,  # 'j'
        13: SequenceLikelihood.UNLIKELY,  # 'k'
        4: SequenceLikelihood.POSITIVE,  # 'l'
        12: SequenceLikelihood.UNLIKELY,  # 'm'
        6: SequenceLikelihood.POSITIVE,  # 'n'
        9: SequenceLikelihood.POSITIVE,  # 'o'
        16: SequenceLikelihood.UNLIKELY,  # 'p'
        26: SequenceLikelihood.LIKELY,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        10: SequenceLikelihood.POSITIVE,  # 's'
        3: SequenceLikelihood.POSITIVE,  # 't'
        8: SequenceLikelihood.POSITIVE,  # 'u'
        27: SequenceLikelihood.UNLIKELY,  # 'v'
        21: SequenceLikelihood.LIKELY,  # 'w'
        25: SequenceLikelihood.LIKELY,  # 'x'
        51: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        57: SequenceLikelihood.NEGATIVE,  # 'Ċ'
        28: SequenceLikelihood.UNLIKELY,  # 'ċ'
        49: SequenceLikelihood.NEGATIVE,  # 'Ġ'
        22: SequenceLikelihood.UNLIKELY,  # 'ġ'
        55: SequenceLikelihood.UNLIKELY,  # 'Ħ'
        15: SequenceLikelihood.UNLIKELY,  # 'ħ'
        58: SequenceLikelihood.NEGATIVE,  # 'Ż'
        24: SequenceLikelihood.UNLIKELY,  # 'ż'
    },
    18: {  # 'g'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        46: SequenceLikelihood.UNLIKELY,  # 'C'
        36: SequenceLikelihood.UNLIKELY,  # 'D'
        32: SequenceLikelihood.UNLIKELY,  # 'E'
        40: SequenceLikelihood.UNLIKELY,  # 'F'
        44: SequenceLikelihood.UNLIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        29: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        33: SequenceLikelihood.UNLIKELY,  # 'K'
        37: SequenceLikelihood.UNLIKELY,  # 'L'
        30: SequenceLikelihood.UNLIKELY,  # 'M'
        45: SequenceLikelihood.UNLIKELY,  # 'N'
        48: SequenceLikelihood.UNLIKELY,  # 'O'
        35: SequenceLikelihood.UNLIKELY,  # 'P'
        53: SequenceLikelihood.UNLIKELY,  # 'Q'
        42: SequenceLikelihood.UNLIKELY,  # 'R'
        34: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        39: SequenceLikelihood.UNLIKELY,  # 'U'
        52: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        60: SequenceLikelihood.UNLIKELY,  # 'Y'
        59: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        17: SequenceLikelihood.UNLIKELY,  # 'b'
        41: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.POSITIVE,  # 'e'
        19: SequenceLikelihood.UNLIKELY,  # 'f'
        18: SequenceLikelihood.LIKELY,  # 'g'
        23: SequenceLikelihood.LIKELY,  # 'h'
        1: SequenceLikelihood.POSITIVE,  # 'i'
        11: SequenceLikelihood.UNLIKELY,  # 'j'
        13: SequenceLikelihood.UNLIKELY,  # 'k'
        4: SequenceLikelihood.POSITIVE,  # 'l'
        12: SequenceLikelihood.LIKELY,  # 'm'
        6: SequenceLikelihood.LIKELY,  # 'n'
        9: SequenceLikelihood.POSITIVE,  # 'o'
        16: SequenceLikelihood.UNLIKELY,  # 'p'
        26: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        10: SequenceLikelihood.LIKELY,  # 's'
        3: SequenceLikelihood.UNLIKELY,  # 't'
        8: SequenceLikelihood.POSITIVE,  # 'u'
        27: SequenceLikelihood.LIKELY,  # 'v'
        21: SequenceLikelihood.POSITIVE,  # 'w'
        25: SequenceLikelihood.UNLIKELY,  # 'x'
        51: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        57: SequenceLikelihood.NEGATIVE,  # 'Ċ'
        28: SequenceLikelihood.UNLIKELY,  # 'ċ'
        49: SequenceLikelihood.NEGATIVE,  # 'Ġ'
        22: SequenceLikelihood.UNLIKELY,  # 'ġ'
        55: SequenceLikelihood.UNLIKELY,  # 'Ħ'
        15: SequenceLikelihood.POSITIVE,  # 'ħ'
        58: SequenceLikelihood.NEGATIVE,  # 'Ż'
        24: SequenceLikelihood.LIKELY,  # 'ż'
    },
    23: {  # 'h'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        46: SequenceLikelihood.UNLIKELY,  # 'C'
        36: SequenceLikelihood.UNLIKELY,  # 'D'
        32: SequenceLikelihood.UNLIKELY,  # 'E'
        40: SequenceLikelihood.UNLIKELY,  # 'F'
        44: SequenceLikelihood.UNLIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        29: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        33: SequenceLikelihood.UNLIKELY,  # 'K'
        37: SequenceLikelihood.UNLIKELY,  # 'L'
        30: SequenceLikelihood.UNLIKELY,  # 'M'
        45: SequenceLikelihood.UNLIKELY,  # 'N'
        48: SequenceLikelihood.UNLIKELY,  # 'O'
        35: SequenceLikelihood.UNLIKELY,  # 'P'
        53: SequenceLikelihood.UNLIKELY,  # 'Q'
        42: SequenceLikelihood.UNLIKELY,  # 'R'
        34: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        39: SequenceLikelihood.UNLIKELY,  # 'U'
        52: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        60: SequenceLikelihood.UNLIKELY,  # 'Y'
        59: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        17: SequenceLikelihood.UNLIKELY,  # 'b'
        41: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.POSITIVE,  # 'e'
        19: SequenceLikelihood.UNLIKELY,  # 'f'
        18: SequenceLikelihood.UNLIKELY,  # 'g'
        23: SequenceLikelihood.UNLIKELY,  # 'h'
        1: SequenceLikelihood.POSITIVE,  # 'i'
        11: SequenceLikelihood.UNLIKELY,  # 'j'
        13: SequenceLikelihood.UNLIKELY,  # 'k'
        4: SequenceLikelihood.LIKELY,  # 'l'
        12: SequenceLikelihood.LIKELY,  # 'm'
        6: SequenceLikelihood.LIKELY,  # 'n'
        9: SequenceLikelihood.POSITIVE,  # 'o'
        16: SequenceLikelihood.UNLIKELY,  # 'p'
        26: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.LIKELY,  # 'r'
        10: SequenceLikelihood.UNLIKELY,  # 's'
        3: SequenceLikelihood.LIKELY,  # 't'
        8: SequenceLikelihood.POSITIVE,  # 'u'
        27: SequenceLikelihood.UNLIKELY,  # 'v'
        21: SequenceLikelihood.UNLIKELY,  # 'w'
        25: SequenceLikelihood.UNLIKELY,  # 'x'
        51: SequenceLikelihood.LIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        57: SequenceLikelihood.NEGATIVE,  # 'Ċ'
        28: SequenceLikelihood.UNLIKELY,  # 'ċ'
        49: SequenceLikelihood.NEGATIVE,  # 'Ġ'
        22: SequenceLikelihood.UNLIKELY,  # 'ġ'
        55: SequenceLikelihood.UNLIKELY,  # 'Ħ'
        15: SequenceLikelihood.UNLIKELY,  # 'ħ'
        58: SequenceLikelihood.NEGATIVE,  # 'Ż'
        24: SequenceLikelihood.UNLIKELY,  # 'ż'
    },
    1: {  # 'i'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        46: SequenceLikelihood.UNLIKELY,  # 'C'
        36: SequenceLikelihood.UNLIKELY,  # 'D'
        32: SequenceLikelihood.UNLIKELY,  # 'E'
        40: SequenceLikelihood.UNLIKELY,  # 'F'
        44: SequenceLikelihood.UNLIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        29: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        33: SequenceLikelihood.UNLIKELY,  # 'K'
        37: SequenceLikelihood.UNLIKELY,  # 'L'
        30: SequenceLikelihood.UNLIKELY,  # 'M'
        45: SequenceLikelihood.UNLIKELY,  # 'N'
        48: SequenceLikelihood.UNLIKELY,  # 'O'
        35: SequenceLikelihood.LIKELY,  # 'P'
        53: SequenceLikelihood.UNLIKELY,  # 'Q'
        42: SequenceLikelihood.UNLIKELY,  # 'R'
        34: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        39: SequenceLikelihood.UNLIKELY,  # 'U'
        52: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        60: SequenceLikelihood.UNLIKELY,  # 'Y'
        59: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        17: SequenceLikelihood.POSITIVE,  # 'b'
        41: SequenceLikelihood.POSITIVE,  # 'c'
        14: SequenceLikelihood.POSITIVE,  # 'd'
        5: SequenceLikelihood.POSITIVE,  # 'e'
        19: SequenceLikelihood.POSITIVE,  # 'f'
        18: SequenceLikelihood.POSITIVE,  # 'g'
        23: SequenceLikelihood.POSITIVE,  # 'h'
        1: SequenceLikelihood.LIKELY,  # 'i'
        11: SequenceLikelihood.POSITIVE,  # 'j'
        13: SequenceLikelihood.POSITIVE,  # 'k'
        4: SequenceLikelihood.POSITIVE,  # 'l'
        12: SequenceLikelihood.POSITIVE,  # 'm'
        6: SequenceLikelihood.POSITIVE,  # 'n'
        9: SequenceLikelihood.POSITIVE,  # 'o'
        16: SequenceLikelihood.POSITIVE,  # 'p'
        26: SequenceLikelihood.POSITIVE,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        10: SequenceLikelihood.POSITIVE,  # 's'
        3: SequenceLikelihood.POSITIVE,  # 't'
        8: SequenceLikelihood.LIKELY,  # 'u'
        27: SequenceLikelihood.POSITIVE,  # 'v'
        21: SequenceLikelihood.LIKELY,  # 'w'
        25: SequenceLikelihood.POSITIVE,  # 'x'
        51: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.POSITIVE,  # 'z'
        57: SequenceLikelihood.UNLIKELY,  # 'Ċ'
        28: SequenceLikelihood.POSITIVE,  # 'ċ'
        49: SequenceLikelihood.UNLIKELY,  # 'Ġ'
        22: SequenceLikelihood.POSITIVE,  # 'ġ'
        55: SequenceLikelihood.UNLIKELY,  # 'Ħ'
        15: SequenceLikelihood.POSITIVE,  # 'ħ'
        58: SequenceLikelihood.UNLIKELY,  # 'Ż'
        24: SequenceLikelihood.POSITIVE,  # 'ż'
    },
    11: {  # 'j'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        46: SequenceLikelihood.UNLIKELY,  # 'C'
        36: SequenceLikelihood.UNLIKELY,  # 'D'
        32: SequenceLikelihood.UNLIKELY,  # 'E'
        40: SequenceLikelihood.UNLIKELY,  # 'F'
        44: SequenceLikelihood.UNLIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        29: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        33: SequenceLikelihood.UNLIKELY,  # 'K'
        37: SequenceLikelihood.UNLIKELY,  # 'L'
        30: SequenceLikelihood.UNLIKELY,  # 'M'
        45: SequenceLikelihood.UNLIKELY,  # 'N'
        48: SequenceLikelihood.UNLIKELY,  # 'O'
        35: SequenceLikelihood.UNLIKELY,  # 'P'
        53: SequenceLikelihood.UNLIKELY,  # 'Q'
        42: SequenceLikelihood.UNLIKELY,  # 'R'
        34: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        39: SequenceLikelihood.UNLIKELY,  # 'U'
        52: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        60: SequenceLikelihood.UNLIKELY,  # 'Y'
        59: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        17: SequenceLikelihood.POSITIVE,  # 'b'
        41: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.POSITIVE,  # 'd'
        5: SequenceLikelihood.POSITIVE,  # 'e'
        19: SequenceLikelihood.LIKELY,  # 'f'
        18: SequenceLikelihood.POSITIVE,  # 'g'
        23: SequenceLikelihood.LIKELY,  # 'h'
        1: SequenceLikelihood.POSITIVE,  # 'i'
        11: SequenceLikelihood.POSITIVE,  # 'j'
        13: SequenceLikelihood.POSITIVE,  # 'k'
        4: SequenceLikelihood.POSITIVE,  # 'l'
        12: SequenceLikelihood.LIKELY,  # 'm'
        6: SequenceLikelihood.POSITIVE,  # 'n'
        9: SequenceLikelihood.POSITIVE,  # 'o'
        16: SequenceLikelihood.LIKELY,  # 'p'
        26: SequenceLikelihood.LIKELY,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        10: SequenceLikelihood.POSITIVE,  # 's'
        3: SequenceLikelihood.POSITIVE,  # 't'
        8: SequenceLikelihood.POSITIVE,  # 'u'
        27: SequenceLikelihood.LIKELY,  # 'v'
        21: SequenceLikelihood.LIKELY,  # 'w'
        25: SequenceLikelihood.LIKELY,  # 'x'
        51: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        57: SequenceLikelihood.NEGATIVE,  # 'Ċ'
        28: SequenceLikelihood.UNLIKELY,  # 'ċ'
        49: SequenceLikelihood.NEGATIVE,  # 'Ġ'
        22: SequenceLikelihood.LIKELY,  # 'ġ'
        55: SequenceLikelihood.UNLIKELY,  # 'Ħ'
        15: SequenceLikelihood.POSITIVE,  # 'ħ'
        58: SequenceLikelihood.NEGATIVE,  # 'Ż'
        24: SequenceLikelihood.LIKELY,  # 'ż'
    },
    13: {  # 'k'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        46: SequenceLikelihood.UNLIKELY,  # 'C'
        36: SequenceLikelihood.UNLIKELY,  # 'D'
        32: SequenceLikelihood.UNLIKELY,  # 'E'
        40: SequenceLikelihood.UNLIKELY,  # 'F'
        44: SequenceLikelihood.UNLIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        29: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        33: SequenceLikelihood.UNLIKELY,  # 'K'
        37: SequenceLikelihood.UNLIKELY,  # 'L'
        30: SequenceLikelihood.UNLIKELY,  # 'M'
        45: SequenceLikelihood.UNLIKELY,  # 'N'
        48: SequenceLikelihood.UNLIKELY,  # 'O'
        35: SequenceLikelihood.UNLIKELY,  # 'P'
        53: SequenceLikelihood.UNLIKELY,  # 'Q'
        42: SequenceLikelihood.UNLIKELY,  # 'R'
        34: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        39: SequenceLikelihood.UNLIKELY,  # 'U'
        52: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        60: SequenceLikelihood.UNLIKELY,  # 'Y'
        59: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        17: SequenceLikelihood.POSITIVE,  # 'b'
        41: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.POSITIVE,  # 'e'
        19: SequenceLikelihood.UNLIKELY,  # 'f'
        18: SequenceLikelihood.LIKELY,  # 'g'
        23: SequenceLikelihood.UNLIKELY,  # 'h'
        1: SequenceLikelihood.POSITIVE,  # 'i'
        11: SequenceLikelihood.POSITIVE,  # 'j'
        13: SequenceLikelihood.POSITIVE,  # 'k'
        4: SequenceLikelihood.POSITIVE,  # 'l'
        12: SequenceLikelihood.LIKELY,  # 'm'
        6: SequenceLikelihood.POSITIVE,  # 'n'
        9: SequenceLikelihood.POSITIVE,  # 'o'
        16: SequenceLikelihood.UNLIKELY,  # 'p'
        26: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        10: SequenceLikelihood.POSITIVE,  # 's'
        3: SequenceLikelihood.POSITIVE,  # 't'
        8: SequenceLikelihood.POSITIVE,  # 'u'
        27: SequenceLikelihood.UNLIKELY,  # 'v'
        21: SequenceLikelihood.POSITIVE,  # 'w'
        25: SequenceLikelihood.LIKELY,  # 'x'
        51: SequenceLikelihood.LIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        57: SequenceLikelihood.NEGATIVE,  # 'Ċ'
        28: SequenceLikelihood.UNLIKELY,  # 'ċ'
        49: SequenceLikelihood.NEGATIVE,  # 'Ġ'
        22: SequenceLikelihood.UNLIKELY,  # 'ġ'
        55: SequenceLikelihood.UNLIKELY,  # 'Ħ'
        15: SequenceLikelihood.UNLIKELY,  # 'ħ'
        58: SequenceLikelihood.UNLIKELY,  # 'Ż'
        24: SequenceLikelihood.UNLIKELY,  # 'ż'
    },
    4: {  # 'l'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        46: SequenceLikelihood.UNLIKELY,  # 'C'
        36: SequenceLikelihood.UNLIKELY,  # 'D'
        32: SequenceLikelihood.UNLIKELY,  # 'E'
        40: SequenceLikelihood.UNLIKELY,  # 'F'
        44: SequenceLikelihood.UNLIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        29: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        33: SequenceLikelihood.UNLIKELY,  # 'K'
        37: SequenceLikelihood.UNLIKELY,  # 'L'
        30: SequenceLikelihood.UNLIKELY,  # 'M'
        45: SequenceLikelihood.UNLIKELY,  # 'N'
        48: SequenceLikelihood.UNLIKELY,  # 'O'
        35: SequenceLikelihood.UNLIKELY,  # 'P'
        53: SequenceLikelihood.UNLIKELY,  # 'Q'
        42: SequenceLikelihood.UNLIKELY,  # 'R'
        34: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        39: SequenceLikelihood.UNLIKELY,  # 'U'
        52: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        60: SequenceLikelihood.UNLIKELY,  # 'Y'
        59: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        17: SequenceLikelihood.POSITIVE,  # 'b'
        41: SequenceLikelihood.LIKELY,  # 'c'
        14: SequenceLikelihood.POSITIVE,  # 'd'
        5: SequenceLikelihood.POSITIVE,  # 'e'
        19: SequenceLikelihood.POSITIVE,  # 'f'
        18: SequenceLikelihood.POSITIVE,  # 'g'
        23: SequenceLikelihood.POSITIVE,  # 'h'
        1: SequenceLikelihood.POSITIVE,  # 'i'
        11: SequenceLikelihood.POSITIVE,  # 'j'
        13: SequenceLikelihood.POSITIVE,  # 'k'
        4: SequenceLikelihood.POSITIVE,  # 'l'
        12: SequenceLikelihood.POSITIVE,  # 'm'
        6: SequenceLikelihood.POSITIVE,  # 'n'
        9: SequenceLikelihood.POSITIVE,  # 'o'
        16: SequenceLikelihood.LIKELY,  # 'p'
        26: SequenceLikelihood.POSITIVE,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        10: SequenceLikelihood.POSITIVE,  # 's'
        3: SequenceLikelihood.POSITIVE,  # 't'
        8: SequenceLikelihood.POSITIVE,  # 'u'
        27: SequenceLikelihood.POSITIVE,  # 'v'
        21: SequenceLikelihood.POSITIVE,  # 'w'
        25: SequenceLikelihood.LIKELY,  # 'x'
        51: SequenceLikelihood.LIKELY,  # 'y'
        20: SequenceLikelihood.LIKELY,  # 'z'
        57: SequenceLikelihood.UNLIKELY,  # 'Ċ'
        28: SequenceLikelihood.UNLIKELY,  # 'ċ'
        49: SequenceLikelihood.UNLIKELY,  # 'Ġ'
        22: SequenceLikelihood.LIKELY,  # 'ġ'
        55: SequenceLikelihood.UNLIKELY,  # 'Ħ'
        15: SequenceLikelihood.POSITIVE,  # 'ħ'
        58: SequenceLikelihood.UNLIKELY,  # 'Ż'
        24: SequenceLikelihood.UNLIKELY,  # 'ż'
    },
    12: {  # 'm'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        46: SequenceLikelihood.UNLIKELY,  # 'C'
        36: SequenceLikelihood.UNLIKELY,  # 'D'
        32: SequenceLikelihood.UNLIKELY,  # 'E'
        40: SequenceLikelihood.UNLIKELY,  # 'F'
        44: SequenceLikelihood.UNLIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        29: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        33: SequenceLikelihood.UNLIKELY,  # 'K'
        37: SequenceLikelihood.UNLIKELY,  # 'L'
        30: SequenceLikelihood.UNLIKELY,  # 'M'
        45: SequenceLikelihood.UNLIKELY,  # 'N'
        48: SequenceLikelihood.UNLIKELY,  # 'O'
        35: SequenceLikelihood.UNLIKELY,  # 'P'
        53: SequenceLikelihood.UNLIKELY,  # 'Q'
        42: SequenceLikelihood.UNLIKELY,  # 'R'
        34: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        39: SequenceLikelihood.UNLIKELY,  # 'U'
        52: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        60: SequenceLikelihood.UNLIKELY,  # 'Y'
        59: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        17: SequenceLikelihood.POSITIVE,  # 'b'
        41: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.LIKELY,  # 'd'
        5: SequenceLikelihood.POSITIVE,  # 'e'
        19: SequenceLikelihood.LIKELY,  # 'f'
        18: SequenceLikelihood.POSITIVE,  # 'g'
        23: SequenceLikelihood.POSITIVE,  # 'h'
        1: SequenceLikelihood.POSITIVE,  # 'i'
        11: SequenceLikelihood.LIKELY,  # 'j'
        13: SequenceLikelihood.POSITIVE,  # 'k'
        4: SequenceLikelihood.POSITIVE,  # 'l'
        12: SequenceLikelihood.POSITIVE,  # 'm'
        6: SequenceLikelihood.LIKELY,  # 'n'
        9: SequenceLikelihood.POSITIVE,  # 'o'
        16: SequenceLikelihood.POSITIVE,  # 'p'
        26: SequenceLikelihood.LIKELY,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        10: SequenceLikelihood.POSITIVE,  # 's'
        3: SequenceLikelihood.LIKELY,  # 't'
        8: SequenceLikelihood.POSITIVE,  # 'u'
        27: SequenceLikelihood.UNLIKELY,  # 'v'
        21: SequenceLikelihood.LIKELY,  # 'w'
        25: SequenceLikelihood.POSITIVE,  # 'x'
        51: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        57: SequenceLikelihood.NEGATIVE,  # 'Ċ'
        28: SequenceLikelihood.UNLIKELY,  # 'ċ'
        49: SequenceLikelihood.UNLIKELY,  # 'Ġ'
        22: SequenceLikelihood.LIKELY,  # 'ġ'
        55: SequenceLikelihood.UNLIKELY,  # 'Ħ'
        15: SequenceLikelihood.POSITIVE,  # 'ħ'
        58: SequenceLikelihood.UNLIKELY,  # 'Ż'
        24: SequenceLikelihood.UNLIKELY,  # 'ż'
    },
    6: {  # 'n'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        46: SequenceLikelihood.UNLIKELY,  # 'C'
        36: SequenceLikelihood.UNLIKELY,  # 'D'
        32: SequenceLikelihood.UNLIKELY,  # 'E'
        40: SequenceLikelihood.UNLIKELY,  # 'F'
        44: SequenceLikelihood.UNLIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        29: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        33: SequenceLikelihood.UNLIKELY,  # 'K'
        37: SequenceLikelihood.UNLIKELY,  # 'L'
        30: SequenceLikelihood.UNLIKELY,  # 'M'
        45: SequenceLikelihood.UNLIKELY,  # 'N'
        48: SequenceLikelihood.UNLIKELY,  # 'O'
        35: SequenceLikelihood.UNLIKELY,  # 'P'
        53: SequenceLikelihood.UNLIKELY,  # 'Q'
        42: SequenceLikelihood.UNLIKELY,  # 'R'
        34: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        39: SequenceLikelihood.UNLIKELY,  # 'U'
        52: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        60: SequenceLikelihood.UNLIKELY,  # 'Y'
        59: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        17: SequenceLikelihood.POSITIVE,  # 'b'
        41: SequenceLikelihood.POSITIVE,  # 'c'
        14: SequenceLikelihood.POSITIVE,  # 'd'
        5: SequenceLikelihood.POSITIVE,  # 'e'
        19: SequenceLikelihood.POSITIVE,  # 'f'
        18: SequenceLikelihood.POSITIVE,  # 'g'
        23: SequenceLikelihood.POSITIVE,  # 'h'
        1: SequenceLikelihood.POSITIVE,  # 'i'
        11: SequenceLikelihood.POSITIVE,  # 'j'
        13: SequenceLikelihood.POSITIVE,  # 'k'
        4: SequenceLikelihood.LIKELY,  # 'l'
        12: SequenceLikelihood.LIKELY,  # 'm'
        6: SequenceLikelihood.POSITIVE,  # 'n'
        9: SequenceLikelihood.POSITIVE,  # 'o'
        16: SequenceLikelihood.LIKELY,  # 'p'
        26: SequenceLikelihood.POSITIVE,  # 'q'
        7: SequenceLikelihood.LIKELY,  # 'r'
        10: SequenceLikelihood.POSITIVE,  # 's'
        3: SequenceLikelihood.POSITIVE,  # 't'
        8: SequenceLikelihood.POSITIVE,  # 'u'
        27: SequenceLikelihood.POSITIVE,  # 'v'
        21: SequenceLikelihood.POSITIVE,  # 'w'
        25: SequenceLikelihood.POSITIVE,  # 'x'
        51: SequenceLikelihood.LIKELY,  # 'y'
        20: SequenceLikelihood.POSITIVE,  # 'z'
        57: SequenceLikelihood.UNLIKELY,  # 'Ċ'
        28: SequenceLikelihood.POSITIVE,  # 'ċ'
        49: SequenceLikelihood.UNLIKELY,  # 'Ġ'
        22: SequenceLikelihood.POSITIVE,  # 'ġ'
        55: SequenceLikelihood.UNLIKELY,  # 'Ħ'
        15: SequenceLikelihood.POSITIVE,  # 'ħ'
        58: SequenceLikelihood.UNLIKELY,  # 'Ż'
        24: SequenceLikelihood.POSITIVE,  # 'ż'
    },
    9: {  # 'o'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        46: SequenceLikelihood.UNLIKELY,  # 'C'
        36: SequenceLikelihood.UNLIKELY,  # 'D'
        32: SequenceLikelihood.UNLIKELY,  # 'E'
        40: SequenceLikelihood.UNLIKELY,  # 'F'
        44: SequenceLikelihood.UNLIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        29: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        33: SequenceLikelihood.UNLIKELY,  # 'K'
        37: SequenceLikelihood.UNLIKELY,  # 'L'
        30: SequenceLikelihood.UNLIKELY,  # 'M'
        45: SequenceLikelihood.UNLIKELY,  # 'N'
        48: SequenceLikelihood.UNLIKELY,  # 'O'
        35: SequenceLikelihood.UNLIKELY,  # 'P'
        53: SequenceLikelihood.UNLIKELY,  # 'Q'
        42: SequenceLikelihood.UNLIKELY,  # 'R'
        34: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        39: SequenceLikelihood.UNLIKELY,  # 'U'
        52: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        60: SequenceLikelihood.UNLIKELY,  # 'Y'
        59: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.LIKELY,  # 'a'
        17: SequenceLikelihood.POSITIVE,  # 'b'
        41: SequenceLikelihood.LIKELY,  # 'c'
        14: SequenceLikelihood.POSITIVE,  # 'd'
        5: SequenceLikelihood.LIKELY,  # 'e'
        19: SequenceLikelihood.POSITIVE,  # 'f'
        18: SequenceLikelihood.POSITIVE,  # 'g'
        23: SequenceLikelihood.LIKELY,  # 'h'
        1: SequenceLikelihood.LIKELY,  # 'i'
        11: SequenceLikelihood.LIKELY,  # 'j'
        13: SequenceLikelihood.POSITIVE,  # 'k'
        4: SequenceLikelihood.POSITIVE,  # 'l'
        12: SequenceLikelihood.POSITIVE,  # 'm'
        6: SequenceLikelihood.POSITIVE,  # 'n'
        9: SequenceLikelihood.POSITIVE,  # 'o'
        16: SequenceLikelihood.POSITIVE,  # 'p'
        26: SequenceLikelihood.POSITIVE,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        10: SequenceLikelihood.POSITIVE,  # 's'
        3: SequenceLikelihood.POSITIVE,  # 't'
        8: SequenceLikelihood.POSITIVE,  # 'u'
        27: SequenceLikelihood.POSITIVE,  # 'v'
        21: SequenceLikelihood.POSITIVE,  # 'w'
        25: SequenceLikelihood.POSITIVE,  # 'x'
        51: SequenceLikelihood.LIKELY,  # 'y'
        20: SequenceLikelihood.POSITIVE,  # 'z'
        57: SequenceLikelihood.UNLIKELY,  # 'Ċ'
        28: SequenceLikelihood.POSITIVE,  # 'ċ'
        49: SequenceLikelihood.UNLIKELY,  # 'Ġ'
        22: SequenceLikelihood.POSITIVE,  # 'ġ'
        55: SequenceLikelihood.UNLIKELY,  # 'Ħ'
        15: SequenceLikelihood.POSITIVE,  # 'ħ'
        58: SequenceLikelihood.NEGATIVE,  # 'Ż'
        24: SequenceLikelihood.POSITIVE,  # 'ż'
    },
    16: {  # 'p'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        46: SequenceLikelihood.UNLIKELY,  # 'C'
        36: SequenceLikelihood.UNLIKELY,  # 'D'
        32: SequenceLikelihood.UNLIKELY,  # 'E'
        40: SequenceLikelihood.UNLIKELY,  # 'F'
        44: SequenceLikelihood.UNLIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        29: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        33: SequenceLikelihood.UNLIKELY,  # 'K'
        37: SequenceLikelihood.UNLIKELY,  # 'L'
        30: SequenceLikelihood.UNLIKELY,  # 'M'
        45: SequenceLikelihood.UNLIKELY,  # 'N'
        48: SequenceLikelihood.UNLIKELY,  # 'O'
        35: SequenceLikelihood.UNLIKELY,  # 'P'
        53: SequenceLikelihood.UNLIKELY,  # 'Q'
        42: SequenceLikelihood.UNLIKELY,  # 'R'
        34: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        39: SequenceLikelihood.UNLIKELY,  # 'U'
        52: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        60: SequenceLikelihood.UNLIKELY,  # 'Y'
        59: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        17: SequenceLikelihood.UNLIKELY,  # 'b'
        41: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.POSITIVE,  # 'e'
        19: SequenceLikelihood.UNLIKELY,  # 'f'
        18: SequenceLikelihood.UNLIKELY,  # 'g'
        23: SequenceLikelihood.LIKELY,  # 'h'
        1: SequenceLikelihood.POSITIVE,  # 'i'
        11: SequenceLikelihood.POSITIVE,  # 'j'
        13: SequenceLikelihood.UNLIKELY,  # 'k'
        4: SequenceLikelihood.POSITIVE,  # 'l'
        12: SequenceLikelihood.LIKELY,  # 'm'
        6: SequenceLikelihood.UNLIKELY,  # 'n'
        9: SequenceLikelihood.POSITIVE,  # 'o'
        16: SequenceLikelihood.POSITIVE,  # 'p'
        26: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        10: SequenceLikelihood.LIKELY,  # 's'
        3: SequenceLikelihood.LIKELY,  # 't'
        8: SequenceLikelihood.POSITIVE,  # 'u'
        27: SequenceLikelihood.UNLIKELY,  # 'v'
        21: SequenceLikelihood.UNLIKELY,  # 'w'
        25: SequenceLikelihood.UNLIKELY,  # 'x'
        51: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        57: SequenceLikelihood.NEGATIVE,  # 'Ċ'
        28: SequenceLikelihood.UNLIKELY,  # 'ċ'
        49: SequenceLikelihood.UNLIKELY,  # 'Ġ'
        22: SequenceLikelihood.UNLIKELY,  # 'ġ'
        55: SequenceLikelihood.UNLIKELY,  # 'Ħ'
        15: SequenceLikelihood.UNLIKELY,  # 'ħ'
        58: SequenceLikelihood.NEGATIVE,  # 'Ż'
        24: SequenceLikelihood.UNLIKELY,  # 'ż'
    },
    26: {  # 'q'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        46: SequenceLikelihood.UNLIKELY,  # 'C'
        36: SequenceLikelihood.UNLIKELY,  # 'D'
        32: SequenceLikelihood.UNLIKELY,  # 'E'
        40: SequenceLikelihood.UNLIKELY,  # 'F'
        44: SequenceLikelihood.UNLIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        29: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        33: SequenceLikelihood.UNLIKELY,  # 'K'
        37: SequenceLikelihood.UNLIKELY,  # 'L'
        30: SequenceLikelihood.UNLIKELY,  # 'M'
        45: SequenceLikelihood.UNLIKELY,  # 'N'
        48: SequenceLikelihood.UNLIKELY,  # 'O'
        35: SequenceLikelihood.UNLIKELY,  # 'P'
        53: SequenceLikelihood.UNLIKELY,  # 'Q'
        42: SequenceLikelihood.UNLIKELY,  # 'R'
        34: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        39: SequenceLikelihood.UNLIKELY,  # 'U'
        52: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        60: SequenceLikelihood.UNLIKELY,  # 'Y'
        59: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        17: SequenceLikelihood.POSITIVE,  # 'b'
        41: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.LIKELY,  # 'd'
        5: SequenceLikelihood.POSITIVE,  # 'e'
        19: SequenceLikelihood.LIKELY,  # 'f'
        18: SequenceLikelihood.POSITIVE,  # 'g'
        23: SequenceLikelihood.LIKELY,  # 'h'
        1: SequenceLikelihood.POSITIVE,  # 'i'
        11: SequenceLikelihood.LIKELY,  # 'j'
        13: SequenceLikelihood.UNLIKELY,  # 'k'
        4: SequenceLikelihood.LIKELY,  # 'l'
        12: SequenceLikelihood.UNLIKELY,  # 'm'
        6: SequenceLikelihood.LIKELY,  # 'n'
        9: SequenceLikelihood.POSITIVE,  # 'o'
        16: SequenceLikelihood.UNLIKELY,  # 'p'
        26: SequenceLikelihood.POSITIVE,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        10: SequenceLikelihood.POSITIVE,  # 's'
        3: SequenceLikelihood.POSITIVE,  # 't'
        8: SequenceLikelihood.POSITIVE,  # 'u'
        27: SequenceLikelihood.UNLIKELY,  # 'v'
        21: SequenceLikelihood.LIKELY,  # 'w'
        25: SequenceLikelihood.LIKELY,  # 'x'
        51: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        57: SequenceLikelihood.NEGATIVE,  # 'Ċ'
        28: SequenceLikelihood.UNLIKELY,  # 'ċ'
        49: SequenceLikelihood.NEGATIVE,  # 'Ġ'
        22: SequenceLikelihood.UNLIKELY,  # 'ġ'
        55: SequenceLikelihood.UNLIKELY,  # 'Ħ'
        15: SequenceLikelihood.UNLIKELY,  # 'ħ'
        58: SequenceLikelihood.NEGATIVE,  # 'Ż'
        24: SequenceLikelihood.UNLIKELY,  # 'ż'
    },
    7: {  # 'r'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        46: SequenceLikelihood.UNLIKELY,  # 'C'
        36: SequenceLikelihood.UNLIKELY,  # 'D'
        32: SequenceLikelihood.UNLIKELY,  # 'E'
        40: SequenceLikelihood.UNLIKELY,  # 'F'
        44: SequenceLikelihood.UNLIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        29: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        33: SequenceLikelihood.UNLIKELY,  # 'K'
        37: SequenceLikelihood.UNLIKELY,  # 'L'
        30: SequenceLikelihood.UNLIKELY,  # 'M'
        45: SequenceLikelihood.UNLIKELY,  # 'N'
        48: SequenceLikelihood.UNLIKELY,  # 'O'
        35: SequenceLikelihood.UNLIKELY,  # 'P'
        53: SequenceLikelihood.UNLIKELY,  # 'Q'
        42: SequenceLikelihood.UNLIKELY,  # 'R'
        34: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        39: SequenceLikelihood.UNLIKELY,  # 'U'
        52: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        60: SequenceLikelihood.UNLIKELY,  # 'Y'
        59: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        17: SequenceLikelihood.POSITIVE,  # 'b'
        41: SequenceLikelihood.LIKELY,  # 'c'
        14: SequenceLikelihood.POSITIVE,  # 'd'
        5: SequenceLikelihood.POSITIVE,  # 'e'
        19: SequenceLikelihood.POSITIVE,  # 'f'
        18: SequenceLikelihood.POSITIVE,  # 'g'
        23: SequenceLikelihood.LIKELY,  # 'h'
        1: SequenceLikelihood.POSITIVE,  # 'i'
        11: SequenceLikelihood.POSITIVE,  # 'j'
        13: SequenceLikelihood.POSITIVE,  # 'k'
        4: SequenceLikelihood.POSITIVE,  # 'l'
        12: SequenceLikelihood.POSITIVE,  # 'm'
        6: SequenceLikelihood.POSITIVE,  # 'n'
        9: SequenceLikelihood.POSITIVE,  # 'o'
        16: SequenceLikelihood.POSITIVE,  # 'p'
        26: SequenceLikelihood.LIKELY,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        10: SequenceLikelihood.POSITIVE,  # 's'
        3: SequenceLikelihood.POSITIVE,  # 't'
        8: SequenceLikelihood.POSITIVE,  # 'u'
        27: SequenceLikelihood.POSITIVE,  # 'v'
        21: SequenceLikelihood.LIKELY,  # 'w'
        25: SequenceLikelihood.LIKELY,  # 'x'
        51: SequenceLikelihood.LIKELY,  # 'y'
        20: SequenceLikelihood.POSITIVE,  # 'z'
        57: SequenceLikelihood.NEGATIVE,  # 'Ċ'
        28: SequenceLikelihood.POSITIVE,  # 'ċ'
        49: SequenceLikelihood.NEGATIVE,  # 'Ġ'
        22: SequenceLikelihood.POSITIVE,  # 'ġ'
        55: SequenceLikelihood.UNLIKELY,  # 'Ħ'
        15: SequenceLikelihood.LIKELY,  # 'ħ'
        58: SequenceLikelihood.UNLIKELY,  # 'Ż'
        24: SequenceLikelihood.LIKELY,  # 'ż'
    },
    10: {  # 's'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        46: SequenceLikelihood.UNLIKELY,  # 'C'
        36: SequenceLikelihood.UNLIKELY,  # 'D'
        32: SequenceLikelihood.UNLIKELY,  # 'E'
        40: SequenceLikelihood.UNLIKELY,  # 'F'
        44: SequenceLikelihood.UNLIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        29: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        33: SequenceLikelihood.UNLIKELY,  # 'K'
        37: SequenceLikelihood.UNLIKELY,  # 'L'
        30: SequenceLikelihood.UNLIKELY,  # 'M'
        45: SequenceLikelihood.UNLIKELY,  # 'N'
        48: SequenceLikelihood.UNLIKELY,  # 'O'
        35: SequenceLikelihood.UNLIKELY,  # 'P'
        53: SequenceLikelihood.UNLIKELY,  # 'Q'
        42: SequenceLikelihood.UNLIKELY,  # 'R'
        34: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        39: SequenceLikelihood.UNLIKELY,  # 'U'
        52: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        60: SequenceLikelihood.UNLIKELY,  # 'Y'
        59: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        17: SequenceLikelihood.POSITIVE,  # 'b'
        41: SequenceLikelihood.LIKELY,  # 'c'
        14: SequenceLikelihood.LIKELY,  # 'd'
        5: SequenceLikelihood.POSITIVE,  # 'e'
        19: SequenceLikelihood.POSITIVE,  # 'f'
        18: SequenceLikelihood.LIKELY,  # 'g'
        23: SequenceLikelihood.POSITIVE,  # 'h'
        1: SequenceLikelihood.POSITIVE,  # 'i'
        11: SequenceLikelihood.POSITIVE,  # 'j'
        13: SequenceLikelihood.POSITIVE,  # 'k'
        4: SequenceLikelihood.POSITIVE,  # 'l'
        12: SequenceLikelihood.POSITIVE,  # 'm'
        6: SequenceLikelihood.POSITIVE,  # 'n'
        9: SequenceLikelihood.POSITIVE,  # 'o'
        16: SequenceLikelihood.POSITIVE,  # 'p'
        26: SequenceLikelihood.POSITIVE,  # 'q'
        7: SequenceLikelihood.LIKELY,  # 'r'
        10: SequenceLikelihood.POSITIVE,  # 's'
        3: SequenceLikelihood.POSITIVE,  # 't'
        8: SequenceLikelihood.POSITIVE,  # 'u'
        27: SequenceLikelihood.LIKELY,  # 'v'
        21: SequenceLikelihood.POSITIVE,  # 'w'
        25: SequenceLikelihood.LIKELY,  # 'x'
        51: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        57: SequenceLikelihood.UNLIKELY,  # 'Ċ'
        28: SequenceLikelihood.UNLIKELY,  # 'ċ'
        49: SequenceLikelihood.UNLIKELY,  # 'Ġ'
        22: SequenceLikelihood.UNLIKELY,  # 'ġ'
        55: SequenceLikelihood.UNLIKELY,  # 'Ħ'
        15: SequenceLikelihood.POSITIVE,  # 'ħ'
        58: SequenceLikelihood.UNLIKELY,  # 'Ż'
        24: SequenceLikelihood.UNLIKELY,  # 'ż'
    },
    3: {  # 't'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        46: SequenceLikelihood.UNLIKELY,  # 'C'
        36: SequenceLikelihood.UNLIKELY,  # 'D'
        32: SequenceLikelihood.UNLIKELY,  # 'E'
        40: SequenceLikelihood.UNLIKELY,  # 'F'
        44: SequenceLikelihood.UNLIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        29: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        33: SequenceLikelihood.UNLIKELY,  # 'K'
        37: SequenceLikelihood.UNLIKELY,  # 'L'
        30: SequenceLikelihood.UNLIKELY,  # 'M'
        45: SequenceLikelihood.UNLIKELY,  # 'N'
        48: SequenceLikelihood.UNLIKELY,  # 'O'
        35: SequenceLikelihood.UNLIKELY,  # 'P'
        53: SequenceLikelihood.UNLIKELY,  # 'Q'
        42: SequenceLikelihood.UNLIKELY,  # 'R'
        34: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        39: SequenceLikelihood.UNLIKELY,  # 'U'
        52: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        60: SequenceLikelihood.UNLIKELY,  # 'Y'
        59: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        17: SequenceLikelihood.POSITIVE,  # 'b'
        41: SequenceLikelihood.LIKELY,  # 'c'
        14: SequenceLikelihood.LIKELY,  # 'd'
        5: SequenceLikelihood.POSITIVE,  # 'e'
        19: SequenceLikelihood.POSITIVE,  # 'f'
        18: SequenceLikelihood.POSITIVE,  # 'g'
        23: SequenceLikelihood.POSITIVE,  # 'h'
        1: SequenceLikelihood.POSITIVE,  # 'i'
        11: SequenceLikelihood.POSITIVE,  # 'j'
        13: SequenceLikelihood.POSITIVE,  # 'k'
        4: SequenceLikelihood.POSITIVE,  # 'l'
        12: SequenceLikelihood.POSITIVE,  # 'm'
        6: SequenceLikelihood.POSITIVE,  # 'n'
        9: SequenceLikelihood.POSITIVE,  # 'o'
        16: SequenceLikelihood.LIKELY,  # 'p'
        26: SequenceLikelihood.POSITIVE,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        10: SequenceLikelihood.POSITIVE,  # 's'
        3: SequenceLikelihood.POSITIVE,  # 't'
        8: SequenceLikelihood.POSITIVE,  # 'u'
        27: SequenceLikelihood.LIKELY,  # 'v'
        21: SequenceLikelihood.POSITIVE,  # 'w'
        25: SequenceLikelihood.POSITIVE,  # 'x'
        51: SequenceLikelihood.LIKELY,  # 'y'
        20: SequenceLikelihood.LIKELY,  # 'z'
        57: SequenceLikelihood.UNLIKELY,  # 'Ċ'
        28: SequenceLikelihood.UNLIKELY,  # 'ċ'
        49: SequenceLikelihood.UNLIKELY,  # 'Ġ'
        22: SequenceLikelihood.UNLIKELY,  # 'ġ'
        55: SequenceLikelihood.UNLIKELY,  # 'Ħ'
        15: SequenceLikelihood.POSITIVE,  # 'ħ'
        58: SequenceLikelihood.UNLIKELY,  # 'Ż'
        24: SequenceLikelihood.UNLIKELY,  # 'ż'
    },
    8: {  # 'u'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        46: SequenceLikelihood.UNLIKELY,  # 'C'
        36: SequenceLikelihood.UNLIKELY,  # 'D'
        32: SequenceLikelihood.UNLIKELY,  # 'E'
        40: SequenceLikelihood.UNLIKELY,  # 'F'
        44: SequenceLikelihood.UNLIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        29: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        33: SequenceLikelihood.UNLIKELY,  # 'K'
        37: SequenceLikelihood.UNLIKELY,  # 'L'
        30: SequenceLikelihood.UNLIKELY,  # 'M'
        45: SequenceLikelihood.UNLIKELY,  # 'N'
        48: SequenceLikelihood.UNLIKELY,  # 'O'
        35: SequenceLikelihood.UNLIKELY,  # 'P'
        53: SequenceLikelihood.UNLIKELY,  # 'Q'
        42: SequenceLikelihood.UNLIKELY,  # 'R'
        34: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        39: SequenceLikelihood.UNLIKELY,  # 'U'
        52: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        60: SequenceLikelihood.UNLIKELY,  # 'Y'
        59: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.LIKELY,  # 'a'
        17: SequenceLikelihood.POSITIVE,  # 'b'
        41: SequenceLikelihood.LIKELY,  # 'c'
        14: SequenceLikelihood.POSITIVE,  # 'd'
        5: SequenceLikelihood.LIKELY,  # 'e'
        19: SequenceLikelihood.POSITIVE,  # 'f'
        18: SequenceLikelihood.POSITIVE,  # 'g'
        23: SequenceLikelihood.POSITIVE,  # 'h'
        1: SequenceLikelihood.LIKELY,  # 'i'
        11: SequenceLikelihood.UNLIKELY,  # 'j'
        13: SequenceLikelihood.POSITIVE,  # 'k'
        4: SequenceLikelihood.POSITIVE,  # 'l'
        12: SequenceLikelihood.POSITIVE,  # 'm'
        6: SequenceLikelihood.POSITIVE,  # 'n'
        9: SequenceLikelihood.UNLIKELY,  # 'o'
        16: SequenceLikelihood.POSITIVE,  # 'p'
        26: SequenceLikelihood.POSITIVE,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        10: SequenceLikelihood.POSITIVE,  # 's'
        3: SequenceLikelihood.POSITIVE,  # 't'
        8: SequenceLikelihood.UNLIKELY,  # 'u'
        27: SequenceLikelihood.LIKELY,  # 'v'
        21: SequenceLikelihood.POSITIVE,  # 'w'
        25: SequenceLikelihood.POSITIVE,  # 'x'
        51: SequenceLikelihood.LIKELY,  # 'y'
        20: SequenceLikelihood.POSITIVE,  # 'z'
        57: SequenceLikelihood.UNLIKELY,  # 'Ċ'
        28: SequenceLikelihood.POSITIVE,  # 'ċ'
        49: SequenceLikelihood.UNLIKELY,  # 'Ġ'
        22: SequenceLikelihood.POSITIVE,  # 'ġ'
        55: SequenceLikelihood.UNLIKELY,  # 'Ħ'
        15: SequenceLikelihood.POSITIVE,  # 'ħ'
        58: SequenceLikelihood.UNLIKELY,  # 'Ż'
        24: SequenceLikelihood.POSITIVE,  # 'ż'
    },
    27: {  # 'v'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        46: SequenceLikelihood.UNLIKELY,  # 'C'
        36: SequenceLikelihood.UNLIKELY,  # 'D'
        32: SequenceLikelihood.UNLIKELY,  # 'E'
        40: SequenceLikelihood.UNLIKELY,  # 'F'
        44: SequenceLikelihood.UNLIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        29: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        33: SequenceLikelihood.UNLIKELY,  # 'K'
        37: SequenceLikelihood.UNLIKELY,  # 'L'
        30: SequenceLikelihood.UNLIKELY,  # 'M'
        45: SequenceLikelihood.UNLIKELY,  # 'N'
        48: SequenceLikelihood.UNLIKELY,  # 'O'
        35: SequenceLikelihood.UNLIKELY,  # 'P'
        53: SequenceLikelihood.UNLIKELY,  # 'Q'
        42: SequenceLikelihood.UNLIKELY,  # 'R'
        34: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        39: SequenceLikelihood.UNLIKELY,  # 'U'
        52: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        60: SequenceLikelihood.UNLIKELY,  # 'Y'
        59: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        17: SequenceLikelihood.UNLIKELY,  # 'b'
        41: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.POSITIVE,  # 'd'
        5: SequenceLikelihood.POSITIVE,  # 'e'
        19: SequenceLikelihood.UNLIKELY,  # 'f'
        18: SequenceLikelihood.UNLIKELY,  # 'g'
        23: SequenceLikelihood.UNLIKELY,  # 'h'
        1: SequenceLikelihood.POSITIVE,  # 'i'
        11: SequenceLikelihood.POSITIVE,  # 'j'
        13: SequenceLikelihood.UNLIKELY,  # 'k'
        4: SequenceLikelihood.UNLIKELY,  # 'l'
        12: SequenceLikelihood.UNLIKELY,  # 'm'
        6: SequenceLikelihood.UNLIKELY,  # 'n'
        9: SequenceLikelihood.POSITIVE,  # 'o'
        16: SequenceLikelihood.UNLIKELY,  # 'p'
        26: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.LIKELY,  # 'r'
        10: SequenceLikelihood.LIKELY,  # 's'
        3: SequenceLikelihood.UNLIKELY,  # 't'
        8: SequenceLikelihood.POSITIVE,  # 'u'
        27: SequenceLikelihood.POSITIVE,  # 'v'
        21: SequenceLikelihood.UNLIKELY,  # 'w'
        25: SequenceLikelihood.UNLIKELY,  # 'x'
        51: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        57: SequenceLikelihood.NEGATIVE,  # 'Ċ'
        28: SequenceLikelihood.UNLIKELY,  # 'ċ'
        49: SequenceLikelihood.NEGATIVE,  # 'Ġ'
        22: SequenceLikelihood.UNLIKELY,  # 'ġ'
        55: SequenceLikelihood.NEGATIVE,  # 'Ħ'
        15: SequenceLikelihood.NEGATIVE,  # 'ħ'
        58: SequenceLikelihood.NEGATIVE,  # 'Ż'
        24: SequenceLikelihood.UNLIKELY,  # 'ż'
    },
    21: {  # 'w'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        46: SequenceLikelihood.UNLIKELY,  # 'C'
        36: SequenceLikelihood.UNLIKELY,  # 'D'
        32: SequenceLikelihood.UNLIKELY,  # 'E'
        40: SequenceLikelihood.UNLIKELY,  # 'F'
        44: SequenceLikelihood.UNLIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        29: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        33: SequenceLikelihood.UNLIKELY,  # 'K'
        37: SequenceLikelihood.UNLIKELY,  # 'L'
        30: SequenceLikelihood.UNLIKELY,  # 'M'
        45: SequenceLikelihood.UNLIKELY,  # 'N'
        48: SequenceLikelihood.UNLIKELY,  # 'O'
        35: SequenceLikelihood.UNLIKELY,  # 'P'
        53: SequenceLikelihood.UNLIKELY,  # 'Q'
        42: SequenceLikelihood.UNLIKELY,  # 'R'
        34: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        39: SequenceLikelihood.UNLIKELY,  # 'U'
        52: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        60: SequenceLikelihood.UNLIKELY,  # 'Y'
        59: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        17: SequenceLikelihood.UNLIKELY,  # 'b'
        41: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.POSITIVE,  # 'd'
        5: SequenceLikelihood.POSITIVE,  # 'e'
        19: SequenceLikelihood.UNLIKELY,  # 'f'
        18: SequenceLikelihood.LIKELY,  # 'g'
        23: SequenceLikelihood.LIKELY,  # 'h'
        1: SequenceLikelihood.POSITIVE,  # 'i'
        11: SequenceLikelihood.UNLIKELY,  # 'j'
        13: SequenceLikelihood.POSITIVE,  # 'k'
        4: SequenceLikelihood.POSITIVE,  # 'l'
        12: SequenceLikelihood.LIKELY,  # 'm'
        6: SequenceLikelihood.POSITIVE,  # 'n'
        9: SequenceLikelihood.POSITIVE,  # 'o'
        16: SequenceLikelihood.UNLIKELY,  # 'p'
        26: SequenceLikelihood.LIKELY,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        10: SequenceLikelihood.POSITIVE,  # 's'
        3: SequenceLikelihood.POSITIVE,  # 't'
        8: SequenceLikelihood.LIKELY,  # 'u'
        27: SequenceLikelihood.UNLIKELY,  # 'v'
        21: SequenceLikelihood.POSITIVE,  # 'w'
        25: SequenceLikelihood.LIKELY,  # 'x'
        51: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        57: SequenceLikelihood.NEGATIVE,  # 'Ċ'
        28: SequenceLikelihood.UNLIKELY,  # 'ċ'
        49: SequenceLikelihood.NEGATIVE,  # 'Ġ'
        22: SequenceLikelihood.POSITIVE,  # 'ġ'
        55: SequenceLikelihood.NEGATIVE,  # 'Ħ'
        15: SequenceLikelihood.LIKELY,  # 'ħ'
        58: SequenceLikelihood.UNLIKELY,  # 'Ż'
        24: SequenceLikelihood.POSITIVE,  # 'ż'
    },
    25: {  # 'x'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        46: SequenceLikelihood.UNLIKELY,  # 'C'
        36: SequenceLikelihood.UNLIKELY,  # 'D'
        32: SequenceLikelihood.UNLIKELY,  # 'E'
        40: SequenceLikelihood.UNLIKELY,  # 'F'
        44: SequenceLikelihood.UNLIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        29: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        33: SequenceLikelihood.UNLIKELY,  # 'K'
        37: SequenceLikelihood.UNLIKELY,  # 'L'
        30: SequenceLikelihood.UNLIKELY,  # 'M'
        45: SequenceLikelihood.UNLIKELY,  # 'N'
        48: SequenceLikelihood.UNLIKELY,  # 'O'
        35: SequenceLikelihood.UNLIKELY,  # 'P'
        53: SequenceLikelihood.UNLIKELY,  # 'Q'
        42: SequenceLikelihood.UNLIKELY,  # 'R'
        34: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        39: SequenceLikelihood.UNLIKELY,  # 'U'
        52: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        60: SequenceLikelihood.UNLIKELY,  # 'Y'
        59: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        17: SequenceLikelihood.LIKELY,  # 'b'
        41: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.POSITIVE,  # 'e'
        19: SequenceLikelihood.LIKELY,  # 'f'
        18: SequenceLikelihood.UNLIKELY,  # 'g'
        23: SequenceLikelihood.LIKELY,  # 'h'
        1: SequenceLikelihood.POSITIVE,  # 'i'
        11: SequenceLikelihood.LIKELY,  # 'j'
        13: SequenceLikelihood.LIKELY,  # 'k'
        4: SequenceLikelihood.UNLIKELY,  # 'l'
        12: SequenceLikelihood.UNLIKELY,  # 'm'
        6: SequenceLikelihood.UNLIKELY,  # 'n'
        9: SequenceLikelihood.POSITIVE,  # 'o'
        16: SequenceLikelihood.LIKELY,  # 'p'
        26: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.LIKELY,  # 'r'
        10: SequenceLikelihood.UNLIKELY,  # 's'
        3: SequenceLikelihood.POSITIVE,  # 't'
        8: SequenceLikelihood.POSITIVE,  # 'u'
        27: SequenceLikelihood.UNLIKELY,  # 'v'
        21: SequenceLikelihood.UNLIKELY,  # 'w'
        25: SequenceLikelihood.POSITIVE,  # 'x'
        51: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        57: SequenceLikelihood.NEGATIVE,  # 'Ċ'
        28: SequenceLikelihood.UNLIKELY,  # 'ċ'
        49: SequenceLikelihood.UNLIKELY,  # 'Ġ'
        22: SequenceLikelihood.UNLIKELY,  # 'ġ'
        55: SequenceLikelihood.NEGATIVE,  # 'Ħ'
        15: SequenceLikelihood.UNLIKELY,  # 'ħ'
        58: SequenceLikelihood.NEGATIVE,  # 'Ż'
        24: SequenceLikelihood.UNLIKELY,  # 'ż'
    },
    51: {  # 'y'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        46: SequenceLikelihood.UNLIKELY,  # 'C'
        36: SequenceLikelihood.UNLIKELY,  # 'D'
        32: SequenceLikelihood.UNLIKELY,  # 'E'
        40: SequenceLikelihood.UNLIKELY,  # 'F'
        44: SequenceLikelihood.UNLIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        29: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        33: SequenceLikelihood.UNLIKELY,  # 'K'
        37: SequenceLikelihood.UNLIKELY,  # 'L'
        30: SequenceLikelihood.UNLIKELY,  # 'M'
        45: SequenceLikelihood.UNLIKELY,  # 'N'
        48: SequenceLikelihood.UNLIKELY,  # 'O'
        35: SequenceLikelihood.UNLIKELY,  # 'P'
        53: SequenceLikelihood.UNLIKELY,  # 'Q'
        42: SequenceLikelihood.UNLIKELY,  # 'R'
        34: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        39: SequenceLikelihood.UNLIKELY,  # 'U'
        52: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        60: SequenceLikelihood.UNLIKELY,  # 'Y'
        59: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.LIKELY,  # 'a'
        17: SequenceLikelihood.UNLIKELY,  # 'b'
        41: SequenceLikelihood.LIKELY,  # 'c'
        14: SequenceLikelihood.LIKELY,  # 'd'
        5: SequenceLikelihood.LIKELY,  # 'e'
        19: SequenceLikelihood.UNLIKELY,  # 'f'
        18: SequenceLikelihood.UNLIKELY,  # 'g'
        23: SequenceLikelihood.UNLIKELY,  # 'h'
        1: SequenceLikelihood.UNLIKELY,  # 'i'
        11: SequenceLikelihood.UNLIKELY,  # 'j'
        13: SequenceLikelihood.UNLIKELY,  # 'k'
        4: SequenceLikelihood.LIKELY,  # 'l'
        12: SequenceLikelihood.LIKELY,  # 'm'
        6: SequenceLikelihood.LIKELY,  # 'n'
        9: SequenceLikelihood.LIKELY,  # 'o'
        16: SequenceLikelihood.LIKELY,  # 'p'
        26: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        10: SequenceLikelihood.LIKELY,  # 's'
        3: SequenceLikelihood.LIKELY,  # 't'
        8: SequenceLikelihood.UNLIKELY,  # 'u'
        27: SequenceLikelihood.UNLIKELY,  # 'v'
        21: SequenceLikelihood.UNLIKELY,  # 'w'
        25: SequenceLikelihood.UNLIKELY,  # 'x'
        51: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        57: SequenceLikelihood.NEGATIVE,  # 'Ċ'
        28: SequenceLikelihood.UNLIKELY,  # 'ċ'
        49: SequenceLikelihood.UNLIKELY,  # 'Ġ'
        22: SequenceLikelihood.UNLIKELY,  # 'ġ'
        55: SequenceLikelihood.NEGATIVE,  # 'Ħ'
        15: SequenceLikelihood.UNLIKELY,  # 'ħ'
        58: SequenceLikelihood.NEGATIVE,  # 'Ż'
        24: SequenceLikelihood.UNLIKELY,  # 'ż'
    },
    20: {  # 'z'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        46: SequenceLikelihood.UNLIKELY,  # 'C'
        36: SequenceLikelihood.UNLIKELY,  # 'D'
        32: SequenceLikelihood.UNLIKELY,  # 'E'
        40: SequenceLikelihood.UNLIKELY,  # 'F'
        44: SequenceLikelihood.UNLIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        29: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        33: SequenceLikelihood.UNLIKELY,  # 'K'
        37: SequenceLikelihood.UNLIKELY,  # 'L'
        30: SequenceLikelihood.UNLIKELY,  # 'M'
        45: SequenceLikelihood.UNLIKELY,  # 'N'
        48: SequenceLikelihood.UNLIKELY,  # 'O'
        35: SequenceLikelihood.UNLIKELY,  # 'P'
        53: SequenceLikelihood.UNLIKELY,  # 'Q'
        42: SequenceLikelihood.UNLIKELY,  # 'R'
        34: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        39: SequenceLikelihood.UNLIKELY,  # 'U'
        52: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.NEGATIVE,  # 'W'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        60: SequenceLikelihood.UNLIKELY,  # 'Y'
        59: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        17: SequenceLikelihood.UNLIKELY,  # 'b'
        41: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.LIKELY,  # 'e'
        19: SequenceLikelihood.UNLIKELY,  # 'f'
        18: SequenceLikelihood.UNLIKELY,  # 'g'
        23: SequenceLikelihood.UNLIKELY,  # 'h'
        1: SequenceLikelihood.POSITIVE,  # 'i'
        11: SequenceLikelihood.POSITIVE,  # 'j'
        13: SequenceLikelihood.UNLIKELY,  # 'k'
        4: SequenceLikelihood.UNLIKELY,  # 'l'
        12: SequenceLikelihood.UNLIKELY,  # 'm'
        6: SequenceLikelihood.UNLIKELY,  # 'n'
        9: SequenceLikelihood.LIKELY,  # 'o'
        16: SequenceLikelihood.UNLIKELY,  # 'p'
        26: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        10: SequenceLikelihood.UNLIKELY,  # 's'
        3: SequenceLikelihood.UNLIKELY,  # 't'
        8: SequenceLikelihood.LIKELY,  # 'u'
        27: SequenceLikelihood.UNLIKELY,  # 'v'
        21: SequenceLikelihood.UNLIKELY,  # 'w'
        25: SequenceLikelihood.UNLIKELY,  # 'x'
        51: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.POSITIVE,  # 'z'
        57: SequenceLikelihood.NEGATIVE,  # 'Ċ'
        28: SequenceLikelihood.NEGATIVE,  # 'ċ'
        49: SequenceLikelihood.UNLIKELY,  # 'Ġ'
        22: SequenceLikelihood.UNLIKELY,  # 'ġ'
        55: SequenceLikelihood.NEGATIVE,  # 'Ħ'
        15: SequenceLikelihood.UNLIKELY,  # 'ħ'
        58: SequenceLikelihood.NEGATIVE,  # 'Ż'
        24: SequenceLikelihood.UNLIKELY,  # 'ż'
    },
    57: {  # 'Ċ'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        43: SequenceLikelihood.NEGATIVE,  # 'B'
        46: SequenceLikelihood.NEGATIVE,  # 'C'
        36: SequenceLikelihood.UNLIKELY,  # 'D'
        32: SequenceLikelihood.LIKELY,  # 'E'
        40: SequenceLikelihood.UNLIKELY,  # 'F'
        44: SequenceLikelihood.NEGATIVE,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        29: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        33: SequenceLikelihood.UNLIKELY,  # 'K'
        37: SequenceLikelihood.UNLIKELY,  # 'L'
        30: SequenceLikelihood.UNLIKELY,  # 'M'
        45: SequenceLikelihood.UNLIKELY,  # 'N'
        48: SequenceLikelihood.UNLIKELY,  # 'O'
        35: SequenceLikelihood.UNLIKELY,  # 'P'
        53: SequenceLikelihood.NEGATIVE,  # 'Q'
        42: SequenceLikelihood.UNLIKELY,  # 'R'
        34: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        39: SequenceLikelihood.UNLIKELY,  # 'U'
        52: SequenceLikelihood.NEGATIVE,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        56: SequenceLikelihood.NEGATIVE,  # 'X'
        60: SequenceLikelihood.NEGATIVE,  # 'Y'
        59: SequenceLikelihood.NEGATIVE,  # 'Z'
        2: SequenceLikelihood.UNLIKELY,  # 'a'
        17: SequenceLikelihood.UNLIKELY,  # 'b'
        41: SequenceLikelihood.NEGATIVE,  # 'c'
        14: SequenceLikelihood.NEGATIVE,  # 'd'
        5: SequenceLikelihood.LIKELY,  # 'e'
        19: SequenceLikelihood.NEGATIVE,  # 'f'
        18: SequenceLikelihood.NEGATIVE,  # 'g'
        23: SequenceLikelihood.UNLIKELY,  # 'h'
        1: SequenceLikelihood.LIKELY,  # 'i'
        11: SequenceLikelihood.UNLIKELY,  # 'j'
        13: SequenceLikelihood.UNLIKELY,  # 'k'
        4: SequenceLikelihood.UNLIKELY,  # 'l'
        12: SequenceLikelihood.UNLIKELY,  # 'm'
        6: SequenceLikelihood.UNLIKELY,  # 'n'
        9: SequenceLikelihood.UNLIKELY,  # 'o'
        16: SequenceLikelihood.UNLIKELY,  # 'p'
        26: SequenceLikelihood.NEGATIVE,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        10: SequenceLikelihood.NEGATIVE,  # 's'
        3: SequenceLikelihood.UNLIKELY,  # 't'
        8: SequenceLikelihood.UNLIKELY,  # 'u'
        27: SequenceLikelihood.UNLIKELY,  # 'v'
        21: SequenceLikelihood.UNLIKELY,  # 'w'
        25: SequenceLikelihood.NEGATIVE,  # 'x'
        51: SequenceLikelihood.NEGATIVE,  # 'y'
        20: SequenceLikelihood.NEGATIVE,  # 'z'
        57: SequenceLikelihood.UNLIKELY,  # 'Ċ'
        28: SequenceLikelihood.UNLIKELY,  # 'ċ'
        49: SequenceLikelihood.UNLIKELY,  # 'Ġ'
        22: SequenceLikelihood.NEGATIVE,  # 'ġ'
        55: SequenceLikelihood.UNLIKELY,  # 'Ħ'
        15: SequenceLikelihood.UNLIKELY,  # 'ħ'
        58: SequenceLikelihood.UNLIKELY,  # 'Ż'
        24: SequenceLikelihood.NEGATIVE,  # 'ż'
    },
    28: {  # 'ċ'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        43: SequenceLikelihood.NEGATIVE,  # 'B'
        46: SequenceLikelihood.UNLIKELY,  # 'C'
        36: SequenceLikelihood.UNLIKELY,  # 'D'
        32: SequenceLikelihood.UNLIKELY,  # 'E'
        40: SequenceLikelihood.UNLIKELY,  # 'F'
        44: SequenceLikelihood.UNLIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        29: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        33: SequenceLikelihood.UNLIKELY,  # 'K'
        37: SequenceLikelihood.UNLIKELY,  # 'L'
        30: SequenceLikelihood.UNLIKELY,  # 'M'
        45: SequenceLikelihood.NEGATIVE,  # 'N'
        48: SequenceLikelihood.NEGATIVE,  # 'O'
        35: SequenceLikelihood.UNLIKELY,  # 'P'
        53: SequenceLikelihood.NEGATIVE,  # 'Q'
        42: SequenceLikelihood.NEGATIVE,  # 'R'
        34: SequenceLikelihood.NEGATIVE,  # 'S'
        38: SequenceLikelihood.NEGATIVE,  # 'T'
        39: SequenceLikelihood.UNLIKELY,  # 'U'
        52: SequenceLikelihood.NEGATIVE,  # 'V'
        54: SequenceLikelihood.NEGATIVE,  # 'W'
        56: SequenceLikelihood.NEGATIVE,  # 'X'
        60: SequenceLikelihood.NEGATIVE,  # 'Y'
        59: SequenceLikelihood.NEGATIVE,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        17: SequenceLikelihood.UNLIKELY,  # 'b'
        41: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.POSITIVE,  # 'e'
        19: SequenceLikelihood.UNLIKELY,  # 'f'
        18: SequenceLikelihood.UNLIKELY,  # 'g'
        23: SequenceLikelihood.UNLIKELY,  # 'h'
        1: SequenceLikelihood.POSITIVE,  # 'i'
        11: SequenceLikelihood.POSITIVE,  # 'j'
        13: SequenceLikelihood.UNLIKELY,  # 'k'
        4: SequenceLikelihood.LIKELY,  # 'l'
        12: SequenceLikelihood.UNLIKELY,  # 'm'
        6: SequenceLikelihood.UNLIKELY,  # 'n'
        9: SequenceLikelihood.UNLIKELY,  # 'o'
        16: SequenceLikelihood.UNLIKELY,  # 'p'
        26: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        10: SequenceLikelihood.UNLIKELY,  # 's'
        3: SequenceLikelihood.UNLIKELY,  # 't'
        8: SequenceLikelihood.LIKELY,  # 'u'
        27: SequenceLikelihood.UNLIKELY,  # 'v'
        21: SequenceLikelihood.UNLIKELY,  # 'w'
        25: SequenceLikelihood.NEGATIVE,  # 'x'
        51: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        57: SequenceLikelihood.UNLIKELY,  # 'Ċ'
        28: SequenceLikelihood.POSITIVE,  # 'ċ'
        49: SequenceLikelihood.NEGATIVE,  # 'Ġ'
        22: SequenceLikelihood.NEGATIVE,  # 'ġ'
        55: SequenceLikelihood.UNLIKELY,  # 'Ħ'
        15: SequenceLikelihood.LIKELY,  # 'ħ'
        58: SequenceLikelihood.NEGATIVE,  # 'Ż'
        24: SequenceLikelihood.UNLIKELY,  # 'ż'
    },
    49: {  # 'Ġ'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        46: SequenceLikelihood.NEGATIVE,  # 'C'
        36: SequenceLikelihood.UNLIKELY,  # 'D'
        32: SequenceLikelihood.UNLIKELY,  # 'E'
        40: SequenceLikelihood.UNLIKELY,  # 'F'
        44: SequenceLikelihood.UNLIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        29: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        33: SequenceLikelihood.UNLIKELY,  # 'K'
        37: SequenceLikelihood.UNLIKELY,  # 'L'
        30: SequenceLikelihood.UNLIKELY,  # 'M'
        45: SequenceLikelihood.UNLIKELY,  # 'N'
        48: SequenceLikelihood.UNLIKELY,  # 'O'
        35: SequenceLikelihood.UNLIKELY,  # 'P'
        53: SequenceLikelihood.NEGATIVE,  # 'Q'
        42: SequenceLikelihood.UNLIKELY,  # 'R'
        34: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        39: SequenceLikelihood.LIKELY,  # 'U'
        52: SequenceLikelihood.NEGATIVE,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        56: SequenceLikelihood.NEGATIVE,  # 'X'
        60: SequenceLikelihood.NEGATIVE,  # 'Y'
        59: SequenceLikelihood.NEGATIVE,  # 'Z'
        2: SequenceLikelihood.LIKELY,  # 'a'
        17: SequenceLikelihood.UNLIKELY,  # 'b'
        41: SequenceLikelihood.NEGATIVE,  # 'c'
        14: SequenceLikelihood.LIKELY,  # 'd'
        5: SequenceLikelihood.POSITIVE,  # 'e'
        19: SequenceLikelihood.NEGATIVE,  # 'f'
        18: SequenceLikelihood.UNLIKELY,  # 'g'
        23: SequenceLikelihood.UNLIKELY,  # 'h'
        1: SequenceLikelihood.LIKELY,  # 'i'
        11: SequenceLikelihood.UNLIKELY,  # 'j'
        13: SequenceLikelihood.UNLIKELY,  # 'k'
        4: SequenceLikelihood.UNLIKELY,  # 'l'
        12: SequenceLikelihood.UNLIKELY,  # 'm'
        6: SequenceLikelihood.UNLIKELY,  # 'n'
        9: SequenceLikelihood.LIKELY,  # 'o'
        16: SequenceLikelihood.NEGATIVE,  # 'p'
        26: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        10: SequenceLikelihood.UNLIKELY,  # 's'
        3: SequenceLikelihood.NEGATIVE,  # 't'
        8: SequenceLikelihood.POSITIVE,  # 'u'
        27: SequenceLikelihood.UNLIKELY,  # 'v'
        21: SequenceLikelihood.LIKELY,  # 'w'
        25: SequenceLikelihood.NEGATIVE,  # 'x'
        51: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.NEGATIVE,  # 'z'
        57: SequenceLikelihood.NEGATIVE,  # 'Ċ'
        28: SequenceLikelihood.NEGATIVE,  # 'ċ'
        49: SequenceLikelihood.UNLIKELY,  # 'Ġ'
        22: SequenceLikelihood.UNLIKELY,  # 'ġ'
        55: SequenceLikelihood.UNLIKELY,  # 'Ħ'
        15: SequenceLikelihood.UNLIKELY,  # 'ħ'
        58: SequenceLikelihood.UNLIKELY,  # 'Ż'
        24: SequenceLikelihood.UNLIKELY,  # 'ż'
    },
    22: {  # 'ġ'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        46: SequenceLikelihood.NEGATIVE,  # 'C'
        36: SequenceLikelihood.UNLIKELY,  # 'D'
        32: SequenceLikelihood.UNLIKELY,  # 'E'
        40: SequenceLikelihood.UNLIKELY,  # 'F'
        44: SequenceLikelihood.UNLIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        29: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        33: SequenceLikelihood.UNLIKELY,  # 'K'
        37: SequenceLikelihood.UNLIKELY,  # 'L'
        30: SequenceLikelihood.UNLIKELY,  # 'M'
        45: SequenceLikelihood.UNLIKELY,  # 'N'
        48: SequenceLikelihood.UNLIKELY,  # 'O'
        35: SequenceLikelihood.UNLIKELY,  # 'P'
        53: SequenceLikelihood.UNLIKELY,  # 'Q'
        42: SequenceLikelihood.UNLIKELY,  # 'R'
        34: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        39: SequenceLikelihood.UNLIKELY,  # 'U'
        52: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        56: SequenceLikelihood.NEGATIVE,  # 'X'
        60: SequenceLikelihood.NEGATIVE,  # 'Y'
        59: SequenceLikelihood.NEGATIVE,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        17: SequenceLikelihood.POSITIVE,  # 'b'
        41: SequenceLikelihood.NEGATIVE,  # 'c'
        14: SequenceLikelihood.POSITIVE,  # 'd'
        5: SequenceLikelihood.POSITIVE,  # 'e'
        19: SequenceLikelihood.UNLIKELY,  # 'f'
        18: SequenceLikelihood.LIKELY,  # 'g'
        23: SequenceLikelihood.UNLIKELY,  # 'h'
        1: SequenceLikelihood.POSITIVE,  # 'i'
        11: SequenceLikelihood.POSITIVE,  # 'j'
        13: SequenceLikelihood.UNLIKELY,  # 'k'
        4: SequenceLikelihood.LIKELY,  # 'l'
        12: SequenceLikelihood.UNLIKELY,  # 'm'
        6: SequenceLikelihood.LIKELY,  # 'n'
        9: SequenceLikelihood.POSITIVE,  # 'o'
        16: SequenceLikelihood.UNLIKELY,  # 'p'
        26: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.LIKELY,  # 'r'
        10: SequenceLikelihood.UNLIKELY,  # 's'
        3: SequenceLikelihood.UNLIKELY,  # 't'
        8: SequenceLikelihood.POSITIVE,  # 'u'
        27: SequenceLikelihood.NEGATIVE,  # 'v'
        21: SequenceLikelihood.UNLIKELY,  # 'w'
        25: SequenceLikelihood.UNLIKELY,  # 'x'
        51: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        57: SequenceLikelihood.UNLIKELY,  # 'Ċ'
        28: SequenceLikelihood.UNLIKELY,  # 'ċ'
        49: SequenceLikelihood.NEGATIVE,  # 'Ġ'
        22: SequenceLikelihood.POSITIVE,  # 'ġ'
        55: SequenceLikelihood.UNLIKELY,  # 'Ħ'
        15: SequenceLikelihood.UNLIKELY,  # 'ħ'
        58: SequenceLikelihood.UNLIKELY,  # 'Ż'
        24: SequenceLikelihood.UNLIKELY,  # 'ż'
    },
    55: {  # 'Ħ'
        31: SequenceLikelihood.LIKELY,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        46: SequenceLikelihood.NEGATIVE,  # 'C'
        36: SequenceLikelihood.UNLIKELY,  # 'D'
        32: SequenceLikelihood.UNLIKELY,  # 'E'
        40: SequenceLikelihood.UNLIKELY,  # 'F'
        44: SequenceLikelihood.UNLIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        29: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        33: SequenceLikelihood.UNLIKELY,  # 'K'
        37: SequenceLikelihood.UNLIKELY,  # 'L'
        30: SequenceLikelihood.UNLIKELY,  # 'M'
        45: SequenceLikelihood.UNLIKELY,  # 'N'
        48: SequenceLikelihood.UNLIKELY,  # 'O'
        35: SequenceLikelihood.UNLIKELY,  # 'P'
        53: SequenceLikelihood.UNLIKELY,  # 'Q'
        42: SequenceLikelihood.UNLIKELY,  # 'R'
        34: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        39: SequenceLikelihood.UNLIKELY,  # 'U'
        52: SequenceLikelihood.NEGATIVE,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        60: SequenceLikelihood.NEGATIVE,  # 'Y'
        59: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        17: SequenceLikelihood.UNLIKELY,  # 'b'
        41: SequenceLikelihood.NEGATIVE,  # 'c'
        14: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.UNLIKELY,  # 'e'
        19: SequenceLikelihood.UNLIKELY,  # 'f'
        18: SequenceLikelihood.UNLIKELY,  # 'g'
        23: SequenceLikelihood.NEGATIVE,  # 'h'
        1: SequenceLikelihood.LIKELY,  # 'i'
        11: SequenceLikelihood.UNLIKELY,  # 'j'
        13: SequenceLikelihood.NEGATIVE,  # 'k'
        4: SequenceLikelihood.UNLIKELY,  # 'l'
        12: SequenceLikelihood.UNLIKELY,  # 'm'
        6: SequenceLikelihood.UNLIKELY,  # 'n'
        9: SequenceLikelihood.UNLIKELY,  # 'o'
        16: SequenceLikelihood.NEGATIVE,  # 'p'
        26: SequenceLikelihood.NEGATIVE,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        10: SequenceLikelihood.UNLIKELY,  # 's'
        3: SequenceLikelihood.UNLIKELY,  # 't'
        8: SequenceLikelihood.UNLIKELY,  # 'u'
        27: SequenceLikelihood.NEGATIVE,  # 'v'
        21: SequenceLikelihood.UNLIKELY,  # 'w'
        25: SequenceLikelihood.UNLIKELY,  # 'x'
        51: SequenceLikelihood.NEGATIVE,  # 'y'
        20: SequenceLikelihood.NEGATIVE,  # 'z'
        57: SequenceLikelihood.UNLIKELY,  # 'Ċ'
        28: SequenceLikelihood.NEGATIVE,  # 'ċ'
        49: SequenceLikelihood.UNLIKELY,  # 'Ġ'
        22: SequenceLikelihood.UNLIKELY,  # 'ġ'
        55: SequenceLikelihood.UNLIKELY,  # 'Ħ'
        15: SequenceLikelihood.NEGATIVE,  # 'ħ'
        58: SequenceLikelihood.UNLIKELY,  # 'Ż'
        24: SequenceLikelihood.UNLIKELY,  # 'ż'
    },
    15: {  # 'ħ'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        46: SequenceLikelihood.UNLIKELY,  # 'C'
        36: SequenceLikelihood.UNLIKELY,  # 'D'
        32: SequenceLikelihood.UNLIKELY,  # 'E'
        40: SequenceLikelihood.UNLIKELY,  # 'F'
        44: SequenceLikelihood.UNLIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        29: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        33: SequenceLikelihood.UNLIKELY,  # 'K'
        37: SequenceLikelihood.UNLIKELY,  # 'L'
        30: SequenceLikelihood.UNLIKELY,  # 'M'
        45: SequenceLikelihood.UNLIKELY,  # 'N'
        48: SequenceLikelihood.UNLIKELY,  # 'O'
        35: SequenceLikelihood.UNLIKELY,  # 'P'
        53: SequenceLikelihood.NEGATIVE,  # 'Q'
        42: SequenceLikelihood.UNLIKELY,  # 'R'
        34: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        39: SequenceLikelihood.UNLIKELY,  # 'U'
        52: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        60: SequenceLikelihood.NEGATIVE,  # 'Y'
        59: SequenceLikelihood.NEGATIVE,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        17: SequenceLikelihood.POSITIVE,  # 'b'
        41: SequenceLikelihood.NEGATIVE,  # 'c'
        14: SequenceLikelihood.POSITIVE,  # 'd'
        5: SequenceLikelihood.POSITIVE,  # 'e'
        19: SequenceLikelihood.LIKELY,  # 'f'
        18: SequenceLikelihood.UNLIKELY,  # 'g'
        23: SequenceLikelihood.POSITIVE,  # 'h'
        1: SequenceLikelihood.POSITIVE,  # 'i'
        11: SequenceLikelihood.POSITIVE,  # 'j'
        13: SequenceLikelihood.LIKELY,  # 'k'
        4: SequenceLikelihood.POSITIVE,  # 'l'
        12: SequenceLikelihood.POSITIVE,  # 'm'
        6: SequenceLikelihood.POSITIVE,  # 'n'
        9: SequenceLikelihood.POSITIVE,  # 'o'
        16: SequenceLikelihood.UNLIKELY,  # 'p'
        26: SequenceLikelihood.LIKELY,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        10: SequenceLikelihood.POSITIVE,  # 's'
        3: SequenceLikelihood.POSITIVE,  # 't'
        8: SequenceLikelihood.POSITIVE,  # 'u'
        27: SequenceLikelihood.UNLIKELY,  # 'v'
        21: SequenceLikelihood.LIKELY,  # 'w'
        25: SequenceLikelihood.LIKELY,  # 'x'
        51: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        57: SequenceLikelihood.NEGATIVE,  # 'Ċ'
        28: SequenceLikelihood.UNLIKELY,  # 'ċ'
        49: SequenceLikelihood.UNLIKELY,  # 'Ġ'
        22: SequenceLikelihood.LIKELY,  # 'ġ'
        55: SequenceLikelihood.NEGATIVE,  # 'Ħ'
        15: SequenceLikelihood.POSITIVE,  # 'ħ'
        58: SequenceLikelihood.UNLIKELY,  # 'Ż'
        24: SequenceLikelihood.POSITIVE,  # 'ż'
    },
    58: {  # 'Ż'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        46: SequenceLikelihood.NEGATIVE,  # 'C'
        36: SequenceLikelihood.UNLIKELY,  # 'D'
        32: SequenceLikelihood.LIKELY,  # 'E'
        40: SequenceLikelihood.UNLIKELY,  # 'F'
        44: SequenceLikelihood.UNLIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        29: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        33: SequenceLikelihood.UNLIKELY,  # 'K'
        37: SequenceLikelihood.UNLIKELY,  # 'L'
        30: SequenceLikelihood.UNLIKELY,  # 'M'
        45: SequenceLikelihood.UNLIKELY,  # 'N'
        48: SequenceLikelihood.UNLIKELY,  # 'O'
        35: SequenceLikelihood.UNLIKELY,  # 'P'
        53: SequenceLikelihood.UNLIKELY,  # 'Q'
        42: SequenceLikelihood.UNLIKELY,  # 'R'
        34: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        39: SequenceLikelihood.UNLIKELY,  # 'U'
        52: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        56: SequenceLikelihood.NEGATIVE,  # 'X'
        60: SequenceLikelihood.NEGATIVE,  # 'Y'
        59: SequenceLikelihood.NEGATIVE,  # 'Z'
        2: SequenceLikelihood.UNLIKELY,  # 'a'
        17: SequenceLikelihood.UNLIKELY,  # 'b'
        41: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.LIKELY,  # 'e'
        19: SequenceLikelihood.UNLIKELY,  # 'f'
        18: SequenceLikelihood.LIKELY,  # 'g'
        23: SequenceLikelihood.UNLIKELY,  # 'h'
        1: SequenceLikelihood.LIKELY,  # 'i'
        11: SequenceLikelihood.UNLIKELY,  # 'j'
        13: SequenceLikelihood.NEGATIVE,  # 'k'
        4: SequenceLikelihood.UNLIKELY,  # 'l'
        12: SequenceLikelihood.UNLIKELY,  # 'm'
        6: SequenceLikelihood.UNLIKELY,  # 'n'
        9: SequenceLikelihood.LIKELY,  # 'o'
        16: SequenceLikelihood.NEGATIVE,  # 'p'
        26: SequenceLikelihood.NEGATIVE,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        10: SequenceLikelihood.NEGATIVE,  # 's'
        3: SequenceLikelihood.NEGATIVE,  # 't'
        8: SequenceLikelihood.UNLIKELY,  # 'u'
        27: SequenceLikelihood.LIKELY,  # 'v'
        21: SequenceLikelihood.UNLIKELY,  # 'w'
        25: SequenceLikelihood.NEGATIVE,  # 'x'
        51: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.NEGATIVE,  # 'z'
        57: SequenceLikelihood.NEGATIVE,  # 'Ċ'
        28: SequenceLikelihood.NEGATIVE,  # 'ċ'
        49: SequenceLikelihood.UNLIKELY,  # 'Ġ'
        22: SequenceLikelihood.UNLIKELY,  # 'ġ'
        55: SequenceLikelihood.UNLIKELY,  # 'Ħ'
        15: SequenceLikelihood.NEGATIVE,  # 'ħ'
        58: SequenceLikelihood.UNLIKELY,  # 'Ż'
        24: SequenceLikelihood.UNLIKELY,  # 'ż'
    },
    24: {  # 'ż'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        46: SequenceLikelihood.UNLIKELY,  # 'C'
        36: SequenceLikelihood.UNLIKELY,  # 'D'
        32: SequenceLikelihood.UNLIKELY,  # 'E'
        40: SequenceLikelihood.UNLIKELY,  # 'F'
        44: SequenceLikelihood.UNLIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        29: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        33: SequenceLikelihood.UNLIKELY,  # 'K'
        37: SequenceLikelihood.UNLIKELY,  # 'L'
        30: SequenceLikelihood.UNLIKELY,  # 'M'
        45: SequenceLikelihood.UNLIKELY,  # 'N'
        48: SequenceLikelihood.UNLIKELY,  # 'O'
        35: SequenceLikelihood.UNLIKELY,  # 'P'
        53: SequenceLikelihood.UNLIKELY,  # 'Q'
        42: SequenceLikelihood.UNLIKELY,  # 'R'
        34: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        39: SequenceLikelihood.UNLIKELY,  # 'U'
        52: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.NEGATIVE,  # 'W'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        60: SequenceLikelihood.NEGATIVE,  # 'Y'
        59: SequenceLikelihood.NEGATIVE,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        17: SequenceLikelihood.LIKELY,  # 'b'
        41: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.POSITIVE,  # 'd'
        5: SequenceLikelihood.POSITIVE,  # 'e'
        19: SequenceLikelihood.UNLIKELY,  # 'f'
        18: SequenceLikelihood.POSITIVE,  # 'g'
        23: SequenceLikelihood.UNLIKELY,  # 'h'
        1: SequenceLikelihood.POSITIVE,  # 'i'
        11: SequenceLikelihood.POSITIVE,  # 'j'
        13: SequenceLikelihood.UNLIKELY,  # 'k'
        4: SequenceLikelihood.POSITIVE,  # 'l'
        12: SequenceLikelihood.POSITIVE,  # 'm'
        6: SequenceLikelihood.LIKELY,  # 'n'
        9: SequenceLikelihood.POSITIVE,  # 'o'
        16: SequenceLikelihood.UNLIKELY,  # 'p'
        26: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.LIKELY,  # 'r'
        10: SequenceLikelihood.UNLIKELY,  # 's'
        3: SequenceLikelihood.UNLIKELY,  # 't'
        8: SequenceLikelihood.POSITIVE,  # 'u'
        27: SequenceLikelihood.POSITIVE,  # 'v'
        21: SequenceLikelihood.LIKELY,  # 'w'
        25: SequenceLikelihood.UNLIKELY,  # 'x'
        51: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        57: SequenceLikelihood.UNLIKELY,  # 'Ċ'
        28: SequenceLikelihood.UNLIKELY,  # 'ċ'
        49: SequenceLikelihood.UNLIKELY,  # 'Ġ'
        22: SequenceLikelihood.UNLIKELY,  # 'ġ'
        55: SequenceLikelihood.UNLIKELY,  # 'Ħ'
        15: SequenceLikelihood.UNLIKELY,  # 'ħ'
        58: SequenceLikelihood.UNLIKELY,  # 'Ż'
        24: SequenceLikelihood.POSITIVE,  # 'ż'
    },
}

# Character Mapping Table(s):
ISO_8859_3_MALTESE_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 31,  # 'A'
    66: 43,  # 'B'
    67: 46,  # 'C'
    68: 36,  # 'D'
    69: 32,  # 'E'
    70: 40,  # 'F'
    71: 44,  # 'G'
    72: 50,  # 'H'
    73: 29,  # 'I'
    74: 47,  # 'J'
    75: 33,  # 'K'
    76: 37,  # 'L'
    77: 30,  # 'M'
    78: 45,  # 'N'
    79: 48,  # 'O'
    80: 35,  # 'P'
    81: 53,  # 'Q'
    82: 42,  # 'R'
    83: 34,  # 'S'
    84: 38,  # 'T'
    85: 39,  # 'U'
    86: 52,  # 'V'
    87: 54,  # 'W'
    88: 56,  # 'X'
    89: 60,  # 'Y'
    90: 59,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 2,  # 'a'
    98: 17,  # 'b'
    99: 41,  # 'c'
    100: 14,  # 'd'
    101: 5,  # 'e'
    102: 19,  # 'f'
    103: 18,  # 'g'
    104: 23,  # 'h'
    105: 1,  # 'i'
    106: 11,  # 'j'
    107: 13,  # 'k'
    108: 4,  # 'l'
    109: 12,  # 'm'
    110: 6,  # 'n'
    111: 9,  # 'o'
    112: 16,  # 'p'
    113: 26,  # 'q'
    114: 7,  # 'r'
    115: 10,  # 's'
    116: 3,  # 't'
    117: 8,  # 'u'
    118: 27,  # 'v'
    119: 21,  # 'w'
    120: 25,  # 'x'
    121: 51,  # 'y'
    122: 20,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: CharacterCategory.CONTROL,  # '\x80'
    129: CharacterCategory.CONTROL,  # '\x81'
    130: CharacterCategory.CONTROL,  # '\x82'
    131: CharacterCategory.CONTROL,  # '\x83'
    132: CharacterCategory.CONTROL,  # '\x84'
    133: CharacterCategory.CONTROL,  # '\x85'
    134: CharacterCategory.CONTROL,  # '\x86'
    135: CharacterCategory.CONTROL,  # '\x87'
    136: CharacterCategory.CONTROL,  # '\x88'
    137: CharacterCategory.CONTROL,  # '\x89'
    138: CharacterCategory.CONTROL,  # '\x8a'
    139: CharacterCategory.CONTROL,  # '\x8b'
    140: CharacterCategory.CONTROL,  # '\x8c'
    141: CharacterCategory.CONTROL,  # '\x8d'
    142: CharacterCategory.CONTROL,  # '\x8e'
    143: CharacterCategory.CONTROL,  # '\x8f'
    144: CharacterCategory.CONTROL,  # '\x90'
    145: CharacterCategory.CONTROL,  # '\x91'
    146: CharacterCategory.CONTROL,  # '\x92'
    147: CharacterCategory.CONTROL,  # '\x93'
    148: CharacterCategory.CONTROL,  # '\x94'
    149: CharacterCategory.CONTROL,  # '\x95'
    150: CharacterCategory.CONTROL,  # '\x96'
    151: CharacterCategory.CONTROL,  # '\x97'
    152: CharacterCategory.CONTROL,  # '\x98'
    153: CharacterCategory.CONTROL,  # '\x99'
    154: CharacterCategory.CONTROL,  # '\x9a'
    155: CharacterCategory.CONTROL,  # '\x9b'
    156: CharacterCategory.CONTROL,  # '\x9c'
    157: CharacterCategory.CONTROL,  # '\x9d'
    158: CharacterCategory.CONTROL,  # '\x9e'
    159: CharacterCategory.CONTROL,  # '\x9f'
    160: CharacterCategory.CONTROL,  # '\xa0'
    161: 55,  # 'Ħ'
    162: CharacterCategory.SYMBOL,  # '˘'
    163: CharacterCategory.SYMBOL,  # '£'
    164: CharacterCategory.SYMBOL,  # '¤'
    165: CharacterCategory.UNDEFINED,  # None
    166: 0,  # 'Ĥ'
    167: CharacterCategory.SYMBOL,  # '§'
    168: CharacterCategory.SYMBOL,  # '¨'
    169: 0,  # 'İ'
    170: 0,  # 'Ş'
    171: 0,  # 'Ğ'
    172: 0,  # 'Ĵ'
    173: CharacterCategory.CONTROL,  # '\xad'
    174: CharacterCategory.UNDEFINED,  # None
    175: 58,  # 'Ż'
    176: CharacterCategory.SYMBOL,  # '°'
    177: 15,  # 'ħ'
    178: CharacterCategory.DIGIT,  # '²'
    179: CharacterCategory.DIGIT,  # '³'
    180: CharacterCategory.SYMBOL,  # '´'
    181: 0,  # 'µ'
    182: 0,  # 'ĥ'
    183: CharacterCategory.SYMBOL,  # '·'
    184: CharacterCategory.SYMBOL,  # '¸'
    185: 0,  # 'ı'
    186: 0,  # 'ş'
    187: 0,  # 'ğ'
    188: 0,  # 'ĵ'
    189: CharacterCategory.DIGIT,  # '½'
    190: CharacterCategory.UNDEFINED,  # None
    191: 24,  # 'ż'
    192: 0,  # 'À'
    193: 0,  # 'Á'
    194: 0,  # 'Â'
    195: CharacterCategory.UNDEFINED,  # None
    196: 0,  # 'Ä'
    197: 57,  # 'Ċ'
    198: 0,  # 'Ĉ'
    199: 0,  # 'Ç'
    200: 0,  # 'È'
    201: 0,  # 'É'
    202: 0,  # 'Ê'
    203: 0,  # 'Ë'
    204: 0,  # 'Ì'
    205: 0,  # 'Í'
    206: 0,  # 'Î'
    207: 0,  # 'Ï'
    208: CharacterCategory.UNDEFINED,  # None
    209: 0,  # 'Ñ'
    210: 0,  # 'Ò'
    211: 0,  # 'Ó'
    212: 0,  # 'Ô'
    213: 49,  # 'Ġ'
    214: 0,  # 'Ö'
    215: CharacterCategory.SYMBOL,  # '×'
    216: 0,  # 'Ĝ'
    217: 0,  # 'Ù'
    218: 0,  # 'Ú'
    219: 0,  # 'Û'
    220: 0,  # 'Ü'
    221: 0,  # 'Ŭ'
    222: 0,  # 'Ŝ'
    223: 0,  # 'ß'
    224: 0,  # 'à'
    225: 0,  # 'á'
    226: 0,  # 'â'
    227: CharacterCategory.UNDEFINED,  # None
    228: 0,  # 'ä'
    229: 28,  # 'ċ'
    230: 0,  # 'ĉ'
    231: 0,  # 'ç'
    232: 0,  # 'è'
    233: 0,  # 'é'
    234: 0,  # 'ê'
    235: 0,  # 'ë'
    236: 0,  # 'ì'
    237: 0,  # 'í'
    238: 0,  # 'î'
    239: 0,  # 'ï'
    240: CharacterCategory.UNDEFINED,  # None
    241: 0,  # 'ñ'
    242: 0,  # 'ò'
    243: 0,  # 'ó'
    244: 0,  # 'ô'
    245: 22,  # 'ġ'
    246: 0,  # 'ö'
    247: CharacterCategory.SYMBOL,  # '÷'
    248: 0,  # 'ĝ'
    249: 0,  # 'ù'
    250: 0,  # 'ú'
    251: 0,  # 'û'
    252: 0,  # 'ü'
    253: 0,  # 'ŭ'
    254: 0,  # 'ŝ'
    255: CharacterCategory.SYMBOL,  # '˙'
}

ISO_8859_3_MALTESE_MODEL = SingleByteCharSetModel(
    charset_name="ISO-8859-3",
    language="Maltese",
    char_to_order_map=ISO_8859_3_MALTESE_CHAR_TO_ORDER,
    language_model=MALTESE_LANG_MODEL,
    typical_positive_ratio=0.9758132588338152,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzĊċĠġĦħŻż",
)
