/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.ui;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.ui.CompareBranchesDiffPanel;
import com.intellij.dvcs.ui.CompareBranchesHelper;
import com.intellij.dvcs.ui.CompareBranchesLogPanel;
import com.intellij.dvcs.ui.DvcsBundle;
import com.intellij.dvcs.util.CommitCompareInfo;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.WindowWrapper;
import com.intellij.openapi.ui.WindowWrapperBuilder;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.ui.TabbedPaneImpl;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class CompareBranchesDialog {
    @NotNull
    private final Project myProject;
    @NotNull
    private final JPanel myLogPanel;
    @NotNull
    private final TabbedPaneImpl myTabbedPane;
    @NlsContexts.DialogTitle
    @NotNull
    private final String myTitle;
    @NotNull
    private final WindowWrapper.Mode myMode;
    private WindowWrapper myWrapper;

    public CompareBranchesDialog(@NotNull CompareBranchesHelper helper, @NotNull String branchName, @NotNull String currentBranchName, @NotNull CommitCompareInfo compareInfo, @NotNull Repository initialRepo, boolean dialog) {
        if (helper == null) {
            CompareBranchesDialog.$$$reportNull$$$0(0);
        }
        if (branchName == null) {
            CompareBranchesDialog.$$$reportNull$$$0(1);
        }
        if (currentBranchName == null) {
            CompareBranchesDialog.$$$reportNull$$$0(2);
        }
        if (compareInfo == null) {
            CompareBranchesDialog.$$$reportNull$$$0(3);
        }
        if (initialRepo == null) {
            CompareBranchesDialog.$$$reportNull$$$0(4);
        }
        this.myProject = helper.getProject();
        this.myTitle = compareInfo.getRepositories().size() == 1 && helper.getRepositoryManager().moreThanOneRoot() ? DvcsBundle.message((String)"compare.branches.dialog.title.branch.with.branch.in.root", (Object[])new Object[]{currentBranchName, branchName, DvcsUtil.getShortRepositoryName(initialRepo)}) : DvcsBundle.message((String)"compare.branches.dialog.title.branch.with.branch", (Object[])new Object[]{currentBranchName, branchName});
        this.myMode = dialog ? WindowWrapper.Mode.MODAL : WindowWrapper.Mode.FRAME;
        CompareBranchesDiffPanel diffPanel = new CompareBranchesDiffPanel(helper.getProject(), helper.getDvcsCompareSettings(), branchName, currentBranchName);
        diffPanel.setCompareInfo(compareInfo);
        this.myLogPanel = new CompareBranchesLogPanel(helper, branchName, currentBranchName, compareInfo, initialRepo);
        this.myTabbedPane = new TabbedPaneImpl(1);
        this.myTabbedPane.addTab(DvcsBundle.message((String)"compare.branches.tab.name.log", (Object[])new Object[0]), AllIcons.Vcs.Branch, (Component)this.myLogPanel);
        this.myTabbedPane.addTab(DvcsBundle.message((String)"compare.branches.tab.name.files", (Object[])new Object[0]), AllIcons.Actions.ListChanges, (Component)diffPanel);
        this.myTabbedPane.setKeyboardNavigation(TabbedPaneImpl.DEFAULT_PREV_NEXT_SHORTCUTS);
    }

    public void show() {
        if (this.myWrapper == null) {
            this.myWrapper = new WindowWrapperBuilder(this.myMode, (JComponent)this.myTabbedPane).setProject(this.myProject).setTitle(this.myTitle).setPreferredFocusedComponent((JComponent)this.myLogPanel).setDimensionServiceKey(CompareBranchesDialog.class.getName()).build();
        }
        this.myWrapper.show();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "helper";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "branchName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "currentBranchName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "compareInfo";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[0] = "initialRepo";
                break;
            }
        }
        objectArray[1] = "com/intellij/dvcs/ui/CompareBranchesDialog";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

