/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.validation;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAware;
import com.intellij.psi.PsiElement;
import com.jetbrains.python.validation.AssignTargetAnnotator;
import com.jetbrains.python.validation.BreakContinueAnnotator;
import com.jetbrains.python.validation.GlobalAnnotator;
import com.jetbrains.python.validation.HighlightingAnnotator;
import com.jetbrains.python.validation.ImportAnnotator;
import com.jetbrains.python.validation.ParameterListAnnotator;
import com.jetbrains.python.validation.PyAnnotator;
import com.jetbrains.python.validation.PyAnnotatorBase;
import com.jetbrains.python.validation.PyAsyncAwaitAnnotator;
import com.jetbrains.python.validation.PyBuiltinAnnotator;
import com.jetbrains.python.validation.ReturnAnnotator;
import com.jetbrains.python.validation.TryExceptAnnotator;
import com.jetbrains.python.validation.TypeAnnotationTargetAnnotator;
import com.jetbrains.python.validation.UnsupportedFeatures;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public final class PyAnnotatingVisitor
implements Annotator,
DumbAware {
    private static final Logger LOGGER = Logger.getInstance((String)PyAnnotatingVisitor.class.getName());
    private static final Class[] ANNOTATOR_CLASSES = new Class[]{AssignTargetAnnotator.class, TypeAnnotationTargetAnnotator.class, ParameterListAnnotator.class, HighlightingAnnotator.class, ReturnAnnotator.class, TryExceptAnnotator.class, BreakContinueAnnotator.class, GlobalAnnotator.class, ImportAnnotator.class, PyBuiltinAnnotator.class, UnsupportedFeatures.class, PyAsyncAwaitAnnotator.class};
    private final PyAnnotator[] myAnnotators;

    public PyAnnotatingVisitor() {
        ArrayList<PyAnnotator> annotators = new ArrayList<PyAnnotator>();
        for (Class cls : ANNOTATOR_CLASSES) {
            PyAnnotator annotator;
            try {
                annotator = (PyAnnotator)cls.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                LOGGER.error((Throwable)e);
                continue;
            }
            annotators.add(annotator);
        }
        this.myAnnotators = annotators.toArray(new PyAnnotator[0]);
    }

    public void annotate(@NotNull PsiElement psiElement, @NotNull AnnotationHolder holder) {
        if (psiElement == null) {
            PyAnnotatingVisitor.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            PyAnnotatingVisitor.$$$reportNull$$$0(1);
        }
        PyAnnotatorBase.runAnnotators(psiElement, holder, this.myAnnotators);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "psiElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/python/validation/PyAnnotatingVisitor";
        objectArray[2] = "annotate";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

