/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui;

import com.intellij.database.run.ui.FormattedModeHandlerKt;
import com.intellij.database.run.ui.MinimizedFormat;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.TreeTraversal;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002J\u0012\u0010\u0010\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002J\u0012\u0010\u0011\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002J\"\u0010\u0012\u001a\u00020\u00132\u0018\u0010\u0014\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u0016\u0012\u0004\u0012\u00020\u00130\u0015H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/database/run/ui/XmlMinimizedFormat;", "Lcom/intellij/database/run/ui/MinimizedFormat;", "project", "Lcom/intellij/openapi/project/Project;", "document", "Lcom/intellij/openapi/editor/Document;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/editor/Document;)V", "restore", "", "file", "Lcom/intellij/psi/PsiFile;", "isSpaceBeforeTagEnd", "", "it", "Lcom/intellij/psi/PsiElement;", "isSpaceInAttribute", "isSpaceBetweenTags", "reformat", "", "disableUpdateListener", "Lkotlin/Function1;", "Lkotlin/Function0;", "Companion", "intellij.grid.impl"})
final class XmlMinimizedFormat
implements MinimizedFormat {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final Document document;

    public XmlMinimizedFormat(@NotNull Project project, @NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        this.project = project;
        this.document = document;
    }

    @Override
    @NotNull
    public String restore(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        JBIterable jBIterable = SyntaxTraverser.psiTraverser((PsiElement)((PsiElement)file)).traverse(TreeTraversal.LEAVES_DFS).filter(arg_0 -> XmlMinimizedFormat.restore$lambda$1(arg_0 -> XmlMinimizedFormat.restore$lambda$0(this, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"filter(...)");
        return CollectionsKt.joinToString$default((Iterable)((Iterable)jBIterable), (CharSequence)"", null, null, (int)0, null, XmlMinimizedFormat::restore$lambda$2, (int)30, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isSpaceBeforeTagEnd(PsiElement it) {
        if (!(it instanceof PsiWhiteSpace)) return false;
        PsiElement psiElement = ((PsiWhiteSpace)it).getNextSibling();
        if (!Intrinsics.areEqual((Object)(psiElement != null ? PsiTreeUtilKt.getElementType((PsiElement)psiElement) : null), (Object)XmlTokenType.XML_TAG_END)) return false;
        return true;
    }

    private final boolean isSpaceInAttribute(PsiElement it) {
        return it instanceof PsiWhiteSpace && ((PsiWhiteSpace)it).getParent() instanceof XmlAttribute;
    }

    private final boolean isSpaceBetweenTags(PsiElement it) {
        return it instanceof PsiWhiteSpace && ((PsiWhiteSpace)it).getParent() instanceof XmlText && ((PsiWhiteSpace)it).getParent().getChildren().length == 1;
    }

    @Override
    public void reformat(@NotNull Function1<? super Function0<Unit>, Unit> disableUpdateListener) {
        Intrinsics.checkNotNullParameter(disableUpdateListener, (String)"disableUpdateListener");
        FormattedModeHandlerKt.runFormatter(this.project, this.document, disableUpdateListener);
    }

    private static final boolean restore$lambda$0(XmlMinimizedFormat this$0, PsiElement it) {
        return !this$0.isSpaceBetweenTags(it) && !this$0.isSpaceInAttribute(it) && !this$0.isSpaceBeforeTagEnd(it);
    }

    private static final boolean restore$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final CharSequence restore$lambda$2(PsiElement it) {
        CharSequence charSequence;
        if (it instanceof PsiWhiteSpace && ((PsiWhiteSpace)it).getParent() instanceof XmlTag) {
            charSequence = " ";
        } else {
            String string = it.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            charSequence = string;
        }
        return charSequence;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lcom/intellij/database/run/ui/XmlMinimizedFormat$Companion;", "", "<init>", "()V", "detect", "Lcom/intellij/database/run/ui/XmlMinimizedFormat;", "project", "Lcom/intellij/openapi/project/Project;", "document", "Lcom/intellij/openapi/editor/Document;", "intellij.grid.impl"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final XmlMinimizedFormat detect(@NotNull Project project, @NotNull Document document) {
            PsiFile file;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)document, (String)"document");
            PsiFile psiFile = file = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
            return (psiFile != null ? psiFile.getLanguage() : null) instanceof XMLLanguage ? new XmlMinimizedFormat(project, document) : null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

