/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.agent;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.commons.text.StringSubstitutor;
import org.opensearch.ml.common.FunctionName;
import org.opensearch.ml.common.MLAgentType;
import org.opensearch.ml.common.connector.Connector;
import org.opensearch.ml.common.connector.ConnectorAction;
import org.opensearch.ml.common.connector.ConnectorClientConfig;
import org.opensearch.ml.common.connector.HttpConnector;
import org.opensearch.ml.common.input.execute.agent.ContentBlock;
import org.opensearch.ml.common.input.execute.agent.DocumentContent;
import org.opensearch.ml.common.input.execute.agent.ImageContent;
import org.opensearch.ml.common.input.execute.agent.Message;
import org.opensearch.ml.common.input.execute.agent.SourceType;
import org.opensearch.ml.common.input.execute.agent.VideoContent;
import org.opensearch.ml.common.model.ModelProvider;
import org.opensearch.ml.common.transport.register.MLRegisterModelInput;

public class GeminiV1BetaGenerateContentModelProvider
extends ModelProvider {
    private static final String REQUEST_BODY_TEMPLATE = "{\"systemInstruction\":{\"parts\":[{\"text\":\"${parameters.system_prompt:-You are a helpful assistant.}\"}]},\"contents\":[${parameters._chat_history:-}${parameters.body}${parameters._interactions:-}]${parameters.tool_configs:-}}";
    private static final String TEXT_INPUT_BODY_TEMPLATE = "{\"role\":\"user\",\"parts\":[{\"text\":\"${parameters.user_text}\"}]}";
    private static final String CONTENT_BLOCKS_BODY_TEMPLATE = "{\"role\":\"user\",\"parts\":[${parameters.content_array}]}";
    private static final String TEXT_CONTENT_TEMPLATE = "{\"text\":\"${parameters.content_text}\"}";
    private static final String IMAGE_CONTENT_TEMPLATE = "{\"inlineData\":{\"mimeType\":\"image/${parameters.image_format}\",\"data\":\"${parameters.image_data}\"}}";
    private static final String DOCUMENT_CONTENT_TEMPLATE = "{\"fileData\":{\"mimeType\":\"${parameters.doc_format}\",\"fileUri\":\"${parameters.doc_data}\"}}";
    private static final String VIDEO_CONTENT_TEMPLATE = "{\"fileData\":{\"mimeType\":\"video/${parameters.video_format}\",\"fileUri\":\"${parameters.video_data}\"}}";
    private static final String MESSAGE_TEMPLATE = "{\"role\":\"${parameters.msg_role}\",\"parts\":[${parameters.msg_content_array}]}";

    @Override
    public Connector createConnector(String modelId, Map<String, String> credential, Map<String, String> modelParameters) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("model", modelId);
        if (modelParameters != null) {
            parameters.putAll(modelParameters);
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        headers.put("x-goog-api-key", "${credential.gemini_api_key}");
        ConnectorAction predictAction = ConnectorAction.builder().actionType(ConnectorAction.ActionType.PREDICT).method("POST").url("https://generativelanguage.googleapis.com/v1beta/models/${parameters.model}:generateContent").headers(headers).requestBody(REQUEST_BODY_TEMPLATE).build();
        ConnectorClientConfig connectorClientConfig = new ConnectorClientConfig();
        connectorClientConfig.setMaxRetryTimes(3);
        return HttpConnector.builder().name("Auto-generated Gemini connector for Agent").description("Auto-generated connector for Gemini generateContent API").version("1").protocol("http").parameters(parameters).credential(credential != null ? credential : new HashMap()).actions(List.of(predictAction)).connectorClientConfig(connectorClientConfig).build();
    }

    @Override
    public MLRegisterModelInput createModelInput(String modelName, Connector connector, Map<String, String> modelParameters) {
        return MLRegisterModelInput.builder().functionName(FunctionName.REMOTE).modelName("Auto-generated model for " + modelName).description("Auto-generated model for agent").connector(connector).build();
    }

    @Override
    public String getLLMInterface() {
        return "gemini/v1beta/generatecontent";
    }

    @Override
    public Map<String, String> mapTextInput(String text, MLAgentType type) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        HashMap<String, String> templateParams = new HashMap<String, String>();
        if (type == MLAgentType.PLAN_EXECUTE_AND_REFLECT) {
            templateParams.put("user_text", "${parameters.prompt}");
        } else {
            templateParams.put("user_text", StringEscapeUtils.escapeJson((String)text));
        }
        StringSubstitutor substitutor = new StringSubstitutor(templateParams, "${parameters.", "}");
        String body = substitutor.replace(TEXT_INPUT_BODY_TEMPLATE);
        parameters.put("body", body);
        return parameters;
    }

    @Override
    public Map<String, String> mapContentBlocks(List<ContentBlock> contentBlocks, MLAgentType type) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        String contentArray = this.buildContentArrayFromBlocks(contentBlocks, type);
        HashMap<String, String> templateParams = new HashMap<String, String>();
        templateParams.put("content_array", contentArray);
        StringSubstitutor substitutor = new StringSubstitutor(templateParams, "${parameters.", "}");
        String body = substitutor.replace(CONTENT_BLOCKS_BODY_TEMPLATE);
        parameters.put("body", body);
        return parameters;
    }

    @Override
    public Map<String, String> mapMessages(List<Message> messages, MLAgentType type) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        String messagesString = this.buildMessagesArray(messages, type);
        parameters.put("body", messagesString);
        parameters.put("no_escape_params", "_chat_history,_tools,_interactions,tool_configs,body");
        return parameters;
    }

    private String buildContentArrayFromBlocks(List<ContentBlock> blocks, MLAgentType type) {
        if (blocks == null || blocks.isEmpty()) {
            return "";
        }
        StringBuilder contentArray = new StringBuilder();
        boolean first = true;
        for (ContentBlock block : blocks) {
            if (!first) {
                contentArray.append(",");
            }
            first = false;
            switch (block.getType()) {
                case TEXT: {
                    HashMap<String, String> textParams = new HashMap<String, String>();
                    if (type == MLAgentType.PLAN_EXECUTE_AND_REFLECT) {
                        textParams.put("content_text", "${parameters.prompt}");
                    } else {
                        textParams.put("content_text", StringEscapeUtils.escapeJson((String)block.getText()));
                    }
                    StringSubstitutor textSubstitutor = new StringSubstitutor(textParams, "${parameters.", "}");
                    contentArray.append(textSubstitutor.replace(TEXT_CONTENT_TEMPLATE));
                    break;
                }
                case IMAGE: {
                    ImageContent image = block.getImage();
                    HashMap<String, String> imageParams = new HashMap<String, String>();
                    imageParams.put("image_format", image.getFormat());
                    imageParams.put("image_data", StringEscapeUtils.escapeJson((String)image.getData()));
                    String imageTemplate = this.mapImageSourceTypeToGemini(image.getType());
                    StringSubstitutor imageSubstitutor = new StringSubstitutor(imageParams, "${parameters.", "}");
                    contentArray.append(imageSubstitutor.replace(imageTemplate));
                    break;
                }
                case DOCUMENT: {
                    DocumentContent document = block.getDocument();
                    HashMap<String, String> docParams = new HashMap<String, String>();
                    docParams.put("doc_format", document.getFormat());
                    docParams.put("doc_data", StringEscapeUtils.escapeJson((String)document.getData()));
                    StringSubstitutor docSubstitutor = new StringSubstitutor(docParams, "${parameters.", "}");
                    contentArray.append(docSubstitutor.replace(DOCUMENT_CONTENT_TEMPLATE));
                    break;
                }
                case VIDEO: {
                    VideoContent video = block.getVideo();
                    HashMap<String, String> videoParams = new HashMap<String, String>();
                    videoParams.put("video_format", video.getFormat());
                    videoParams.put("video_data", StringEscapeUtils.escapeJson((String)video.getData()));
                    StringSubstitutor videoSubstitutor = new StringSubstitutor(videoParams, "${parameters.", "}");
                    contentArray.append(videoSubstitutor.replace(VIDEO_CONTENT_TEMPLATE));
                    break;
                }
            }
        }
        return contentArray.toString();
    }

    private String buildMessagesArray(List<Message> messages, MLAgentType type) {
        if (messages == null || messages.isEmpty()) {
            return "";
        }
        StringBuilder messagesArray = new StringBuilder();
        boolean first = true;
        for (Message message : messages) {
            if (!first) {
                messagesArray.append(",");
            }
            first = false;
            String contentArray = this.buildContentArrayFromBlocks(message.getContent(), type);
            HashMap<String, String> msgParams = new HashMap<String, String>();
            String geminiRole = "user".equals(message.getRole()) ? "user" : "model";
            msgParams.put("msg_role", geminiRole);
            msgParams.put("msg_content_array", contentArray);
            StringSubstitutor msgSubstitutor = new StringSubstitutor(msgParams, "${parameters.", "}");
            messagesArray.append(msgSubstitutor.replace(MESSAGE_TEMPLATE));
        }
        return messagesArray.toString();
    }

    private String mapImageSourceTypeToGemini(SourceType sourceType) {
        if (sourceType == null) {
            String supportedTypes = Stream.of(SourceType.values()).map(Enum::name).collect(Collectors.joining(", "));
            throw new IllegalArgumentException("Image source type is required. Supported types: " + supportedTypes);
        }
        return switch (sourceType) {
            case SourceType.BASE64 -> IMAGE_CONTENT_TEMPLATE;
            case SourceType.URL -> "{\"fileData\":{\"mimeType\":\"image/${parameters.image_format}\",\"fileUri\":\"${parameters.image_data}\"}}";
            default -> {
                String supportedTypes = Stream.of(SourceType.values()).map(Enum::name).collect(Collectors.joining(", "));
                throw new IllegalArgumentException("Unsupported image source type. Supported types: " + supportedTypes);
            }
        };
    }
}

