/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.resources.sharing;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.core.common.io.stream.NamedWriteable;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentFragment;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.security.resources.sharing.CreatedBy;
import org.opensearch.security.resources.sharing.Recipient;
import org.opensearch.security.resources.sharing.Recipients;
import org.opensearch.security.resources.sharing.ShareWith;
import org.opensearch.security.user.User;

public class ResourceSharing
implements ToXContentFragment,
NamedWriteable {
    private final Logger log = LogManager.getLogger(this.getClass());
    private String resourceId;
    private String resourceType;
    private final CreatedBy createdBy;
    private ShareWith shareWith;

    private ResourceSharing(Builder b) {
        this.resourceId = b.resourceId;
        this.resourceType = b.resourceType;
        this.createdBy = b.createdBy;
        this.shareWith = b.shareWith;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    public CreatedBy getCreatedBy() {
        return this.createdBy;
    }

    public ShareWith getShareWith() {
        if (this.shareWith == null) {
            this.shareWith = new ShareWith(new HashMap<String, Recipients>());
        }
        return this.shareWith;
    }

    public void share(String accessLevel, Recipients target) {
        if (this.shareWith == null) {
            HashMap<String, Recipients> recs = new HashMap<String, Recipients>();
            recs.put(accessLevel, target);
            this.shareWith = new ShareWith(recs);
            return;
        }
        Recipients sharedWith = this.shareWith.atAccessLevel(accessLevel);
        if (sharedWith == null) {
            this.shareWith = this.shareWith.updateSharingInfo(accessLevel, target);
        } else {
            sharedWith.share(target);
        }
    }

    public void revoke(String accessLevel, Recipients target) {
        if (this.shareWith == null) {
            this.log.warn("Cannot revoke access as resource {} is not shared with anyone", (Object)this.resourceId);
            return;
        }
        Recipients sharedWith = this.shareWith.atAccessLevel(accessLevel);
        if (sharedWith == null) {
            this.log.warn("Cannot revoke access to {} for {} as the resource is not shared at accessLevel {}", (Object)this.resourceId, (Object)accessLevel, (Object)target);
        } else {
            sharedWith.revoke(target);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ResourceSharing)) {
            return false;
        }
        ResourceSharing that = (ResourceSharing)o;
        return Objects.equals(this.resourceId, that.resourceId) && Objects.equals(this.resourceType, that.resourceType) && Objects.equals(this.createdBy, that.createdBy) && Objects.equals(this.shareWith, that.shareWith);
    }

    public int hashCode() {
        return Objects.hash(this.resourceId, this.resourceType, this.createdBy, this.shareWith);
    }

    public String toString() {
        return "ResourceSharing{resourceId='" + this.resourceId + "', resourceType='" + this.resourceType + "', createdBy=" + String.valueOf(this.createdBy) + ", shareWith=" + String.valueOf(this.shareWith) + "}";
    }

    public String getWriteableName() {
        return "resource_sharing";
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.resourceId);
        out.writeString(this.resourceType);
        this.createdBy.writeTo(out);
        if (this.shareWith != null) {
            out.writeBoolean(true);
            this.shareWith.writeTo(out);
        } else {
            out.writeBoolean(false);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject().field("resource_id", this.resourceId).field("resource_type", this.resourceType).field("created_by");
        this.createdBy.toXContent(builder, params);
        if (this.shareWith != null) {
            builder.field("share_with");
            this.shareWith.toXContent(builder, params);
        }
        return builder.endObject();
    }

    public static ResourceSharing fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token;
        Builder b = ResourceSharing.builder();
        String currentFieldName = null;
        block12: while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            switch (Objects.requireNonNull(currentFieldName)) {
                case "resource_id": {
                    b.resourceId(parser.text());
                    continue block12;
                }
                case "resource_type": {
                    if (token == XContentParser.Token.VALUE_NULL) {
                        b.resourceType(null);
                        continue block12;
                    }
                    b.resourceType(parser.text());
                    continue block12;
                }
                case "created_by": {
                    b.createdBy(CreatedBy.fromXContent(parser));
                    continue block12;
                }
                case "share_with": {
                    b.shareWith(ShareWith.fromXContent(parser));
                    continue block12;
                }
            }
            parser.skipChildren();
        }
        return b.build();
    }

    private static <T> void validateRequiredField(String field, T value) {
        if (value == null) {
            throw new IllegalArgumentException(field + " is required");
        }
    }

    public boolean isCreatedBy(String userName) {
        return this.createdBy != null && this.createdBy.getUsername().equals(userName);
    }

    public boolean isSharedWithEveryone() {
        return this.shareWith != null && this.shareWith.isPublic();
    }

    public boolean isSharedWithEntity(Recipient recipientType, Set<String> targets, String accessLevel) {
        if (this.shareWith == null || this.shareWith.atAccessLevel(accessLevel) == null) {
            return false;
        }
        return this.shareWith.atAccessLevel(accessLevel).isSharedWithAny(recipientType, targets);
    }

    public Set<String> getAccessLevelsForUser(User user) {
        HashSet<String> userRoles = new HashSet<String>((Collection<String>)user.getSecurityRoles());
        HashSet<String> userBackendRoles = new HashSet<String>((Collection<String>)user.getRoles());
        userRoles.add("*");
        userBackendRoles.add("*");
        HashSet<String> accessLevels = new HashSet<String>();
        accessLevels.addAll(this.fetchAccessLevels(Recipient.USERS, Set.of(user.getName(), "*")));
        accessLevels.addAll(this.fetchAccessLevels(Recipient.ROLES, userRoles));
        accessLevels.addAll(this.fetchAccessLevels(Recipient.BACKEND_ROLES, userBackendRoles));
        return accessLevels;
    }

    public Set<String> fetchAccessLevels(Recipient recipientType, Set<String> entities) {
        if (this.shareWith == null) {
            return Collections.emptySet();
        }
        HashSet<String> matchingGroups = new HashSet<String>();
        for (Map.Entry<String, Recipients> entry : this.shareWith.getSharingInfo().entrySet()) {
            boolean intersects;
            String accessLevel = entry.getKey();
            Recipients recipients = entry.getValue();
            HashSet sharingRecipients = new HashSet(recipients.getRecipients().getOrDefault((Object)recipientType, Set.of()));
            boolean matchesWildcard = sharingRecipients.contains("*");
            boolean bl = intersects = !Collections.disjoint(sharingRecipients, entities);
            if (!matchesWildcard && !intersects) continue;
            matchingGroups.add(accessLevel);
        }
        return matchingGroups;
    }

    public List<String> getAllPrincipals() {
        ArrayList<String> principals = new ArrayList<String>();
        if (this.createdBy != null) {
            principals.add("user:" + this.createdBy.getUsername());
        }
        if (this.shareWith != null) {
            for (Recipients recipients : this.shareWith.getSharingInfo().values()) {
                Object user2;
                Map<Recipient, Set<String>> recipientMap = recipients.getRecipients();
                Set users = recipientMap.getOrDefault((Object)Recipient.USERS, Collections.emptySet());
                for (Object user2 : users) {
                    principals.add("user:" + (String)user2);
                }
                Set roles = recipientMap.getOrDefault((Object)Recipient.ROLES, Collections.emptySet());
                user2 = roles.iterator();
                while (user2.hasNext()) {
                    String role = (String)user2.next();
                    principals.add("role:" + role);
                }
                Set backendRoles = recipientMap.getOrDefault((Object)Recipient.BACKEND_ROLES, Collections.emptySet());
                for (String backendRole : backendRoles) {
                    principals.add("backend:" + backendRole);
                }
            }
        }
        return principals;
    }

    public static final class Builder {
        private String resourceId;
        private String resourceType;
        private CreatedBy createdBy;
        private ShareWith shareWith;

        public Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public Builder createdBy(CreatedBy createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public Builder shareWith(ShareWith shareWith) {
            this.shareWith = shareWith;
            return this;
        }

        public ResourceSharing build() {
            ResourceSharing.validateRequiredField("resource_id", this.resourceId);
            ResourceSharing.validateRequiredField("created_by", this.createdBy);
            return new ResourceSharing(this);
        }
    }
}

