/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.udp;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFactory;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.InternetProtocolFamily;
import io.netty.channel.socket.SocketProtocolFamily;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.channel.unix.DomainDatagramChannel;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.resolver.AddressResolverGroup;
import java.net.SocketAddress;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.function.Supplier;
import org.jspecify.annotations.Nullable;
import reactor.netty.channel.ChannelMetricsRecorder;
import reactor.netty.channel.ChannelOperations;
import reactor.netty.channel.MicrometerChannelMetricsRecorder;
import reactor.netty.resources.ConnectionProvider;
import reactor.netty.resources.LoopResources;
import reactor.netty.transport.ClientTransportConfig;
import reactor.netty.transport.logging.AdvancedByteBufFormat;
import reactor.netty.udp.UdpClient;
import reactor.netty.udp.UdpOperations;
import reactor.netty.udp.UdpResources;

public final class UdpClientConfig
extends ClientTransportConfig<UdpClientConfig> {
    @Nullable InternetProtocolFamily family;
    @Nullable SocketProtocolFamily socketFamily;
    static final ChannelOperations.OnSetup DEFAULT_OPS = (ch, c, msg) -> new UdpOperations(ch, c);
    static final LoggingHandler LOGGING_HANDLER = AdvancedByteBufFormat.HEX_DUMP.toLoggingHandler(UdpClient.class.getName(), LogLevel.DEBUG, Charset.defaultCharset());

    @Override
    public final ChannelOperations.OnSetup channelOperationsProvider() {
        return DEFAULT_OPS;
    }

    @Deprecated
    public final @Nullable InternetProtocolFamily family() {
        return this.family;
    }

    public final @Nullable SocketProtocolFamily socketFamily() {
        return this.socketFamily;
    }

    UdpClientConfig(ConnectionProvider connectionProvider, Map<ChannelOption<?>, ?> options, Supplier<? extends SocketAddress> remoteAddress) {
        super(connectionProvider, options, remoteAddress);
    }

    UdpClientConfig(UdpClientConfig parent) {
        super(parent);
        this.family = parent.family;
        this.socketFamily = parent.socketFamily;
    }

    @Override
    protected Class<? extends Channel> channelType(boolean isDomainSocket) {
        return isDomainSocket ? DomainDatagramChannel.class : DatagramChannel.class;
    }

    @Override
    protected ChannelFactory<? extends Channel> connectionFactory(EventLoopGroup elg, boolean isDomainSocket) {
        if (this.isPreferNative()) {
            return super.connectionFactory(elg, isDomainSocket);
        }
        return () -> new NioDatagramChannel(this.socketFamily());
    }

    @Override
    protected AddressResolverGroup<?> defaultAddressResolverGroup() {
        return UdpResources.get().getOrCreateDefaultResolver();
    }

    @Override
    protected LoggingHandler defaultLoggingHandler() {
        return LOGGING_HANDLER;
    }

    @Override
    protected LoopResources defaultLoopResources() {
        return UdpResources.get();
    }

    @Override
    protected ChannelMetricsRecorder defaultMetricsRecorder() {
        return MicrometerUdpClientMetricsRecorder.INSTANCE;
    }

    static final class MicrometerUdpClientMetricsRecorder
    extends MicrometerChannelMetricsRecorder {
        static final MicrometerUdpClientMetricsRecorder INSTANCE = new MicrometerUdpClientMetricsRecorder();

        MicrometerUdpClientMetricsRecorder() {
            super("reactor.netty.udp.client", "udp");
        }
    }
}

