/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.dynamodb.model.WitnessStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GlobalTableWitnessDescription
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GlobalTableWitnessDescription> {
    private static final SdkField<String> REGION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RegionName").getter(GlobalTableWitnessDescription.getter(GlobalTableWitnessDescription::regionName)).setter(GlobalTableWitnessDescription.setter(Builder::regionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegionName").build()}).build();
    private static final SdkField<String> WITNESS_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WitnessStatus").getter(GlobalTableWitnessDescription.getter(GlobalTableWitnessDescription::witnessStatusAsString)).setter(GlobalTableWitnessDescription.setter(Builder::witnessStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WitnessStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGION_NAME_FIELD, WITNESS_STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GlobalTableWitnessDescription.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String regionName;
    private final String witnessStatus;

    private GlobalTableWitnessDescription(BuilderImpl builder) {
        this.regionName = builder.regionName;
        this.witnessStatus = builder.witnessStatus;
    }

    public final String regionName() {
        return this.regionName;
    }

    public final WitnessStatus witnessStatus() {
        return WitnessStatus.fromValue(this.witnessStatus);
    }

    public final String witnessStatusAsString() {
        return this.witnessStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.regionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.witnessStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GlobalTableWitnessDescription)) {
            return false;
        }
        GlobalTableWitnessDescription other = (GlobalTableWitnessDescription)obj;
        return Objects.equals(this.regionName(), other.regionName()) && Objects.equals(this.witnessStatusAsString(), other.witnessStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"GlobalTableWitnessDescription").add("RegionName", (Object)this.regionName()).add("WitnessStatus", (Object)this.witnessStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RegionName": {
                return Optional.ofNullable(clazz.cast(this.regionName()));
            }
            case "WitnessStatus": {
                return Optional.ofNullable(clazz.cast(this.witnessStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("RegionName", REGION_NAME_FIELD);
        map.put("WitnessStatus", WITNESS_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GlobalTableWitnessDescription, T> g) {
        return obj -> g.apply((GlobalTableWitnessDescription)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String regionName;
        private String witnessStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(GlobalTableWitnessDescription model) {
            this.regionName(model.regionName);
            this.witnessStatus(model.witnessStatus);
        }

        public final String getRegionName() {
            return this.regionName;
        }

        public final void setRegionName(String regionName) {
            this.regionName = regionName;
        }

        @Override
        public final Builder regionName(String regionName) {
            this.regionName = regionName;
            return this;
        }

        public final String getWitnessStatus() {
            return this.witnessStatus;
        }

        public final void setWitnessStatus(String witnessStatus) {
            this.witnessStatus = witnessStatus;
        }

        @Override
        public final Builder witnessStatus(String witnessStatus) {
            this.witnessStatus = witnessStatus;
            return this;
        }

        @Override
        public final Builder witnessStatus(WitnessStatus witnessStatus) {
            this.witnessStatus(witnessStatus == null ? null : witnessStatus.toString());
            return this;
        }

        public GlobalTableWitnessDescription build() {
            return new GlobalTableWitnessDescription(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GlobalTableWitnessDescription> {
        public Builder regionName(String var1);

        public Builder witnessStatus(String var1);

        public Builder witnessStatus(WitnessStatus var1);
    }
}

