/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.search.query;

import java.util.List;
import lombok.Generated;
import org.apache.lucene.search.SortField;
import org.opensearch.neuralsearch.search.query.TopDocsMerger;
import org.opensearch.search.DocValueFormat;
import org.opensearch.search.internal.SearchContext;
import org.opensearch.search.rescore.RescoreContext;
import org.opensearch.search.sort.SortAndFormats;

public class HybridCollectorResultsUtilParams {
    private final SearchContext searchContext;
    private final TopDocsMerger topDocsMerger;
    private final int trackTotalHitsUpTo;
    private final boolean isSortEnabled;
    private final boolean isCollapseEnabled;
    private SortField[] sortFields = null;
    private final List<RescoreContext> rescoreContexts;
    private SortAndFormats sortAndFormats = null;
    private DocValueFormat[] docValueFormats = null;
    private static final SortField[] DEFAULT_SORT_FIELDS = new SortField[]{new SortField(null, SortField.Type.SCORE)};

    private HybridCollectorResultsUtilParams(Builder builder) {
        this.searchContext = builder.searchContext;
        this.topDocsMerger = new TopDocsMerger(this.searchContext.sort(), this.searchContext.collapse());
        this.trackTotalHitsUpTo = this.searchContext.trackTotalHitsUpTo();
        boolean bl = this.isSortEnabled = this.searchContext.sort() != null;
        if (this.isSortEnabled) {
            this.setSortEnabledParameters();
        }
        boolean bl2 = this.isCollapseEnabled = this.searchContext.collapse() != null;
        if (this.isCollapseEnabled && !this.isSortEnabled) {
            this.docValueFormats = new DocValueFormat[]{DocValueFormat.RAW};
        }
        if ((this.isSortEnabled || this.isCollapseEnabled) && this.sortFields == null) {
            this.sortFields = DEFAULT_SORT_FIELDS;
        }
        this.rescoreContexts = this.searchContext.rescore();
    }

    private void setSortEnabledParameters() {
        this.sortAndFormats = this.searchContext.sort();
        this.sortFields = this.sortAndFormats.sort.getSort();
        this.docValueFormats = this.sortAndFormats.formats;
    }

    @Generated
    public SearchContext getSearchContext() {
        return this.searchContext;
    }

    @Generated
    public TopDocsMerger getTopDocsMerger() {
        return this.topDocsMerger;
    }

    @Generated
    public int getTrackTotalHitsUpTo() {
        return this.trackTotalHitsUpTo;
    }

    @Generated
    public boolean isSortEnabled() {
        return this.isSortEnabled;
    }

    @Generated
    public boolean isCollapseEnabled() {
        return this.isCollapseEnabled;
    }

    @Generated
    public SortField[] getSortFields() {
        return this.sortFields;
    }

    @Generated
    public List<RescoreContext> getRescoreContexts() {
        return this.rescoreContexts;
    }

    @Generated
    public SortAndFormats getSortAndFormats() {
        return this.sortAndFormats;
    }

    @Generated
    public DocValueFormat[] getDocValueFormats() {
        return this.docValueFormats;
    }

    public static class Builder {
        private SearchContext searchContext;

        public Builder searchContext(SearchContext searchContext) {
            this.searchContext = searchContext;
            return this;
        }

        public HybridCollectorResultsUtilParams build() {
            return new HybridCollectorResultsUtilParams(this);
        }
    }
}

