/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.processor.normalization.bounds;

import java.util.Map;
import org.opensearch.neuralsearch.processor.normalization.bounds.BoundMode;
import org.opensearch.neuralsearch.processor.normalization.bounds.ScoreBound;

public class UpperBound
extends ScoreBound {
    public static final float DEFAULT_UPPER_BOUND_SCORE = 1.0f;
    private static final String PARAM_NAME_UPPER_BOUND_MAX_SCORE = "max_score";

    public UpperBound() {
        this(false, BoundMode.DEFAULT, 1.0f);
    }

    public UpperBound(boolean enabled, BoundMode mode, float boundScore) {
        super(enabled, mode, boundScore);
    }

    public UpperBound(Map<String, Object> upperBound) {
        this(true, UpperBound.parseBoundMode(upperBound), UpperBound.parseBoundScore(upperBound, PARAM_NAME_UPPER_BOUND_MAX_SCORE, 1.0f));
    }

    @Override
    public float determineEffectiveScore(float score, float minScore, float maxScore) {
        if (!this.enabled) {
            return maxScore;
        }
        return switch (this.mode) {
            default -> throw new MatchException(null, null);
            case BoundMode.APPLY -> {
                if (minScore < this.boundScore && score < this.boundScore) {
                    yield this.boundScore;
                }
                yield maxScore;
            }
            case BoundMode.CLIP -> {
                if (minScore > this.boundScore) {
                    yield maxScore;
                }
                yield this.boundScore;
            }
            case BoundMode.IGNORE -> maxScore;
        };
    }

    @Override
    public boolean shouldClipToBound(float score, float effectiveScore) {
        return this.enabled && this.mode == BoundMode.CLIP && score > effectiveScore;
    }
}

