/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.codec.derivedsource;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import lombok.Generated;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SegmentReadState;
import org.opensearch.knn.index.codec.derivedsource.DerivedSourceReaders;

public class DerivedSourceLuceneHelper {
    private static final int[] NESTED_OFFSET_STARTING_POINTS = new int[]{150, 1500, 6000};
    private final DerivedSourceReaders derivedSourceReaders;
    private final SegmentReadState segmentReadState;
    @VisibleForTesting
    static final int NO_CHILDREN_INDICATOR = -1;

    public int getFirstChild(int parentDocId) throws IOException {
        int offset;
        int currentStartingPoint;
        if (parentDocId == 0) {
            return Integer.MAX_VALUE;
        }
        int lastStartingPoint = -1;
        int[] nArray = NESTED_OFFSET_STARTING_POINTS;
        int n = nArray.length;
        for (int i = 0; i < n && (currentStartingPoint = Math.max(0, parentDocId - (offset = nArray[i]))) > lastStartingPoint; ++i) {
            int firstChild = this.getFirstChild(parentDocId, currentStartingPoint);
            if (firstChild == -1) {
                return Integer.MAX_VALUE;
            }
            if (firstChild != Integer.MAX_VALUE) {
                return firstChild;
            }
            lastStartingPoint = currentStartingPoint;
        }
        return this.getFirstChild(parentDocId, 0);
    }

    @VisibleForTesting
    int getFirstChild(int parentDocId, int startingPoint) throws IOException {
        FieldInfo fieldInfo = this.segmentReadState.fieldInfos.fieldInfo("_primary_term");
        assert (this.derivedSourceReaders.getDocValuesProducer() != null);
        NumericDocValues numericDocValues = this.derivedSourceReaders.getDocValuesProducer().getNumeric(fieldInfo);
        int previousParentDocId = Integer.MAX_VALUE;
        numericDocValues.advance(startingPoint);
        while (numericDocValues.docID() != Integer.MAX_VALUE && numericDocValues.docID() < parentDocId) {
            previousParentDocId = numericDocValues.docID();
            numericDocValues.nextDoc();
        }
        if (previousParentDocId == Integer.MAX_VALUE) {
            return 0;
        }
        if (parentDocId - previousParentDocId <= 1) {
            return -1;
        }
        return previousParentDocId + 1;
    }

    @Generated
    public DerivedSourceLuceneHelper(DerivedSourceReaders derivedSourceReaders, SegmentReadState segmentReadState) {
        this.derivedSourceReaders = derivedSourceReaders;
        this.segmentReadState = segmentReadState;
    }
}

