/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.indexstatemanagement.step.allocation;

import java.lang.invoke.LambdaMetafactory;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.action.admin.indices.settings.put.UpdateSettingsRequest;
import org.opensearch.action.support.clustermanager.AcknowledgedResponse;
import org.opensearch.common.settings.Settings;
import org.opensearch.core.action.ActionListener;
import org.opensearch.indexmanagement.indexstatemanagement.action.AllocationAction;
import org.opensearch.indexmanagement.indexstatemanagement.step.allocation.AttemptAllocationStep;
import org.opensearch.indexmanagement.opensearchapi.OpenSearchExtensionsKt;
import org.opensearch.indexmanagement.spi.indexstatemanagement.Step;
import org.opensearch.indexmanagement.spi.indexstatemanagement.model.ManagedIndexMetaData;
import org.opensearch.indexmanagement.spi.indexstatemanagement.model.StepContext;
import org.opensearch.indexmanagement.spi.indexstatemanagement.model.StepMetaData;
import org.opensearch.transport.client.IndicesAdminClient;
import org.opensearch.transport.client.OpenSearchClient;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 !2\u00020\u0001:\u0001!B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u000f\u001a\u00020\u0001H\u0096@\u00a2\u0006\u0002\u0010\u0010J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\u001c\u0010\u0013\u001a\u00020\u00142\n\u0010\u0015\u001a\u00060\u0016j\u0002`\u00172\u0006\u0010\u0018\u001a\u00020\rH\u0002J\u0018\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0018\u001a\u00020\rH\u0002J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001dH\u0016J\b\u0010\u001f\u001a\u00020 H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/opensearch/indexmanagement/indexstatemanagement/step/allocation/AttemptAllocationStep;", "Lorg/opensearch/indexmanagement/spi/indexstatemanagement/Step;", "action", "Lorg/opensearch/indexmanagement/indexstatemanagement/action/AllocationAction;", "<init>", "(Lorg/opensearch/indexmanagement/indexstatemanagement/action/AllocationAction;)V", "logger", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "stepStatus", "Lorg/opensearch/indexmanagement/spi/indexstatemanagement/Step$StepStatus;", "info", "", "", "", "execute", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "buildSettings", "Lorg/opensearch/common/settings/Settings;", "handleException", "", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "indexName", "handleResponse", "response", "Lorg/opensearch/action/support/clustermanager/AcknowledgedResponse;", "getUpdatedManagedIndexMetadata", "Lorg/opensearch/indexmanagement/spi/indexstatemanagement/model/ManagedIndexMetaData;", "currentMetadata", "isIdempotent", "", "Companion", "opensearch-index-management"})
@SourceDebugExtension(value={"SMAP\nAttemptAllocationStep.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AttemptAllocationStep.kt\norg/opensearch/indexmanagement/indexstatemanagement/step/allocation/AttemptAllocationStep\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,84:1\n216#2,2:85\n216#2,2:87\n216#2,2:89\n*S KotlinDebug\n*F\n+ 1 AttemptAllocationStep.kt\norg/opensearch/indexmanagement/indexstatemanagement/step/allocation/AttemptAllocationStep\n*L\n41#1:85,2\n42#1:87,2\n43#1:89,2\n*E\n"})
public final class AttemptAllocationStep
extends Step {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AllocationAction action;
    private final Logger logger;
    @NotNull
    private Step.StepStatus stepStatus;
    @Nullable
    private Map<String, ? extends Object> info;
    @NotNull
    public static final String name = "attempt_allocation";
    @NotNull
    private static final String SETTINGS_PREFIX = "index.routing.allocation.";

    public AttemptAllocationStep(@NotNull AllocationAction action) {
        Intrinsics.checkNotNullParameter((Object)((Object)action), (String)"action");
        super(name, false, 2, null);
        this.action = action;
        this.logger = LogManager.getLogger(((Object)((Object)this)).getClass());
        this.stepStatus = Step.StepStatus.STARTING;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public Object execute(@NotNull Continuation<? super Step> $completion) {
        if (!($completion instanceof execute.1)) ** GOTO lbl-1000
        var6_2 = $completion;
        if ((var6_2.label & -2147483648) != 0) {
            var6_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ AttemptAllocationStep this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.execute((Continuation<? super Step>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var7_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = this.getContext();
                if (v0 == null) {
                    return this;
                }
                context = v0;
                indexName = context.getMetadata().getIndex();
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)context);
                $continuation.L$1 = indexName;
                $continuation.label = 1;
                v1 = OpenSearchExtensionsKt.suspendUntil((OpenSearchClient)context.getClient().admin().indices(), (Function2)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, execute$lambda$0(org.opensearch.indexmanagement.indexstatemanagement.step.allocation.AttemptAllocationStep java.lang.String org.opensearch.transport.client.IndicesAdminClient org.opensearch.core.action.ActionListener ), (Lorg/opensearch/transport/client/IndicesAdminClient;Lorg/opensearch/core/action/ActionListener;)Lkotlin/Unit;)((AttemptAllocationStep)this, (String)indexName), $continuation);
                ** if (v1 != var7_4) goto lbl25
lbl24:
                // 1 sources

                return var7_4;
lbl25:
                // 1 sources

                ** GOTO lbl33
            }
            case 1: {
                indexName = (String)$continuation.L$1;
                context = (StepContext)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl33:
                    // 2 sources

                    response = (AcknowledgedResponse)v1;
                    this.handleResponse(response, indexName);
                }
                catch (Exception e) {
                    this.handleException(e, indexName);
                }
                return this;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final Settings buildSettings() {
        String value;
        String key;
        Map.Entry<String, String> entry;
        Map.Entry<String, String> element$iv;
        Settings.Builder builder = Settings.builder();
        Map<String, String> $this$forEach$iv = this.action.getRequire();
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, String>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = element$iv = iterator.next();
            boolean bl = false;
            key = entry.getKey();
            value = entry.getValue();
            builder.put("index.routing.allocation.require." + key, value);
        }
        $this$forEach$iv = this.action.getInclude();
        $i$f$forEach = false;
        iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = element$iv = iterator.next();
            boolean bl = false;
            key = entry.getKey();
            value = entry.getValue();
            builder.put("index.routing.allocation.include." + key, value);
        }
        $this$forEach$iv = this.action.getExclude();
        $i$f$forEach = false;
        iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = element$iv = iterator.next();
            boolean bl = false;
            key = entry.getKey();
            value = entry.getValue();
            builder.put("index.routing.allocation.exclude." + key, value);
        }
        Settings settings = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)settings, (String)"build(...)");
        return settings;
    }

    private final void handleException(Exception e, String indexName) {
        String message = Companion.getFailedMessage(indexName);
        this.logger.error(message, (Throwable)e);
        this.stepStatus = Step.StepStatus.FAILED;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"message", (Object)message)};
        Map mutableInfo = MapsKt.mutableMapOf((Pair[])pairArray);
        String errorMessage = e.getMessage();
        if (errorMessage != null) {
            mutableInfo.put("cause", errorMessage);
        }
        this.info = MapsKt.toMap((Map)mutableInfo);
    }

    private final void handleResponse(AcknowledgedResponse response2, String indexName) {
        if (response2.isAcknowledged()) {
            this.stepStatus = Step.StepStatus.COMPLETED;
            this.info = MapsKt.mapOf((Pair)TuplesKt.to((Object)"message", (Object)Companion.getSuccessMessage(indexName)));
        } else {
            this.stepStatus = Step.StepStatus.FAILED;
            this.info = MapsKt.mapOf((Pair)TuplesKt.to((Object)"message", (Object)Companion.getFailedMessage(indexName)));
        }
    }

    @NotNull
    public ManagedIndexMetaData getUpdatedManagedIndexMetadata(@NotNull ManagedIndexMetaData currentMetadata) {
        Intrinsics.checkNotNullParameter((Object)currentMetadata, (String)"currentMetadata");
        StepMetaData stepMetaData = new StepMetaData(this.getName(), this.getStepStartTime(currentMetadata).toEpochMilli(), this.stepStatus);
        Map<String, ? extends Object> map = this.info;
        return ManagedIndexMetaData.copy$default((ManagedIndexMetaData)currentMetadata, null, null, null, null, null, null, null, null, null, null, null, (StepMetaData)stepMetaData, null, map, null, (long)0L, (long)0L, null, (int)251647, null);
    }

    public boolean isIdempotent() {
        return true;
    }

    private static final Unit execute$lambda$0(AttemptAllocationStep this$0, String $indexName, IndicesAdminClient $this$suspendUntil, ActionListener it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String[] stringArray = new String[]{$indexName};
        $this$suspendUntil.updateSettings(new UpdateSettingsRequest(this$0.buildSettings(), stringArray), it);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0005J\u000e\u0010\t\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/opensearch/indexmanagement/indexstatemanagement/step/allocation/AttemptAllocationStep$Companion;", "", "<init>", "()V", "name", "", "SETTINGS_PREFIX", "getFailedMessage", "index", "getSuccessMessage", "opensearch-index-management"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getFailedMessage(@NotNull String index2) {
            Intrinsics.checkNotNullParameter((Object)index2, (String)"index");
            return "Failed to update allocation setting [index=" + index2 + "]";
        }

        @NotNull
        public final String getSuccessMessage(@NotNull String index2) {
            Intrinsics.checkNotNullParameter((Object)index2, (String)"index");
            return "Successfully updated allocation setting [index=" + index2 + "]";
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

