/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ko.dict;

import org.apache.lucene.analysis.ko.POS;
import org.apache.lucene.analysis.ko.dict.KoMorphData;

final class UserMorphData
implements KoMorphData {
    private static final int WORD_COST = -100000;
    private static final short LEFT_ID = 1781;
    private final int[][] segmentations;
    private final short[] rightIds;

    UserMorphData(int[][] segmentations, short[] rightIds) {
        this.segmentations = segmentations;
        this.rightIds = rightIds;
    }

    public int getLeftId(int morphId) {
        return 1781;
    }

    public int getRightId(int morphId) {
        return this.rightIds[morphId];
    }

    public int getWordCost(int morphId) {
        return -100000;
    }

    @Override
    public POS.Type getPOSType(int morphId) {
        if (this.segmentations[morphId] == null) {
            return POS.Type.MORPHEME;
        }
        return POS.Type.COMPOUND;
    }

    @Override
    public POS.Tag getLeftPOS(int morphId) {
        return POS.Tag.NNG;
    }

    @Override
    public POS.Tag getRightPOS(int morphId) {
        return POS.Tag.NNG;
    }

    @Override
    public String getReading(int morphId) {
        return null;
    }

    @Override
    public KoMorphData.Morpheme[] getMorphemes(int morphId, char[] surfaceForm, int off, int len) {
        int[] segs = this.segmentations[morphId];
        if (segs == null) {
            return null;
        }
        int offset = 0;
        KoMorphData.Morpheme[] morphemes = new KoMorphData.Morpheme[segs.length];
        for (int i = 0; i < segs.length; ++i) {
            morphemes[i] = new KoMorphData.Morpheme(POS.Tag.NNG, new String(surfaceForm, off + offset, segs[i]));
            offset += segs[i];
        }
        return morphemes;
    }
}

