/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.prometheus.response;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import lombok.NonNull;
import org.json.JSONArray;
import org.json.JSONObject;
import org.opensearch.sql.data.model.ExprDoubleValue;
import org.opensearch.sql.data.model.ExprIntegerValue;
import org.opensearch.sql.data.model.ExprLongValue;
import org.opensearch.sql.data.model.ExprStringValue;
import org.opensearch.sql.data.model.ExprTimestampValue;
import org.opensearch.sql.data.model.ExprTupleValue;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.data.type.ExprCoreType;
import org.opensearch.sql.data.type.ExprType;
import org.opensearch.sql.expression.NamedExpression;
import org.opensearch.sql.expression.ReferenceExpression;
import org.opensearch.sql.prometheus.storage.model.PrometheusResponseFieldNames;

public class PrometheusResponse
implements Iterable<ExprValue> {
    private final JSONObject responseObject;
    private final PrometheusResponseFieldNames prometheusResponseFieldNames;

    public PrometheusResponse(JSONObject responseObject, PrometheusResponseFieldNames prometheusResponseFieldNames) {
        this.responseObject = responseObject;
        this.prometheusResponseFieldNames = prometheusResponseFieldNames;
    }

    @Override
    @NonNull
    public Iterator<ExprValue> iterator() {
        ArrayList<ExprTupleValue> result = new ArrayList<ExprTupleValue>();
        if ("matrix".equals(this.responseObject.getString("resultType"))) {
            JSONArray itemArray = this.responseObject.getJSONArray("result");
            for (int i = 0; i < itemArray.length(); ++i) {
                JSONObject item = itemArray.getJSONObject(i);
                JSONObject metric = item.getJSONObject("metric");
                JSONArray values = item.getJSONArray("values");
                for (int j = 0; j < values.length(); ++j) {
                    LinkedHashMap<String, ExprValue> linkedHashMap = new LinkedHashMap<String, ExprValue>();
                    JSONArray val = values.getJSONArray(j);
                    linkedHashMap.put(this.prometheusResponseFieldNames.getTimestampFieldName(), new ExprTimestampValue(Instant.ofEpochMilli((long)(val.getDouble(0) * 1000.0))));
                    linkedHashMap.put(this.prometheusResponseFieldNames.getValueFieldName(), this.getValue(val, 1, this.prometheusResponseFieldNames.getValueType()));
                    this.insertLabels(linkedHashMap, metric);
                    result.add(new ExprTupleValue(linkedHashMap));
                }
            }
        } else {
            throw new RuntimeException(String.format("Unexpected Result Type: %s during Prometheus Response Parsing. 'matrix' resultType is expected", this.responseObject.getString("resultType")));
        }
        return result.iterator();
    }

    private void insertLabels(LinkedHashMap<String, ExprValue> linkedHashMap, JSONObject metric) {
        for (String key : metric.keySet()) {
            linkedHashMap.put(this.getKey(key), new ExprStringValue(metric.getString(key)));
        }
    }

    private ExprValue getValue(JSONArray jsonArray, Integer index, ExprType exprType) {
        if (ExprCoreType.INTEGER.equals(exprType)) {
            return new ExprIntegerValue(jsonArray.getInt(index.intValue()));
        }
        if (ExprCoreType.LONG.equals(exprType)) {
            return new ExprLongValue(jsonArray.getLong(index.intValue()));
        }
        return new ExprDoubleValue(jsonArray.getDouble(index.intValue()));
    }

    private String getKey(String key) {
        if (this.prometheusResponseFieldNames.getGroupByList() == null) {
            return key;
        }
        return this.prometheusResponseFieldNames.getGroupByList().stream().filter(expression -> expression.getDelegated() instanceof ReferenceExpression).filter(expression -> ((ReferenceExpression)expression.getDelegated()).getAttr().equals(key)).findFirst().map(NamedExpression::getName).orElse(key);
    }
}

