/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image.loader.metrics;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.MetricsRegistry;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.apache.kafka.image.MetadataProvenance;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import org.apache.kafka.server.metrics.TimeRatio;

public final class MetadataLoaderMetrics
implements AutoCloseable {
    private static final MetricName CURRENT_METADATA_VERSION = MetadataLoaderMetrics.getMetricName("MetadataLoader", "CurrentMetadataVersion");
    private static final MetricName HANDLE_LOAD_SNAPSHOT_COUNT = MetadataLoaderMetrics.getMetricName("MetadataLoader", "HandleLoadSnapshotCount");
    private static final MetricName CURRENT_CONTROLLER_ID = MetadataLoaderMetrics.getMetricName("MetadataLoader", "CurrentControllerId");
    private static final MetricName AVERAGE_IDLE_RATIO = MetadataLoaderMetrics.getMetricName("MetadataLoader", "AvgIdleRatio");
    private static final String FINALIZED_LEVEL_METRIC_NAME = "FinalizedLevel";
    private static final String FEATURE_NAME_TAG = "featureName";
    private final Optional<MetricsRegistry> registry;
    private final AtomicReference<MetadataVersion> currentMetadataVersion = new AtomicReference<MetadataVersion>(MetadataVersion.MINIMUM_VERSION);
    private final Map<String, Short> finalizedFeatureLevels = new ConcurrentHashMap<String, Short>();
    private final AtomicInteger currentControllerId = new AtomicInteger(-1);
    private final AtomicLong handleLoadSnapshotCount = new AtomicLong(0L);
    private final Consumer<Long> batchProcessingTimeNsUpdater;
    private final Consumer<Integer> batchSizesUpdater;
    private final AtomicReference<MetadataProvenance> lastAppliedProvenance;
    private final TimeRatio avgIdleTimeRatio;

    public MetadataLoaderMetrics(Optional<MetricsRegistry> registry, Consumer<Long> batchProcessingTimeNsUpdater, Consumer<Integer> batchSizesUpdater, AtomicReference<MetadataProvenance> lastAppliedProvenance) {
        this.registry = registry;
        this.batchProcessingTimeNsUpdater = batchProcessingTimeNsUpdater;
        this.batchSizesUpdater = batchSizesUpdater;
        this.lastAppliedProvenance = lastAppliedProvenance;
        this.avgIdleTimeRatio = new TimeRatio(1.0);
        registry.ifPresent(r -> r.newGauge(CURRENT_METADATA_VERSION, (Gauge)new Gauge<Integer>(){

            public Integer value() {
                return MetadataLoaderMetrics.this.currentMetadataVersion().featureLevel();
            }
        }));
        registry.ifPresent(r -> r.newGauge(CURRENT_CONTROLLER_ID, (Gauge)new Gauge<Integer>(){

            public Integer value() {
                return MetadataLoaderMetrics.this.currentControllerId();
            }
        }));
        registry.ifPresent(r -> r.newGauge(HANDLE_LOAD_SNAPSHOT_COUNT, (Gauge)new Gauge<Long>(){

            public Long value() {
                return MetadataLoaderMetrics.this.handleLoadSnapshotCount();
            }
        }));
        registry.ifPresent(r -> r.newGauge(AVERAGE_IDLE_RATIO, (Gauge)new Gauge<Double>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Double value() {
                TimeRatio timeRatio = MetadataLoaderMetrics.this.avgIdleTimeRatio;
                synchronized (timeRatio) {
                    return MetadataLoaderMetrics.this.avgIdleTimeRatio.measure();
                }
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateIdleTime(long idleDurationMs, long currentTimeMs) {
        TimeRatio timeRatio = this.avgIdleTimeRatio;
        synchronized (timeRatio) {
            this.avgIdleTimeRatio.record((double)idleDurationMs, currentTimeMs);
        }
    }

    private void addFinalizedFeatureLevelMetric(final String featureName) {
        this.registry.ifPresent(r -> r.newGauge(MetadataLoaderMetrics.getFeatureNameTagMetricName("MetadataLoader", FINALIZED_LEVEL_METRIC_NAME, featureName), (Gauge)new Gauge<Short>(){

            public Short value() {
                return MetadataLoaderMetrics.this.finalizedFeatureLevel(featureName);
            }
        }));
    }

    private void removeFinalizedFeatureLevelMetric(String featureName) {
        this.registry.ifPresent(r -> r.removeMetric(MetadataLoaderMetrics.getFeatureNameTagMetricName("MetadataLoader", FINALIZED_LEVEL_METRIC_NAME, featureName)));
    }

    public void updateBatchProcessingTimeNs(long elapsedNs) {
        this.batchProcessingTimeNsUpdater.accept(elapsedNs);
    }

    public void updateBatchSize(int size) {
        this.batchSizesUpdater.accept(size);
    }

    public void updateLastAppliedImageProvenance(MetadataProvenance lastAppliedProvenance) {
        this.lastAppliedProvenance.set(lastAppliedProvenance);
    }

    public long lastAppliedOffset() {
        return this.lastAppliedProvenance.get().lastContainedOffset();
    }

    public void setCurrentMetadataVersion(MetadataVersion metadataVersion) {
        this.currentMetadataVersion.set(metadataVersion);
    }

    public MetadataVersion currentMetadataVersion() {
        return this.currentMetadataVersion.get();
    }

    public int currentControllerId() {
        return this.currentControllerId.get();
    }

    public void setCurrentControllerId(int newCurrentControllerId) {
        this.currentControllerId.set(newCurrentControllerId);
    }

    public long incrementHandleLoadSnapshotCount() {
        return this.handleLoadSnapshotCount.incrementAndGet();
    }

    public long handleLoadSnapshotCount() {
        return this.handleLoadSnapshotCount.get();
    }

    public void maybeRemoveFinalizedFeatureLevelMetrics(Map<String, Short> newFinalizedLevels) {
        Iterator<String> iter = this.finalizedFeatureLevels.keySet().iterator();
        while (iter.hasNext()) {
            String featureName = iter.next();
            if (newFinalizedLevels.containsKey(featureName) || featureName.equals("metadata.version") || featureName.equals("kraft.version")) continue;
            this.removeFinalizedFeatureLevelMetric(featureName);
            iter.remove();
        }
    }

    public void recordFinalizedFeatureLevel(String featureName, short featureLevel) {
        boolean metricNotRegistered;
        boolean bl = metricNotRegistered = this.finalizedFeatureLevels.put(featureName, featureLevel) == null;
        if (metricNotRegistered) {
            this.addFinalizedFeatureLevelMetric(featureName);
        }
    }

    public short finalizedFeatureLevel(String featureName) {
        return this.finalizedFeatureLevels.get(featureName);
    }

    @Override
    public void close() {
        this.registry.ifPresent(r -> List.of(CURRENT_METADATA_VERSION, CURRENT_CONTROLLER_ID, HANDLE_LOAD_SNAPSHOT_COUNT, AVERAGE_IDLE_RATIO).forEach(arg_0 -> ((MetricsRegistry)r).removeMetric(arg_0)));
        for (String featureName : this.finalizedFeatureLevels.keySet()) {
            this.removeFinalizedFeatureLevelMetric(featureName);
        }
    }

    private static MetricName getMetricName(String type, String name) {
        return KafkaYammerMetrics.getMetricName((String)"kafka.server", (String)type, (String)name);
    }

    private static MetricName getFeatureNameTagMetricName(String type, String name, String featureName) {
        LinkedHashMap<String, String> featureNameTag = new LinkedHashMap<String, String>();
        featureNameTag.put(FEATURE_NAME_TAG, MetadataLoaderMetrics.sanitizeFeatureName(featureName));
        return KafkaYammerMetrics.getMetricName((String)"kafka.server", (String)type, (String)name, featureNameTag);
    }

    private static String sanitizeFeatureName(String featureName) {
        String[] words = featureName.split("\\.");
        StringBuilder builder = new StringBuilder(words[0]);
        for (int i = 1; i < words.length; ++i) {
            String word = words[i];
            builder.append(Character.toUpperCase(word.charAt(0))).append(word.substring(1).toLowerCase(Locale.ROOT));
        }
        return builder.toString();
    }
}

