/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.connector.policy;

import java.util.List;
import java.util.Map;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigValue;
import org.apache.kafka.connect.connector.policy.AbstractConnectorClientConfigOverridePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AllowlistConnectorClientConfigOverridePolicy
extends AbstractConnectorClientConfigOverridePolicy {
    public static final String ALLOWLIST_CONFIG = "connector.client.config.override.allowlist";
    private static final Logger LOGGER = LoggerFactory.getLogger(AllowlistConnectorClientConfigOverridePolicy.class);
    private static final List<String> ALLOWLIST_CONFIG_DEFAULT = List.of();
    private static final String ALLOWLIST_CONFIG_DOC = "List of client configurations that can be overridden by connectors. If empty, connectors can't override any client configurations.";
    private static final ConfigDef CONFIG_DEF = new ConfigDef().define("connector.client.config.override.allowlist", ConfigDef.Type.LIST, ALLOWLIST_CONFIG_DEFAULT, (ConfigDef.Validator)ConfigDef.ValidList.anyNonDuplicateValues((boolean)true, (boolean)false), ConfigDef.Importance.MEDIUM, "List of client configurations that can be overridden by connectors. If empty, connectors can't override any client configurations.");
    private List<String> allowlist = ALLOWLIST_CONFIG_DEFAULT;

    @Override
    protected String policyName() {
        return "Allowlist";
    }

    @Override
    protected boolean isAllowed(ConfigValue configValue) {
        return this.allowlist.contains(configValue.name());
    }

    public void configure(Map<String, ?> configs) {
        AbstractConfig config = new AbstractConfig(CONFIG_DEF, configs);
        this.allowlist = config.getList(ALLOWLIST_CONFIG);
        LOGGER.info("Setting up Allowlist policy for ConnectorClientConfigOverride. This will allow the following client configurations to be overridden. {}", this.allowlist);
    }
}

