/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental;

import com.intellij.openapi.util.io.FileUtilRt;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.builders.PreloadedDataExtension;
import org.jetbrains.jps.cmdline.PreloadedData;
import org.jetbrains.jps.cmdline.ProjectDescriptor;
import org.jetbrains.jps.service.JpsServiceManager;

public final class CleanupTempDirectoryExtension
implements PreloadedDataExtension {
    private Future<?> myTask;

    @Override
    public void preloadData(@NotNull PreloadedData data) {
        ProjectDescriptor projectDescriptor;
        if (data == null) {
            CleanupTempDirectoryExtension.$$$reportNull$$$0(0);
        }
        if ((projectDescriptor = data.getProjectDescriptor()) != null) {
            this.myTask = CleanupTempDirectoryExtension.startTempDirectoryCleanupTask(projectDescriptor);
        }
    }

    @Override
    public void buildSessionInitialized(@NotNull PreloadedData data) {
        if (data == null) {
            CleanupTempDirectoryExtension.$$$reportNull$$$0(1);
        }
    }

    @Override
    public void discardPreloadedData(PreloadedData data) {
    }

    @Nullable
    public static CleanupTempDirectoryExtension getInstance() {
        for (PreloadedDataExtension extension : JpsServiceManager.getInstance().getExtensions(PreloadedDataExtension.class)) {
            if (!(extension instanceof CleanupTempDirectoryExtension)) continue;
            return (CleanupTempDirectoryExtension)extension;
        }
        return null;
    }

    public Future<?> getCleanupTask() {
        return this.myTask;
    }

    @NotNull
    static Collection<Future<?>> getRunningCleanupTasks() {
        ArrayList tasks = new ArrayList();
        for (PreloadedDataExtension extension : JpsServiceManager.getInstance().getExtensions(PreloadedDataExtension.class)) {
            Future<?> task = extension instanceof CleanupTempDirectoryExtension ? ((CleanupTempDirectoryExtension)extension).getCleanupTask() : null;
            if (task == null) continue;
            tasks.add(task);
        }
        ArrayList arrayList = tasks;
        if (arrayList == null) {
            CleanupTempDirectoryExtension.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    @Nullable
    static Future<?> startTempDirectoryCleanupTask(@NotNull ProjectDescriptor pd) {
        Path dataRoot;
        String tempPath;
        if (pd == null) {
            CleanupTempDirectoryExtension.$$$reportNull$$$0(3);
        }
        if ((tempPath = System.getProperty("java.io.tmpdir", null)) == null || tempPath.isBlank()) {
            return null;
        }
        Path tempDir = Path.of(tempPath, new String[0]).toAbsolutePath().normalize();
        if (!tempDir.startsWith(dataRoot = pd.dataManager.getDataPaths().getDataStorageDir()) || tempDir.equals(dataRoot)) {
            return null;
        }
        ArrayList<Path> files = new ArrayList<Path>();
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(tempDir);){
            for (Path path : stream) {
                files.add(path);
            }
        }
        catch (IOException ex) {
            try {
                Files.createDirectories(tempDir, new FileAttribute[0]);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return null;
        }
        if (files.isEmpty()) {
            return null;
        }
        FutureTask<Object> task = new FutureTask<Object>(() -> {
            for (Path tempFile : files) {
                try {
                    FileUtilRt.deleteRecursively((Path)tempFile);
                }
                catch (IOException iOException) {}
            }
        }, null);
        Thread thread = new Thread(task, "Temp directory cleanup");
        thread.setPriority(1);
        thread.setDaemon(true);
        thread.start();
        return task;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/incremental/CleanupTempDirectoryExtension";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pd";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/incremental/CleanupTempDirectoryExtension";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunningCleanupTasks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "preloadData";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildSessionInitialized";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "startTempDirectoryCleanupTask";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

