/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.editor;

import com.intellij.lang.Commenter;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiFile;
import com.intellij.psi.templateLanguages.MultipleLangCommentProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.textmate.TextMateFileType;
import org.jetbrains.plugins.textmate.TextMateService;
import org.jetbrains.plugins.textmate.editor.TextMateEditorUtils;
import org.jetbrains.plugins.textmate.language.PreferencesReadUtil;
import org.jetbrains.plugins.textmate.language.TextMateBlockCommentPair;
import org.jetbrains.plugins.textmate.language.TextMateCommentPrefixes;
import org.jetbrains.plugins.textmate.language.preferences.ShellVariablesRegistry;
import org.jetbrains.plugins.textmate.language.syntax.lexer.TextMateScope;

public class TextMateCommentProvider
implements MultipleLangCommentProvider,
Commenter {
    @Nullable
    public Commenter getLineCommenter(@NotNull PsiFile file, @NotNull Editor editor, @NotNull Language lineStartLanguage, @NotNull Language lineEndLanguage) {
        TextMateScope actualScope;
        if (file == null) {
            TextMateCommentProvider.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            TextMateCommentProvider.$$$reportNull$$$0(1);
        }
        if (lineStartLanguage == null) {
            TextMateCommentProvider.$$$reportNull$$$0(2);
        }
        if (lineEndLanguage == null) {
            TextMateCommentProvider.$$$reportNull$$$0(3);
        }
        if ((actualScope = TextMateEditorUtils.getCurrentScopeSelector((EditorEx)editor)) == null) {
            return null;
        }
        ShellVariablesRegistry registry = TextMateService.getInstance().getShellVariableRegistry();
        TextMateCommentPrefixes prefixes = PreferencesReadUtil.readCommentPrefixes((ShellVariablesRegistry)registry, (TextMateScope)actualScope);
        return prefixes.getBlockCommentPair() != null || prefixes.getLineCommentPrefix() != null ? new MyCommenter(prefixes) : null;
    }

    public boolean canProcess(@NotNull PsiFile file, @NotNull FileViewProvider viewProvider) {
        if (file == null) {
            TextMateCommentProvider.$$$reportNull$$$0(4);
        }
        if (viewProvider == null) {
            TextMateCommentProvider.$$$reportNull$$$0(5);
        }
        return file.getFileType() == TextMateFileType.INSTANCE;
    }

    @Nullable
    public String getLineCommentPrefix() {
        return null;
    }

    @Nullable
    public String getBlockCommentPrefix() {
        return "";
    }

    @Nullable
    public String getBlockCommentSuffix() {
        return "";
    }

    @Nullable
    public String getCommentedBlockCommentPrefix() {
        return null;
    }

    @Nullable
    public String getCommentedBlockCommentSuffix() {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lineStartLanguage";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lineEndLanguage";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewProvider";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/textmate/editor/TextMateCommentProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getLineCommenter";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "canProcess";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class MyCommenter
    implements Commenter {
        @Nullable
        final String myLinePrefix;
        @Nullable
        final TextMateBlockCommentPair myBlockPrefixes;

        private MyCommenter(@NotNull TextMateCommentPrefixes prefixes) {
            if (prefixes == null) {
                MyCommenter.$$$reportNull$$$0(0);
            }
            this.myLinePrefix = prefixes.getLineCommentPrefix();
            this.myBlockPrefixes = prefixes.getBlockCommentPair();
        }

        @Nullable
        public String getLineCommentPrefix() {
            return this.myLinePrefix;
        }

        @Nullable
        public String getBlockCommentPrefix() {
            return this.myBlockPrefixes != null ? this.myBlockPrefixes.getPrefix() : null;
        }

        @Nullable
        public String getBlockCommentSuffix() {
            return this.myBlockPrefixes != null ? this.myBlockPrefixes.getSuffix() : null;
        }

        @Nullable
        public String getCommentedBlockCommentPrefix() {
            return null;
        }

        @Nullable
        public String getCommentedBlockCommentSuffix() {
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefixes", "org/jetbrains/plugins/textmate/editor/TextMateCommentProvider$MyCommenter", "<init>"));
        }
    }
}

