/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.images.options.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.options.BaseConfigurable;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import org.intellij.images.ImagesBundle;
import org.intellij.images.actions.EditExternalImageEditorAction;
import org.intellij.images.options.Options;
import org.intellij.images.options.OptionsManager;
import org.intellij.images.options.impl.ImagesOptionsComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class ImagesConfigurable
extends BaseConfigurable
implements SearchableConfigurable,
PropertyChangeListener {
    private ImagesOptionsComponent myComponent;
    private final Disposable myUIResourcesDisposable = Disposer.newDisposable();

    public String getDisplayName() {
        return ImagesBundle.message("settings.page.name", new Object[0]);
    }

    public String getHelpTopic() {
        return "preferences.images";
    }

    public JComponent createComponent() {
        if (this.myComponent == null) {
            this.myComponent = new ImagesOptionsComponent();
            Options options = OptionsManager.getInstance().getOptions();
            options.addPropertyChangeListener(this, this.myUIResourcesDisposable);
            this.myComponent.getOptions().inject(options);
            this.myComponent.updateUI();
            this.myComponent.getOptions().addPropertyChangeListener(this, this.myUIResourcesDisposable);
            this.setModified(false);
        }
        return this.myComponent.getContentPane();
    }

    public void apply() {
        if (this.myComponent != null) {
            Options options = OptionsManager.getInstance().getOptions();
            options.inject(this.myComponent.getOptions());
        }
    }

    public void reset() {
        if (this.myComponent != null) {
            Options options = OptionsManager.getInstance().getOptions();
            this.myComponent.getOptions().inject(options);
            this.myComponent.updateUI();
        }
    }

    public void disposeUIResources() {
        Disposer.dispose((Disposable)this.myUIResourcesDisposable);
        this.myComponent = null;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Options uiOptions;
        Options options = OptionsManager.getInstance().getOptions();
        this.setModified(!options.equals(uiOptions = this.myComponent.getOptions()));
    }

    public static void show(Project project) {
        EditExternalImageEditorAction.Companion.showDialog(project);
    }

    @NotNull
    @NonNls
    public String getId() {
        return "Images";
    }
}

