/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jetCheck;

import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jetCheck.DataSerializer;
import org.jetbrains.jetCheck.IntCustomizer;
import org.jetbrains.jetCheck.Iteration;
import org.jetbrains.jetCheck.NodeId;
import org.jetbrains.jetCheck.PropertyFailure;
import org.jetbrains.jetCheck.ReplayDataStructure;
import org.jetbrains.jetCheck.StructureNode;

class CounterExampleImpl<T>
implements PropertyFailure.CounterExample<T> {
    final StructureNode data;
    private final T value;
    @Nullable
    private final Throwable exception;
    private final Iteration<T> iteration;

    private CounterExampleImpl(StructureNode data, T value, @Nullable Throwable exception, Iteration<T> iteration) {
        this.data = data;
        this.value = value;
        this.exception = exception;
        this.iteration = iteration;
    }

    @Override
    public T getExampleValue() {
        return this.value;
    }

    @Override
    @Nullable
    public Throwable getExceptionCause() {
        return this.exception;
    }

    @Override
    @NotNull
    public CounterExampleImpl<T> replay() {
        T value = this.iteration.generateValue(this.createReplayData());
        CounterExampleImpl<T> example = CounterExampleImpl.checkProperty(this.iteration, value, this.data);
        return example != null ? example : new CounterExampleImpl<T>(this.data, value, new IllegalStateException("Replaying failure is unexpectedly successful!"), this.iteration);
    }

    boolean tryReproducing() {
        this.iteration.session.notifier.beforeReproducing(this.data);
        try {
            return CounterExampleImpl.checkProperty(this.iteration, this.iteration.generateValue(this.createReplayData()), this.data) != null;
        }
        catch (Throwable e2) {
            this.iteration.session.notifier.replayFailed(e2);
            return false;
        }
    }

    @Override
    @NotNull
    public String getSerializedData() {
        return DataSerializer.serialize(this.iteration, this.data);
    }

    ReplayDataStructure createReplayData() {
        return new ReplayDataStructure(this.data, this.iteration.sizeHint, IntCustomizer::checkValidInt, new HashSet<NodeId>());
    }

    static <T> CounterExampleImpl<T> checkProperty(Iteration<T> iteration, T value, StructureNode node) {
        try {
            iteration.session.notifier.beforePropertyCheck(value);
            if (!iteration.session.property.test(value)) {
                iteration.session.notifier.propertyCheckFailed(null);
                return new CounterExampleImpl<T>(node, value, null, iteration);
            }
        }
        catch (Throwable e2) {
            iteration.session.notifier.propertyCheckFailed(e2);
            return new CounterExampleImpl<T>(node, value, e2, iteration);
        }
        return null;
    }
}

